/*******************************************************************************
* Copyright (c) 2009, 2011 Overture Team and others.
*
* Overture is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Overture is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Overture.  If not, see <http://www.gnu.org/licenses/>.
*
* The Overture Tool web-site: http://overturetool.org/
*******************************************************************************/

/* This file was generated by ASTcreator (http://www.lausdahl.com/). */

package org.intocps.maestro.ast.analysis;


import org.intocps.maestro.ast.node.AIfStm;
import org.intocps.maestro.ast.node.ABoolLiteralExp;
import org.intocps.maestro.ast.node.AArrayStateDesignator;
import org.intocps.maestro.ast.ALessBinaryExp;
import org.intocps.maestro.ast.node.AWhileStm;
import java.lang.Integer;
import org.intocps.maestro.ast.node.ANameType;
import org.intocps.maestro.ast.node.AStringPrimitiveType;
import org.intocps.maestro.ast.node.AFormalParameter;
import org.intocps.maestro.ast.node.AIdentifierExp;
import org.intocps.maestro.ast.node.PParameter;
import org.intocps.maestro.ast.node.AIntLiteralExp;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.ast.AOrBinaryExp;
import org.intocps.maestro.ast.node.AParExp;
import java.lang.Long;
import org.intocps.maestro.ast.node.PDocument;
import org.intocps.maestro.ast.ABasicBlockStm;
import org.intocps.maestro.ast.node.ASimulationSpecificationCompilationUnit;
import org.intocps.maestro.ast.node.SUnaryExp;
import org.intocps.maestro.ast.node.AExpressionStm;
import org.intocps.maestro.ast.analysis.intf.IAnalysis;
import org.intocps.maestro.ast.AParallelBlockStm;
import java.util.Set;
import org.intocps.maestro.ast.AFunctionDeclaration;
import org.intocps.maestro.ast.node.AErrorStm;
import org.intocps.maestro.ast.node.ARefExp;
import org.intocps.maestro.ast.ALessEqualBinaryExp;
import org.intocps.maestro.ast.node.AImportedModuleCompilationUnit;
import org.intocps.maestro.ast.AGreaterEqualBinaryExp;
import org.intocps.maestro.ast.node.PCompilationUnit;
import org.intocps.maestro.ast.node.AConfigFramework;
import org.intocps.maestro.ast.AGreaterBinaryExp;
import org.intocps.maestro.ast.LexIdentifier;
import java.lang.Double;
import org.intocps.maestro.ast.node.AObservableStm;
import java.util.ArrayList;
import org.intocps.maestro.ast.node.ALocalVariableStm;
import org.intocps.maestro.ast.node.PStateDesignator;
import org.intocps.maestro.ast.node.SLiteralExp;
import org.intocps.maestro.ast.node.ANullType;
import org.intocps.maestro.ast.node.PStm;
import java.lang.String;
import org.intocps.maestro.ast.node.IToken;
import org.intocps.maestro.ast.AVariableDeclaration;
import org.intocps.maestro.ast.node.AUIntLiteralExp;
import org.intocps.maestro.ast.node.PInitializer;
import org.intocps.maestro.ast.AAndBinaryExp;
import org.intocps.maestro.ast.node.ARealLiteralExp;
import org.intocps.maestro.ast.node.SBinaryExp;
import org.intocps.maestro.ast.AEqualBinaryExp;
import org.intocps.maestro.ast.node.AExpInitializer;
import org.intocps.maestro.ast.ANotUnaryExp;
import org.intocps.maestro.ast.node.ARootDocument;
import org.intocps.maestro.ast.node.AModuleType;
import org.intocps.maestro.ast.node.ACallExp;
import org.intocps.maestro.ast.APlusUnaryExp;
import org.intocps.maestro.ast.node.AStringLiteralExp;
import org.intocps.maestro.ast.analysis.AnalysisException;
import org.intocps.maestro.ast.AMinusBinaryExp;
import org.intocps.maestro.ast.AMultiplyBinaryExp;
import org.intocps.maestro.ast.node.AIdentifierStateDesignator;
import org.intocps.maestro.ast.node.AInstanceMappingStm;
import org.intocps.maestro.ast.node.AArrayType;
import org.intocps.maestro.ast.node.AIntNumericPrimitiveType;
import org.intocps.maestro.ast.node.AFunctionType;
import org.intocps.maestro.ast.node.ALoadExp;
import org.intocps.maestro.ast.node.PExp;
import java.util.List;
import org.intocps.maestro.ast.AModuleDeclaration;
import org.intocps.maestro.ast.node.AArrayInitializer;
import org.intocps.maestro.ast.APlusBinaryExp;
import org.intocps.maestro.ast.node.SBlockStm;
import org.intocps.maestro.ast.node.INode;
import org.intocps.maestro.ast.node.SNumericPrimitiveType;
import org.intocps.maestro.ast.node.AConfigStm;
import org.intocps.maestro.ast.node.AUnknownType;
import org.intocps.maestro.ast.node.AUnloadExp;
import org.intocps.maestro.ast.PDeclaration;
import org.intocps.maestro.ast.node.AAssigmentStm;
import org.intocps.maestro.ast.node.ANullExp;
import org.intocps.maestro.ast.node.ABooleanPrimitiveType;
import java.lang.Boolean;
import org.intocps.maestro.ast.node.AArrayIndexExp;
import org.intocps.maestro.ast.node.AFmuMappingStm;
import java.util.LinkedList;
import org.intocps.maestro.ast.node.ABreakStm;
import org.intocps.maestro.ast.node.ARealNumericPrimitiveType;
import org.intocps.maestro.ast.ANotEqualBinaryExp;
import org.intocps.maestro.ast.node.ATryStm;
import org.intocps.maestro.ast.node.AUIntNumericPrimitiveType;
import org.intocps.maestro.ast.AMinusUnaryExp;
import org.intocps.maestro.ast.node.AFieldExp;
import org.intocps.maestro.ast.ADivideBinaryExp;
import org.intocps.maestro.ast.node.SPrimitiveType;
import org.intocps.maestro.ast.node.PFramework;
import org.intocps.maestro.ast.LexToken;
import org.intocps.maestro.ast.node.AReferenceType;
import org.intocps.maestro.ast.node.AVoidType;


/**
* Generated file by AST Creator
* @author Kenneth Lausdahl
*
*/
@SuppressWarnings({"all"})
public abstract class DepthFirstAnalysisAdaptor implements IAnalysis
{
	private static final long serialVersionUID = 1L;

	protected Set<INode> _visitedNodes = new java.util.HashSet<INode>();
	final protected IAnalysis THIS;

	/**
	* Creates a new complete constructor {@code DepthFirstAnalysisAdaptor} node with the given nodes as children.
	* The basic child nodes are removed from their previous parents.
	* @param visitedNodes_ the {@link Set} node for the {@code visitedNodes} child of this {@link DepthFirstAnalysisAdaptor} node
	* @param THIS_ the {@link IAnalysis} <b>graph</a> node for the {@code THIS} child of this {@link DepthFirstAnalysisAdaptor} node.
	*  <i>The parent of this {@code THIS } will not be changed by adding it to this node.</i>
	*/
	public DepthFirstAnalysisAdaptor(Set<INode> visitedNodes_, IAnalysis THIS_)
	{
		super();
		this.setVisitedNodes(visitedNodes_);
		this.THIS = THIS_;

	}


	/**
	 * Creates a new default constructor {@link DepthFirstAnalysisAdaptor} node with no children.
	 */
	public DepthFirstAnalysisAdaptor()
	{
		this.THIS=this;

	}


	/**
	 * Sets the {@code _visitedNodes} child of this {@link DepthFirstAnalysisAdaptor} node.
	 * @param value the new {@code _visitedNodes} child of this {@link DepthFirstAnalysisAdaptor} node
	*/
	public void setVisitedNodes(Set<INode> value)
	{

	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void caseString(String node) throws AnalysisException
	{
		inString(node);


		outString(node);

	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void inString(String node) throws AnalysisException
	{

	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void outString(String node) throws AnalysisException
	{

	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void caseBoolean(Boolean node) throws AnalysisException
	{
		inBoolean(node);


		outBoolean(node);

	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void inBoolean(Boolean node) throws AnalysisException
	{

	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void outBoolean(Boolean node) throws AnalysisException
	{

	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void caseInteger(Integer node) throws AnalysisException
	{
		inInteger(node);


		outInteger(node);

	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void inInteger(Integer node) throws AnalysisException
	{

	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void outInteger(Integer node) throws AnalysisException
	{

	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void caseDouble(Double node) throws AnalysisException
	{
		inDouble(node);


		outDouble(node);

	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void inDouble(Double node) throws AnalysisException
	{

	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void outDouble(Double node) throws AnalysisException
	{

	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void caseLong(Long node) throws AnalysisException
	{
		inLong(node);


		outLong(node);

	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void inLong(Long node) throws AnalysisException
	{

	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void outLong(Long node) throws AnalysisException
	{

	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void caseLexIdentifier(LexIdentifier node) throws AnalysisException
	{
		inLexIdentifier(node);


		outLexIdentifier(node);

	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void inLexIdentifier(LexIdentifier node) throws AnalysisException
	{

	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void outLexIdentifier(LexIdentifier node) throws AnalysisException
	{

	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void caseLexToken(LexToken node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inLexToken(node);


		outLexToken(node);

	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void inLexToken(LexToken node) throws AnalysisException
	{
		defaultInINode(node);
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void outLexToken(LexToken node) throws AnalysisException
	{
		defaultOutINode(node);
	}


	/**
	* Called by the {@link PDocument} node from {@link PDocument#apply(IAnalysis)}.
	* @param node the calling {@link PDocument} node
	*/
	public void defaultInPDocument(PDocument node) throws AnalysisException
	{
		defaultInINode(node);
	}


	/**
	* Called by the {@link PDocument} node from {@link PDocument#apply(IAnalysis)}.
	* @param node the calling {@link PDocument} node
	*/
	public void defaultOutPDocument(PDocument node) throws AnalysisException
	{
		defaultOutINode(node);
	}


	/**
	* Called by the {@link PDocument} node from {@link PDocument#apply(IAnalysis)}.
	* @param node the calling {@link PDocument} node
	*/
	public void defaultPDocument(PDocument node) throws AnalysisException
	{
		defaultINode(node);
	}


	/**
	* Called by the {@link PDocument} node from {@link PDocument#apply(IAnalysis)}.
	* @param node the calling {@link PDocument} node
	*/
	public void inPDocument(PDocument node) throws AnalysisException
	{
		defaultInINode(node);
	}


	/**
	* Called by the {@link PDocument} node from {@link PDocument#apply(IAnalysis)}.
	* @param node the calling {@link PDocument} node
	*/
	public void outPDocument(PDocument node) throws AnalysisException
	{
		defaultOutINode(node);
	}


	/**
	* Called by the {@link ARootDocument} node from {@link ARootDocument#apply(IAnalysis)}.
	* @param node the calling {@link ARootDocument} node
	*/
	public void caseARootDocument(ARootDocument node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inARootDocument(node);

		{
			List<PCompilationUnit> copy = new ArrayList<PCompilationUnit>(node.getContent());
			for( PCompilationUnit e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					e.apply(this);
				}
			}
		}

		outARootDocument(node);

	}


	/**
	* Called by the {@link ARootDocument} node from {@link ARootDocument#apply(IAnalysis)}.
	* @param node the calling {@link ARootDocument} node
	*/
	public void inARootDocument(ARootDocument node) throws AnalysisException
	{
		defaultInPDocument(node);
	}


	/**
	* Called by the {@link ARootDocument} node from {@link ARootDocument#apply(IAnalysis)}.
	* @param node the calling {@link ARootDocument} node
	*/
	public void outARootDocument(ARootDocument node) throws AnalysisException
	{
		defaultOutPDocument(node);
	}


	/**
	* Called by the {@link PCompilationUnit} node from {@link PCompilationUnit#apply(IAnalysis)}.
	* @param node the calling {@link PCompilationUnit} node
	*/
	public void defaultInPCompilationUnit(PCompilationUnit node) throws AnalysisException
	{
		defaultInINode(node);
	}


	/**
	* Called by the {@link PCompilationUnit} node from {@link PCompilationUnit#apply(IAnalysis)}.
	* @param node the calling {@link PCompilationUnit} node
	*/
	public void defaultOutPCompilationUnit(PCompilationUnit node) throws AnalysisException
	{
		defaultOutINode(node);
	}


	/**
	* Called by the {@link PCompilationUnit} node from {@link PCompilationUnit#apply(IAnalysis)}.
	* @param node the calling {@link PCompilationUnit} node
	*/
	public void defaultPCompilationUnit(PCompilationUnit node) throws AnalysisException
	{
		defaultINode(node);
	}


	/**
	* Called by the {@link PCompilationUnit} node from {@link PCompilationUnit#apply(IAnalysis)}.
	* @param node the calling {@link PCompilationUnit} node
	*/
	public void inPCompilationUnit(PCompilationUnit node) throws AnalysisException
	{
		defaultInINode(node);
	}


	/**
	* Called by the {@link PCompilationUnit} node from {@link PCompilationUnit#apply(IAnalysis)}.
	* @param node the calling {@link PCompilationUnit} node
	*/
	public void outPCompilationUnit(PCompilationUnit node) throws AnalysisException
	{
		defaultOutINode(node);
	}


	/**
	* Called by the {@link AImportedModuleCompilationUnit} node from {@link AImportedModuleCompilationUnit#apply(IAnalysis)}.
	* @param node the calling {@link AImportedModuleCompilationUnit} node
	*/
	public void caseAImportedModuleCompilationUnit(AImportedModuleCompilationUnit node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAImportedModuleCompilationUnit(node);

		if(node.getModule() != null && !_visitedNodes.contains(node.getModule())) 
		{
			node.getModule().apply(this);
		}

		outAImportedModuleCompilationUnit(node);

	}


	/**
	* Called by the {@link AImportedModuleCompilationUnit} node from {@link AImportedModuleCompilationUnit#apply(IAnalysis)}.
	* @param node the calling {@link AImportedModuleCompilationUnit} node
	*/
	public void inAImportedModuleCompilationUnit(AImportedModuleCompilationUnit node) throws AnalysisException
	{
		defaultInPCompilationUnit(node);
	}


	/**
	* Called by the {@link AImportedModuleCompilationUnit} node from {@link AImportedModuleCompilationUnit#apply(IAnalysis)}.
	* @param node the calling {@link AImportedModuleCompilationUnit} node
	*/
	public void outAImportedModuleCompilationUnit(AImportedModuleCompilationUnit node) throws AnalysisException
	{
		defaultOutPCompilationUnit(node);
	}


	/**
	* Called by the {@link ASimulationSpecificationCompilationUnit} node from {@link ASimulationSpecificationCompilationUnit#apply(IAnalysis)}.
	* @param node the calling {@link ASimulationSpecificationCompilationUnit} node
	*/
	public void caseASimulationSpecificationCompilationUnit(ASimulationSpecificationCompilationUnit node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inASimulationSpecificationCompilationUnit(node);

		if(node.getBody() != null && !_visitedNodes.contains(node.getBody())) 
		{
			node.getBody().apply(this);
		}
		{
			List<AConfigFramework> copy = new ArrayList<AConfigFramework>(node.getFrameworkConfigs());
			for( AConfigFramework e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					e.apply(this);
				}
			}
		}

		outASimulationSpecificationCompilationUnit(node);

	}


	/**
	* Called by the {@link ASimulationSpecificationCompilationUnit} node from {@link ASimulationSpecificationCompilationUnit#apply(IAnalysis)}.
	* @param node the calling {@link ASimulationSpecificationCompilationUnit} node
	*/
	public void inASimulationSpecificationCompilationUnit(ASimulationSpecificationCompilationUnit node) throws AnalysisException
	{
		defaultInPCompilationUnit(node);
	}


	/**
	* Called by the {@link ASimulationSpecificationCompilationUnit} node from {@link ASimulationSpecificationCompilationUnit#apply(IAnalysis)}.
	* @param node the calling {@link ASimulationSpecificationCompilationUnit} node
	*/
	public void outASimulationSpecificationCompilationUnit(ASimulationSpecificationCompilationUnit node) throws AnalysisException
	{
		defaultOutPCompilationUnit(node);
	}


	/**
	* Called by the {@link PFramework} node from {@link PFramework#apply(IAnalysis)}.
	* @param node the calling {@link PFramework} node
	*/
	public void defaultInPFramework(PFramework node) throws AnalysisException
	{
		defaultInINode(node);
	}


	/**
	* Called by the {@link PFramework} node from {@link PFramework#apply(IAnalysis)}.
	* @param node the calling {@link PFramework} node
	*/
	public void defaultOutPFramework(PFramework node) throws AnalysisException
	{
		defaultOutINode(node);
	}


	/**
	* Called by the {@link PFramework} node from {@link PFramework#apply(IAnalysis)}.
	* @param node the calling {@link PFramework} node
	*/
	public void defaultPFramework(PFramework node) throws AnalysisException
	{
		defaultINode(node);
	}


	/**
	* Called by the {@link PFramework} node from {@link PFramework#apply(IAnalysis)}.
	* @param node the calling {@link PFramework} node
	*/
	public void inPFramework(PFramework node) throws AnalysisException
	{
		defaultInINode(node);
	}


	/**
	* Called by the {@link PFramework} node from {@link PFramework#apply(IAnalysis)}.
	* @param node the calling {@link PFramework} node
	*/
	public void outPFramework(PFramework node) throws AnalysisException
	{
		defaultOutINode(node);
	}


	/**
	* Called by the {@link AConfigFramework} node from {@link AConfigFramework#apply(IAnalysis)}.
	* @param node the calling {@link AConfigFramework} node
	*/
	public void caseAConfigFramework(AConfigFramework node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAConfigFramework(node);


		outAConfigFramework(node);

	}


	/**
	* Called by the {@link AConfigFramework} node from {@link AConfigFramework#apply(IAnalysis)}.
	* @param node the calling {@link AConfigFramework} node
	*/
	public void inAConfigFramework(AConfigFramework node) throws AnalysisException
	{
		defaultInPFramework(node);
	}


	/**
	* Called by the {@link AConfigFramework} node from {@link AConfigFramework#apply(IAnalysis)}.
	* @param node the calling {@link AConfigFramework} node
	*/
	public void outAConfigFramework(AConfigFramework node) throws AnalysisException
	{
		defaultOutPFramework(node);
	}


	/**
	* Called by the {@link PDeclaration} node from {@link PDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link PDeclaration} node
	*/
	public void defaultInPDeclaration(PDeclaration node) throws AnalysisException
	{
		defaultInINode(node);
	}


	/**
	* Called by the {@link PDeclaration} node from {@link PDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link PDeclaration} node
	*/
	public void defaultOutPDeclaration(PDeclaration node) throws AnalysisException
	{
		defaultOutINode(node);
	}


	/**
	* Called by the {@link PDeclaration} node from {@link PDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link PDeclaration} node
	*/
	public void defaultPDeclaration(PDeclaration node) throws AnalysisException
	{
		defaultINode(node);
	}


	/**
	* Called by the {@link PDeclaration} node from {@link PDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link PDeclaration} node
	*/
	public void inPDeclaration(PDeclaration node) throws AnalysisException
	{
		defaultInINode(node);
	}


	/**
	* Called by the {@link PDeclaration} node from {@link PDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link PDeclaration} node
	*/
	public void outPDeclaration(PDeclaration node) throws AnalysisException
	{
		defaultOutINode(node);
	}


	/**
	* Called by the {@link AFunctionDeclaration} node from {@link AFunctionDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link AFunctionDeclaration} node
	*/
	public void caseAFunctionDeclaration(AFunctionDeclaration node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAFunctionDeclaration(node);

		if(node.getReturnType() != null && !_visitedNodes.contains(node.getReturnType())) 
		{
			node.getReturnType().apply(this);
		}
		{
			List<AFormalParameter> copy = new ArrayList<AFormalParameter>(node.getFormals());
			for( AFormalParameter e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					e.apply(this);
				}
			}
		}

		outAFunctionDeclaration(node);

	}


	/**
	* Called by the {@link AFunctionDeclaration} node from {@link AFunctionDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link AFunctionDeclaration} node
	*/
	public void inAFunctionDeclaration(AFunctionDeclaration node) throws AnalysisException
	{
		defaultInPDeclaration(node);
	}


	/**
	* Called by the {@link AFunctionDeclaration} node from {@link AFunctionDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link AFunctionDeclaration} node
	*/
	public void outAFunctionDeclaration(AFunctionDeclaration node) throws AnalysisException
	{
		defaultOutPDeclaration(node);
	}


	/**
	* Called by the {@link AVariableDeclaration} node from {@link AVariableDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link AVariableDeclaration} node
	*/
	public void caseAVariableDeclaration(AVariableDeclaration node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAVariableDeclaration(node);

		if(node.getType() != null && !_visitedNodes.contains(node.getType())) 
		{
			node.getType().apply(this);
		}
		{
			List<PExp> copy = new ArrayList<PExp>(node.getSize());
			for( PExp e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					e.apply(this);
				}
			}
		}
		if(node.getInitializer() != null && !_visitedNodes.contains(node.getInitializer())) 
		{
			node.getInitializer().apply(this);
		}

		outAVariableDeclaration(node);

	}


	/**
	* Called by the {@link AVariableDeclaration} node from {@link AVariableDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link AVariableDeclaration} node
	*/
	public void inAVariableDeclaration(AVariableDeclaration node) throws AnalysisException
	{
		defaultInPDeclaration(node);
	}


	/**
	* Called by the {@link AVariableDeclaration} node from {@link AVariableDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link AVariableDeclaration} node
	*/
	public void outAVariableDeclaration(AVariableDeclaration node) throws AnalysisException
	{
		defaultOutPDeclaration(node);
	}


	/**
	* Called by the {@link AModuleDeclaration} node from {@link AModuleDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link AModuleDeclaration} node
	*/
	public void caseAModuleDeclaration(AModuleDeclaration node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAModuleDeclaration(node);

		{
			List<AFunctionDeclaration> copy = new ArrayList<AFunctionDeclaration>(node.getFunctions());
			for( AFunctionDeclaration e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					e.apply(this);
				}
			}
		}

		outAModuleDeclaration(node);

	}


	/**
	* Called by the {@link AModuleDeclaration} node from {@link AModuleDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link AModuleDeclaration} node
	*/
	public void inAModuleDeclaration(AModuleDeclaration node) throws AnalysisException
	{
		defaultInPDeclaration(node);
	}


	/**
	* Called by the {@link AModuleDeclaration} node from {@link AModuleDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link AModuleDeclaration} node
	*/
	public void outAModuleDeclaration(AModuleDeclaration node) throws AnalysisException
	{
		defaultOutPDeclaration(node);
	}


	/**
	* Called by the {@link PInitializer} node from {@link PInitializer#apply(IAnalysis)}.
	* @param node the calling {@link PInitializer} node
	*/
	public void defaultInPInitializer(PInitializer node) throws AnalysisException
	{
		defaultInINode(node);
	}


	/**
	* Called by the {@link PInitializer} node from {@link PInitializer#apply(IAnalysis)}.
	* @param node the calling {@link PInitializer} node
	*/
	public void defaultOutPInitializer(PInitializer node) throws AnalysisException
	{
		defaultOutINode(node);
	}


	/**
	* Called by the {@link PInitializer} node from {@link PInitializer#apply(IAnalysis)}.
	* @param node the calling {@link PInitializer} node
	*/
	public void defaultPInitializer(PInitializer node) throws AnalysisException
	{
		defaultINode(node);
	}


	/**
	* Called by the {@link PInitializer} node from {@link PInitializer#apply(IAnalysis)}.
	* @param node the calling {@link PInitializer} node
	*/
	public void inPInitializer(PInitializer node) throws AnalysisException
	{
		defaultInINode(node);
	}


	/**
	* Called by the {@link PInitializer} node from {@link PInitializer#apply(IAnalysis)}.
	* @param node the calling {@link PInitializer} node
	*/
	public void outPInitializer(PInitializer node) throws AnalysisException
	{
		defaultOutINode(node);
	}


	/**
	* Called by the {@link AExpInitializer} node from {@link AExpInitializer#apply(IAnalysis)}.
	* @param node the calling {@link AExpInitializer} node
	*/
	public void caseAExpInitializer(AExpInitializer node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAExpInitializer(node);

		if(node.getExp() != null && !_visitedNodes.contains(node.getExp())) 
		{
			node.getExp().apply(this);
		}

		outAExpInitializer(node);

	}


	/**
	* Called by the {@link AExpInitializer} node from {@link AExpInitializer#apply(IAnalysis)}.
	* @param node the calling {@link AExpInitializer} node
	*/
	public void inAExpInitializer(AExpInitializer node) throws AnalysisException
	{
		defaultInPInitializer(node);
	}


	/**
	* Called by the {@link AExpInitializer} node from {@link AExpInitializer#apply(IAnalysis)}.
	* @param node the calling {@link AExpInitializer} node
	*/
	public void outAExpInitializer(AExpInitializer node) throws AnalysisException
	{
		defaultOutPInitializer(node);
	}


	/**
	* Called by the {@link AArrayInitializer} node from {@link AArrayInitializer#apply(IAnalysis)}.
	* @param node the calling {@link AArrayInitializer} node
	*/
	public void caseAArrayInitializer(AArrayInitializer node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAArrayInitializer(node);

		{
			List<PExp> copy = new ArrayList<PExp>(node.getExp());
			for( PExp e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					e.apply(this);
				}
			}
		}

		outAArrayInitializer(node);

	}


	/**
	* Called by the {@link AArrayInitializer} node from {@link AArrayInitializer#apply(IAnalysis)}.
	* @param node the calling {@link AArrayInitializer} node
	*/
	public void inAArrayInitializer(AArrayInitializer node) throws AnalysisException
	{
		defaultInPInitializer(node);
	}


	/**
	* Called by the {@link AArrayInitializer} node from {@link AArrayInitializer#apply(IAnalysis)}.
	* @param node the calling {@link AArrayInitializer} node
	*/
	public void outAArrayInitializer(AArrayInitializer node) throws AnalysisException
	{
		defaultOutPInitializer(node);
	}


	/**
	* Called by the {@link PParameter} node from {@link PParameter#apply(IAnalysis)}.
	* @param node the calling {@link PParameter} node
	*/
	public void defaultInPParameter(PParameter node) throws AnalysisException
	{
		defaultInINode(node);
	}


	/**
	* Called by the {@link PParameter} node from {@link PParameter#apply(IAnalysis)}.
	* @param node the calling {@link PParameter} node
	*/
	public void defaultOutPParameter(PParameter node) throws AnalysisException
	{
		defaultOutINode(node);
	}


	/**
	* Called by the {@link PParameter} node from {@link PParameter#apply(IAnalysis)}.
	* @param node the calling {@link PParameter} node
	*/
	public void defaultPParameter(PParameter node) throws AnalysisException
	{
		defaultINode(node);
	}


	/**
	* Called by the {@link PParameter} node from {@link PParameter#apply(IAnalysis)}.
	* @param node the calling {@link PParameter} node
	*/
	public void inPParameter(PParameter node) throws AnalysisException
	{
		defaultInINode(node);
	}


	/**
	* Called by the {@link PParameter} node from {@link PParameter#apply(IAnalysis)}.
	* @param node the calling {@link PParameter} node
	*/
	public void outPParameter(PParameter node) throws AnalysisException
	{
		defaultOutINode(node);
	}


	/**
	* Called by the {@link AFormalParameter} node from {@link AFormalParameter#apply(IAnalysis)}.
	* @param node the calling {@link AFormalParameter} node
	*/
	public void caseAFormalParameter(AFormalParameter node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAFormalParameter(node);

		if(node.getType() != null && !_visitedNodes.contains(node.getType())) 
		{
			node.getType().apply(this);
		}

		outAFormalParameter(node);

	}


	/**
	* Called by the {@link AFormalParameter} node from {@link AFormalParameter#apply(IAnalysis)}.
	* @param node the calling {@link AFormalParameter} node
	*/
	public void inAFormalParameter(AFormalParameter node) throws AnalysisException
	{
		defaultInPParameter(node);
	}


	/**
	* Called by the {@link AFormalParameter} node from {@link AFormalParameter#apply(IAnalysis)}.
	* @param node the calling {@link AFormalParameter} node
	*/
	public void outAFormalParameter(AFormalParameter node) throws AnalysisException
	{
		defaultOutPParameter(node);
	}


	/**
	* Called by the {@link PExp} node from {@link PExp#apply(IAnalysis)}.
	* @param node the calling {@link PExp} node
	*/
	public void defaultInPExp(PExp node) throws AnalysisException
	{
		defaultInINode(node);
	}


	/**
	* Called by the {@link PExp} node from {@link PExp#apply(IAnalysis)}.
	* @param node the calling {@link PExp} node
	*/
	public void defaultOutPExp(PExp node) throws AnalysisException
	{
		defaultOutINode(node);
	}


	/**
	* Called by the {@link PExp} node from {@link PExp#apply(IAnalysis)}.
	* @param node the calling {@link PExp} node
	*/
	public void defaultPExp(PExp node) throws AnalysisException
	{
		defaultINode(node);
	}


	/**
	* Called by the {@link PExp} node from {@link PExp#apply(IAnalysis)}.
	* @param node the calling {@link PExp} node
	*/
	public void inPExp(PExp node) throws AnalysisException
	{
		defaultInINode(node);
	}


	/**
	* Called by the {@link PExp} node from {@link PExp#apply(IAnalysis)}.
	* @param node the calling {@link PExp} node
	*/
	public void outPExp(PExp node) throws AnalysisException
	{
		defaultOutINode(node);
	}


	/**
	* Called by the {@link AIdentifierExp} node from {@link AIdentifierExp#apply(IAnalysis)}.
	* @param node the calling {@link AIdentifierExp} node
	*/
	public void caseAIdentifierExp(AIdentifierExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAIdentifierExp(node);


		outAIdentifierExp(node);

	}


	/**
	* Called by the {@link AIdentifierExp} node from {@link AIdentifierExp#apply(IAnalysis)}.
	* @param node the calling {@link AIdentifierExp} node
	*/
	public void inAIdentifierExp(AIdentifierExp node) throws AnalysisException
	{
		defaultInPExp(node);
	}


	/**
	* Called by the {@link AIdentifierExp} node from {@link AIdentifierExp#apply(IAnalysis)}.
	* @param node the calling {@link AIdentifierExp} node
	*/
	public void outAIdentifierExp(AIdentifierExp node) throws AnalysisException
	{
		defaultOutPExp(node);
	}


	/**
	* Called by the {@link SLiteralExp} node from {@link SLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link SLiteralExp} node
	*/
	public void defaultInSLiteralExp(SLiteralExp node) throws AnalysisException
	{
		defaultInPExp(node);
	}


	/**
	* Called by the {@link SLiteralExp} node from {@link SLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link SLiteralExp} node
	*/
	public void defaultOutSLiteralExp(SLiteralExp node) throws AnalysisException
	{
		defaultOutPExp(node);
	}


	/**
	* Called by the {@link SLiteralExp} node from {@link SLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link SLiteralExp} node
	*/
	public void defaultSLiteralExp(SLiteralExp node) throws AnalysisException
	{
		defaultPExp(node);
	}


	/**
	* Called by the {@link SLiteralExp} node from {@link SLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link SLiteralExp} node
	*/
	public void inSLiteralExp(SLiteralExp node) throws AnalysisException
	{
		defaultInPExp(node);
	}


	/**
	* Called by the {@link SLiteralExp} node from {@link SLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link SLiteralExp} node
	*/
	public void outSLiteralExp(SLiteralExp node) throws AnalysisException
	{
		defaultOutPExp(node);
	}


	/**
	* Called by the {@link ALoadExp} node from {@link ALoadExp#apply(IAnalysis)}.
	* @param node the calling {@link ALoadExp} node
	*/
	public void caseALoadExp(ALoadExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inALoadExp(node);

		{
			List<PExp> copy = new ArrayList<PExp>(node.getArgs());
			for( PExp e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					e.apply(this);
				}
			}
		}

		outALoadExp(node);

	}


	/**
	* Called by the {@link ALoadExp} node from {@link ALoadExp#apply(IAnalysis)}.
	* @param node the calling {@link ALoadExp} node
	*/
	public void inALoadExp(ALoadExp node) throws AnalysisException
	{
		defaultInPExp(node);
	}


	/**
	* Called by the {@link ALoadExp} node from {@link ALoadExp#apply(IAnalysis)}.
	* @param node the calling {@link ALoadExp} node
	*/
	public void outALoadExp(ALoadExp node) throws AnalysisException
	{
		defaultOutPExp(node);
	}


	/**
	* Called by the {@link AUnloadExp} node from {@link AUnloadExp#apply(IAnalysis)}.
	* @param node the calling {@link AUnloadExp} node
	*/
	public void caseAUnloadExp(AUnloadExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAUnloadExp(node);

		{
			List<PExp> copy = new ArrayList<PExp>(node.getArgs());
			for( PExp e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					e.apply(this);
				}
			}
		}

		outAUnloadExp(node);

	}


	/**
	* Called by the {@link AUnloadExp} node from {@link AUnloadExp#apply(IAnalysis)}.
	* @param node the calling {@link AUnloadExp} node
	*/
	public void inAUnloadExp(AUnloadExp node) throws AnalysisException
	{
		defaultInPExp(node);
	}


	/**
	* Called by the {@link AUnloadExp} node from {@link AUnloadExp#apply(IAnalysis)}.
	* @param node the calling {@link AUnloadExp} node
	*/
	public void outAUnloadExp(AUnloadExp node) throws AnalysisException
	{
		defaultOutPExp(node);
	}


	/**
	* Called by the {@link SBinaryExp} node from {@link SBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link SBinaryExp} node
	*/
	public void defaultInSBinaryExp(SBinaryExp node) throws AnalysisException
	{
		defaultInPExp(node);
	}


	/**
	* Called by the {@link SBinaryExp} node from {@link SBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link SBinaryExp} node
	*/
	public void defaultOutSBinaryExp(SBinaryExp node) throws AnalysisException
	{
		defaultOutPExp(node);
	}


	/**
	* Called by the {@link SBinaryExp} node from {@link SBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link SBinaryExp} node
	*/
	public void defaultSBinaryExp(SBinaryExp node) throws AnalysisException
	{
		defaultPExp(node);
	}


	/**
	* Called by the {@link SBinaryExp} node from {@link SBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link SBinaryExp} node
	*/
	public void inSBinaryExp(SBinaryExp node) throws AnalysisException
	{
		defaultInPExp(node);
	}


	/**
	* Called by the {@link SBinaryExp} node from {@link SBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link SBinaryExp} node
	*/
	public void outSBinaryExp(SBinaryExp node) throws AnalysisException
	{
		defaultOutPExp(node);
	}


	/**
	* Called by the {@link SUnaryExp} node from {@link SUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link SUnaryExp} node
	*/
	public void defaultInSUnaryExp(SUnaryExp node) throws AnalysisException
	{
		defaultInPExp(node);
	}


	/**
	* Called by the {@link SUnaryExp} node from {@link SUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link SUnaryExp} node
	*/
	public void defaultOutSUnaryExp(SUnaryExp node) throws AnalysisException
	{
		defaultOutPExp(node);
	}


	/**
	* Called by the {@link SUnaryExp} node from {@link SUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link SUnaryExp} node
	*/
	public void defaultSUnaryExp(SUnaryExp node) throws AnalysisException
	{
		defaultPExp(node);
	}


	/**
	* Called by the {@link SUnaryExp} node from {@link SUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link SUnaryExp} node
	*/
	public void inSUnaryExp(SUnaryExp node) throws AnalysisException
	{
		defaultInPExp(node);
	}


	/**
	* Called by the {@link SUnaryExp} node from {@link SUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link SUnaryExp} node
	*/
	public void outSUnaryExp(SUnaryExp node) throws AnalysisException
	{
		defaultOutPExp(node);
	}


	/**
	* Called by the {@link AFieldExp} node from {@link AFieldExp#apply(IAnalysis)}.
	* @param node the calling {@link AFieldExp} node
	*/
	public void caseAFieldExp(AFieldExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAFieldExp(node);

		if(node.getRoot() != null && !_visitedNodes.contains(node.getRoot())) 
		{
			node.getRoot().apply(this);
		}

		outAFieldExp(node);

	}


	/**
	* Called by the {@link AFieldExp} node from {@link AFieldExp#apply(IAnalysis)}.
	* @param node the calling {@link AFieldExp} node
	*/
	public void inAFieldExp(AFieldExp node) throws AnalysisException
	{
		defaultInPExp(node);
	}


	/**
	* Called by the {@link AFieldExp} node from {@link AFieldExp#apply(IAnalysis)}.
	* @param node the calling {@link AFieldExp} node
	*/
	public void outAFieldExp(AFieldExp node) throws AnalysisException
	{
		defaultOutPExp(node);
	}


	/**
	* Called by the {@link ACallExp} node from {@link ACallExp#apply(IAnalysis)}.
	* @param node the calling {@link ACallExp} node
	*/
	public void caseACallExp(ACallExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inACallExp(node);

		if(node.getObject() != null && !_visitedNodes.contains(node.getObject())) 
		{
			node.getObject().apply(this);
		}
		if(node.getExpand() != null ) 
		{
			node.getExpand().apply(this);
		}
		{
			List<PExp> copy = new ArrayList<PExp>(node.getArgs());
			for( PExp e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					e.apply(this);
				}
			}
		}

		outACallExp(node);

	}


	/**
	* Called by the {@link ACallExp} node from {@link ACallExp#apply(IAnalysis)}.
	* @param node the calling {@link ACallExp} node
	*/
	public void inACallExp(ACallExp node) throws AnalysisException
	{
		defaultInPExp(node);
	}


	/**
	* Called by the {@link ACallExp} node from {@link ACallExp#apply(IAnalysis)}.
	* @param node the calling {@link ACallExp} node
	*/
	public void outACallExp(ACallExp node) throws AnalysisException
	{
		defaultOutPExp(node);
	}


	/**
	* Called by the {@link AArrayIndexExp} node from {@link AArrayIndexExp#apply(IAnalysis)}.
	* @param node the calling {@link AArrayIndexExp} node
	*/
	public void caseAArrayIndexExp(AArrayIndexExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAArrayIndexExp(node);

		if(node.getArray() != null && !_visitedNodes.contains(node.getArray())) 
		{
			node.getArray().apply(this);
		}
		{
			List<PExp> copy = new ArrayList<PExp>(node.getIndices());
			for( PExp e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					e.apply(this);
				}
			}
		}

		outAArrayIndexExp(node);

	}


	/**
	* Called by the {@link AArrayIndexExp} node from {@link AArrayIndexExp#apply(IAnalysis)}.
	* @param node the calling {@link AArrayIndexExp} node
	*/
	public void inAArrayIndexExp(AArrayIndexExp node) throws AnalysisException
	{
		defaultInPExp(node);
	}


	/**
	* Called by the {@link AArrayIndexExp} node from {@link AArrayIndexExp#apply(IAnalysis)}.
	* @param node the calling {@link AArrayIndexExp} node
	*/
	public void outAArrayIndexExp(AArrayIndexExp node) throws AnalysisException
	{
		defaultOutPExp(node);
	}


	/**
	* Called by the {@link AParExp} node from {@link AParExp#apply(IAnalysis)}.
	* @param node the calling {@link AParExp} node
	*/
	public void caseAParExp(AParExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAParExp(node);

		if(node.getExp() != null && !_visitedNodes.contains(node.getExp())) 
		{
			node.getExp().apply(this);
		}

		outAParExp(node);

	}


	/**
	* Called by the {@link AParExp} node from {@link AParExp#apply(IAnalysis)}.
	* @param node the calling {@link AParExp} node
	*/
	public void inAParExp(AParExp node) throws AnalysisException
	{
		defaultInPExp(node);
	}


	/**
	* Called by the {@link AParExp} node from {@link AParExp#apply(IAnalysis)}.
	* @param node the calling {@link AParExp} node
	*/
	public void outAParExp(AParExp node) throws AnalysisException
	{
		defaultOutPExp(node);
	}


	/**
	* Called by the {@link ANullExp} node from {@link ANullExp#apply(IAnalysis)}.
	* @param node the calling {@link ANullExp} node
	*/
	public void caseANullExp(ANullExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inANullExp(node);

		if(node.getToken() != null ) 
		{
			node.getToken().apply(this);
		}

		outANullExp(node);

	}


	/**
	* Called by the {@link ANullExp} node from {@link ANullExp#apply(IAnalysis)}.
	* @param node the calling {@link ANullExp} node
	*/
	public void inANullExp(ANullExp node) throws AnalysisException
	{
		defaultInPExp(node);
	}


	/**
	* Called by the {@link ANullExp} node from {@link ANullExp#apply(IAnalysis)}.
	* @param node the calling {@link ANullExp} node
	*/
	public void outANullExp(ANullExp node) throws AnalysisException
	{
		defaultOutPExp(node);
	}


	/**
	* Called by the {@link ARefExp} node from {@link ARefExp#apply(IAnalysis)}.
	* @param node the calling {@link ARefExp} node
	*/
	public void caseARefExp(ARefExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inARefExp(node);

		if(node.getExp() != null && !_visitedNodes.contains(node.getExp())) 
		{
			node.getExp().apply(this);
		}

		outARefExp(node);

	}


	/**
	* Called by the {@link ARefExp} node from {@link ARefExp#apply(IAnalysis)}.
	* @param node the calling {@link ARefExp} node
	*/
	public void inARefExp(ARefExp node) throws AnalysisException
	{
		defaultInPExp(node);
	}


	/**
	* Called by the {@link ARefExp} node from {@link ARefExp#apply(IAnalysis)}.
	* @param node the calling {@link ARefExp} node
	*/
	public void outARefExp(ARefExp node) throws AnalysisException
	{
		defaultOutPExp(node);
	}


	/**
	* Called by the {@link AStringLiteralExp} node from {@link AStringLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link AStringLiteralExp} node
	*/
	public void caseAStringLiteralExp(AStringLiteralExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAStringLiteralExp(node);


		outAStringLiteralExp(node);

	}


	/**
	* Called by the {@link AStringLiteralExp} node from {@link AStringLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link AStringLiteralExp} node
	*/
	public void inAStringLiteralExp(AStringLiteralExp node) throws AnalysisException
	{
		defaultInSLiteralExp(node);
	}


	/**
	* Called by the {@link AStringLiteralExp} node from {@link AStringLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link AStringLiteralExp} node
	*/
	public void outAStringLiteralExp(AStringLiteralExp node) throws AnalysisException
	{
		defaultOutSLiteralExp(node);
	}


	/**
	* Called by the {@link ABoolLiteralExp} node from {@link ABoolLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link ABoolLiteralExp} node
	*/
	public void caseABoolLiteralExp(ABoolLiteralExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inABoolLiteralExp(node);


		outABoolLiteralExp(node);

	}


	/**
	* Called by the {@link ABoolLiteralExp} node from {@link ABoolLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link ABoolLiteralExp} node
	*/
	public void inABoolLiteralExp(ABoolLiteralExp node) throws AnalysisException
	{
		defaultInSLiteralExp(node);
	}


	/**
	* Called by the {@link ABoolLiteralExp} node from {@link ABoolLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link ABoolLiteralExp} node
	*/
	public void outABoolLiteralExp(ABoolLiteralExp node) throws AnalysisException
	{
		defaultOutSLiteralExp(node);
	}


	/**
	* Called by the {@link AIntLiteralExp} node from {@link AIntLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link AIntLiteralExp} node
	*/
	public void caseAIntLiteralExp(AIntLiteralExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAIntLiteralExp(node);


		outAIntLiteralExp(node);

	}


	/**
	* Called by the {@link AIntLiteralExp} node from {@link AIntLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link AIntLiteralExp} node
	*/
	public void inAIntLiteralExp(AIntLiteralExp node) throws AnalysisException
	{
		defaultInSLiteralExp(node);
	}


	/**
	* Called by the {@link AIntLiteralExp} node from {@link AIntLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link AIntLiteralExp} node
	*/
	public void outAIntLiteralExp(AIntLiteralExp node) throws AnalysisException
	{
		defaultOutSLiteralExp(node);
	}


	/**
	* Called by the {@link AUIntLiteralExp} node from {@link AUIntLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link AUIntLiteralExp} node
	*/
	public void caseAUIntLiteralExp(AUIntLiteralExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAUIntLiteralExp(node);


		outAUIntLiteralExp(node);

	}


	/**
	* Called by the {@link AUIntLiteralExp} node from {@link AUIntLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link AUIntLiteralExp} node
	*/
	public void inAUIntLiteralExp(AUIntLiteralExp node) throws AnalysisException
	{
		defaultInSLiteralExp(node);
	}


	/**
	* Called by the {@link AUIntLiteralExp} node from {@link AUIntLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link AUIntLiteralExp} node
	*/
	public void outAUIntLiteralExp(AUIntLiteralExp node) throws AnalysisException
	{
		defaultOutSLiteralExp(node);
	}


	/**
	* Called by the {@link ARealLiteralExp} node from {@link ARealLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link ARealLiteralExp} node
	*/
	public void caseARealLiteralExp(ARealLiteralExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inARealLiteralExp(node);


		outARealLiteralExp(node);

	}


	/**
	* Called by the {@link ARealLiteralExp} node from {@link ARealLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link ARealLiteralExp} node
	*/
	public void inARealLiteralExp(ARealLiteralExp node) throws AnalysisException
	{
		defaultInSLiteralExp(node);
	}


	/**
	* Called by the {@link ARealLiteralExp} node from {@link ARealLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link ARealLiteralExp} node
	*/
	public void outARealLiteralExp(ARealLiteralExp node) throws AnalysisException
	{
		defaultOutSLiteralExp(node);
	}


	/**
	* Called by the {@link APlusBinaryExp} node from {@link APlusBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link APlusBinaryExp} node
	*/
	public void caseAPlusBinaryExp(APlusBinaryExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAPlusBinaryExp(node);

		if(node.getLeft() != null && !_visitedNodes.contains(node.getLeft())) 
		{
			node.getLeft().apply(this);
		}
		if(node.getRight() != null && !_visitedNodes.contains(node.getRight())) 
		{
			node.getRight().apply(this);
		}

		outAPlusBinaryExp(node);

	}


	/**
	* Called by the {@link APlusBinaryExp} node from {@link APlusBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link APlusBinaryExp} node
	*/
	public void inAPlusBinaryExp(APlusBinaryExp node) throws AnalysisException
	{
		defaultInSBinaryExp(node);
	}


	/**
	* Called by the {@link APlusBinaryExp} node from {@link APlusBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link APlusBinaryExp} node
	*/
	public void outAPlusBinaryExp(APlusBinaryExp node) throws AnalysisException
	{
		defaultOutSBinaryExp(node);
	}


	/**
	* Called by the {@link AMinusBinaryExp} node from {@link AMinusBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AMinusBinaryExp} node
	*/
	public void caseAMinusBinaryExp(AMinusBinaryExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAMinusBinaryExp(node);

		if(node.getLeft() != null && !_visitedNodes.contains(node.getLeft())) 
		{
			node.getLeft().apply(this);
		}
		if(node.getRight() != null && !_visitedNodes.contains(node.getRight())) 
		{
			node.getRight().apply(this);
		}

		outAMinusBinaryExp(node);

	}


	/**
	* Called by the {@link AMinusBinaryExp} node from {@link AMinusBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AMinusBinaryExp} node
	*/
	public void inAMinusBinaryExp(AMinusBinaryExp node) throws AnalysisException
	{
		defaultInSBinaryExp(node);
	}


	/**
	* Called by the {@link AMinusBinaryExp} node from {@link AMinusBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AMinusBinaryExp} node
	*/
	public void outAMinusBinaryExp(AMinusBinaryExp node) throws AnalysisException
	{
		defaultOutSBinaryExp(node);
	}


	/**
	* Called by the {@link ALessEqualBinaryExp} node from {@link ALessEqualBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ALessEqualBinaryExp} node
	*/
	public void caseALessEqualBinaryExp(ALessEqualBinaryExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inALessEqualBinaryExp(node);

		if(node.getLeft() != null && !_visitedNodes.contains(node.getLeft())) 
		{
			node.getLeft().apply(this);
		}
		if(node.getRight() != null && !_visitedNodes.contains(node.getRight())) 
		{
			node.getRight().apply(this);
		}

		outALessEqualBinaryExp(node);

	}


	/**
	* Called by the {@link ALessEqualBinaryExp} node from {@link ALessEqualBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ALessEqualBinaryExp} node
	*/
	public void inALessEqualBinaryExp(ALessEqualBinaryExp node) throws AnalysisException
	{
		defaultInSBinaryExp(node);
	}


	/**
	* Called by the {@link ALessEqualBinaryExp} node from {@link ALessEqualBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ALessEqualBinaryExp} node
	*/
	public void outALessEqualBinaryExp(ALessEqualBinaryExp node) throws AnalysisException
	{
		defaultOutSBinaryExp(node);
	}


	/**
	* Called by the {@link AGreaterEqualBinaryExp} node from {@link AGreaterEqualBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AGreaterEqualBinaryExp} node
	*/
	public void caseAGreaterEqualBinaryExp(AGreaterEqualBinaryExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAGreaterEqualBinaryExp(node);

		if(node.getLeft() != null && !_visitedNodes.contains(node.getLeft())) 
		{
			node.getLeft().apply(this);
		}
		if(node.getRight() != null && !_visitedNodes.contains(node.getRight())) 
		{
			node.getRight().apply(this);
		}

		outAGreaterEqualBinaryExp(node);

	}


	/**
	* Called by the {@link AGreaterEqualBinaryExp} node from {@link AGreaterEqualBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AGreaterEqualBinaryExp} node
	*/
	public void inAGreaterEqualBinaryExp(AGreaterEqualBinaryExp node) throws AnalysisException
	{
		defaultInSBinaryExp(node);
	}


	/**
	* Called by the {@link AGreaterEqualBinaryExp} node from {@link AGreaterEqualBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AGreaterEqualBinaryExp} node
	*/
	public void outAGreaterEqualBinaryExp(AGreaterEqualBinaryExp node) throws AnalysisException
	{
		defaultOutSBinaryExp(node);
	}


	/**
	* Called by the {@link ALessBinaryExp} node from {@link ALessBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ALessBinaryExp} node
	*/
	public void caseALessBinaryExp(ALessBinaryExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inALessBinaryExp(node);

		if(node.getLeft() != null && !_visitedNodes.contains(node.getLeft())) 
		{
			node.getLeft().apply(this);
		}
		if(node.getRight() != null && !_visitedNodes.contains(node.getRight())) 
		{
			node.getRight().apply(this);
		}

		outALessBinaryExp(node);

	}


	/**
	* Called by the {@link ALessBinaryExp} node from {@link ALessBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ALessBinaryExp} node
	*/
	public void inALessBinaryExp(ALessBinaryExp node) throws AnalysisException
	{
		defaultInSBinaryExp(node);
	}


	/**
	* Called by the {@link ALessBinaryExp} node from {@link ALessBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ALessBinaryExp} node
	*/
	public void outALessBinaryExp(ALessBinaryExp node) throws AnalysisException
	{
		defaultOutSBinaryExp(node);
	}


	/**
	* Called by the {@link AGreaterBinaryExp} node from {@link AGreaterBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AGreaterBinaryExp} node
	*/
	public void caseAGreaterBinaryExp(AGreaterBinaryExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAGreaterBinaryExp(node);

		if(node.getLeft() != null && !_visitedNodes.contains(node.getLeft())) 
		{
			node.getLeft().apply(this);
		}
		if(node.getRight() != null && !_visitedNodes.contains(node.getRight())) 
		{
			node.getRight().apply(this);
		}

		outAGreaterBinaryExp(node);

	}


	/**
	* Called by the {@link AGreaterBinaryExp} node from {@link AGreaterBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AGreaterBinaryExp} node
	*/
	public void inAGreaterBinaryExp(AGreaterBinaryExp node) throws AnalysisException
	{
		defaultInSBinaryExp(node);
	}


	/**
	* Called by the {@link AGreaterBinaryExp} node from {@link AGreaterBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AGreaterBinaryExp} node
	*/
	public void outAGreaterBinaryExp(AGreaterBinaryExp node) throws AnalysisException
	{
		defaultOutSBinaryExp(node);
	}


	/**
	* Called by the {@link AEqualBinaryExp} node from {@link AEqualBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AEqualBinaryExp} node
	*/
	public void caseAEqualBinaryExp(AEqualBinaryExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAEqualBinaryExp(node);

		if(node.getLeft() != null && !_visitedNodes.contains(node.getLeft())) 
		{
			node.getLeft().apply(this);
		}
		if(node.getRight() != null && !_visitedNodes.contains(node.getRight())) 
		{
			node.getRight().apply(this);
		}

		outAEqualBinaryExp(node);

	}


	/**
	* Called by the {@link AEqualBinaryExp} node from {@link AEqualBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AEqualBinaryExp} node
	*/
	public void inAEqualBinaryExp(AEqualBinaryExp node) throws AnalysisException
	{
		defaultInSBinaryExp(node);
	}


	/**
	* Called by the {@link AEqualBinaryExp} node from {@link AEqualBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AEqualBinaryExp} node
	*/
	public void outAEqualBinaryExp(AEqualBinaryExp node) throws AnalysisException
	{
		defaultOutSBinaryExp(node);
	}


	/**
	* Called by the {@link ANotEqualBinaryExp} node from {@link ANotEqualBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ANotEqualBinaryExp} node
	*/
	public void caseANotEqualBinaryExp(ANotEqualBinaryExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inANotEqualBinaryExp(node);

		if(node.getLeft() != null && !_visitedNodes.contains(node.getLeft())) 
		{
			node.getLeft().apply(this);
		}
		if(node.getRight() != null && !_visitedNodes.contains(node.getRight())) 
		{
			node.getRight().apply(this);
		}

		outANotEqualBinaryExp(node);

	}


	/**
	* Called by the {@link ANotEqualBinaryExp} node from {@link ANotEqualBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ANotEqualBinaryExp} node
	*/
	public void inANotEqualBinaryExp(ANotEqualBinaryExp node) throws AnalysisException
	{
		defaultInSBinaryExp(node);
	}


	/**
	* Called by the {@link ANotEqualBinaryExp} node from {@link ANotEqualBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ANotEqualBinaryExp} node
	*/
	public void outANotEqualBinaryExp(ANotEqualBinaryExp node) throws AnalysisException
	{
		defaultOutSBinaryExp(node);
	}


	/**
	* Called by the {@link AOrBinaryExp} node from {@link AOrBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AOrBinaryExp} node
	*/
	public void caseAOrBinaryExp(AOrBinaryExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAOrBinaryExp(node);

		if(node.getLeft() != null && !_visitedNodes.contains(node.getLeft())) 
		{
			node.getLeft().apply(this);
		}
		if(node.getRight() != null && !_visitedNodes.contains(node.getRight())) 
		{
			node.getRight().apply(this);
		}

		outAOrBinaryExp(node);

	}


	/**
	* Called by the {@link AOrBinaryExp} node from {@link AOrBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AOrBinaryExp} node
	*/
	public void inAOrBinaryExp(AOrBinaryExp node) throws AnalysisException
	{
		defaultInSBinaryExp(node);
	}


	/**
	* Called by the {@link AOrBinaryExp} node from {@link AOrBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AOrBinaryExp} node
	*/
	public void outAOrBinaryExp(AOrBinaryExp node) throws AnalysisException
	{
		defaultOutSBinaryExp(node);
	}


	/**
	* Called by the {@link AAndBinaryExp} node from {@link AAndBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AAndBinaryExp} node
	*/
	public void caseAAndBinaryExp(AAndBinaryExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAAndBinaryExp(node);

		if(node.getLeft() != null && !_visitedNodes.contains(node.getLeft())) 
		{
			node.getLeft().apply(this);
		}
		if(node.getRight() != null && !_visitedNodes.contains(node.getRight())) 
		{
			node.getRight().apply(this);
		}

		outAAndBinaryExp(node);

	}


	/**
	* Called by the {@link AAndBinaryExp} node from {@link AAndBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AAndBinaryExp} node
	*/
	public void inAAndBinaryExp(AAndBinaryExp node) throws AnalysisException
	{
		defaultInSBinaryExp(node);
	}


	/**
	* Called by the {@link AAndBinaryExp} node from {@link AAndBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AAndBinaryExp} node
	*/
	public void outAAndBinaryExp(AAndBinaryExp node) throws AnalysisException
	{
		defaultOutSBinaryExp(node);
	}


	/**
	* Called by the {@link ADivideBinaryExp} node from {@link ADivideBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ADivideBinaryExp} node
	*/
	public void caseADivideBinaryExp(ADivideBinaryExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inADivideBinaryExp(node);

		if(node.getLeft() != null && !_visitedNodes.contains(node.getLeft())) 
		{
			node.getLeft().apply(this);
		}
		if(node.getRight() != null && !_visitedNodes.contains(node.getRight())) 
		{
			node.getRight().apply(this);
		}

		outADivideBinaryExp(node);

	}


	/**
	* Called by the {@link ADivideBinaryExp} node from {@link ADivideBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ADivideBinaryExp} node
	*/
	public void inADivideBinaryExp(ADivideBinaryExp node) throws AnalysisException
	{
		defaultInSBinaryExp(node);
	}


	/**
	* Called by the {@link ADivideBinaryExp} node from {@link ADivideBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ADivideBinaryExp} node
	*/
	public void outADivideBinaryExp(ADivideBinaryExp node) throws AnalysisException
	{
		defaultOutSBinaryExp(node);
	}


	/**
	* Called by the {@link AMultiplyBinaryExp} node from {@link AMultiplyBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AMultiplyBinaryExp} node
	*/
	public void caseAMultiplyBinaryExp(AMultiplyBinaryExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAMultiplyBinaryExp(node);

		if(node.getLeft() != null && !_visitedNodes.contains(node.getLeft())) 
		{
			node.getLeft().apply(this);
		}
		if(node.getRight() != null && !_visitedNodes.contains(node.getRight())) 
		{
			node.getRight().apply(this);
		}

		outAMultiplyBinaryExp(node);

	}


	/**
	* Called by the {@link AMultiplyBinaryExp} node from {@link AMultiplyBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AMultiplyBinaryExp} node
	*/
	public void inAMultiplyBinaryExp(AMultiplyBinaryExp node) throws AnalysisException
	{
		defaultInSBinaryExp(node);
	}


	/**
	* Called by the {@link AMultiplyBinaryExp} node from {@link AMultiplyBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AMultiplyBinaryExp} node
	*/
	public void outAMultiplyBinaryExp(AMultiplyBinaryExp node) throws AnalysisException
	{
		defaultOutSBinaryExp(node);
	}


	/**
	* Called by the {@link ANotUnaryExp} node from {@link ANotUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ANotUnaryExp} node
	*/
	public void caseANotUnaryExp(ANotUnaryExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inANotUnaryExp(node);

		if(node.getExp() != null && !_visitedNodes.contains(node.getExp())) 
		{
			node.getExp().apply(this);
		}

		outANotUnaryExp(node);

	}


	/**
	* Called by the {@link ANotUnaryExp} node from {@link ANotUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ANotUnaryExp} node
	*/
	public void inANotUnaryExp(ANotUnaryExp node) throws AnalysisException
	{
		defaultInSUnaryExp(node);
	}


	/**
	* Called by the {@link ANotUnaryExp} node from {@link ANotUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ANotUnaryExp} node
	*/
	public void outANotUnaryExp(ANotUnaryExp node) throws AnalysisException
	{
		defaultOutSUnaryExp(node);
	}


	/**
	* Called by the {@link AMinusUnaryExp} node from {@link AMinusUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AMinusUnaryExp} node
	*/
	public void caseAMinusUnaryExp(AMinusUnaryExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAMinusUnaryExp(node);

		if(node.getExp() != null && !_visitedNodes.contains(node.getExp())) 
		{
			node.getExp().apply(this);
		}

		outAMinusUnaryExp(node);

	}


	/**
	* Called by the {@link AMinusUnaryExp} node from {@link AMinusUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AMinusUnaryExp} node
	*/
	public void inAMinusUnaryExp(AMinusUnaryExp node) throws AnalysisException
	{
		defaultInSUnaryExp(node);
	}


	/**
	* Called by the {@link AMinusUnaryExp} node from {@link AMinusUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AMinusUnaryExp} node
	*/
	public void outAMinusUnaryExp(AMinusUnaryExp node) throws AnalysisException
	{
		defaultOutSUnaryExp(node);
	}


	/**
	* Called by the {@link APlusUnaryExp} node from {@link APlusUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link APlusUnaryExp} node
	*/
	public void caseAPlusUnaryExp(APlusUnaryExp node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAPlusUnaryExp(node);

		if(node.getExp() != null && !_visitedNodes.contains(node.getExp())) 
		{
			node.getExp().apply(this);
		}

		outAPlusUnaryExp(node);

	}


	/**
	* Called by the {@link APlusUnaryExp} node from {@link APlusUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link APlusUnaryExp} node
	*/
	public void inAPlusUnaryExp(APlusUnaryExp node) throws AnalysisException
	{
		defaultInSUnaryExp(node);
	}


	/**
	* Called by the {@link APlusUnaryExp} node from {@link APlusUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link APlusUnaryExp} node
	*/
	public void outAPlusUnaryExp(APlusUnaryExp node) throws AnalysisException
	{
		defaultOutSUnaryExp(node);
	}


	/**
	* Called by the {@link PStateDesignator} node from {@link PStateDesignator#apply(IAnalysis)}.
	* @param node the calling {@link PStateDesignator} node
	*/
	public void defaultInPStateDesignator(PStateDesignator node) throws AnalysisException
	{
		defaultInINode(node);
	}


	/**
	* Called by the {@link PStateDesignator} node from {@link PStateDesignator#apply(IAnalysis)}.
	* @param node the calling {@link PStateDesignator} node
	*/
	public void defaultOutPStateDesignator(PStateDesignator node) throws AnalysisException
	{
		defaultOutINode(node);
	}


	/**
	* Called by the {@link PStateDesignator} node from {@link PStateDesignator#apply(IAnalysis)}.
	* @param node the calling {@link PStateDesignator} node
	*/
	public void defaultPStateDesignator(PStateDesignator node) throws AnalysisException
	{
		defaultINode(node);
	}


	/**
	* Called by the {@link PStateDesignator} node from {@link PStateDesignator#apply(IAnalysis)}.
	* @param node the calling {@link PStateDesignator} node
	*/
	public void inPStateDesignator(PStateDesignator node) throws AnalysisException
	{
		defaultInINode(node);
	}


	/**
	* Called by the {@link PStateDesignator} node from {@link PStateDesignator#apply(IAnalysis)}.
	* @param node the calling {@link PStateDesignator} node
	*/
	public void outPStateDesignator(PStateDesignator node) throws AnalysisException
	{
		defaultOutINode(node);
	}


	/**
	* Called by the {@link AIdentifierStateDesignator} node from {@link AIdentifierStateDesignator#apply(IAnalysis)}.
	* @param node the calling {@link AIdentifierStateDesignator} node
	*/
	public void caseAIdentifierStateDesignator(AIdentifierStateDesignator node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAIdentifierStateDesignator(node);


		outAIdentifierStateDesignator(node);

	}


	/**
	* Called by the {@link AIdentifierStateDesignator} node from {@link AIdentifierStateDesignator#apply(IAnalysis)}.
	* @param node the calling {@link AIdentifierStateDesignator} node
	*/
	public void inAIdentifierStateDesignator(AIdentifierStateDesignator node) throws AnalysisException
	{
		defaultInPStateDesignator(node);
	}


	/**
	* Called by the {@link AIdentifierStateDesignator} node from {@link AIdentifierStateDesignator#apply(IAnalysis)}.
	* @param node the calling {@link AIdentifierStateDesignator} node
	*/
	public void outAIdentifierStateDesignator(AIdentifierStateDesignator node) throws AnalysisException
	{
		defaultOutPStateDesignator(node);
	}


	/**
	* Called by the {@link AArrayStateDesignator} node from {@link AArrayStateDesignator#apply(IAnalysis)}.
	* @param node the calling {@link AArrayStateDesignator} node
	*/
	public void caseAArrayStateDesignator(AArrayStateDesignator node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAArrayStateDesignator(node);

		if(node.getTarget() != null && !_visitedNodes.contains(node.getTarget())) 
		{
			node.getTarget().apply(this);
		}
		if(node.getExp() != null && !_visitedNodes.contains(node.getExp())) 
		{
			node.getExp().apply(this);
		}

		outAArrayStateDesignator(node);

	}


	/**
	* Called by the {@link AArrayStateDesignator} node from {@link AArrayStateDesignator#apply(IAnalysis)}.
	* @param node the calling {@link AArrayStateDesignator} node
	*/
	public void inAArrayStateDesignator(AArrayStateDesignator node) throws AnalysisException
	{
		defaultInPStateDesignator(node);
	}


	/**
	* Called by the {@link AArrayStateDesignator} node from {@link AArrayStateDesignator#apply(IAnalysis)}.
	* @param node the calling {@link AArrayStateDesignator} node
	*/
	public void outAArrayStateDesignator(AArrayStateDesignator node) throws AnalysisException
	{
		defaultOutPStateDesignator(node);
	}


	/**
	* Called by the {@link PStm} node from {@link PStm#apply(IAnalysis)}.
	* @param node the calling {@link PStm} node
	*/
	public void defaultInPStm(PStm node) throws AnalysisException
	{
		defaultInINode(node);
	}


	/**
	* Called by the {@link PStm} node from {@link PStm#apply(IAnalysis)}.
	* @param node the calling {@link PStm} node
	*/
	public void defaultOutPStm(PStm node) throws AnalysisException
	{
		defaultOutINode(node);
	}


	/**
	* Called by the {@link PStm} node from {@link PStm#apply(IAnalysis)}.
	* @param node the calling {@link PStm} node
	*/
	public void defaultPStm(PStm node) throws AnalysisException
	{
		defaultINode(node);
	}


	/**
	* Called by the {@link PStm} node from {@link PStm#apply(IAnalysis)}.
	* @param node the calling {@link PStm} node
	*/
	public void inPStm(PStm node) throws AnalysisException
	{
		defaultInINode(node);
	}


	/**
	* Called by the {@link PStm} node from {@link PStm#apply(IAnalysis)}.
	* @param node the calling {@link PStm} node
	*/
	public void outPStm(PStm node) throws AnalysisException
	{
		defaultOutINode(node);
	}


	/**
	* Called by the {@link SBlockStm} node from {@link SBlockStm#apply(IAnalysis)}.
	* @param node the calling {@link SBlockStm} node
	*/
	public void defaultInSBlockStm(SBlockStm node) throws AnalysisException
	{
		defaultInPStm(node);
	}


	/**
	* Called by the {@link SBlockStm} node from {@link SBlockStm#apply(IAnalysis)}.
	* @param node the calling {@link SBlockStm} node
	*/
	public void defaultOutSBlockStm(SBlockStm node) throws AnalysisException
	{
		defaultOutPStm(node);
	}


	/**
	* Called by the {@link SBlockStm} node from {@link SBlockStm#apply(IAnalysis)}.
	* @param node the calling {@link SBlockStm} node
	*/
	public void defaultSBlockStm(SBlockStm node) throws AnalysisException
	{
		defaultPStm(node);
	}


	/**
	* Called by the {@link SBlockStm} node from {@link SBlockStm#apply(IAnalysis)}.
	* @param node the calling {@link SBlockStm} node
	*/
	public void inSBlockStm(SBlockStm node) throws AnalysisException
	{
		defaultInPStm(node);
	}


	/**
	* Called by the {@link SBlockStm} node from {@link SBlockStm#apply(IAnalysis)}.
	* @param node the calling {@link SBlockStm} node
	*/
	public void outSBlockStm(SBlockStm node) throws AnalysisException
	{
		defaultOutPStm(node);
	}


	/**
	* Called by the {@link AAssigmentStm} node from {@link AAssigmentStm#apply(IAnalysis)}.
	* @param node the calling {@link AAssigmentStm} node
	*/
	public void caseAAssigmentStm(AAssigmentStm node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAAssigmentStm(node);

		if(node.getTarget() != null && !_visitedNodes.contains(node.getTarget())) 
		{
			node.getTarget().apply(this);
		}
		if(node.getExp() != null && !_visitedNodes.contains(node.getExp())) 
		{
			node.getExp().apply(this);
		}

		outAAssigmentStm(node);

	}


	/**
	* Called by the {@link AAssigmentStm} node from {@link AAssigmentStm#apply(IAnalysis)}.
	* @param node the calling {@link AAssigmentStm} node
	*/
	public void inAAssigmentStm(AAssigmentStm node) throws AnalysisException
	{
		defaultInPStm(node);
	}


	/**
	* Called by the {@link AAssigmentStm} node from {@link AAssigmentStm#apply(IAnalysis)}.
	* @param node the calling {@link AAssigmentStm} node
	*/
	public void outAAssigmentStm(AAssigmentStm node) throws AnalysisException
	{
		defaultOutPStm(node);
	}


	/**
	* Called by the {@link ALocalVariableStm} node from {@link ALocalVariableStm#apply(IAnalysis)}.
	* @param node the calling {@link ALocalVariableStm} node
	*/
	public void caseALocalVariableStm(ALocalVariableStm node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inALocalVariableStm(node);

		if(node.getDeclaration() != null && !_visitedNodes.contains(node.getDeclaration())) 
		{
			node.getDeclaration().apply(this);
		}

		outALocalVariableStm(node);

	}


	/**
	* Called by the {@link ALocalVariableStm} node from {@link ALocalVariableStm#apply(IAnalysis)}.
	* @param node the calling {@link ALocalVariableStm} node
	*/
	public void inALocalVariableStm(ALocalVariableStm node) throws AnalysisException
	{
		defaultInPStm(node);
	}


	/**
	* Called by the {@link ALocalVariableStm} node from {@link ALocalVariableStm#apply(IAnalysis)}.
	* @param node the calling {@link ALocalVariableStm} node
	*/
	public void outALocalVariableStm(ALocalVariableStm node) throws AnalysisException
	{
		defaultOutPStm(node);
	}


	/**
	* Called by the {@link AIfStm} node from {@link AIfStm#apply(IAnalysis)}.
	* @param node the calling {@link AIfStm} node
	*/
	public void caseAIfStm(AIfStm node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAIfStm(node);

		if(node.getTest() != null && !_visitedNodes.contains(node.getTest())) 
		{
			node.getTest().apply(this);
		}
		if(node.getThen() != null && !_visitedNodes.contains(node.getThen())) 
		{
			node.getThen().apply(this);
		}
		if(node.getElse() != null && !_visitedNodes.contains(node.getElse())) 
		{
			node.getElse().apply(this);
		}

		outAIfStm(node);

	}


	/**
	* Called by the {@link AIfStm} node from {@link AIfStm#apply(IAnalysis)}.
	* @param node the calling {@link AIfStm} node
	*/
	public void inAIfStm(AIfStm node) throws AnalysisException
	{
		defaultInPStm(node);
	}


	/**
	* Called by the {@link AIfStm} node from {@link AIfStm#apply(IAnalysis)}.
	* @param node the calling {@link AIfStm} node
	*/
	public void outAIfStm(AIfStm node) throws AnalysisException
	{
		defaultOutPStm(node);
	}


	/**
	* Called by the {@link AWhileStm} node from {@link AWhileStm#apply(IAnalysis)}.
	* @param node the calling {@link AWhileStm} node
	*/
	public void caseAWhileStm(AWhileStm node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAWhileStm(node);

		if(node.getTest() != null && !_visitedNodes.contains(node.getTest())) 
		{
			node.getTest().apply(this);
		}
		if(node.getBody() != null && !_visitedNodes.contains(node.getBody())) 
		{
			node.getBody().apply(this);
		}

		outAWhileStm(node);

	}


	/**
	* Called by the {@link AWhileStm} node from {@link AWhileStm#apply(IAnalysis)}.
	* @param node the calling {@link AWhileStm} node
	*/
	public void inAWhileStm(AWhileStm node) throws AnalysisException
	{
		defaultInPStm(node);
	}


	/**
	* Called by the {@link AWhileStm} node from {@link AWhileStm#apply(IAnalysis)}.
	* @param node the calling {@link AWhileStm} node
	*/
	public void outAWhileStm(AWhileStm node) throws AnalysisException
	{
		defaultOutPStm(node);
	}


	/**
	* Called by the {@link AExpressionStm} node from {@link AExpressionStm#apply(IAnalysis)}.
	* @param node the calling {@link AExpressionStm} node
	*/
	public void caseAExpressionStm(AExpressionStm node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAExpressionStm(node);

		if(node.getExp() != null && !_visitedNodes.contains(node.getExp())) 
		{
			node.getExp().apply(this);
		}

		outAExpressionStm(node);

	}


	/**
	* Called by the {@link AExpressionStm} node from {@link AExpressionStm#apply(IAnalysis)}.
	* @param node the calling {@link AExpressionStm} node
	*/
	public void inAExpressionStm(AExpressionStm node) throws AnalysisException
	{
		defaultInPStm(node);
	}


	/**
	* Called by the {@link AExpressionStm} node from {@link AExpressionStm#apply(IAnalysis)}.
	* @param node the calling {@link AExpressionStm} node
	*/
	public void outAExpressionStm(AExpressionStm node) throws AnalysisException
	{
		defaultOutPStm(node);
	}


	/**
	* Called by the {@link AObservableStm} node from {@link AObservableStm#apply(IAnalysis)}.
	* @param node the calling {@link AObservableStm} node
	*/
	public void caseAObservableStm(AObservableStm node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAObservableStm(node);

		if(node.getIdentifier() != null && !_visitedNodes.contains(node.getIdentifier())) 
		{
			node.getIdentifier().apply(this);
		}

		outAObservableStm(node);

	}


	/**
	* Called by the {@link AObservableStm} node from {@link AObservableStm#apply(IAnalysis)}.
	* @param node the calling {@link AObservableStm} node
	*/
	public void inAObservableStm(AObservableStm node) throws AnalysisException
	{
		defaultInPStm(node);
	}


	/**
	* Called by the {@link AObservableStm} node from {@link AObservableStm#apply(IAnalysis)}.
	* @param node the calling {@link AObservableStm} node
	*/
	public void outAObservableStm(AObservableStm node) throws AnalysisException
	{
		defaultOutPStm(node);
	}


	/**
	* Called by the {@link ABreakStm} node from {@link ABreakStm#apply(IAnalysis)}.
	* @param node the calling {@link ABreakStm} node
	*/
	public void caseABreakStm(ABreakStm node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inABreakStm(node);

		if(node.getToken() != null ) 
		{
			node.getToken().apply(this);
		}

		outABreakStm(node);

	}


	/**
	* Called by the {@link ABreakStm} node from {@link ABreakStm#apply(IAnalysis)}.
	* @param node the calling {@link ABreakStm} node
	*/
	public void inABreakStm(ABreakStm node) throws AnalysisException
	{
		defaultInPStm(node);
	}


	/**
	* Called by the {@link ABreakStm} node from {@link ABreakStm#apply(IAnalysis)}.
	* @param node the calling {@link ABreakStm} node
	*/
	public void outABreakStm(ABreakStm node) throws AnalysisException
	{
		defaultOutPStm(node);
	}


	/**
	* Called by the {@link AInstanceMappingStm} node from {@link AInstanceMappingStm#apply(IAnalysis)}.
	* @param node the calling {@link AInstanceMappingStm} node
	*/
	public void caseAInstanceMappingStm(AInstanceMappingStm node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAInstanceMappingStm(node);


		outAInstanceMappingStm(node);

	}


	/**
	* Called by the {@link AInstanceMappingStm} node from {@link AInstanceMappingStm#apply(IAnalysis)}.
	* @param node the calling {@link AInstanceMappingStm} node
	*/
	public void inAInstanceMappingStm(AInstanceMappingStm node) throws AnalysisException
	{
		defaultInPStm(node);
	}


	/**
	* Called by the {@link AInstanceMappingStm} node from {@link AInstanceMappingStm#apply(IAnalysis)}.
	* @param node the calling {@link AInstanceMappingStm} node
	*/
	public void outAInstanceMappingStm(AInstanceMappingStm node) throws AnalysisException
	{
		defaultOutPStm(node);
	}


	/**
	* Called by the {@link AFmuMappingStm} node from {@link AFmuMappingStm#apply(IAnalysis)}.
	* @param node the calling {@link AFmuMappingStm} node
	*/
	public void caseAFmuMappingStm(AFmuMappingStm node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAFmuMappingStm(node);


		outAFmuMappingStm(node);

	}


	/**
	* Called by the {@link AFmuMappingStm} node from {@link AFmuMappingStm#apply(IAnalysis)}.
	* @param node the calling {@link AFmuMappingStm} node
	*/
	public void inAFmuMappingStm(AFmuMappingStm node) throws AnalysisException
	{
		defaultInPStm(node);
	}


	/**
	* Called by the {@link AFmuMappingStm} node from {@link AFmuMappingStm#apply(IAnalysis)}.
	* @param node the calling {@link AFmuMappingStm} node
	*/
	public void outAFmuMappingStm(AFmuMappingStm node) throws AnalysisException
	{
		defaultOutPStm(node);
	}


	/**
	* Called by the {@link AConfigStm} node from {@link AConfigStm#apply(IAnalysis)}.
	* @param node the calling {@link AConfigStm} node
	*/
	public void caseAConfigStm(AConfigStm node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAConfigStm(node);


		outAConfigStm(node);

	}


	/**
	* Called by the {@link AConfigStm} node from {@link AConfigStm#apply(IAnalysis)}.
	* @param node the calling {@link AConfigStm} node
	*/
	public void inAConfigStm(AConfigStm node) throws AnalysisException
	{
		defaultInPStm(node);
	}


	/**
	* Called by the {@link AConfigStm} node from {@link AConfigStm#apply(IAnalysis)}.
	* @param node the calling {@link AConfigStm} node
	*/
	public void outAConfigStm(AConfigStm node) throws AnalysisException
	{
		defaultOutPStm(node);
	}


	/**
	* Called by the {@link AErrorStm} node from {@link AErrorStm#apply(IAnalysis)}.
	* @param node the calling {@link AErrorStm} node
	*/
	public void caseAErrorStm(AErrorStm node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAErrorStm(node);

		if(node.getExp() != null && !_visitedNodes.contains(node.getExp())) 
		{
			node.getExp().apply(this);
		}

		outAErrorStm(node);

	}


	/**
	* Called by the {@link AErrorStm} node from {@link AErrorStm#apply(IAnalysis)}.
	* @param node the calling {@link AErrorStm} node
	*/
	public void inAErrorStm(AErrorStm node) throws AnalysisException
	{
		defaultInPStm(node);
	}


	/**
	* Called by the {@link AErrorStm} node from {@link AErrorStm#apply(IAnalysis)}.
	* @param node the calling {@link AErrorStm} node
	*/
	public void outAErrorStm(AErrorStm node) throws AnalysisException
	{
		defaultOutPStm(node);
	}


	/**
	* Called by the {@link ATryStm} node from {@link ATryStm#apply(IAnalysis)}.
	* @param node the calling {@link ATryStm} node
	*/
	public void caseATryStm(ATryStm node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inATryStm(node);

		if(node.getBody() != null && !_visitedNodes.contains(node.getBody())) 
		{
			node.getBody().apply(this);
		}
		if(node.getFinally() != null && !_visitedNodes.contains(node.getFinally())) 
		{
			node.getFinally().apply(this);
		}

		outATryStm(node);

	}


	/**
	* Called by the {@link ATryStm} node from {@link ATryStm#apply(IAnalysis)}.
	* @param node the calling {@link ATryStm} node
	*/
	public void inATryStm(ATryStm node) throws AnalysisException
	{
		defaultInPStm(node);
	}


	/**
	* Called by the {@link ATryStm} node from {@link ATryStm#apply(IAnalysis)}.
	* @param node the calling {@link ATryStm} node
	*/
	public void outATryStm(ATryStm node) throws AnalysisException
	{
		defaultOutPStm(node);
	}


	/**
	* Called by the {@link ABasicBlockStm} node from {@link ABasicBlockStm#apply(IAnalysis)}.
	* @param node the calling {@link ABasicBlockStm} node
	*/
	public void caseABasicBlockStm(ABasicBlockStm node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inABasicBlockStm(node);

		{
			List<PStm> copy = new ArrayList<PStm>(node.getBody());
			for( PStm e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					e.apply(this);
				}
			}
		}

		outABasicBlockStm(node);

	}


	/**
	* Called by the {@link ABasicBlockStm} node from {@link ABasicBlockStm#apply(IAnalysis)}.
	* @param node the calling {@link ABasicBlockStm} node
	*/
	public void inABasicBlockStm(ABasicBlockStm node) throws AnalysisException
	{
		defaultInSBlockStm(node);
	}


	/**
	* Called by the {@link ABasicBlockStm} node from {@link ABasicBlockStm#apply(IAnalysis)}.
	* @param node the calling {@link ABasicBlockStm} node
	*/
	public void outABasicBlockStm(ABasicBlockStm node) throws AnalysisException
	{
		defaultOutSBlockStm(node);
	}


	/**
	* Called by the {@link AParallelBlockStm} node from {@link AParallelBlockStm#apply(IAnalysis)}.
	* @param node the calling {@link AParallelBlockStm} node
	*/
	public void caseAParallelBlockStm(AParallelBlockStm node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAParallelBlockStm(node);

		{
			List<PStm> copy = new ArrayList<PStm>(node.getBody());
			for( PStm e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					e.apply(this);
				}
			}
		}

		outAParallelBlockStm(node);

	}


	/**
	* Called by the {@link AParallelBlockStm} node from {@link AParallelBlockStm#apply(IAnalysis)}.
	* @param node the calling {@link AParallelBlockStm} node
	*/
	public void inAParallelBlockStm(AParallelBlockStm node) throws AnalysisException
	{
		defaultInSBlockStm(node);
	}


	/**
	* Called by the {@link AParallelBlockStm} node from {@link AParallelBlockStm#apply(IAnalysis)}.
	* @param node the calling {@link AParallelBlockStm} node
	*/
	public void outAParallelBlockStm(AParallelBlockStm node) throws AnalysisException
	{
		defaultOutSBlockStm(node);
	}


	/**
	* Called by the {@link PType} node from {@link PType#apply(IAnalysis)}.
	* @param node the calling {@link PType} node
	*/
	public void defaultInPType(PType node) throws AnalysisException
	{
		defaultInINode(node);
	}


	/**
	* Called by the {@link PType} node from {@link PType#apply(IAnalysis)}.
	* @param node the calling {@link PType} node
	*/
	public void defaultOutPType(PType node) throws AnalysisException
	{
		defaultOutINode(node);
	}


	/**
	* Called by the {@link PType} node from {@link PType#apply(IAnalysis)}.
	* @param node the calling {@link PType} node
	*/
	public void defaultPType(PType node) throws AnalysisException
	{
		defaultINode(node);
	}


	/**
	* Called by the {@link PType} node from {@link PType#apply(IAnalysis)}.
	* @param node the calling {@link PType} node
	*/
	public void inPType(PType node) throws AnalysisException
	{
		defaultInINode(node);
	}


	/**
	* Called by the {@link PType} node from {@link PType#apply(IAnalysis)}.
	* @param node the calling {@link PType} node
	*/
	public void outPType(PType node) throws AnalysisException
	{
		defaultOutINode(node);
	}


	/**
	* Called by the {@link SPrimitiveType} node from {@link SPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link SPrimitiveType} node
	*/
	public void defaultInSPrimitiveType(SPrimitiveType node) throws AnalysisException
	{
		defaultInPType(node);
	}


	/**
	* Called by the {@link SPrimitiveType} node from {@link SPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link SPrimitiveType} node
	*/
	public void defaultOutSPrimitiveType(SPrimitiveType node) throws AnalysisException
	{
		defaultOutPType(node);
	}


	/**
	* Called by the {@link SPrimitiveType} node from {@link SPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link SPrimitiveType} node
	*/
	public void defaultSPrimitiveType(SPrimitiveType node) throws AnalysisException
	{
		defaultPType(node);
	}


	/**
	* Called by the {@link SPrimitiveType} node from {@link SPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link SPrimitiveType} node
	*/
	public void inSPrimitiveType(SPrimitiveType node) throws AnalysisException
	{
		defaultInPType(node);
	}


	/**
	* Called by the {@link SPrimitiveType} node from {@link SPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link SPrimitiveType} node
	*/
	public void outSPrimitiveType(SPrimitiveType node) throws AnalysisException
	{
		defaultOutPType(node);
	}


	/**
	* Called by the {@link ANameType} node from {@link ANameType#apply(IAnalysis)}.
	* @param node the calling {@link ANameType} node
	*/
	public void caseANameType(ANameType node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inANameType(node);


		outANameType(node);

	}


	/**
	* Called by the {@link ANameType} node from {@link ANameType#apply(IAnalysis)}.
	* @param node the calling {@link ANameType} node
	*/
	public void inANameType(ANameType node) throws AnalysisException
	{
		defaultInPType(node);
	}


	/**
	* Called by the {@link ANameType} node from {@link ANameType#apply(IAnalysis)}.
	* @param node the calling {@link ANameType} node
	*/
	public void outANameType(ANameType node) throws AnalysisException
	{
		defaultOutPType(node);
	}


	/**
	* Called by the {@link AFunctionType} node from {@link AFunctionType#apply(IAnalysis)}.
	* @param node the calling {@link AFunctionType} node
	*/
	public void caseAFunctionType(AFunctionType node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAFunctionType(node);

		if(node.getResult() != null && !_visitedNodes.contains(node.getResult())) 
		{
			node.getResult().apply(this);
		}
		{
			List<PType> copy = new ArrayList<PType>(node.getParameters());
			for( PType e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					e.apply(this);
				}
			}
		}

		outAFunctionType(node);

	}


	/**
	* Called by the {@link AFunctionType} node from {@link AFunctionType#apply(IAnalysis)}.
	* @param node the calling {@link AFunctionType} node
	*/
	public void inAFunctionType(AFunctionType node) throws AnalysisException
	{
		defaultInPType(node);
	}


	/**
	* Called by the {@link AFunctionType} node from {@link AFunctionType#apply(IAnalysis)}.
	* @param node the calling {@link AFunctionType} node
	*/
	public void outAFunctionType(AFunctionType node) throws AnalysisException
	{
		defaultOutPType(node);
	}


	/**
	* Called by the {@link AArrayType} node from {@link AArrayType#apply(IAnalysis)}.
	* @param node the calling {@link AArrayType} node
	*/
	public void caseAArrayType(AArrayType node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAArrayType(node);

		if(node.getType() != null && !_visitedNodes.contains(node.getType())) 
		{
			node.getType().apply(this);
		}

		outAArrayType(node);

	}


	/**
	* Called by the {@link AArrayType} node from {@link AArrayType#apply(IAnalysis)}.
	* @param node the calling {@link AArrayType} node
	*/
	public void inAArrayType(AArrayType node) throws AnalysisException
	{
		defaultInPType(node);
	}


	/**
	* Called by the {@link AArrayType} node from {@link AArrayType#apply(IAnalysis)}.
	* @param node the calling {@link AArrayType} node
	*/
	public void outAArrayType(AArrayType node) throws AnalysisException
	{
		defaultOutPType(node);
	}


	/**
	* Called by the {@link AUnknownType} node from {@link AUnknownType#apply(IAnalysis)}.
	* @param node the calling {@link AUnknownType} node
	*/
	public void caseAUnknownType(AUnknownType node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAUnknownType(node);


		outAUnknownType(node);

	}


	/**
	* Called by the {@link AUnknownType} node from {@link AUnknownType#apply(IAnalysis)}.
	* @param node the calling {@link AUnknownType} node
	*/
	public void inAUnknownType(AUnknownType node) throws AnalysisException
	{
		defaultInPType(node);
	}


	/**
	* Called by the {@link AUnknownType} node from {@link AUnknownType#apply(IAnalysis)}.
	* @param node the calling {@link AUnknownType} node
	*/
	public void outAUnknownType(AUnknownType node) throws AnalysisException
	{
		defaultOutPType(node);
	}


	/**
	* Called by the {@link AVoidType} node from {@link AVoidType#apply(IAnalysis)}.
	* @param node the calling {@link AVoidType} node
	*/
	public void caseAVoidType(AVoidType node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAVoidType(node);


		outAVoidType(node);

	}


	/**
	* Called by the {@link AVoidType} node from {@link AVoidType#apply(IAnalysis)}.
	* @param node the calling {@link AVoidType} node
	*/
	public void inAVoidType(AVoidType node) throws AnalysisException
	{
		defaultInPType(node);
	}


	/**
	* Called by the {@link AVoidType} node from {@link AVoidType#apply(IAnalysis)}.
	* @param node the calling {@link AVoidType} node
	*/
	public void outAVoidType(AVoidType node) throws AnalysisException
	{
		defaultOutPType(node);
	}


	/**
	* Called by the {@link AModuleType} node from {@link AModuleType#apply(IAnalysis)}.
	* @param node the calling {@link AModuleType} node
	*/
	public void caseAModuleType(AModuleType node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAModuleType(node);


		outAModuleType(node);

	}


	/**
	* Called by the {@link AModuleType} node from {@link AModuleType#apply(IAnalysis)}.
	* @param node the calling {@link AModuleType} node
	*/
	public void inAModuleType(AModuleType node) throws AnalysisException
	{
		defaultInPType(node);
	}


	/**
	* Called by the {@link AModuleType} node from {@link AModuleType#apply(IAnalysis)}.
	* @param node the calling {@link AModuleType} node
	*/
	public void outAModuleType(AModuleType node) throws AnalysisException
	{
		defaultOutPType(node);
	}


	/**
	* Called by the {@link AReferenceType} node from {@link AReferenceType#apply(IAnalysis)}.
	* @param node the calling {@link AReferenceType} node
	*/
	public void caseAReferenceType(AReferenceType node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAReferenceType(node);

		if(node.getType() != null && !_visitedNodes.contains(node.getType())) 
		{
			node.getType().apply(this);
		}

		outAReferenceType(node);

	}


	/**
	* Called by the {@link AReferenceType} node from {@link AReferenceType#apply(IAnalysis)}.
	* @param node the calling {@link AReferenceType} node
	*/
	public void inAReferenceType(AReferenceType node) throws AnalysisException
	{
		defaultInPType(node);
	}


	/**
	* Called by the {@link AReferenceType} node from {@link AReferenceType#apply(IAnalysis)}.
	* @param node the calling {@link AReferenceType} node
	*/
	public void outAReferenceType(AReferenceType node) throws AnalysisException
	{
		defaultOutPType(node);
	}


	/**
	* Called by the {@link ANullType} node from {@link ANullType#apply(IAnalysis)}.
	* @param node the calling {@link ANullType} node
	*/
	public void caseANullType(ANullType node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inANullType(node);


		outANullType(node);

	}


	/**
	* Called by the {@link ANullType} node from {@link ANullType#apply(IAnalysis)}.
	* @param node the calling {@link ANullType} node
	*/
	public void inANullType(ANullType node) throws AnalysisException
	{
		defaultInPType(node);
	}


	/**
	* Called by the {@link ANullType} node from {@link ANullType#apply(IAnalysis)}.
	* @param node the calling {@link ANullType} node
	*/
	public void outANullType(ANullType node) throws AnalysisException
	{
		defaultOutPType(node);
	}


	/**
	* Called by the {@link ABooleanPrimitiveType} node from {@link ABooleanPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link ABooleanPrimitiveType} node
	*/
	public void caseABooleanPrimitiveType(ABooleanPrimitiveType node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inABooleanPrimitiveType(node);


		outABooleanPrimitiveType(node);

	}


	/**
	* Called by the {@link ABooleanPrimitiveType} node from {@link ABooleanPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link ABooleanPrimitiveType} node
	*/
	public void inABooleanPrimitiveType(ABooleanPrimitiveType node) throws AnalysisException
	{
		defaultInSPrimitiveType(node);
	}


	/**
	* Called by the {@link ABooleanPrimitiveType} node from {@link ABooleanPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link ABooleanPrimitiveType} node
	*/
	public void outABooleanPrimitiveType(ABooleanPrimitiveType node) throws AnalysisException
	{
		defaultOutSPrimitiveType(node);
	}


	/**
	* Called by the {@link AStringPrimitiveType} node from {@link AStringPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link AStringPrimitiveType} node
	*/
	public void caseAStringPrimitiveType(AStringPrimitiveType node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAStringPrimitiveType(node);


		outAStringPrimitiveType(node);

	}


	/**
	* Called by the {@link AStringPrimitiveType} node from {@link AStringPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link AStringPrimitiveType} node
	*/
	public void inAStringPrimitiveType(AStringPrimitiveType node) throws AnalysisException
	{
		defaultInSPrimitiveType(node);
	}


	/**
	* Called by the {@link AStringPrimitiveType} node from {@link AStringPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link AStringPrimitiveType} node
	*/
	public void outAStringPrimitiveType(AStringPrimitiveType node) throws AnalysisException
	{
		defaultOutSPrimitiveType(node);
	}


	/**
	* Called by the {@link SNumericPrimitiveType} node from {@link SNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link SNumericPrimitiveType} node
	*/
	public void defaultInSNumericPrimitiveType(SNumericPrimitiveType node) throws AnalysisException
	{
		defaultInSPrimitiveType(node);
	}


	/**
	* Called by the {@link SNumericPrimitiveType} node from {@link SNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link SNumericPrimitiveType} node
	*/
	public void defaultOutSNumericPrimitiveType(SNumericPrimitiveType node) throws AnalysisException
	{
		defaultOutSPrimitiveType(node);
	}


	/**
	* Called by the {@link SNumericPrimitiveType} node from {@link SNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link SNumericPrimitiveType} node
	*/
	public void defaultSNumericPrimitiveType(SNumericPrimitiveType node) throws AnalysisException
	{
		defaultSPrimitiveType(node);
	}


	/**
	* Called by the {@link SNumericPrimitiveType} node from {@link SNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link SNumericPrimitiveType} node
	*/
	public void inSNumericPrimitiveType(SNumericPrimitiveType node) throws AnalysisException
	{
		defaultInSPrimitiveType(node);
	}


	/**
	* Called by the {@link SNumericPrimitiveType} node from {@link SNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link SNumericPrimitiveType} node
	*/
	public void outSNumericPrimitiveType(SNumericPrimitiveType node) throws AnalysisException
	{
		defaultOutSPrimitiveType(node);
	}


	/**
	* Called by the {@link ARealNumericPrimitiveType} node from {@link ARealNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link ARealNumericPrimitiveType} node
	*/
	public void caseARealNumericPrimitiveType(ARealNumericPrimitiveType node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inARealNumericPrimitiveType(node);


		outARealNumericPrimitiveType(node);

	}


	/**
	* Called by the {@link ARealNumericPrimitiveType} node from {@link ARealNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link ARealNumericPrimitiveType} node
	*/
	public void inARealNumericPrimitiveType(ARealNumericPrimitiveType node) throws AnalysisException
	{
		defaultInSNumericPrimitiveType(node);
	}


	/**
	* Called by the {@link ARealNumericPrimitiveType} node from {@link ARealNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link ARealNumericPrimitiveType} node
	*/
	public void outARealNumericPrimitiveType(ARealNumericPrimitiveType node) throws AnalysisException
	{
		defaultOutSNumericPrimitiveType(node);
	}


	/**
	* Called by the {@link AIntNumericPrimitiveType} node from {@link AIntNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link AIntNumericPrimitiveType} node
	*/
	public void caseAIntNumericPrimitiveType(AIntNumericPrimitiveType node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAIntNumericPrimitiveType(node);


		outAIntNumericPrimitiveType(node);

	}


	/**
	* Called by the {@link AIntNumericPrimitiveType} node from {@link AIntNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link AIntNumericPrimitiveType} node
	*/
	public void inAIntNumericPrimitiveType(AIntNumericPrimitiveType node) throws AnalysisException
	{
		defaultInSNumericPrimitiveType(node);
	}


	/**
	* Called by the {@link AIntNumericPrimitiveType} node from {@link AIntNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link AIntNumericPrimitiveType} node
	*/
	public void outAIntNumericPrimitiveType(AIntNumericPrimitiveType node) throws AnalysisException
	{
		defaultOutSNumericPrimitiveType(node);
	}


	/**
	* Called by the {@link AUIntNumericPrimitiveType} node from {@link AUIntNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link AUIntNumericPrimitiveType} node
	*/
	public void caseAUIntNumericPrimitiveType(AUIntNumericPrimitiveType node) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAUIntNumericPrimitiveType(node);


		outAUIntNumericPrimitiveType(node);

	}


	/**
	* Called by the {@link AUIntNumericPrimitiveType} node from {@link AUIntNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link AUIntNumericPrimitiveType} node
	*/
	public void inAUIntNumericPrimitiveType(AUIntNumericPrimitiveType node) throws AnalysisException
	{
		defaultInSNumericPrimitiveType(node);
	}


	/**
	* Called by the {@link AUIntNumericPrimitiveType} node from {@link AUIntNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link AUIntNumericPrimitiveType} node
	*/
	public void outAUIntNumericPrimitiveType(AUIntNumericPrimitiveType node) throws AnalysisException
	{
		defaultOutSNumericPrimitiveType(node);
	}


	/**
	* Called by the {@link INode} node from {@link INode#apply(IAnalysis)}.
	* @param node the calling {@link INode} node
	*/
	public void defaultOutINode(INode node) throws AnalysisException
	{
		//nothing to do
	}


	/**
	* Called by the {@link INode} node from {@link INode#apply(IAnalysis)}.
	* @param node the calling {@link INode} node
	*/
	public void defaultInINode(INode node) throws AnalysisException
	{
		//nothing to do
	}


	/**
	* Called by the {@link INode} node from {@link INode#apply(IAnalysis)}.
	* @param node the calling {@link INode} node
	*/
	public void defaultINode(INode node) throws AnalysisException
	{
		//nothing to do
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void defaultOutIToken(IToken node) throws AnalysisException
	{
		//nothing to do
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void defaultInIToken(IToken node) throws AnalysisException
	{
		//nothing to do
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void defaultIToken(IToken node) throws AnalysisException
	{
		//nothing to do
	}



}
