/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.ast;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.intocps.maestro.ast.AOrBinaryExp;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.MableAstFactory;
import org.intocps.maestro.ast.node.AArrayStateDesignator;
import org.intocps.maestro.ast.node.AAssigmentStm;
import org.intocps.maestro.ast.node.AIntLiteralExp;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PInitializer;
import org.intocps.maestro.ast.node.PStm;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.ast.node.SBinaryExp;

public class MableBuilder {
    public static PStm newVariable(LexIdentifier name, PType type, PExp value) {
        return MableBuilder.newVariable(name.getText(), type, value);
    }

    public static PStm newVariable(String name, PType type, PExp value) {
        return MableAstFactory.newALocalVariableStm(MableAstFactory.newAVariableDeclaration(MableAstFactory.newAIdentifier(name), type.clone(), value == null ? null : MableAstFactory.newAExpInitializer(value.clone())));
    }

    public static PStm newVariable(LexIdentifier name, PType type, List<PExp> values) {
        return MableBuilder.newVariable(name.getText(), type, values);
    }

    public static PStm newVariable(String name, PType type, List<PExp> values) {
        return MableAstFactory.newALocalVariableStm(MableAstFactory.newAVariableDeclaration(MableAstFactory.newAIdentifier(name), type.clone(), values.size(), (PInitializer)MableAstFactory.newAArrayInitializer(values.stream().map(PExp::clone).collect(Collectors.toList()))));
    }

    public static PStm newVariable(String name, PType type, int size) {
        return MableAstFactory.newALocalVariableStm(MableAstFactory.newAVariableDeclaration(MableAstFactory.newAIdentifier(name), (PType)MableAstFactory.newAArrayType(type.clone()), size, null));
    }

    public static PStm newVariable(String name, PType type, int ... size) {
        List<PExp> d = Arrays.stream(size).mapToObj(MableAstFactory::newAIntLiteralExp).map(PExp.class::cast).collect(Collectors.toList());
        return MableAstFactory.newALocalVariableStm(MableAstFactory.newAVariableDeclaration(MableAstFactory.newAIdentifier(name), type.clone(), null, d));
    }

    public static PExp call(String object, String method, PExp ... args) {
        return MableBuilder.call(object, method, args == null ? null : Arrays.asList(args));
    }

    public static PExp nestedOr(List<PExp> expressionsToAdd) {
        if (expressionsToAdd == null || expressionsToAdd.size() == 0) {
            return null;
        }
        if (expressionsToAdd.size() == 1) {
            return expressionsToAdd.remove(0);
        }
        PExp firstExpression = expressionsToAdd.remove(0);
        AOrBinaryExp exp = new AOrBinaryExp();
        exp.setLeft(firstExpression);
        MableBuilder.nestedOrRecursive(expressionsToAdd, exp);
        return exp;
    }

    public static void nestedOrRecursive(List<PExp> expressionsToAdd, SBinaryExp currentExpression) {
        if (expressionsToAdd.size() > 0) {
            if (expressionsToAdd.size() > 1) {
                AOrBinaryExp orBinaryExp = new AOrBinaryExp();
                orBinaryExp.setLeft(expressionsToAdd.get(0));
                currentExpression.setRight(orBinaryExp);
                expressionsToAdd.remove(0);
                MableBuilder.nestedOrRecursive(expressionsToAdd, orBinaryExp);
            } else {
                currentExpression.setRight(expressionsToAdd.get(0));
            }
        }
    }

    public static PExp call(String object, String method, List<PExp> args) {
        return MableBuilder.call((PExp)MableAstFactory.newAIdentifierExp(object), method, args);
    }

    public static PExp call(PExp object, String method, List<PExp> args) {
        return MableAstFactory.newACallExp(object, MableAstFactory.newAIdentifier(method), args);
    }

    public static PExp call(PExp object, String method, PExp ... args) {
        return MableAstFactory.newACallExp(object, MableAstFactory.newAIdentifier(method), Arrays.asList(args));
    }

    public static PExp call(String object, String method) {
        return MableBuilder.call(object, method, (List<PExp>)null);
    }

    public static PExp call(String method, PExp ... args) {
        return MableBuilder.call(method, args == null ? null : Arrays.asList(args));
    }

    public static PExp call(String method, List<PExp> args) {
        return MableAstFactory.newACallExp(MableAstFactory.newAIdentifier(method), args);
    }

    public static PExp call(String method) {
        return MableBuilder.call(method, (List<PExp>)null);
    }

    public static PExp arrayGet(String name, PExp index) {
        return MableAstFactory.newAArrayIndexExp(MableAstFactory.newAIdentifierExp(name), Collections.singletonList(index));
    }

    public static PExp arrayGet(PExp name, PExp index) {
        return MableAstFactory.newAArrayIndexExp(name.clone(), Collections.singletonList(index.clone()));
    }

    public static PExp arrayGet(String name, int index) {
        return MableBuilder.arrayGet(name, (PExp)MableAstFactory.newAIntLiteralExp(index));
    }

    public static PExp arrayGet(LexIdentifier name, AIntLiteralExp index) {
        return MableBuilder.arrayGet(name.getText(), (PExp)index);
    }

    public static PExp arrayGet(LexIdentifier name, int index) {
        return MableBuilder.arrayGet(name.getText(), index);
    }

    public static PStm arraySet(String name, Integer index, PExp value) {
        AArrayStateDesignator stateDesignator = MableAstFactory.newAArayStateDesignator(MableAstFactory.newAIdentifierStateDesignator(MableAstFactory.newAIdentifier(name)), MableAstFactory.newAIntLiteralExp(index));
        return new AAssigmentStm(stateDesignator, value);
    }
}

