/*******************************************************************************
* Copyright (c) 2009, 2011 Overture Team and others.
*
* Overture is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Overture is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Overture.  If not, see <http://www.gnu.org/licenses/>.
*
* The Overture Tool web-site: http://overturetool.org/
*******************************************************************************/

/* This file was generated by ASTcreator (http://www.lausdahl.com/). */

package org.intocps.maestro.ast.node;


import org.intocps.maestro.ast.node.PTypeBase;
import org.intocps.maestro.ast.analysis.intf.IAnalysis;
import org.intocps.maestro.ast.analysis.AnalysisException;
import java.util.HashMap;
import org.intocps.maestro.ast.analysis.intf.IAnswer;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.ast.analysis.intf.IQuestionAnswer;
import java.util.Map;
import java.lang.Boolean;
import org.intocps.maestro.ast.analysis.intf.IQuestion;
import java.lang.String;
import org.intocps.maestro.ast.node.INode;
import org.intocps.maestro.ast.node.AArrayType;


/**
* Generated file by AST Creator
* @author Kenneth Lausdahl
*
*/
@SuppressWarnings({"all"})
public class AArrayType extends PTypeBase
{
	private static final long serialVersionUID = 1L;

	private PType _type;

	/**
	 * Creates a new default constructor {@link AArrayType} node with no children.
	 */
	public AArrayType()
	{

	}



	/**
	* Creates a new complete constructor {@code AArrayType} node with the given nodes as children.
	* @deprecated This method should not be used, use AstFactory instead.
	* The basic child nodes are removed from their previous parents.
	* @param type_ the {@link PType} node for the {@code type} child of this {@link AArrayType} node
	*/
	public AArrayType(PType type_)
	{
		super();
		this.setType(type_);

	}


	/**
	 * Removes the {@link INode} {@code child} as a child of this {@link AArrayType} node.
	 * Do not call this method with any graph fields of this node. This will cause any child's
	 * with the same reference to be removed unintentionally or {@link RuntimeException}will be thrown.
	 * @param child the child node to be removed from this {@link AArrayType} node
	 * @throws RuntimeException if {@code child} is not a child of this {@link AArrayType} node
	 */
	public void removeChild(INode child)
	{
		if (this._type == child) {
			this._type = null;
			return;
		}

		throw new RuntimeException("Not a child.");
	}


	/**
	 * Creates a map of all field names and their value
	 * @param includeInheritedFields if true all inherited fields are included
	 * @return a a map of names to values of all fields
	 */
	@Override
	public Map<String,Object> getChildren(Boolean includeInheritedFields)
	{
		Map<String,Object> fields = new HashMap<String,Object>();
		if(includeInheritedFields)
		{
			fields.putAll(super.getChildren(includeInheritedFields));
		}
		fields.put("_type",this._type);
		return fields;
	}


	/**
	 * Returns a deep clone of this {@link AArrayType} node.
	 * @return a deep clone of this {@link AArrayType} node
	 */
	public AArrayType clone()
	{
		return new AArrayType(
			cloneNode(_type)
		);
	}


	/**
	* Forwarding hashCode call to {@link Object#hashCode()}.
	**/
	@Override
	public int hashCode()
	{
		return super.hashCode();
	}



	public String toString()
	{
		return "" + _type+"[]";
	}


	/**
	 * Creates a deep clone of this {@link AArrayType} node while putting all
	 * old node-new node relations in the map {@code oldToNewMap}.
	 * @param oldToNewMap the map filled with the old node-new node relation
	 * @return a deep clone of this {@link AArrayType} node
	 */
	public AArrayType clone(Map<INode,INode> oldToNewMap)
	{
		AArrayType node = new AArrayType(
			cloneNode(_type, oldToNewMap)
		);
		oldToNewMap.put(this, node);
		return node;
	}


	/**
	* Essentially this.toString().equals(o.toString()).
	**/
	@Override
	public boolean equals(Object o)
	{
		if (o != null && o instanceof AArrayType)		{
			 return toString().equals(o.toString());
		}
		return false;
	}


	/**
	 * Sets the {@code _type} child of this {@link AArrayType} node.
	 * @param value the new {@code _type} child of this {@link AArrayType} node
	*/
	public void setType(PType value)
	{
		if (this._type != null) {
			this._type.parent(null);
		}
		if (value != null) {
			if (value.parent() != null) {
				value.parent().removeChild(value);
		}
			value.parent(this);
		}
		this._type = value;

	}


	/**
	 * @return the {@link PType} node which is the {@code _type} child of this {@link AArrayType} node
	*/
	public PType getType()
	{
		return this._type;
	}


	/**
	* Calls the {@link IAnalysis#caseAArrayType(AArrayType)} of the {@link IAnalysis} {@code caller}.
	* @param caller the {@link IAnalysis} to which this {@link AArrayType} node is applied
	*/
	@Override
	public void apply(IAnalysis caller) throws AnalysisException
	{
		caller.caseAArrayType(this);
	}


	/**
	* Calls the {@link IAnswer#caseAArrayType(AArrayType)} of the {@link IAnswer} {@code caller}.
	* @param caller the {@link IAnswer} to which this {@link AArrayType} node is applied
	*/
	@Override
	public <A> A apply(IAnswer<A> caller) throws AnalysisException
	{
		return caller.caseAArrayType(this);
	}


	/**
	* Calls the {@link IQuestion#caseAArrayType(AArrayType, Object)} of the {@link IQuestion} {@code caller}.
	* @param caller the {@link IQuestion} to which this {@link AArrayType} node is applied
	* @param question the question provided to {@code caller}
	*/
	@Override
	public <Q> void apply(IQuestion<Q> caller, Q question) throws AnalysisException
	{
		caller.caseAArrayType(this,question);
	}


	/**
	* Calls the {@link IQuestionAnswer#caseAArrayType(AArrayType, Object)} of the {@link IQuestionAnswer} {@code caller}.
	* @param caller the {@link IQuestionAnswer} to which this {@link AArrayType} node is applied
	* @param question the question provided to {@code caller}
	*/
	@Override
	public <Q, A> A apply(IQuestionAnswer<Q, A> caller, Q question) throws AnalysisException
	{
		return caller.caseAArrayType(this,question);
	}



}
