/*******************************************************************************
* Copyright (c) 2009, 2011 Overture Team and others.
*
* Overture is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Overture is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Overture.  If not, see <http://www.gnu.org/licenses/>.
*
* The Overture Tool web-site: http://overturetool.org/
*******************************************************************************/

/* This file was generated by ASTcreator (http://www.lausdahl.com/). */

package org.intocps.maestro.ast;


import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.analysis.intf.IAnalysis;
import org.intocps.maestro.ast.analysis.AnalysisException;
import org.intocps.maestro.ast.AFunctionDeclaration;
import java.util.HashMap;
import org.intocps.maestro.ast.analysis.intf.IAnswer;
import java.util.stream.Collectors;
import org.intocps.maestro.ast.PDeclarationBase;
import org.intocps.maestro.ast.node.AFormalParameter;
import java.util.List;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.ast.analysis.intf.IQuestionAnswer;
import org.intocps.maestro.ast.node.NodeList;
import java.util.Map;
import java.lang.Boolean;
import org.intocps.maestro.ast.analysis.intf.IQuestion;
import java.lang.String;
import java.util.LinkedList;
import org.intocps.maestro.ast.node.INode;


/**
* Generated file by AST Creator
* @author Kenneth Lausdahl
*
*/
@SuppressWarnings({"all"})
public class AFunctionDeclaration extends PDeclarationBase
{
	private static final long serialVersionUID = 1L;

	private PType _returnType;
	private NodeList<AFormalParameter> _formals = new NodeList<AFormalParameter>(this);

	/**
	* Creates a new complete constructor {@code AFunctionDeclaration} node with the given nodes as children.
	* @deprecated This method should not be used, use AstFactory instead.
	* The basic child nodes are removed from their previous parents.
	* @param returnType_ the {@link PType} node for the {@code returnType} child of this {@link AFunctionDeclaration} node
	* @param formals_ the {@link NodeList} node for the {@code formals} child of this {@link AFunctionDeclaration} node
	*/
	public AFunctionDeclaration(LexIdentifier name_, PType returnType_, List<? extends AFormalParameter> formals_)
	{
		super(name_);
		this.setReturnType(returnType_);
		this.setFormals(formals_);

	}


	/**
	 * Creates a new default constructor {@link AFunctionDeclaration} node with no children.
	 */
	public AFunctionDeclaration()
	{

	}



	/**
	 * Removes the {@link INode} {@code child} as a child of this {@link AFunctionDeclaration} node.
	 * Do not call this method with any graph fields of this node. This will cause any child's
	 * with the same reference to be removed unintentionally or {@link RuntimeException}will be thrown.
	 * @param child the child node to be removed from this {@link AFunctionDeclaration} node
	 * @throws RuntimeException if {@code child} is not a child of this {@link AFunctionDeclaration} node
	 */
	public void removeChild(INode child)
	{
		if (this._returnType == child) {
			this._returnType = null;
			return;
		}

		if (this._formals.remove(child)) {
				return;
		}
		throw new RuntimeException("Not a child.");
	}



	public String toString()
	{
		return "" + _returnType+ " "+ _name+"("+ _formals.stream().map(Object::toString).collect(Collectors.joining(", "))+")";
	}


	/**
	 * Returns a deep clone of this {@link AFunctionDeclaration} node.
	 * @return a deep clone of this {@link AFunctionDeclaration} node
	 */
	public AFunctionDeclaration clone()
	{
		return new AFunctionDeclaration(
			_name,
			cloneNode(_returnType),
			cloneList(_formals)
		);
	}


	/**
	* Essentially this.toString().equals(o.toString()).
	**/
	@Override
	public boolean equals(Object o)
	{
		if (o != null && o instanceof AFunctionDeclaration)		{
			 return toString().equals(o.toString());
		}
		return false;
	}


	/**
	 * Creates a deep clone of this {@link AFunctionDeclaration} node while putting all
	 * old node-new node relations in the map {@code oldToNewMap}.
	 * @param oldToNewMap the map filled with the old node-new node relation
	 * @return a deep clone of this {@link AFunctionDeclaration} node
	 */
	public AFunctionDeclaration clone(Map<INode,INode> oldToNewMap)
	{
		AFunctionDeclaration node = new AFunctionDeclaration(
			_name,
			cloneNode(_returnType, oldToNewMap),
			cloneList(_formals, oldToNewMap)
		);
		oldToNewMap.put(this, node);
		return node;
	}


	/**
	 * Creates a map of all field names and their value
	 * @param includeInheritedFields if true all inherited fields are included
	 * @return a a map of names to values of all fields
	 */
	@Override
	public Map<String,Object> getChildren(Boolean includeInheritedFields)
	{
		Map<String,Object> fields = new HashMap<String,Object>();
		if(includeInheritedFields)
		{
			fields.putAll(super.getChildren(includeInheritedFields));
		}
		fields.put("_returnType",this._returnType);
		fields.put("_formals",this._formals);
		return fields;
	}


	/**
	* Forwarding hashCode call to {@link Object#hashCode()}.
	**/
	@Override
	public int hashCode()
	{
		return super.hashCode();
	}


	/**
	 * Sets the {@code _returnType} child of this {@link AFunctionDeclaration} node.
	 * @param value the new {@code _returnType} child of this {@link AFunctionDeclaration} node
	*/
	public void setReturnType(PType value)
	{
		if (this._returnType != null) {
			this._returnType.parent(null);
		}
		if (value != null) {
			if (value.parent() != null) {
				value.parent().removeChild(value);
		}
			value.parent(this);
		}
		this._returnType = value;

	}


	/**
	 * @return the {@link PType} node which is the {@code _returnType} child of this {@link AFunctionDeclaration} node
	*/
	public PType getReturnType()
	{
		return this._returnType;
	}


	/**
	 * Sets the {@code _formals} child of this {@link AFunctionDeclaration} node.
	 * @param value the new {@code _formals} child of this {@link AFunctionDeclaration} node
	*/
	public void setFormals(List<? extends AFormalParameter> value)
	{
		if (this._formals.equals(value)) {
			return;
		}
		this._formals.clear();
		if (value != null) {
			this._formals.addAll(value);
		}

	}


	/**
	 * @return the {@link LinkedList} node which is the {@code _formals} child of this {@link AFunctionDeclaration} node
	*/
	public LinkedList<AFormalParameter> getFormals()
	{
		return this._formals;
	}


	/**
	* Calls the {@link IAnalysis#caseAFunctionDeclaration(AFunctionDeclaration)} of the {@link IAnalysis} {@code caller}.
	* @param caller the {@link IAnalysis} to which this {@link AFunctionDeclaration} node is applied
	*/
	@Override
	public void apply(IAnalysis caller) throws AnalysisException
	{
		caller.caseAFunctionDeclaration(this);
	}


	/**
	* Calls the {@link IAnswer#caseAFunctionDeclaration(AFunctionDeclaration)} of the {@link IAnswer} {@code caller}.
	* @param caller the {@link IAnswer} to which this {@link AFunctionDeclaration} node is applied
	*/
	@Override
	public <A> A apply(IAnswer<A> caller) throws AnalysisException
	{
		return caller.caseAFunctionDeclaration(this);
	}


	/**
	* Calls the {@link IQuestion#caseAFunctionDeclaration(AFunctionDeclaration, Object)} of the {@link IQuestion} {@code caller}.
	* @param caller the {@link IQuestion} to which this {@link AFunctionDeclaration} node is applied
	* @param question the question provided to {@code caller}
	*/
	@Override
	public <Q> void apply(IQuestion<Q> caller, Q question) throws AnalysisException
	{
		caller.caseAFunctionDeclaration(this,question);
	}


	/**
	* Calls the {@link IQuestionAnswer#caseAFunctionDeclaration(AFunctionDeclaration, Object)} of the {@link IQuestionAnswer} {@code caller}.
	* @param caller the {@link IQuestionAnswer} to which this {@link AFunctionDeclaration} node is applied
	* @param question the question provided to {@code caller}
	*/
	@Override
	public <Q, A> A apply(IQuestionAnswer<Q, A> caller, Q question) throws AnalysisException
	{
		return caller.caseAFunctionDeclaration(this,question);
	}



}
