/*******************************************************************************
* Copyright (c) 2009, 2011 Overture Team and others.
*
* Overture is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Overture is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Overture.  If not, see <http://www.gnu.org/licenses/>.
*
* The Overture Tool web-site: http://overturetool.org/
*******************************************************************************/

/* This file was generated by ASTcreator (http://www.lausdahl.com/). */

package org.intocps.maestro.ast.node;


import org.intocps.maestro.ast.node.AIfStm;
import org.intocps.maestro.ast.analysis.intf.IAnalysis;
import org.intocps.maestro.ast.analysis.AnalysisException;
import java.util.HashMap;
import org.intocps.maestro.ast.analysis.intf.IAnswer;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PStmBase;
import org.intocps.maestro.ast.analysis.intf.IQuestionAnswer;
import java.util.Map;
import org.intocps.maestro.ast.node.PStm;
import java.lang.Boolean;
import org.intocps.maestro.ast.analysis.intf.IQuestion;
import java.lang.String;
import org.intocps.maestro.ast.node.INode;


/**
* Generated file by AST Creator
* @author Kenneth Lausdahl
*
*/
@SuppressWarnings({"all"})
public class AIfStm extends PStmBase
{
	private static final long serialVersionUID = 1L;

	private PExp _test;
	private PStm _then;
	private PStm _else;


	/**
	 * Creates a new default constructor {@link AIfStm} node with no children.
	 */
	public AIfStm()
	{

	}


	/**
	* Creates a new complete constructor {@code AIfStm} node with the given nodes as children.
	* @deprecated This method should not be used, use AstFactory instead.
	* The basic child nodes are removed from their previous parents.
	* @param test_ the {@link PExp} node for the {@code test} child of this {@link AIfStm} node
	* @param then_ the {@link PStm} node for the {@code then} child of this {@link AIfStm} node
	* @param else_ the {@link PStm} node for the {@code else} child of this {@link AIfStm} node
	*/
	public AIfStm(PExp test_, PStm then_, PStm else_)
	{
		super();
		this.setTest(test_);
		this.setThen(then_);
		this.setElse(else_);

	}


	/**
	 * Removes the {@link INode} {@code child} as a child of this {@link AIfStm} node.
	 * Do not call this method with any graph fields of this node. This will cause any child's
	 * with the same reference to be removed unintentionally or {@link RuntimeException}will be thrown.
	 * @param child the child node to be removed from this {@link AIfStm} node
	 * @throws RuntimeException if {@code child} is not a child of this {@link AIfStm} node
	 */
	public void removeChild(INode child)
	{
		if (this._test == child) {
			this._test = null;
			return;
		}

		if (this._then == child) {
			this._then = null;
			return;
		}

		if (this._else == child) {
			this._else = null;
			return;
		}

		throw new RuntimeException("Not a child.");
	}


	/**
	 * Creates a map of all field names and their value
	 * @param includeInheritedFields if true all inherited fields are included
	 * @return a a map of names to values of all fields
	 */
	@Override
	public Map<String,Object> getChildren(Boolean includeInheritedFields)
	{
		Map<String,Object> fields = new HashMap<String,Object>();
		if(includeInheritedFields)
		{
			fields.putAll(super.getChildren(includeInheritedFields));
		}
		fields.put("_test",this._test);
		fields.put("_then",this._then);
		fields.put("_else",this._else);
		return fields;
	}


	/**
	* Essentially this.toString().equals(o.toString()).
	**/
	@Override
	public boolean equals(Object o)
	{
		if (o != null && o instanceof AIfStm)		{
			 return toString().equals(o.toString());
		}
		return false;
	}



	public String toString()
	{
		return "" + "if( "+ _test +" ) \n{\n" + _then+ "\n}"+   (_else!=null ?"\nelse \n{\n" +_else +"\n}":"");
	}


	/**
	* Forwarding hashCode call to {@link Object#hashCode()}.
	**/
	@Override
	public int hashCode()
	{
		return super.hashCode();
	}


	/**
	 * Creates a deep clone of this {@link AIfStm} node while putting all
	 * old node-new node relations in the map {@code oldToNewMap}.
	 * @param oldToNewMap the map filled with the old node-new node relation
	 * @return a deep clone of this {@link AIfStm} node
	 */
	public AIfStm clone(Map<INode,INode> oldToNewMap)
	{
		AIfStm node = new AIfStm(
			cloneNode(_test, oldToNewMap),
			cloneNode(_then, oldToNewMap),
			cloneNode(_else, oldToNewMap)
		);
		oldToNewMap.put(this, node);
		return node;
	}


	/**
	 * Returns a deep clone of this {@link AIfStm} node.
	 * @return a deep clone of this {@link AIfStm} node
	 */
	public AIfStm clone()
	{
		return new AIfStm(
			cloneNode(_test),
			cloneNode(_then),
			cloneNode(_else)
		);
	}


	/**
	 * Sets the {@code _test} child of this {@link AIfStm} node.
	 * @param value the new {@code _test} child of this {@link AIfStm} node
	*/
	public void setTest(PExp value)
	{
		if (this._test != null) {
			this._test.parent(null);
		}
		if (value != null) {
			if (value.parent() != null) {
				value.parent().removeChild(value);
		}
			value.parent(this);
		}
		this._test = value;

	}


	/**
	 * @return the {@link PExp} node which is the {@code _test} child of this {@link AIfStm} node
	*/
	public PExp getTest()
	{
		return this._test;
	}


	/**
	 * Sets the {@code _then} child of this {@link AIfStm} node.
	 * @param value the new {@code _then} child of this {@link AIfStm} node
	*/
	public void setThen(PStm value)
	{
		if (this._then != null) {
			this._then.parent(null);
		}
		if (value != null) {
			if (value.parent() != null) {
				value.parent().removeChild(value);
		}
			value.parent(this);
		}
		this._then = value;

	}


	/**
	 * @return the {@link PStm} node which is the {@code _then} child of this {@link AIfStm} node
	*/
	public PStm getThen()
	{
		return this._then;
	}


	/**
	 * Sets the {@code _else} child of this {@link AIfStm} node.
	 * @param value the new {@code _else} child of this {@link AIfStm} node
	*/
	public void setElse(PStm value)
	{
		if (this._else != null) {
			this._else.parent(null);
		}
		if (value != null) {
			if (value.parent() != null) {
				value.parent().removeChild(value);
		}
			value.parent(this);
		}
		this._else = value;

	}


	/**
	 * @return the {@link PStm} node which is the {@code _else} child of this {@link AIfStm} node
	*/
	public PStm getElse()
	{
		return this._else;
	}


	/**
	* Calls the {@link IAnalysis#caseAIfStm(AIfStm)} of the {@link IAnalysis} {@code caller}.
	* @param caller the {@link IAnalysis} to which this {@link AIfStm} node is applied
	*/
	@Override
	public void apply(IAnalysis caller) throws AnalysisException
	{
		caller.caseAIfStm(this);
	}


	/**
	* Calls the {@link IAnswer#caseAIfStm(AIfStm)} of the {@link IAnswer} {@code caller}.
	* @param caller the {@link IAnswer} to which this {@link AIfStm} node is applied
	*/
	@Override
	public <A> A apply(IAnswer<A> caller) throws AnalysisException
	{
		return caller.caseAIfStm(this);
	}


	/**
	* Calls the {@link IQuestion#caseAIfStm(AIfStm, Object)} of the {@link IQuestion} {@code caller}.
	* @param caller the {@link IQuestion} to which this {@link AIfStm} node is applied
	* @param question the question provided to {@code caller}
	*/
	@Override
	public <Q> void apply(IQuestion<Q> caller, Q question) throws AnalysisException
	{
		caller.caseAIfStm(this,question);
	}


	/**
	* Calls the {@link IQuestionAnswer#caseAIfStm(AIfStm, Object)} of the {@link IQuestionAnswer} {@code caller}.
	* @param caller the {@link IQuestionAnswer} to which this {@link AIfStm} node is applied
	* @param question the question provided to {@code caller}
	*/
	@Override
	public <Q, A> A apply(IQuestionAnswer<Q, A> caller, Q question) throws AnalysisException
	{
		return caller.caseAIfStm(this,question);
	}



}
