/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.ast;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.intocps.maestro.ast.AFunctionDeclaration;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.PDeclarationBase;
import org.intocps.maestro.ast.analysis.AnalysisException;
import org.intocps.maestro.ast.analysis.intf.IAnalysis;
import org.intocps.maestro.ast.analysis.intf.IAnswer;
import org.intocps.maestro.ast.analysis.intf.IQuestion;
import org.intocps.maestro.ast.analysis.intf.IQuestionAnswer;
import org.intocps.maestro.ast.node.INode;
import org.intocps.maestro.ast.node.NodeList;

public class AModuleDeclaration
extends PDeclarationBase {
    private static final long serialVersionUID = 1L;
    private NodeList<AFunctionDeclaration> _functions = new NodeList(this);

    public AModuleDeclaration(LexIdentifier name_, List<? extends AFunctionDeclaration> functions_) {
        super(null);
        this.setName(name_);
        this.setFunctions(functions_);
    }

    public AModuleDeclaration() {
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o != null && o instanceof AModuleDeclaration) {
            return this.toString().equals(o.toString());
        }
        return false;
    }

    @Override
    public String toString() {
        return this._name + " {" + this._functions.stream().map(Object::toString).collect(Collectors.joining(";\n", "\n", "\n")) + "}";
    }

    @Override
    public AModuleDeclaration clone(Map<INode, INode> oldToNewMap) {
        AModuleDeclaration node = new AModuleDeclaration(this._name, this.cloneList(this._functions, oldToNewMap));
        oldToNewMap.put(this, node);
        return node;
    }

    @Override
    public AModuleDeclaration clone() {
        return new AModuleDeclaration(this._name, this.cloneList(this._functions));
    }

    @Override
    public void removeChild(INode child) {
        if (this._functions.remove(child)) {
            return;
        }
        throw new RuntimeException("Not a child.");
    }

    @Override
    public Map<String, Object> getChildren(Boolean includeInheritedFields) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        if (includeInheritedFields.booleanValue()) {
            fields.putAll(super.getChildren(includeInheritedFields));
        }
        fields.put("_name", this._name);
        fields.put("_functions", this._functions);
        return fields;
    }

    @Override
    public void setName(LexIdentifier value) {
        this._name = value;
    }

    @Override
    public LexIdentifier getName() {
        return this._name;
    }

    public void setFunctions(List<? extends AFunctionDeclaration> value) {
        if (this._functions.equals(value)) {
            return;
        }
        this._functions.clear();
        if (value != null) {
            this._functions.addAll(value);
        }
    }

    public LinkedList<AFunctionDeclaration> getFunctions() {
        return this._functions;
    }

    @Override
    public void apply(IAnalysis caller) throws AnalysisException {
        caller.caseAModuleDeclaration(this);
    }

    @Override
    public <A> A apply(IAnswer<A> caller) throws AnalysisException {
        return caller.caseAModuleDeclaration(this);
    }

    @Override
    public <Q> void apply(IQuestion<Q> caller, Q question) throws AnalysisException {
        caller.caseAModuleDeclaration(this, question);
    }

    @Override
    public <Q, A> A apply(IQuestionAnswer<Q, A> caller, Q question) throws AnalysisException {
        return caller.caseAModuleDeclaration(this, question);
    }
}

