/*******************************************************************************
* Copyright (c) 2009, 2011 Overture Team and others.
*
* Overture is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Overture is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Overture.  If not, see <http://www.gnu.org/licenses/>.
*
* The Overture Tool web-site: http://overturetool.org/
*******************************************************************************/

/* This file was generated by ASTcreator (http://www.lausdahl.com/). */

package org.intocps.maestro.ast.node;


import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.analysis.intf.IAnalysis;
import org.intocps.maestro.ast.analysis.AnalysisException;
import org.intocps.maestro.ast.node.PCompilationUnitBase;
import java.util.HashMap;
import org.intocps.maestro.ast.node.AImportedModuleCompilationUnit;
import org.intocps.maestro.ast.analysis.intf.IAnswer;
import java.util.stream.Collectors;
import java.util.List;
import java.util.Vector;
import org.intocps.maestro.ast.analysis.intf.IQuestionAnswer;
import org.intocps.maestro.ast.node.NodeList;
import org.intocps.maestro.ast.AModuleDeclaration;
import java.util.Map;
import java.lang.Boolean;
import org.intocps.maestro.ast.analysis.intf.IQuestion;
import java.lang.String;
import java.util.LinkedList;
import org.intocps.maestro.ast.node.INode;


/**
* Generated file by AST Creator
* @author Kenneth Lausdahl
*
*/
@SuppressWarnings({"all"})
public class AImportedModuleCompilationUnit extends PCompilationUnitBase
{
	private static final long serialVersionUID = 1L;

	private AModuleDeclaration _module;
	private List<? extends LexIdentifier> _imports = new Vector<LexIdentifier>();


	/**
	* Creates a new complete constructor {@code AImportedModuleCompilationUnit} node with the given nodes as children.
	* @deprecated This method should not be used, use AstFactory instead.
	* The basic child nodes are removed from their previous parents.
	* @param module_ the {@link AModuleDeclaration} node for the {@code module} child of this {@link AImportedModuleCompilationUnit} node
	* @param imports_ the {@link List} node for the {@code imports} child of this {@link AImportedModuleCompilationUnit} node
	*/
	public AImportedModuleCompilationUnit(AModuleDeclaration module_, List<? extends LexIdentifier> imports_)
	{
		super();
		this.setModule(module_);
		this.setImports(imports_);

	}


	/**
	 * Creates a new default constructor {@link AImportedModuleCompilationUnit} node with no children.
	 */
	public AImportedModuleCompilationUnit()
	{

	}


	/**
	 * Removes the {@link INode} {@code child} as a child of this {@link AImportedModuleCompilationUnit} node.
	 * Do not call this method with any graph fields of this node. This will cause any child's
	 * with the same reference to be removed unintentionally or {@link RuntimeException}will be thrown.
	 * @param child the child node to be removed from this {@link AImportedModuleCompilationUnit} node
	 * @throws RuntimeException if {@code child} is not a child of this {@link AImportedModuleCompilationUnit} node
	 */
	public void removeChild(INode child)
	{
		if (this._module == child) {
			this._module = null;
			return;
		}

		throw new RuntimeException("Not a child.");
	}


	/**
	 * Creates a map of all field names and their value
	 * @param includeInheritedFields if true all inherited fields are included
	 * @return a a map of names to values of all fields
	 */
	@Override
	public Map<String,Object> getChildren(Boolean includeInheritedFields)
	{
		Map<String,Object> fields = new HashMap<String,Object>();
		if(includeInheritedFields)
		{
			fields.putAll(super.getChildren(includeInheritedFields));
		}
		fields.put("_module",this._module);
		fields.put("_imports",this._imports);
		return fields;
	}



	public String toString()
	{
		return "" + "imported "+ _imports.stream().map( s-> "import " + "" + s.toString()).collect(Collectors.joining(";\n","\n",";\n"))+_module;
	}


	/**
	* Essentially this.toString().equals(o.toString()).
	**/
	@Override
	public boolean equals(Object o)
	{
		if (o != null && o instanceof AImportedModuleCompilationUnit)		{
			 return toString().equals(o.toString());
		}
		return false;
	}


	/**
	 * Returns a deep clone of this {@link AImportedModuleCompilationUnit} node.
	 * @return a deep clone of this {@link AImportedModuleCompilationUnit} node
	 */
	public AImportedModuleCompilationUnit clone()
	{
		return new AImportedModuleCompilationUnit(
			cloneNode(_module),
			cloneListExternal(_imports)
		);
	}


	/**
	* Forwarding hashCode call to {@link Object#hashCode()}.
	**/
	@Override
	public int hashCode()
	{
		return super.hashCode();
	}


	/**
	 * Creates a deep clone of this {@link AImportedModuleCompilationUnit} node while putting all
	 * old node-new node relations in the map {@code oldToNewMap}.
	 * @param oldToNewMap the map filled with the old node-new node relation
	 * @return a deep clone of this {@link AImportedModuleCompilationUnit} node
	 */
	public AImportedModuleCompilationUnit clone(Map<INode,INode> oldToNewMap)
	{
		AImportedModuleCompilationUnit node = new AImportedModuleCompilationUnit(
			cloneNode(_module, oldToNewMap),
			cloneListExternal(_imports, oldToNewMap)
		);
		oldToNewMap.put(this, node);
		return node;
	}


	/**
	 * Sets the {@code _module} child of this {@link AImportedModuleCompilationUnit} node.
	 * @param value the new {@code _module} child of this {@link AImportedModuleCompilationUnit} node
	*/
	public void setModule(AModuleDeclaration value)
	{
		if (this._module != null) {
			this._module.parent(null);
		}
		if (value != null) {
			if (value.parent() != null) {
				value.parent().removeChild(value);
		}
			value.parent(this);
		}
		this._module = value;

	}


	/**
	 * @return the {@link AModuleDeclaration} node which is the {@code _module} child of this {@link AImportedModuleCompilationUnit} node
	*/
	public AModuleDeclaration getModule()
	{
		return this._module;
	}


	/**
	 * Sets the {@code _imports} child of this {@link AImportedModuleCompilationUnit} node.
	 * @param value the new {@code _imports} child of this {@link AImportedModuleCompilationUnit} node
	*/
	public void setImports(List<? extends LexIdentifier> value)
	{
		this._imports = value;
	}


	/**
	 * @return the {@link List} node which is the {@code _imports} child of this {@link AImportedModuleCompilationUnit} node
	*/
	public List<? extends LexIdentifier> getImports()
	{
		return this._imports;
	}


	/**
	* Calls the {@link IAnalysis#caseAImportedModuleCompilationUnit(AImportedModuleCompilationUnit)} of the {@link IAnalysis} {@code caller}.
	* @param caller the {@link IAnalysis} to which this {@link AImportedModuleCompilationUnit} node is applied
	*/
	@Override
	public void apply(IAnalysis caller) throws AnalysisException
	{
		caller.caseAImportedModuleCompilationUnit(this);
	}


	/**
	* Calls the {@link IAnswer#caseAImportedModuleCompilationUnit(AImportedModuleCompilationUnit)} of the {@link IAnswer} {@code caller}.
	* @param caller the {@link IAnswer} to which this {@link AImportedModuleCompilationUnit} node is applied
	*/
	@Override
	public <A> A apply(IAnswer<A> caller) throws AnalysisException
	{
		return caller.caseAImportedModuleCompilationUnit(this);
	}


	/**
	* Calls the {@link IQuestion#caseAImportedModuleCompilationUnit(AImportedModuleCompilationUnit, Object)} of the {@link IQuestion} {@code caller}.
	* @param caller the {@link IQuestion} to which this {@link AImportedModuleCompilationUnit} node is applied
	* @param question the question provided to {@code caller}
	*/
	@Override
	public <Q> void apply(IQuestion<Q> caller, Q question) throws AnalysisException
	{
		caller.caseAImportedModuleCompilationUnit(this,question);
	}


	/**
	* Calls the {@link IQuestionAnswer#caseAImportedModuleCompilationUnit(AImportedModuleCompilationUnit, Object)} of the {@link IQuestionAnswer} {@code caller}.
	* @param caller the {@link IQuestionAnswer} to which this {@link AImportedModuleCompilationUnit} node is applied
	* @param question the question provided to {@code caller}
	*/
	@Override
	public <Q, A> A apply(IQuestionAnswer<Q, A> caller, Q question) throws AnalysisException
	{
		return caller.caseAImportedModuleCompilationUnit(this,question);
	}



}
