/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.ast.node;

import java.util.HashMap;
import java.util.Map;
import org.intocps.maestro.ast.analysis.AnalysisException;
import org.intocps.maestro.ast.analysis.intf.IAnalysis;
import org.intocps.maestro.ast.analysis.intf.IAnswer;
import org.intocps.maestro.ast.analysis.intf.IQuestion;
import org.intocps.maestro.ast.analysis.intf.IQuestionAnswer;
import org.intocps.maestro.ast.node.INode;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PStm;
import org.intocps.maestro.ast.node.PStmBase;

public class AIfStm
extends PStmBase {
    private static final long serialVersionUID = 1L;
    private PExp _test;
    private PStm _then;
    private PStm _else;

    public AIfStm(PExp test_, PStm then_, PStm else_) {
        this.setTest(test_);
        this.setThen(then_);
        this.setElse(else_);
    }

    public AIfStm() {
    }

    @Override
    public AIfStm clone() {
        return new AIfStm(this.cloneNode(this._test), this.cloneNode(this._then), this.cloneNode(this._else));
    }

    @Override
    public boolean equals(Object o) {
        if (o != null && o instanceof AIfStm) {
            return this.toString().equals(o.toString());
        }
        return false;
    }

    @Override
    public void removeChild(INode child) {
        if (this._test == child) {
            this._test = null;
            return;
        }
        if (this._then == child) {
            this._then = null;
            return;
        }
        if (this._else == child) {
            this._else = null;
            return;
        }
        throw new RuntimeException("Not a child.");
    }

    @Override
    public String toString() {
        return "if( " + this._test + " ) \n{\n" + this._then + "\n}" + (String)(this._else != null ? "\nelse \n{\n" + this._else + "\n}" : "");
    }

    @Override
    public Map<String, Object> getChildren(Boolean includeInheritedFields) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        if (includeInheritedFields.booleanValue()) {
            fields.putAll(super.getChildren(includeInheritedFields));
        }
        fields.put("_test", this._test);
        fields.put("_then", this._then);
        fields.put("_else", this._else);
        return fields;
    }

    @Override
    public AIfStm clone(Map<INode, INode> oldToNewMap) {
        AIfStm node = new AIfStm(this.cloneNode(this._test, oldToNewMap), this.cloneNode(this._then, oldToNewMap), this.cloneNode(this._else, oldToNewMap));
        oldToNewMap.put(this, node);
        return node;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public void setTest(PExp value) {
        if (this._test != null) {
            this._test.parent(null);
        }
        if (value != null) {
            if (value.parent() != null) {
                value.parent().removeChild(value);
            }
            value.parent(this);
        }
        this._test = value;
    }

    public PExp getTest() {
        return this._test;
    }

    public void setThen(PStm value) {
        if (this._then != null) {
            this._then.parent(null);
        }
        if (value != null) {
            if (value.parent() != null) {
                value.parent().removeChild(value);
            }
            value.parent(this);
        }
        this._then = value;
    }

    public PStm getThen() {
        return this._then;
    }

    public void setElse(PStm value) {
        if (this._else != null) {
            this._else.parent(null);
        }
        if (value != null) {
            if (value.parent() != null) {
                value.parent().removeChild(value);
            }
            value.parent(this);
        }
        this._else = value;
    }

    public PStm getElse() {
        return this._else;
    }

    @Override
    public void apply(IAnalysis caller) throws AnalysisException {
        caller.caseAIfStm(this);
    }

    @Override
    public <A> A apply(IAnswer<A> caller) throws AnalysisException {
        return caller.caseAIfStm(this);
    }

    @Override
    public <Q> void apply(IQuestion<Q> caller, Q question) throws AnalysisException {
        caller.caseAIfStm(this, question);
    }

    @Override
    public <Q, A> A apply(IQuestionAnswer<Q, A> caller, Q question) throws AnalysisException {
        return caller.caseAIfStm(this, question);
    }
}

