/*******************************************************************************
* Copyright (c) 2009, 2011 Overture Team and others.
*
* Overture is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Overture is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Overture.  If not, see <http://www.gnu.org/licenses/>.
*
* The Overture Tool web-site: http://overturetool.org/
*******************************************************************************/

/* This file was generated by ASTcreator (http://www.lausdahl.com/). */

package org.intocps.maestro.ast.analysis;


import java.lang.Float;
import org.intocps.maestro.ast.node.AIfStm;
import org.intocps.maestro.ast.node.ABoolLiteralExp;
import org.intocps.maestro.ast.node.AArrayStateDesignator;
import org.intocps.maestro.ast.ALessBinaryExp;
import org.intocps.maestro.ast.node.AWhileStm;
import java.lang.Integer;
import org.intocps.maestro.ast.node.ANameType;
import org.intocps.maestro.ast.node.AStringPrimitiveType;
import org.intocps.maestro.ast.node.AFormalParameter;
import org.intocps.maestro.ast.node.AIdentifierExp;
import org.intocps.maestro.ast.node.PParameter;
import org.intocps.maestro.ast.node.AIntLiteralExp;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.ast.AOrBinaryExp;
import org.intocps.maestro.ast.node.AParExp;
import java.lang.Long;
import org.intocps.maestro.ast.node.PDocument;
import org.intocps.maestro.ast.ABasicBlockStm;
import org.intocps.maestro.ast.node.ASimulationSpecificationCompilationUnit;
import org.intocps.maestro.ast.node.SUnaryExp;
import org.intocps.maestro.ast.node.AExpressionStm;
import org.intocps.maestro.ast.analysis.intf.IAnalysis;
import org.intocps.maestro.ast.AParallelBlockStm;
import java.util.Set;
import org.intocps.maestro.ast.AFunctionDeclaration;
import org.intocps.maestro.ast.node.AErrorStm;
import org.intocps.maestro.ast.node.ARefExp;
import org.intocps.maestro.ast.ALessEqualBinaryExp;
import org.intocps.maestro.ast.node.AImportedModuleCompilationUnit;
import org.intocps.maestro.ast.node.ALongNumericPrimitiveType;
import org.intocps.maestro.ast.AGreaterEqualBinaryExp;
import org.intocps.maestro.ast.node.PCompilationUnit;
import org.intocps.maestro.ast.node.AConfigFramework;
import org.intocps.maestro.ast.AGreaterBinaryExp;
import org.intocps.maestro.ast.LexIdentifier;
import java.lang.Double;
import org.intocps.maestro.ast.node.AObservableStm;
import java.util.ArrayList;
import org.intocps.maestro.ast.node.ALocalVariableStm;
import org.intocps.maestro.ast.node.PStateDesignator;
import org.intocps.maestro.ast.node.SLiteralExp;
import org.intocps.maestro.ast.node.ANullType;
import org.intocps.maestro.ast.node.PStm;
import java.lang.String;
import org.intocps.maestro.ast.node.IToken;
import org.intocps.maestro.ast.AVariableDeclaration;
import org.intocps.maestro.ast.node.AUIntLiteralExp;
import org.intocps.maestro.ast.node.PInitializer;
import org.intocps.maestro.ast.node.ATransferStm;
import org.intocps.maestro.ast.AAndBinaryExp;
import org.intocps.maestro.ast.node.ARealLiteralExp;
import org.intocps.maestro.ast.node.SBinaryExp;
import org.intocps.maestro.ast.AEqualBinaryExp;
import org.intocps.maestro.ast.node.AExpInitializer;
import org.intocps.maestro.ast.ANotUnaryExp;
import org.intocps.maestro.ast.node.ARootDocument;
import org.intocps.maestro.ast.node.AModuleType;
import org.intocps.maestro.ast.node.ACallExp;
import org.intocps.maestro.ast.APlusUnaryExp;
import org.intocps.maestro.ast.node.AStringLiteralExp;
import org.intocps.maestro.ast.analysis.AnalysisException;
import org.intocps.maestro.ast.AMinusBinaryExp;
import org.intocps.maestro.ast.node.ALongLiteralExp;
import org.intocps.maestro.ast.AMultiplyBinaryExp;
import org.intocps.maestro.ast.node.AIdentifierStateDesignator;
import org.intocps.maestro.ast.node.AFloatLiteralExp;
import org.intocps.maestro.ast.node.AInstanceMappingStm;
import org.intocps.maestro.ast.node.AShortNumericPrimitiveType;
import org.intocps.maestro.ast.node.AArrayType;
import org.intocps.maestro.ast.node.AIntNumericPrimitiveType;
import org.intocps.maestro.ast.node.AFunctionType;
import org.intocps.maestro.ast.node.ALoadExp;
import org.intocps.maestro.ast.node.PExp;
import java.util.List;
import org.intocps.maestro.ast.AModuleDeclaration;
import org.intocps.maestro.ast.node.AArrayInitializer;
import org.intocps.maestro.ast.APlusBinaryExp;
import org.intocps.maestro.ast.analysis.intf.IQuestion;
import org.intocps.maestro.ast.node.SBlockStm;
import org.intocps.maestro.ast.node.INode;
import org.intocps.maestro.ast.node.SNumericPrimitiveType;
import org.intocps.maestro.ast.node.AConfigStm;
import org.intocps.maestro.ast.node.AUnknownType;
import org.intocps.maestro.ast.node.AUnloadExp;
import org.intocps.maestro.ast.node.AFloatNumericPrimitiveType;
import org.intocps.maestro.ast.PDeclaration;
import org.intocps.maestro.ast.node.AAssigmentStm;
import org.intocps.maestro.ast.node.ANullExp;
import org.intocps.maestro.ast.node.ABooleanPrimitiveType;
import java.lang.Boolean;
import org.intocps.maestro.ast.node.AArrayIndexExp;
import org.intocps.maestro.ast.node.AFmuMappingStm;
import org.intocps.maestro.ast.node.ATransferAsStm;
import java.util.LinkedList;
import org.intocps.maestro.ast.node.ABreakStm;
import org.intocps.maestro.ast.node.ARealNumericPrimitiveType;
import org.intocps.maestro.ast.ANotEqualBinaryExp;
import org.intocps.maestro.ast.node.ATryStm;
import org.intocps.maestro.ast.node.AUIntNumericPrimitiveType;
import org.intocps.maestro.ast.AMinusUnaryExp;
import org.intocps.maestro.ast.node.AFieldExp;
import org.intocps.maestro.ast.ADivideBinaryExp;
import org.intocps.maestro.ast.node.SPrimitiveType;
import org.intocps.maestro.ast.node.AByteNumericPrimitiveType;
import org.intocps.maestro.ast.node.PFramework;
import org.intocps.maestro.ast.LexToken;
import org.intocps.maestro.ast.node.AReferenceType;
import org.intocps.maestro.ast.node.AVoidType;


/**
* Generated file by AST Creator
* @author Kenneth Lausdahl
*
*/
@SuppressWarnings({"all"})
public abstract class DepthFirstAnalysisAdaptorQuestion<Q> implements IQuestion<Q>
{
	private static final long serialVersionUID = 1L;

	protected Set<INode> _visitedNodes = new java.util.HashSet<INode>();
	final protected IQuestion<Q> THIS;

	/**
	* Creates a new complete constructor {@code DepthFirstAnalysisAdaptorQuestion} node with the given nodes as children.
	* The basic child nodes are removed from their previous parents.
	* @param visitedNodes_ the {@link Set} node for the {@code visitedNodes} child of this {@link DepthFirstAnalysisAdaptorQuestion} node
	* @param THIS_ the {@link IQuestion} <b>graph</a> node for the {@code THIS} child of this {@link DepthFirstAnalysisAdaptorQuestion} node.
	*  <i>The parent of this {@code THIS } will not be changed by adding it to this node.</i>
	*/
	public DepthFirstAnalysisAdaptorQuestion(Set<INode> visitedNodes_, IQuestion<Q> THIS_)
	{
		super();
		this.setVisitedNodes(visitedNodes_);
		this.THIS = THIS_;

	}


	/**
	 * Creates a new default constructor {@link DepthFirstAnalysisAdaptorQuestion} node with no children.
	 */
	public DepthFirstAnalysisAdaptorQuestion()
	{
		this.THIS=this;

	}


	/**
	 * Sets the {@code _visitedNodes} child of this {@link DepthFirstAnalysisAdaptorQuestion} node.
	 * @param value the new {@code _visitedNodes} child of this {@link DepthFirstAnalysisAdaptorQuestion} node
	*/
	public void setVisitedNodes(Set<INode> value)
	{

	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void caseString(String node, Q question) throws AnalysisException
	{
		inString(node, question);


		outString(node, question);

	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void inString(String node, Q question) throws AnalysisException
	{

	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void outString(String node, Q question) throws AnalysisException
	{

	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void caseBoolean(Boolean node, Q question) throws AnalysisException
	{
		inBoolean(node, question);


		outBoolean(node, question);

	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void inBoolean(Boolean node, Q question) throws AnalysisException
	{

	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void outBoolean(Boolean node, Q question) throws AnalysisException
	{

	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void caseInteger(Integer node, Q question) throws AnalysisException
	{
		inInteger(node, question);


		outInteger(node, question);

	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void inInteger(Integer node, Q question) throws AnalysisException
	{

	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void outInteger(Integer node, Q question) throws AnalysisException
	{

	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void caseDouble(Double node, Q question) throws AnalysisException
	{
		inDouble(node, question);


		outDouble(node, question);

	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void inDouble(Double node, Q question) throws AnalysisException
	{

	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void outDouble(Double node, Q question) throws AnalysisException
	{

	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void caseFloat(Float node, Q question) throws AnalysisException
	{
		inFloat(node, question);


		outFloat(node, question);

	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void inFloat(Float node, Q question) throws AnalysisException
	{

	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void outFloat(Float node, Q question) throws AnalysisException
	{

	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void caseLong(Long node, Q question) throws AnalysisException
	{
		inLong(node, question);


		outLong(node, question);

	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void inLong(Long node, Q question) throws AnalysisException
	{

	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void outLong(Long node, Q question) throws AnalysisException
	{

	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void caseLexIdentifier(LexIdentifier node, Q question) throws AnalysisException
	{
		inLexIdentifier(node, question);


		outLexIdentifier(node, question);

	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void inLexIdentifier(LexIdentifier node, Q question) throws AnalysisException
	{

	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void outLexIdentifier(LexIdentifier node, Q question) throws AnalysisException
	{

	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void caseLexToken(LexToken node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inLexToken(node, question);


		outLexToken(node, question);

	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void inLexToken(LexToken node, Q question) throws AnalysisException
	{
		defaultInINode(node, question);
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void outLexToken(LexToken node, Q question) throws AnalysisException
	{
		defaultOutINode(node, question);
	}


	/**
	* Called by the {@link PDocument} node from {@link PDocument#apply(IAnalysis)}.
	* @param node the calling {@link PDocument} node
	*/
	public void defaultInPDocument(PDocument node, Q question) throws AnalysisException
	{
		defaultInINode(node, question);
	}


	/**
	* Called by the {@link PDocument} node from {@link PDocument#apply(IAnalysis)}.
	* @param node the calling {@link PDocument} node
	*/
	public void defaultOutPDocument(PDocument node, Q question) throws AnalysisException
	{
		defaultOutINode(node, question);
	}


	/**
	* Called by the {@link PDocument} node from {@link PDocument#apply(IAnalysis)}.
	* @param node the calling {@link PDocument} node
	*/
	public void defaultPDocument(PDocument node, Q question) throws AnalysisException
	{
		defaultINode(node, question);
	}


	/**
	* Called by the {@link PDocument} node from {@link PDocument#apply(IAnalysis)}.
	* @param node the calling {@link PDocument} node
	*/
	public void inPDocument(PDocument node, Q question) throws AnalysisException
	{
		defaultInINode(node, question);
	}


	/**
	* Called by the {@link PDocument} node from {@link PDocument#apply(IAnalysis)}.
	* @param node the calling {@link PDocument} node
	*/
	public void outPDocument(PDocument node, Q question) throws AnalysisException
	{
		defaultOutINode(node, question);
	}


	/**
	* Called by the {@link ARootDocument} node from {@link ARootDocument#apply(IAnalysis)}.
	* @param node the calling {@link ARootDocument} node
	*/
	public void caseARootDocument(ARootDocument node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inARootDocument(node, question);

		{
			List<PCompilationUnit> copy = new ArrayList<PCompilationUnit>(node.getContent());
			for( PCompilationUnit e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					e.apply(this, question);
				}
			}
		}

		outARootDocument(node, question);

	}


	/**
	* Called by the {@link ARootDocument} node from {@link ARootDocument#apply(IAnalysis)}.
	* @param node the calling {@link ARootDocument} node
	*/
	public void inARootDocument(ARootDocument node, Q question) throws AnalysisException
	{
		defaultInPDocument(node, question);
	}


	/**
	* Called by the {@link ARootDocument} node from {@link ARootDocument#apply(IAnalysis)}.
	* @param node the calling {@link ARootDocument} node
	*/
	public void outARootDocument(ARootDocument node, Q question) throws AnalysisException
	{
		defaultOutPDocument(node, question);
	}


	/**
	* Called by the {@link PCompilationUnit} node from {@link PCompilationUnit#apply(IAnalysis)}.
	* @param node the calling {@link PCompilationUnit} node
	*/
	public void defaultInPCompilationUnit(PCompilationUnit node, Q question) throws AnalysisException
	{
		defaultInINode(node, question);
	}


	/**
	* Called by the {@link PCompilationUnit} node from {@link PCompilationUnit#apply(IAnalysis)}.
	* @param node the calling {@link PCompilationUnit} node
	*/
	public void defaultOutPCompilationUnit(PCompilationUnit node, Q question) throws AnalysisException
	{
		defaultOutINode(node, question);
	}


	/**
	* Called by the {@link PCompilationUnit} node from {@link PCompilationUnit#apply(IAnalysis)}.
	* @param node the calling {@link PCompilationUnit} node
	*/
	public void defaultPCompilationUnit(PCompilationUnit node, Q question) throws AnalysisException
	{
		defaultINode(node, question);
	}


	/**
	* Called by the {@link PCompilationUnit} node from {@link PCompilationUnit#apply(IAnalysis)}.
	* @param node the calling {@link PCompilationUnit} node
	*/
	public void inPCompilationUnit(PCompilationUnit node, Q question) throws AnalysisException
	{
		defaultInINode(node, question);
	}


	/**
	* Called by the {@link PCompilationUnit} node from {@link PCompilationUnit#apply(IAnalysis)}.
	* @param node the calling {@link PCompilationUnit} node
	*/
	public void outPCompilationUnit(PCompilationUnit node, Q question) throws AnalysisException
	{
		defaultOutINode(node, question);
	}


	/**
	* Called by the {@link AImportedModuleCompilationUnit} node from {@link AImportedModuleCompilationUnit#apply(IAnalysis)}.
	* @param node the calling {@link AImportedModuleCompilationUnit} node
	*/
	public void caseAImportedModuleCompilationUnit(AImportedModuleCompilationUnit node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAImportedModuleCompilationUnit(node, question);

		if(node.getModule() != null && !_visitedNodes.contains(node.getModule())) 
		{
			node.getModule().apply(this, question);
		}

		outAImportedModuleCompilationUnit(node, question);

	}


	/**
	* Called by the {@link AImportedModuleCompilationUnit} node from {@link AImportedModuleCompilationUnit#apply(IAnalysis)}.
	* @param node the calling {@link AImportedModuleCompilationUnit} node
	*/
	public void inAImportedModuleCompilationUnit(AImportedModuleCompilationUnit node, Q question) throws AnalysisException
	{
		defaultInPCompilationUnit(node, question);
	}


	/**
	* Called by the {@link AImportedModuleCompilationUnit} node from {@link AImportedModuleCompilationUnit#apply(IAnalysis)}.
	* @param node the calling {@link AImportedModuleCompilationUnit} node
	*/
	public void outAImportedModuleCompilationUnit(AImportedModuleCompilationUnit node, Q question) throws AnalysisException
	{
		defaultOutPCompilationUnit(node, question);
	}


	/**
	* Called by the {@link ASimulationSpecificationCompilationUnit} node from {@link ASimulationSpecificationCompilationUnit#apply(IAnalysis)}.
	* @param node the calling {@link ASimulationSpecificationCompilationUnit} node
	*/
	public void caseASimulationSpecificationCompilationUnit(ASimulationSpecificationCompilationUnit node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inASimulationSpecificationCompilationUnit(node, question);

		if(node.getBody() != null && !_visitedNodes.contains(node.getBody())) 
		{
			node.getBody().apply(this, question);
		}
		{
			List<AConfigFramework> copy = new ArrayList<AConfigFramework>(node.getFrameworkConfigs());
			for( AConfigFramework e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					e.apply(this, question);
				}
			}
		}

		outASimulationSpecificationCompilationUnit(node, question);

	}


	/**
	* Called by the {@link ASimulationSpecificationCompilationUnit} node from {@link ASimulationSpecificationCompilationUnit#apply(IAnalysis)}.
	* @param node the calling {@link ASimulationSpecificationCompilationUnit} node
	*/
	public void inASimulationSpecificationCompilationUnit(ASimulationSpecificationCompilationUnit node, Q question) throws AnalysisException
	{
		defaultInPCompilationUnit(node, question);
	}


	/**
	* Called by the {@link ASimulationSpecificationCompilationUnit} node from {@link ASimulationSpecificationCompilationUnit#apply(IAnalysis)}.
	* @param node the calling {@link ASimulationSpecificationCompilationUnit} node
	*/
	public void outASimulationSpecificationCompilationUnit(ASimulationSpecificationCompilationUnit node, Q question) throws AnalysisException
	{
		defaultOutPCompilationUnit(node, question);
	}


	/**
	* Called by the {@link PFramework} node from {@link PFramework#apply(IAnalysis)}.
	* @param node the calling {@link PFramework} node
	*/
	public void defaultInPFramework(PFramework node, Q question) throws AnalysisException
	{
		defaultInINode(node, question);
	}


	/**
	* Called by the {@link PFramework} node from {@link PFramework#apply(IAnalysis)}.
	* @param node the calling {@link PFramework} node
	*/
	public void defaultOutPFramework(PFramework node, Q question) throws AnalysisException
	{
		defaultOutINode(node, question);
	}


	/**
	* Called by the {@link PFramework} node from {@link PFramework#apply(IAnalysis)}.
	* @param node the calling {@link PFramework} node
	*/
	public void defaultPFramework(PFramework node, Q question) throws AnalysisException
	{
		defaultINode(node, question);
	}


	/**
	* Called by the {@link PFramework} node from {@link PFramework#apply(IAnalysis)}.
	* @param node the calling {@link PFramework} node
	*/
	public void inPFramework(PFramework node, Q question) throws AnalysisException
	{
		defaultInINode(node, question);
	}


	/**
	* Called by the {@link PFramework} node from {@link PFramework#apply(IAnalysis)}.
	* @param node the calling {@link PFramework} node
	*/
	public void outPFramework(PFramework node, Q question) throws AnalysisException
	{
		defaultOutINode(node, question);
	}


	/**
	* Called by the {@link AConfigFramework} node from {@link AConfigFramework#apply(IAnalysis)}.
	* @param node the calling {@link AConfigFramework} node
	*/
	public void caseAConfigFramework(AConfigFramework node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAConfigFramework(node, question);


		outAConfigFramework(node, question);

	}


	/**
	* Called by the {@link AConfigFramework} node from {@link AConfigFramework#apply(IAnalysis)}.
	* @param node the calling {@link AConfigFramework} node
	*/
	public void inAConfigFramework(AConfigFramework node, Q question) throws AnalysisException
	{
		defaultInPFramework(node, question);
	}


	/**
	* Called by the {@link AConfigFramework} node from {@link AConfigFramework#apply(IAnalysis)}.
	* @param node the calling {@link AConfigFramework} node
	*/
	public void outAConfigFramework(AConfigFramework node, Q question) throws AnalysisException
	{
		defaultOutPFramework(node, question);
	}


	/**
	* Called by the {@link PDeclaration} node from {@link PDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link PDeclaration} node
	*/
	public void defaultInPDeclaration(PDeclaration node, Q question) throws AnalysisException
	{
		defaultInINode(node, question);
	}


	/**
	* Called by the {@link PDeclaration} node from {@link PDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link PDeclaration} node
	*/
	public void defaultOutPDeclaration(PDeclaration node, Q question) throws AnalysisException
	{
		defaultOutINode(node, question);
	}


	/**
	* Called by the {@link PDeclaration} node from {@link PDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link PDeclaration} node
	*/
	public void defaultPDeclaration(PDeclaration node, Q question) throws AnalysisException
	{
		defaultINode(node, question);
	}


	/**
	* Called by the {@link PDeclaration} node from {@link PDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link PDeclaration} node
	*/
	public void inPDeclaration(PDeclaration node, Q question) throws AnalysisException
	{
		defaultInINode(node, question);
	}


	/**
	* Called by the {@link PDeclaration} node from {@link PDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link PDeclaration} node
	*/
	public void outPDeclaration(PDeclaration node, Q question) throws AnalysisException
	{
		defaultOutINode(node, question);
	}


	/**
	* Called by the {@link AFunctionDeclaration} node from {@link AFunctionDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link AFunctionDeclaration} node
	*/
	public void caseAFunctionDeclaration(AFunctionDeclaration node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAFunctionDeclaration(node, question);

		if(node.getReturnType() != null && !_visitedNodes.contains(node.getReturnType())) 
		{
			node.getReturnType().apply(this, question);
		}
		{
			List<AFormalParameter> copy = new ArrayList<AFormalParameter>(node.getFormals());
			for( AFormalParameter e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					e.apply(this, question);
				}
			}
		}

		outAFunctionDeclaration(node, question);

	}


	/**
	* Called by the {@link AFunctionDeclaration} node from {@link AFunctionDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link AFunctionDeclaration} node
	*/
	public void inAFunctionDeclaration(AFunctionDeclaration node, Q question) throws AnalysisException
	{
		defaultInPDeclaration(node, question);
	}


	/**
	* Called by the {@link AFunctionDeclaration} node from {@link AFunctionDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link AFunctionDeclaration} node
	*/
	public void outAFunctionDeclaration(AFunctionDeclaration node, Q question) throws AnalysisException
	{
		defaultOutPDeclaration(node, question);
	}


	/**
	* Called by the {@link AVariableDeclaration} node from {@link AVariableDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link AVariableDeclaration} node
	*/
	public void caseAVariableDeclaration(AVariableDeclaration node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAVariableDeclaration(node, question);

		if(node.getType() != null && !_visitedNodes.contains(node.getType())) 
		{
			node.getType().apply(this, question);
		}
		{
			List<PExp> copy = new ArrayList<PExp>(node.getSize());
			for( PExp e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					e.apply(this, question);
				}
			}
		}
		if(node.getInitializer() != null && !_visitedNodes.contains(node.getInitializer())) 
		{
			node.getInitializer().apply(this, question);
		}

		outAVariableDeclaration(node, question);

	}


	/**
	* Called by the {@link AVariableDeclaration} node from {@link AVariableDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link AVariableDeclaration} node
	*/
	public void inAVariableDeclaration(AVariableDeclaration node, Q question) throws AnalysisException
	{
		defaultInPDeclaration(node, question);
	}


	/**
	* Called by the {@link AVariableDeclaration} node from {@link AVariableDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link AVariableDeclaration} node
	*/
	public void outAVariableDeclaration(AVariableDeclaration node, Q question) throws AnalysisException
	{
		defaultOutPDeclaration(node, question);
	}


	/**
	* Called by the {@link AModuleDeclaration} node from {@link AModuleDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link AModuleDeclaration} node
	*/
	public void caseAModuleDeclaration(AModuleDeclaration node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAModuleDeclaration(node, question);

		{
			List<AFunctionDeclaration> copy = new ArrayList<AFunctionDeclaration>(node.getFunctions());
			for( AFunctionDeclaration e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					e.apply(this, question);
				}
			}
		}

		outAModuleDeclaration(node, question);

	}


	/**
	* Called by the {@link AModuleDeclaration} node from {@link AModuleDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link AModuleDeclaration} node
	*/
	public void inAModuleDeclaration(AModuleDeclaration node, Q question) throws AnalysisException
	{
		defaultInPDeclaration(node, question);
	}


	/**
	* Called by the {@link AModuleDeclaration} node from {@link AModuleDeclaration#apply(IAnalysis)}.
	* @param node the calling {@link AModuleDeclaration} node
	*/
	public void outAModuleDeclaration(AModuleDeclaration node, Q question) throws AnalysisException
	{
		defaultOutPDeclaration(node, question);
	}


	/**
	* Called by the {@link PInitializer} node from {@link PInitializer#apply(IAnalysis)}.
	* @param node the calling {@link PInitializer} node
	*/
	public void defaultInPInitializer(PInitializer node, Q question) throws AnalysisException
	{
		defaultInINode(node, question);
	}


	/**
	* Called by the {@link PInitializer} node from {@link PInitializer#apply(IAnalysis)}.
	* @param node the calling {@link PInitializer} node
	*/
	public void defaultOutPInitializer(PInitializer node, Q question) throws AnalysisException
	{
		defaultOutINode(node, question);
	}


	/**
	* Called by the {@link PInitializer} node from {@link PInitializer#apply(IAnalysis)}.
	* @param node the calling {@link PInitializer} node
	*/
	public void defaultPInitializer(PInitializer node, Q question) throws AnalysisException
	{
		defaultINode(node, question);
	}


	/**
	* Called by the {@link PInitializer} node from {@link PInitializer#apply(IAnalysis)}.
	* @param node the calling {@link PInitializer} node
	*/
	public void inPInitializer(PInitializer node, Q question) throws AnalysisException
	{
		defaultInINode(node, question);
	}


	/**
	* Called by the {@link PInitializer} node from {@link PInitializer#apply(IAnalysis)}.
	* @param node the calling {@link PInitializer} node
	*/
	public void outPInitializer(PInitializer node, Q question) throws AnalysisException
	{
		defaultOutINode(node, question);
	}


	/**
	* Called by the {@link AExpInitializer} node from {@link AExpInitializer#apply(IAnalysis)}.
	* @param node the calling {@link AExpInitializer} node
	*/
	public void caseAExpInitializer(AExpInitializer node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAExpInitializer(node, question);

		if(node.getExp() != null && !_visitedNodes.contains(node.getExp())) 
		{
			node.getExp().apply(this, question);
		}

		outAExpInitializer(node, question);

	}


	/**
	* Called by the {@link AExpInitializer} node from {@link AExpInitializer#apply(IAnalysis)}.
	* @param node the calling {@link AExpInitializer} node
	*/
	public void inAExpInitializer(AExpInitializer node, Q question) throws AnalysisException
	{
		defaultInPInitializer(node, question);
	}


	/**
	* Called by the {@link AExpInitializer} node from {@link AExpInitializer#apply(IAnalysis)}.
	* @param node the calling {@link AExpInitializer} node
	*/
	public void outAExpInitializer(AExpInitializer node, Q question) throws AnalysisException
	{
		defaultOutPInitializer(node, question);
	}


	/**
	* Called by the {@link AArrayInitializer} node from {@link AArrayInitializer#apply(IAnalysis)}.
	* @param node the calling {@link AArrayInitializer} node
	*/
	public void caseAArrayInitializer(AArrayInitializer node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAArrayInitializer(node, question);

		{
			List<PExp> copy = new ArrayList<PExp>(node.getExp());
			for( PExp e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					e.apply(this, question);
				}
			}
		}

		outAArrayInitializer(node, question);

	}


	/**
	* Called by the {@link AArrayInitializer} node from {@link AArrayInitializer#apply(IAnalysis)}.
	* @param node the calling {@link AArrayInitializer} node
	*/
	public void inAArrayInitializer(AArrayInitializer node, Q question) throws AnalysisException
	{
		defaultInPInitializer(node, question);
	}


	/**
	* Called by the {@link AArrayInitializer} node from {@link AArrayInitializer#apply(IAnalysis)}.
	* @param node the calling {@link AArrayInitializer} node
	*/
	public void outAArrayInitializer(AArrayInitializer node, Q question) throws AnalysisException
	{
		defaultOutPInitializer(node, question);
	}


	/**
	* Called by the {@link PParameter} node from {@link PParameter#apply(IAnalysis)}.
	* @param node the calling {@link PParameter} node
	*/
	public void defaultInPParameter(PParameter node, Q question) throws AnalysisException
	{
		defaultInINode(node, question);
	}


	/**
	* Called by the {@link PParameter} node from {@link PParameter#apply(IAnalysis)}.
	* @param node the calling {@link PParameter} node
	*/
	public void defaultOutPParameter(PParameter node, Q question) throws AnalysisException
	{
		defaultOutINode(node, question);
	}


	/**
	* Called by the {@link PParameter} node from {@link PParameter#apply(IAnalysis)}.
	* @param node the calling {@link PParameter} node
	*/
	public void defaultPParameter(PParameter node, Q question) throws AnalysisException
	{
		defaultINode(node, question);
	}


	/**
	* Called by the {@link PParameter} node from {@link PParameter#apply(IAnalysis)}.
	* @param node the calling {@link PParameter} node
	*/
	public void inPParameter(PParameter node, Q question) throws AnalysisException
	{
		defaultInINode(node, question);
	}


	/**
	* Called by the {@link PParameter} node from {@link PParameter#apply(IAnalysis)}.
	* @param node the calling {@link PParameter} node
	*/
	public void outPParameter(PParameter node, Q question) throws AnalysisException
	{
		defaultOutINode(node, question);
	}


	/**
	* Called by the {@link AFormalParameter} node from {@link AFormalParameter#apply(IAnalysis)}.
	* @param node the calling {@link AFormalParameter} node
	*/
	public void caseAFormalParameter(AFormalParameter node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAFormalParameter(node, question);

		if(node.getType() != null && !_visitedNodes.contains(node.getType())) 
		{
			node.getType().apply(this, question);
		}

		outAFormalParameter(node, question);

	}


	/**
	* Called by the {@link AFormalParameter} node from {@link AFormalParameter#apply(IAnalysis)}.
	* @param node the calling {@link AFormalParameter} node
	*/
	public void inAFormalParameter(AFormalParameter node, Q question) throws AnalysisException
	{
		defaultInPParameter(node, question);
	}


	/**
	* Called by the {@link AFormalParameter} node from {@link AFormalParameter#apply(IAnalysis)}.
	* @param node the calling {@link AFormalParameter} node
	*/
	public void outAFormalParameter(AFormalParameter node, Q question) throws AnalysisException
	{
		defaultOutPParameter(node, question);
	}


	/**
	* Called by the {@link PExp} node from {@link PExp#apply(IAnalysis)}.
	* @param node the calling {@link PExp} node
	*/
	public void defaultInPExp(PExp node, Q question) throws AnalysisException
	{
		defaultInINode(node, question);
	}


	/**
	* Called by the {@link PExp} node from {@link PExp#apply(IAnalysis)}.
	* @param node the calling {@link PExp} node
	*/
	public void defaultOutPExp(PExp node, Q question) throws AnalysisException
	{
		defaultOutINode(node, question);
	}


	/**
	* Called by the {@link PExp} node from {@link PExp#apply(IAnalysis)}.
	* @param node the calling {@link PExp} node
	*/
	public void defaultPExp(PExp node, Q question) throws AnalysisException
	{
		defaultINode(node, question);
	}


	/**
	* Called by the {@link PExp} node from {@link PExp#apply(IAnalysis)}.
	* @param node the calling {@link PExp} node
	*/
	public void inPExp(PExp node, Q question) throws AnalysisException
	{
		defaultInINode(node, question);
	}


	/**
	* Called by the {@link PExp} node from {@link PExp#apply(IAnalysis)}.
	* @param node the calling {@link PExp} node
	*/
	public void outPExp(PExp node, Q question) throws AnalysisException
	{
		defaultOutINode(node, question);
	}


	/**
	* Called by the {@link AIdentifierExp} node from {@link AIdentifierExp#apply(IAnalysis)}.
	* @param node the calling {@link AIdentifierExp} node
	*/
	public void caseAIdentifierExp(AIdentifierExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAIdentifierExp(node, question);


		outAIdentifierExp(node, question);

	}


	/**
	* Called by the {@link AIdentifierExp} node from {@link AIdentifierExp#apply(IAnalysis)}.
	* @param node the calling {@link AIdentifierExp} node
	*/
	public void inAIdentifierExp(AIdentifierExp node, Q question) throws AnalysisException
	{
		defaultInPExp(node, question);
	}


	/**
	* Called by the {@link AIdentifierExp} node from {@link AIdentifierExp#apply(IAnalysis)}.
	* @param node the calling {@link AIdentifierExp} node
	*/
	public void outAIdentifierExp(AIdentifierExp node, Q question) throws AnalysisException
	{
		defaultOutPExp(node, question);
	}


	/**
	* Called by the {@link SLiteralExp} node from {@link SLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link SLiteralExp} node
	*/
	public void defaultInSLiteralExp(SLiteralExp node, Q question) throws AnalysisException
	{
		defaultInPExp(node, question);
	}


	/**
	* Called by the {@link SLiteralExp} node from {@link SLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link SLiteralExp} node
	*/
	public void defaultOutSLiteralExp(SLiteralExp node, Q question) throws AnalysisException
	{
		defaultOutPExp(node, question);
	}


	/**
	* Called by the {@link SLiteralExp} node from {@link SLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link SLiteralExp} node
	*/
	public void defaultSLiteralExp(SLiteralExp node, Q question) throws AnalysisException
	{
		defaultPExp(node, question);
	}


	/**
	* Called by the {@link SLiteralExp} node from {@link SLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link SLiteralExp} node
	*/
	public void inSLiteralExp(SLiteralExp node, Q question) throws AnalysisException
	{
		defaultInPExp(node, question);
	}


	/**
	* Called by the {@link SLiteralExp} node from {@link SLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link SLiteralExp} node
	*/
	public void outSLiteralExp(SLiteralExp node, Q question) throws AnalysisException
	{
		defaultOutPExp(node, question);
	}


	/**
	* Called by the {@link ALoadExp} node from {@link ALoadExp#apply(IAnalysis)}.
	* @param node the calling {@link ALoadExp} node
	*/
	public void caseALoadExp(ALoadExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inALoadExp(node, question);

		{
			List<PExp> copy = new ArrayList<PExp>(node.getArgs());
			for( PExp e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					e.apply(this, question);
				}
			}
		}

		outALoadExp(node, question);

	}


	/**
	* Called by the {@link ALoadExp} node from {@link ALoadExp#apply(IAnalysis)}.
	* @param node the calling {@link ALoadExp} node
	*/
	public void inALoadExp(ALoadExp node, Q question) throws AnalysisException
	{
		defaultInPExp(node, question);
	}


	/**
	* Called by the {@link ALoadExp} node from {@link ALoadExp#apply(IAnalysis)}.
	* @param node the calling {@link ALoadExp} node
	*/
	public void outALoadExp(ALoadExp node, Q question) throws AnalysisException
	{
		defaultOutPExp(node, question);
	}


	/**
	* Called by the {@link AUnloadExp} node from {@link AUnloadExp#apply(IAnalysis)}.
	* @param node the calling {@link AUnloadExp} node
	*/
	public void caseAUnloadExp(AUnloadExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAUnloadExp(node, question);

		{
			List<PExp> copy = new ArrayList<PExp>(node.getArgs());
			for( PExp e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					e.apply(this, question);
				}
			}
		}

		outAUnloadExp(node, question);

	}


	/**
	* Called by the {@link AUnloadExp} node from {@link AUnloadExp#apply(IAnalysis)}.
	* @param node the calling {@link AUnloadExp} node
	*/
	public void inAUnloadExp(AUnloadExp node, Q question) throws AnalysisException
	{
		defaultInPExp(node, question);
	}


	/**
	* Called by the {@link AUnloadExp} node from {@link AUnloadExp#apply(IAnalysis)}.
	* @param node the calling {@link AUnloadExp} node
	*/
	public void outAUnloadExp(AUnloadExp node, Q question) throws AnalysisException
	{
		defaultOutPExp(node, question);
	}


	/**
	* Called by the {@link SBinaryExp} node from {@link SBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link SBinaryExp} node
	*/
	public void defaultInSBinaryExp(SBinaryExp node, Q question) throws AnalysisException
	{
		defaultInPExp(node, question);
	}


	/**
	* Called by the {@link SBinaryExp} node from {@link SBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link SBinaryExp} node
	*/
	public void defaultOutSBinaryExp(SBinaryExp node, Q question) throws AnalysisException
	{
		defaultOutPExp(node, question);
	}


	/**
	* Called by the {@link SBinaryExp} node from {@link SBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link SBinaryExp} node
	*/
	public void defaultSBinaryExp(SBinaryExp node, Q question) throws AnalysisException
	{
		defaultPExp(node, question);
	}


	/**
	* Called by the {@link SBinaryExp} node from {@link SBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link SBinaryExp} node
	*/
	public void inSBinaryExp(SBinaryExp node, Q question) throws AnalysisException
	{
		defaultInPExp(node, question);
	}


	/**
	* Called by the {@link SBinaryExp} node from {@link SBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link SBinaryExp} node
	*/
	public void outSBinaryExp(SBinaryExp node, Q question) throws AnalysisException
	{
		defaultOutPExp(node, question);
	}


	/**
	* Called by the {@link SUnaryExp} node from {@link SUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link SUnaryExp} node
	*/
	public void defaultInSUnaryExp(SUnaryExp node, Q question) throws AnalysisException
	{
		defaultInPExp(node, question);
	}


	/**
	* Called by the {@link SUnaryExp} node from {@link SUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link SUnaryExp} node
	*/
	public void defaultOutSUnaryExp(SUnaryExp node, Q question) throws AnalysisException
	{
		defaultOutPExp(node, question);
	}


	/**
	* Called by the {@link SUnaryExp} node from {@link SUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link SUnaryExp} node
	*/
	public void defaultSUnaryExp(SUnaryExp node, Q question) throws AnalysisException
	{
		defaultPExp(node, question);
	}


	/**
	* Called by the {@link SUnaryExp} node from {@link SUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link SUnaryExp} node
	*/
	public void inSUnaryExp(SUnaryExp node, Q question) throws AnalysisException
	{
		defaultInPExp(node, question);
	}


	/**
	* Called by the {@link SUnaryExp} node from {@link SUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link SUnaryExp} node
	*/
	public void outSUnaryExp(SUnaryExp node, Q question) throws AnalysisException
	{
		defaultOutPExp(node, question);
	}


	/**
	* Called by the {@link AFieldExp} node from {@link AFieldExp#apply(IAnalysis)}.
	* @param node the calling {@link AFieldExp} node
	*/
	public void caseAFieldExp(AFieldExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAFieldExp(node, question);

		if(node.getRoot() != null && !_visitedNodes.contains(node.getRoot())) 
		{
			node.getRoot().apply(this, question);
		}

		outAFieldExp(node, question);

	}


	/**
	* Called by the {@link AFieldExp} node from {@link AFieldExp#apply(IAnalysis)}.
	* @param node the calling {@link AFieldExp} node
	*/
	public void inAFieldExp(AFieldExp node, Q question) throws AnalysisException
	{
		defaultInPExp(node, question);
	}


	/**
	* Called by the {@link AFieldExp} node from {@link AFieldExp#apply(IAnalysis)}.
	* @param node the calling {@link AFieldExp} node
	*/
	public void outAFieldExp(AFieldExp node, Q question) throws AnalysisException
	{
		defaultOutPExp(node, question);
	}


	/**
	* Called by the {@link ACallExp} node from {@link ACallExp#apply(IAnalysis)}.
	* @param node the calling {@link ACallExp} node
	*/
	public void caseACallExp(ACallExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inACallExp(node, question);

		if(node.getObject() != null && !_visitedNodes.contains(node.getObject())) 
		{
			node.getObject().apply(this, question);
		}
		if(node.getExpand() != null ) 
		{
			node.getExpand().apply(this, question);
		}
		{
			List<PExp> copy = new ArrayList<PExp>(node.getArgs());
			for( PExp e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					e.apply(this, question);
				}
			}
		}

		outACallExp(node, question);

	}


	/**
	* Called by the {@link ACallExp} node from {@link ACallExp#apply(IAnalysis)}.
	* @param node the calling {@link ACallExp} node
	*/
	public void inACallExp(ACallExp node, Q question) throws AnalysisException
	{
		defaultInPExp(node, question);
	}


	/**
	* Called by the {@link ACallExp} node from {@link ACallExp#apply(IAnalysis)}.
	* @param node the calling {@link ACallExp} node
	*/
	public void outACallExp(ACallExp node, Q question) throws AnalysisException
	{
		defaultOutPExp(node, question);
	}


	/**
	* Called by the {@link AArrayIndexExp} node from {@link AArrayIndexExp#apply(IAnalysis)}.
	* @param node the calling {@link AArrayIndexExp} node
	*/
	public void caseAArrayIndexExp(AArrayIndexExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAArrayIndexExp(node, question);

		if(node.getArray() != null && !_visitedNodes.contains(node.getArray())) 
		{
			node.getArray().apply(this, question);
		}
		{
			List<PExp> copy = new ArrayList<PExp>(node.getIndices());
			for( PExp e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					e.apply(this, question);
				}
			}
		}

		outAArrayIndexExp(node, question);

	}


	/**
	* Called by the {@link AArrayIndexExp} node from {@link AArrayIndexExp#apply(IAnalysis)}.
	* @param node the calling {@link AArrayIndexExp} node
	*/
	public void inAArrayIndexExp(AArrayIndexExp node, Q question) throws AnalysisException
	{
		defaultInPExp(node, question);
	}


	/**
	* Called by the {@link AArrayIndexExp} node from {@link AArrayIndexExp#apply(IAnalysis)}.
	* @param node the calling {@link AArrayIndexExp} node
	*/
	public void outAArrayIndexExp(AArrayIndexExp node, Q question) throws AnalysisException
	{
		defaultOutPExp(node, question);
	}


	/**
	* Called by the {@link AParExp} node from {@link AParExp#apply(IAnalysis)}.
	* @param node the calling {@link AParExp} node
	*/
	public void caseAParExp(AParExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAParExp(node, question);

		if(node.getExp() != null && !_visitedNodes.contains(node.getExp())) 
		{
			node.getExp().apply(this, question);
		}

		outAParExp(node, question);

	}


	/**
	* Called by the {@link AParExp} node from {@link AParExp#apply(IAnalysis)}.
	* @param node the calling {@link AParExp} node
	*/
	public void inAParExp(AParExp node, Q question) throws AnalysisException
	{
		defaultInPExp(node, question);
	}


	/**
	* Called by the {@link AParExp} node from {@link AParExp#apply(IAnalysis)}.
	* @param node the calling {@link AParExp} node
	*/
	public void outAParExp(AParExp node, Q question) throws AnalysisException
	{
		defaultOutPExp(node, question);
	}


	/**
	* Called by the {@link ANullExp} node from {@link ANullExp#apply(IAnalysis)}.
	* @param node the calling {@link ANullExp} node
	*/
	public void caseANullExp(ANullExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inANullExp(node, question);

		if(node.getToken() != null ) 
		{
			node.getToken().apply(this, question);
		}

		outANullExp(node, question);

	}


	/**
	* Called by the {@link ANullExp} node from {@link ANullExp#apply(IAnalysis)}.
	* @param node the calling {@link ANullExp} node
	*/
	public void inANullExp(ANullExp node, Q question) throws AnalysisException
	{
		defaultInPExp(node, question);
	}


	/**
	* Called by the {@link ANullExp} node from {@link ANullExp#apply(IAnalysis)}.
	* @param node the calling {@link ANullExp} node
	*/
	public void outANullExp(ANullExp node, Q question) throws AnalysisException
	{
		defaultOutPExp(node, question);
	}


	/**
	* Called by the {@link ARefExp} node from {@link ARefExp#apply(IAnalysis)}.
	* @param node the calling {@link ARefExp} node
	*/
	public void caseARefExp(ARefExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inARefExp(node, question);

		if(node.getExp() != null && !_visitedNodes.contains(node.getExp())) 
		{
			node.getExp().apply(this, question);
		}

		outARefExp(node, question);

	}


	/**
	* Called by the {@link ARefExp} node from {@link ARefExp#apply(IAnalysis)}.
	* @param node the calling {@link ARefExp} node
	*/
	public void inARefExp(ARefExp node, Q question) throws AnalysisException
	{
		defaultInPExp(node, question);
	}


	/**
	* Called by the {@link ARefExp} node from {@link ARefExp#apply(IAnalysis)}.
	* @param node the calling {@link ARefExp} node
	*/
	public void outARefExp(ARefExp node, Q question) throws AnalysisException
	{
		defaultOutPExp(node, question);
	}


	/**
	* Called by the {@link AStringLiteralExp} node from {@link AStringLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link AStringLiteralExp} node
	*/
	public void caseAStringLiteralExp(AStringLiteralExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAStringLiteralExp(node, question);


		outAStringLiteralExp(node, question);

	}


	/**
	* Called by the {@link AStringLiteralExp} node from {@link AStringLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link AStringLiteralExp} node
	*/
	public void inAStringLiteralExp(AStringLiteralExp node, Q question) throws AnalysisException
	{
		defaultInSLiteralExp(node, question);
	}


	/**
	* Called by the {@link AStringLiteralExp} node from {@link AStringLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link AStringLiteralExp} node
	*/
	public void outAStringLiteralExp(AStringLiteralExp node, Q question) throws AnalysisException
	{
		defaultOutSLiteralExp(node, question);
	}


	/**
	* Called by the {@link ABoolLiteralExp} node from {@link ABoolLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link ABoolLiteralExp} node
	*/
	public void caseABoolLiteralExp(ABoolLiteralExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inABoolLiteralExp(node, question);


		outABoolLiteralExp(node, question);

	}


	/**
	* Called by the {@link ABoolLiteralExp} node from {@link ABoolLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link ABoolLiteralExp} node
	*/
	public void inABoolLiteralExp(ABoolLiteralExp node, Q question) throws AnalysisException
	{
		defaultInSLiteralExp(node, question);
	}


	/**
	* Called by the {@link ABoolLiteralExp} node from {@link ABoolLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link ABoolLiteralExp} node
	*/
	public void outABoolLiteralExp(ABoolLiteralExp node, Q question) throws AnalysisException
	{
		defaultOutSLiteralExp(node, question);
	}


	/**
	* Called by the {@link AIntLiteralExp} node from {@link AIntLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link AIntLiteralExp} node
	*/
	public void caseAIntLiteralExp(AIntLiteralExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAIntLiteralExp(node, question);


		outAIntLiteralExp(node, question);

	}


	/**
	* Called by the {@link AIntLiteralExp} node from {@link AIntLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link AIntLiteralExp} node
	*/
	public void inAIntLiteralExp(AIntLiteralExp node, Q question) throws AnalysisException
	{
		defaultInSLiteralExp(node, question);
	}


	/**
	* Called by the {@link AIntLiteralExp} node from {@link AIntLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link AIntLiteralExp} node
	*/
	public void outAIntLiteralExp(AIntLiteralExp node, Q question) throws AnalysisException
	{
		defaultOutSLiteralExp(node, question);
	}


	/**
	* Called by the {@link AUIntLiteralExp} node from {@link AUIntLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link AUIntLiteralExp} node
	*/
	public void caseAUIntLiteralExp(AUIntLiteralExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAUIntLiteralExp(node, question);


		outAUIntLiteralExp(node, question);

	}


	/**
	* Called by the {@link AUIntLiteralExp} node from {@link AUIntLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link AUIntLiteralExp} node
	*/
	public void inAUIntLiteralExp(AUIntLiteralExp node, Q question) throws AnalysisException
	{
		defaultInSLiteralExp(node, question);
	}


	/**
	* Called by the {@link AUIntLiteralExp} node from {@link AUIntLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link AUIntLiteralExp} node
	*/
	public void outAUIntLiteralExp(AUIntLiteralExp node, Q question) throws AnalysisException
	{
		defaultOutSLiteralExp(node, question);
	}


	/**
	* Called by the {@link ARealLiteralExp} node from {@link ARealLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link ARealLiteralExp} node
	*/
	public void caseARealLiteralExp(ARealLiteralExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inARealLiteralExp(node, question);


		outARealLiteralExp(node, question);

	}


	/**
	* Called by the {@link ARealLiteralExp} node from {@link ARealLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link ARealLiteralExp} node
	*/
	public void inARealLiteralExp(ARealLiteralExp node, Q question) throws AnalysisException
	{
		defaultInSLiteralExp(node, question);
	}


	/**
	* Called by the {@link ARealLiteralExp} node from {@link ARealLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link ARealLiteralExp} node
	*/
	public void outARealLiteralExp(ARealLiteralExp node, Q question) throws AnalysisException
	{
		defaultOutSLiteralExp(node, question);
	}


	/**
	* Called by the {@link ALongLiteralExp} node from {@link ALongLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link ALongLiteralExp} node
	*/
	public void caseALongLiteralExp(ALongLiteralExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inALongLiteralExp(node, question);


		outALongLiteralExp(node, question);

	}


	/**
	* Called by the {@link ALongLiteralExp} node from {@link ALongLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link ALongLiteralExp} node
	*/
	public void inALongLiteralExp(ALongLiteralExp node, Q question) throws AnalysisException
	{
		defaultInSLiteralExp(node, question);
	}


	/**
	* Called by the {@link ALongLiteralExp} node from {@link ALongLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link ALongLiteralExp} node
	*/
	public void outALongLiteralExp(ALongLiteralExp node, Q question) throws AnalysisException
	{
		defaultOutSLiteralExp(node, question);
	}


	/**
	* Called by the {@link AFloatLiteralExp} node from {@link AFloatLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link AFloatLiteralExp} node
	*/
	public void caseAFloatLiteralExp(AFloatLiteralExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAFloatLiteralExp(node, question);


		outAFloatLiteralExp(node, question);

	}


	/**
	* Called by the {@link AFloatLiteralExp} node from {@link AFloatLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link AFloatLiteralExp} node
	*/
	public void inAFloatLiteralExp(AFloatLiteralExp node, Q question) throws AnalysisException
	{
		defaultInSLiteralExp(node, question);
	}


	/**
	* Called by the {@link AFloatLiteralExp} node from {@link AFloatLiteralExp#apply(IAnalysis)}.
	* @param node the calling {@link AFloatLiteralExp} node
	*/
	public void outAFloatLiteralExp(AFloatLiteralExp node, Q question) throws AnalysisException
	{
		defaultOutSLiteralExp(node, question);
	}


	/**
	* Called by the {@link APlusBinaryExp} node from {@link APlusBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link APlusBinaryExp} node
	*/
	public void caseAPlusBinaryExp(APlusBinaryExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAPlusBinaryExp(node, question);

		if(node.getLeft() != null && !_visitedNodes.contains(node.getLeft())) 
		{
			node.getLeft().apply(this, question);
		}
		if(node.getRight() != null && !_visitedNodes.contains(node.getRight())) 
		{
			node.getRight().apply(this, question);
		}

		outAPlusBinaryExp(node, question);

	}


	/**
	* Called by the {@link APlusBinaryExp} node from {@link APlusBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link APlusBinaryExp} node
	*/
	public void inAPlusBinaryExp(APlusBinaryExp node, Q question) throws AnalysisException
	{
		defaultInSBinaryExp(node, question);
	}


	/**
	* Called by the {@link APlusBinaryExp} node from {@link APlusBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link APlusBinaryExp} node
	*/
	public void outAPlusBinaryExp(APlusBinaryExp node, Q question) throws AnalysisException
	{
		defaultOutSBinaryExp(node, question);
	}


	/**
	* Called by the {@link AMinusBinaryExp} node from {@link AMinusBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AMinusBinaryExp} node
	*/
	public void caseAMinusBinaryExp(AMinusBinaryExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAMinusBinaryExp(node, question);

		if(node.getLeft() != null && !_visitedNodes.contains(node.getLeft())) 
		{
			node.getLeft().apply(this, question);
		}
		if(node.getRight() != null && !_visitedNodes.contains(node.getRight())) 
		{
			node.getRight().apply(this, question);
		}

		outAMinusBinaryExp(node, question);

	}


	/**
	* Called by the {@link AMinusBinaryExp} node from {@link AMinusBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AMinusBinaryExp} node
	*/
	public void inAMinusBinaryExp(AMinusBinaryExp node, Q question) throws AnalysisException
	{
		defaultInSBinaryExp(node, question);
	}


	/**
	* Called by the {@link AMinusBinaryExp} node from {@link AMinusBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AMinusBinaryExp} node
	*/
	public void outAMinusBinaryExp(AMinusBinaryExp node, Q question) throws AnalysisException
	{
		defaultOutSBinaryExp(node, question);
	}


	/**
	* Called by the {@link ALessEqualBinaryExp} node from {@link ALessEqualBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ALessEqualBinaryExp} node
	*/
	public void caseALessEqualBinaryExp(ALessEqualBinaryExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inALessEqualBinaryExp(node, question);

		if(node.getLeft() != null && !_visitedNodes.contains(node.getLeft())) 
		{
			node.getLeft().apply(this, question);
		}
		if(node.getRight() != null && !_visitedNodes.contains(node.getRight())) 
		{
			node.getRight().apply(this, question);
		}

		outALessEqualBinaryExp(node, question);

	}


	/**
	* Called by the {@link ALessEqualBinaryExp} node from {@link ALessEqualBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ALessEqualBinaryExp} node
	*/
	public void inALessEqualBinaryExp(ALessEqualBinaryExp node, Q question) throws AnalysisException
	{
		defaultInSBinaryExp(node, question);
	}


	/**
	* Called by the {@link ALessEqualBinaryExp} node from {@link ALessEqualBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ALessEqualBinaryExp} node
	*/
	public void outALessEqualBinaryExp(ALessEqualBinaryExp node, Q question) throws AnalysisException
	{
		defaultOutSBinaryExp(node, question);
	}


	/**
	* Called by the {@link AGreaterEqualBinaryExp} node from {@link AGreaterEqualBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AGreaterEqualBinaryExp} node
	*/
	public void caseAGreaterEqualBinaryExp(AGreaterEqualBinaryExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAGreaterEqualBinaryExp(node, question);

		if(node.getLeft() != null && !_visitedNodes.contains(node.getLeft())) 
		{
			node.getLeft().apply(this, question);
		}
		if(node.getRight() != null && !_visitedNodes.contains(node.getRight())) 
		{
			node.getRight().apply(this, question);
		}

		outAGreaterEqualBinaryExp(node, question);

	}


	/**
	* Called by the {@link AGreaterEqualBinaryExp} node from {@link AGreaterEqualBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AGreaterEqualBinaryExp} node
	*/
	public void inAGreaterEqualBinaryExp(AGreaterEqualBinaryExp node, Q question) throws AnalysisException
	{
		defaultInSBinaryExp(node, question);
	}


	/**
	* Called by the {@link AGreaterEqualBinaryExp} node from {@link AGreaterEqualBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AGreaterEqualBinaryExp} node
	*/
	public void outAGreaterEqualBinaryExp(AGreaterEqualBinaryExp node, Q question) throws AnalysisException
	{
		defaultOutSBinaryExp(node, question);
	}


	/**
	* Called by the {@link ALessBinaryExp} node from {@link ALessBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ALessBinaryExp} node
	*/
	public void caseALessBinaryExp(ALessBinaryExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inALessBinaryExp(node, question);

		if(node.getLeft() != null && !_visitedNodes.contains(node.getLeft())) 
		{
			node.getLeft().apply(this, question);
		}
		if(node.getRight() != null && !_visitedNodes.contains(node.getRight())) 
		{
			node.getRight().apply(this, question);
		}

		outALessBinaryExp(node, question);

	}


	/**
	* Called by the {@link ALessBinaryExp} node from {@link ALessBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ALessBinaryExp} node
	*/
	public void inALessBinaryExp(ALessBinaryExp node, Q question) throws AnalysisException
	{
		defaultInSBinaryExp(node, question);
	}


	/**
	* Called by the {@link ALessBinaryExp} node from {@link ALessBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ALessBinaryExp} node
	*/
	public void outALessBinaryExp(ALessBinaryExp node, Q question) throws AnalysisException
	{
		defaultOutSBinaryExp(node, question);
	}


	/**
	* Called by the {@link AGreaterBinaryExp} node from {@link AGreaterBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AGreaterBinaryExp} node
	*/
	public void caseAGreaterBinaryExp(AGreaterBinaryExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAGreaterBinaryExp(node, question);

		if(node.getLeft() != null && !_visitedNodes.contains(node.getLeft())) 
		{
			node.getLeft().apply(this, question);
		}
		if(node.getRight() != null && !_visitedNodes.contains(node.getRight())) 
		{
			node.getRight().apply(this, question);
		}

		outAGreaterBinaryExp(node, question);

	}


	/**
	* Called by the {@link AGreaterBinaryExp} node from {@link AGreaterBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AGreaterBinaryExp} node
	*/
	public void inAGreaterBinaryExp(AGreaterBinaryExp node, Q question) throws AnalysisException
	{
		defaultInSBinaryExp(node, question);
	}


	/**
	* Called by the {@link AGreaterBinaryExp} node from {@link AGreaterBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AGreaterBinaryExp} node
	*/
	public void outAGreaterBinaryExp(AGreaterBinaryExp node, Q question) throws AnalysisException
	{
		defaultOutSBinaryExp(node, question);
	}


	/**
	* Called by the {@link AEqualBinaryExp} node from {@link AEqualBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AEqualBinaryExp} node
	*/
	public void caseAEqualBinaryExp(AEqualBinaryExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAEqualBinaryExp(node, question);

		if(node.getLeft() != null && !_visitedNodes.contains(node.getLeft())) 
		{
			node.getLeft().apply(this, question);
		}
		if(node.getRight() != null && !_visitedNodes.contains(node.getRight())) 
		{
			node.getRight().apply(this, question);
		}

		outAEqualBinaryExp(node, question);

	}


	/**
	* Called by the {@link AEqualBinaryExp} node from {@link AEqualBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AEqualBinaryExp} node
	*/
	public void inAEqualBinaryExp(AEqualBinaryExp node, Q question) throws AnalysisException
	{
		defaultInSBinaryExp(node, question);
	}


	/**
	* Called by the {@link AEqualBinaryExp} node from {@link AEqualBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AEqualBinaryExp} node
	*/
	public void outAEqualBinaryExp(AEqualBinaryExp node, Q question) throws AnalysisException
	{
		defaultOutSBinaryExp(node, question);
	}


	/**
	* Called by the {@link ANotEqualBinaryExp} node from {@link ANotEqualBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ANotEqualBinaryExp} node
	*/
	public void caseANotEqualBinaryExp(ANotEqualBinaryExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inANotEqualBinaryExp(node, question);

		if(node.getLeft() != null && !_visitedNodes.contains(node.getLeft())) 
		{
			node.getLeft().apply(this, question);
		}
		if(node.getRight() != null && !_visitedNodes.contains(node.getRight())) 
		{
			node.getRight().apply(this, question);
		}

		outANotEqualBinaryExp(node, question);

	}


	/**
	* Called by the {@link ANotEqualBinaryExp} node from {@link ANotEqualBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ANotEqualBinaryExp} node
	*/
	public void inANotEqualBinaryExp(ANotEqualBinaryExp node, Q question) throws AnalysisException
	{
		defaultInSBinaryExp(node, question);
	}


	/**
	* Called by the {@link ANotEqualBinaryExp} node from {@link ANotEqualBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ANotEqualBinaryExp} node
	*/
	public void outANotEqualBinaryExp(ANotEqualBinaryExp node, Q question) throws AnalysisException
	{
		defaultOutSBinaryExp(node, question);
	}


	/**
	* Called by the {@link AOrBinaryExp} node from {@link AOrBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AOrBinaryExp} node
	*/
	public void caseAOrBinaryExp(AOrBinaryExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAOrBinaryExp(node, question);

		if(node.getLeft() != null && !_visitedNodes.contains(node.getLeft())) 
		{
			node.getLeft().apply(this, question);
		}
		if(node.getRight() != null && !_visitedNodes.contains(node.getRight())) 
		{
			node.getRight().apply(this, question);
		}

		outAOrBinaryExp(node, question);

	}


	/**
	* Called by the {@link AOrBinaryExp} node from {@link AOrBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AOrBinaryExp} node
	*/
	public void inAOrBinaryExp(AOrBinaryExp node, Q question) throws AnalysisException
	{
		defaultInSBinaryExp(node, question);
	}


	/**
	* Called by the {@link AOrBinaryExp} node from {@link AOrBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AOrBinaryExp} node
	*/
	public void outAOrBinaryExp(AOrBinaryExp node, Q question) throws AnalysisException
	{
		defaultOutSBinaryExp(node, question);
	}


	/**
	* Called by the {@link AAndBinaryExp} node from {@link AAndBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AAndBinaryExp} node
	*/
	public void caseAAndBinaryExp(AAndBinaryExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAAndBinaryExp(node, question);

		if(node.getLeft() != null && !_visitedNodes.contains(node.getLeft())) 
		{
			node.getLeft().apply(this, question);
		}
		if(node.getRight() != null && !_visitedNodes.contains(node.getRight())) 
		{
			node.getRight().apply(this, question);
		}

		outAAndBinaryExp(node, question);

	}


	/**
	* Called by the {@link AAndBinaryExp} node from {@link AAndBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AAndBinaryExp} node
	*/
	public void inAAndBinaryExp(AAndBinaryExp node, Q question) throws AnalysisException
	{
		defaultInSBinaryExp(node, question);
	}


	/**
	* Called by the {@link AAndBinaryExp} node from {@link AAndBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AAndBinaryExp} node
	*/
	public void outAAndBinaryExp(AAndBinaryExp node, Q question) throws AnalysisException
	{
		defaultOutSBinaryExp(node, question);
	}


	/**
	* Called by the {@link ADivideBinaryExp} node from {@link ADivideBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ADivideBinaryExp} node
	*/
	public void caseADivideBinaryExp(ADivideBinaryExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inADivideBinaryExp(node, question);

		if(node.getLeft() != null && !_visitedNodes.contains(node.getLeft())) 
		{
			node.getLeft().apply(this, question);
		}
		if(node.getRight() != null && !_visitedNodes.contains(node.getRight())) 
		{
			node.getRight().apply(this, question);
		}

		outADivideBinaryExp(node, question);

	}


	/**
	* Called by the {@link ADivideBinaryExp} node from {@link ADivideBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ADivideBinaryExp} node
	*/
	public void inADivideBinaryExp(ADivideBinaryExp node, Q question) throws AnalysisException
	{
		defaultInSBinaryExp(node, question);
	}


	/**
	* Called by the {@link ADivideBinaryExp} node from {@link ADivideBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ADivideBinaryExp} node
	*/
	public void outADivideBinaryExp(ADivideBinaryExp node, Q question) throws AnalysisException
	{
		defaultOutSBinaryExp(node, question);
	}


	/**
	* Called by the {@link AMultiplyBinaryExp} node from {@link AMultiplyBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AMultiplyBinaryExp} node
	*/
	public void caseAMultiplyBinaryExp(AMultiplyBinaryExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAMultiplyBinaryExp(node, question);

		if(node.getLeft() != null && !_visitedNodes.contains(node.getLeft())) 
		{
			node.getLeft().apply(this, question);
		}
		if(node.getRight() != null && !_visitedNodes.contains(node.getRight())) 
		{
			node.getRight().apply(this, question);
		}

		outAMultiplyBinaryExp(node, question);

	}


	/**
	* Called by the {@link AMultiplyBinaryExp} node from {@link AMultiplyBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AMultiplyBinaryExp} node
	*/
	public void inAMultiplyBinaryExp(AMultiplyBinaryExp node, Q question) throws AnalysisException
	{
		defaultInSBinaryExp(node, question);
	}


	/**
	* Called by the {@link AMultiplyBinaryExp} node from {@link AMultiplyBinaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AMultiplyBinaryExp} node
	*/
	public void outAMultiplyBinaryExp(AMultiplyBinaryExp node, Q question) throws AnalysisException
	{
		defaultOutSBinaryExp(node, question);
	}


	/**
	* Called by the {@link ANotUnaryExp} node from {@link ANotUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ANotUnaryExp} node
	*/
	public void caseANotUnaryExp(ANotUnaryExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inANotUnaryExp(node, question);

		if(node.getExp() != null && !_visitedNodes.contains(node.getExp())) 
		{
			node.getExp().apply(this, question);
		}

		outANotUnaryExp(node, question);

	}


	/**
	* Called by the {@link ANotUnaryExp} node from {@link ANotUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ANotUnaryExp} node
	*/
	public void inANotUnaryExp(ANotUnaryExp node, Q question) throws AnalysisException
	{
		defaultInSUnaryExp(node, question);
	}


	/**
	* Called by the {@link ANotUnaryExp} node from {@link ANotUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link ANotUnaryExp} node
	*/
	public void outANotUnaryExp(ANotUnaryExp node, Q question) throws AnalysisException
	{
		defaultOutSUnaryExp(node, question);
	}


	/**
	* Called by the {@link AMinusUnaryExp} node from {@link AMinusUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AMinusUnaryExp} node
	*/
	public void caseAMinusUnaryExp(AMinusUnaryExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAMinusUnaryExp(node, question);

		if(node.getExp() != null && !_visitedNodes.contains(node.getExp())) 
		{
			node.getExp().apply(this, question);
		}

		outAMinusUnaryExp(node, question);

	}


	/**
	* Called by the {@link AMinusUnaryExp} node from {@link AMinusUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AMinusUnaryExp} node
	*/
	public void inAMinusUnaryExp(AMinusUnaryExp node, Q question) throws AnalysisException
	{
		defaultInSUnaryExp(node, question);
	}


	/**
	* Called by the {@link AMinusUnaryExp} node from {@link AMinusUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link AMinusUnaryExp} node
	*/
	public void outAMinusUnaryExp(AMinusUnaryExp node, Q question) throws AnalysisException
	{
		defaultOutSUnaryExp(node, question);
	}


	/**
	* Called by the {@link APlusUnaryExp} node from {@link APlusUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link APlusUnaryExp} node
	*/
	public void caseAPlusUnaryExp(APlusUnaryExp node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAPlusUnaryExp(node, question);

		if(node.getExp() != null && !_visitedNodes.contains(node.getExp())) 
		{
			node.getExp().apply(this, question);
		}

		outAPlusUnaryExp(node, question);

	}


	/**
	* Called by the {@link APlusUnaryExp} node from {@link APlusUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link APlusUnaryExp} node
	*/
	public void inAPlusUnaryExp(APlusUnaryExp node, Q question) throws AnalysisException
	{
		defaultInSUnaryExp(node, question);
	}


	/**
	* Called by the {@link APlusUnaryExp} node from {@link APlusUnaryExp#apply(IAnalysis)}.
	* @param node the calling {@link APlusUnaryExp} node
	*/
	public void outAPlusUnaryExp(APlusUnaryExp node, Q question) throws AnalysisException
	{
		defaultOutSUnaryExp(node, question);
	}


	/**
	* Called by the {@link PStateDesignator} node from {@link PStateDesignator#apply(IAnalysis)}.
	* @param node the calling {@link PStateDesignator} node
	*/
	public void defaultInPStateDesignator(PStateDesignator node, Q question) throws AnalysisException
	{
		defaultInINode(node, question);
	}


	/**
	* Called by the {@link PStateDesignator} node from {@link PStateDesignator#apply(IAnalysis)}.
	* @param node the calling {@link PStateDesignator} node
	*/
	public void defaultOutPStateDesignator(PStateDesignator node, Q question) throws AnalysisException
	{
		defaultOutINode(node, question);
	}


	/**
	* Called by the {@link PStateDesignator} node from {@link PStateDesignator#apply(IAnalysis)}.
	* @param node the calling {@link PStateDesignator} node
	*/
	public void defaultPStateDesignator(PStateDesignator node, Q question) throws AnalysisException
	{
		defaultINode(node, question);
	}


	/**
	* Called by the {@link PStateDesignator} node from {@link PStateDesignator#apply(IAnalysis)}.
	* @param node the calling {@link PStateDesignator} node
	*/
	public void inPStateDesignator(PStateDesignator node, Q question) throws AnalysisException
	{
		defaultInINode(node, question);
	}


	/**
	* Called by the {@link PStateDesignator} node from {@link PStateDesignator#apply(IAnalysis)}.
	* @param node the calling {@link PStateDesignator} node
	*/
	public void outPStateDesignator(PStateDesignator node, Q question) throws AnalysisException
	{
		defaultOutINode(node, question);
	}


	/**
	* Called by the {@link AIdentifierStateDesignator} node from {@link AIdentifierStateDesignator#apply(IAnalysis)}.
	* @param node the calling {@link AIdentifierStateDesignator} node
	*/
	public void caseAIdentifierStateDesignator(AIdentifierStateDesignator node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAIdentifierStateDesignator(node, question);


		outAIdentifierStateDesignator(node, question);

	}


	/**
	* Called by the {@link AIdentifierStateDesignator} node from {@link AIdentifierStateDesignator#apply(IAnalysis)}.
	* @param node the calling {@link AIdentifierStateDesignator} node
	*/
	public void inAIdentifierStateDesignator(AIdentifierStateDesignator node, Q question) throws AnalysisException
	{
		defaultInPStateDesignator(node, question);
	}


	/**
	* Called by the {@link AIdentifierStateDesignator} node from {@link AIdentifierStateDesignator#apply(IAnalysis)}.
	* @param node the calling {@link AIdentifierStateDesignator} node
	*/
	public void outAIdentifierStateDesignator(AIdentifierStateDesignator node, Q question) throws AnalysisException
	{
		defaultOutPStateDesignator(node, question);
	}


	/**
	* Called by the {@link AArrayStateDesignator} node from {@link AArrayStateDesignator#apply(IAnalysis)}.
	* @param node the calling {@link AArrayStateDesignator} node
	*/
	public void caseAArrayStateDesignator(AArrayStateDesignator node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAArrayStateDesignator(node, question);

		if(node.getTarget() != null && !_visitedNodes.contains(node.getTarget())) 
		{
			node.getTarget().apply(this, question);
		}
		if(node.getExp() != null && !_visitedNodes.contains(node.getExp())) 
		{
			node.getExp().apply(this, question);
		}

		outAArrayStateDesignator(node, question);

	}


	/**
	* Called by the {@link AArrayStateDesignator} node from {@link AArrayStateDesignator#apply(IAnalysis)}.
	* @param node the calling {@link AArrayStateDesignator} node
	*/
	public void inAArrayStateDesignator(AArrayStateDesignator node, Q question) throws AnalysisException
	{
		defaultInPStateDesignator(node, question);
	}


	/**
	* Called by the {@link AArrayStateDesignator} node from {@link AArrayStateDesignator#apply(IAnalysis)}.
	* @param node the calling {@link AArrayStateDesignator} node
	*/
	public void outAArrayStateDesignator(AArrayStateDesignator node, Q question) throws AnalysisException
	{
		defaultOutPStateDesignator(node, question);
	}


	/**
	* Called by the {@link PStm} node from {@link PStm#apply(IAnalysis)}.
	* @param node the calling {@link PStm} node
	*/
	public void defaultInPStm(PStm node, Q question) throws AnalysisException
	{
		defaultInINode(node, question);
	}


	/**
	* Called by the {@link PStm} node from {@link PStm#apply(IAnalysis)}.
	* @param node the calling {@link PStm} node
	*/
	public void defaultOutPStm(PStm node, Q question) throws AnalysisException
	{
		defaultOutINode(node, question);
	}


	/**
	* Called by the {@link PStm} node from {@link PStm#apply(IAnalysis)}.
	* @param node the calling {@link PStm} node
	*/
	public void defaultPStm(PStm node, Q question) throws AnalysisException
	{
		defaultINode(node, question);
	}


	/**
	* Called by the {@link PStm} node from {@link PStm#apply(IAnalysis)}.
	* @param node the calling {@link PStm} node
	*/
	public void inPStm(PStm node, Q question) throws AnalysisException
	{
		defaultInINode(node, question);
	}


	/**
	* Called by the {@link PStm} node from {@link PStm#apply(IAnalysis)}.
	* @param node the calling {@link PStm} node
	*/
	public void outPStm(PStm node, Q question) throws AnalysisException
	{
		defaultOutINode(node, question);
	}


	/**
	* Called by the {@link SBlockStm} node from {@link SBlockStm#apply(IAnalysis)}.
	* @param node the calling {@link SBlockStm} node
	*/
	public void defaultInSBlockStm(SBlockStm node, Q question) throws AnalysisException
	{
		defaultInPStm(node, question);
	}


	/**
	* Called by the {@link SBlockStm} node from {@link SBlockStm#apply(IAnalysis)}.
	* @param node the calling {@link SBlockStm} node
	*/
	public void defaultOutSBlockStm(SBlockStm node, Q question) throws AnalysisException
	{
		defaultOutPStm(node, question);
	}


	/**
	* Called by the {@link SBlockStm} node from {@link SBlockStm#apply(IAnalysis)}.
	* @param node the calling {@link SBlockStm} node
	*/
	public void defaultSBlockStm(SBlockStm node, Q question) throws AnalysisException
	{
		defaultPStm(node, question);
	}


	/**
	* Called by the {@link SBlockStm} node from {@link SBlockStm#apply(IAnalysis)}.
	* @param node the calling {@link SBlockStm} node
	*/
	public void inSBlockStm(SBlockStm node, Q question) throws AnalysisException
	{
		defaultInPStm(node, question);
	}


	/**
	* Called by the {@link SBlockStm} node from {@link SBlockStm#apply(IAnalysis)}.
	* @param node the calling {@link SBlockStm} node
	*/
	public void outSBlockStm(SBlockStm node, Q question) throws AnalysisException
	{
		defaultOutPStm(node, question);
	}


	/**
	* Called by the {@link AAssigmentStm} node from {@link AAssigmentStm#apply(IAnalysis)}.
	* @param node the calling {@link AAssigmentStm} node
	*/
	public void caseAAssigmentStm(AAssigmentStm node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAAssigmentStm(node, question);

		if(node.getTarget() != null && !_visitedNodes.contains(node.getTarget())) 
		{
			node.getTarget().apply(this, question);
		}
		if(node.getExp() != null && !_visitedNodes.contains(node.getExp())) 
		{
			node.getExp().apply(this, question);
		}

		outAAssigmentStm(node, question);

	}


	/**
	* Called by the {@link AAssigmentStm} node from {@link AAssigmentStm#apply(IAnalysis)}.
	* @param node the calling {@link AAssigmentStm} node
	*/
	public void inAAssigmentStm(AAssigmentStm node, Q question) throws AnalysisException
	{
		defaultInPStm(node, question);
	}


	/**
	* Called by the {@link AAssigmentStm} node from {@link AAssigmentStm#apply(IAnalysis)}.
	* @param node the calling {@link AAssigmentStm} node
	*/
	public void outAAssigmentStm(AAssigmentStm node, Q question) throws AnalysisException
	{
		defaultOutPStm(node, question);
	}


	/**
	* Called by the {@link ALocalVariableStm} node from {@link ALocalVariableStm#apply(IAnalysis)}.
	* @param node the calling {@link ALocalVariableStm} node
	*/
	public void caseALocalVariableStm(ALocalVariableStm node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inALocalVariableStm(node, question);

		if(node.getDeclaration() != null && !_visitedNodes.contains(node.getDeclaration())) 
		{
			node.getDeclaration().apply(this, question);
		}

		outALocalVariableStm(node, question);

	}


	/**
	* Called by the {@link ALocalVariableStm} node from {@link ALocalVariableStm#apply(IAnalysis)}.
	* @param node the calling {@link ALocalVariableStm} node
	*/
	public void inALocalVariableStm(ALocalVariableStm node, Q question) throws AnalysisException
	{
		defaultInPStm(node, question);
	}


	/**
	* Called by the {@link ALocalVariableStm} node from {@link ALocalVariableStm#apply(IAnalysis)}.
	* @param node the calling {@link ALocalVariableStm} node
	*/
	public void outALocalVariableStm(ALocalVariableStm node, Q question) throws AnalysisException
	{
		defaultOutPStm(node, question);
	}


	/**
	* Called by the {@link AIfStm} node from {@link AIfStm#apply(IAnalysis)}.
	* @param node the calling {@link AIfStm} node
	*/
	public void caseAIfStm(AIfStm node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAIfStm(node, question);

		if(node.getTest() != null && !_visitedNodes.contains(node.getTest())) 
		{
			node.getTest().apply(this, question);
		}
		if(node.getThen() != null && !_visitedNodes.contains(node.getThen())) 
		{
			node.getThen().apply(this, question);
		}
		if(node.getElse() != null && !_visitedNodes.contains(node.getElse())) 
		{
			node.getElse().apply(this, question);
		}

		outAIfStm(node, question);

	}


	/**
	* Called by the {@link AIfStm} node from {@link AIfStm#apply(IAnalysis)}.
	* @param node the calling {@link AIfStm} node
	*/
	public void inAIfStm(AIfStm node, Q question) throws AnalysisException
	{
		defaultInPStm(node, question);
	}


	/**
	* Called by the {@link AIfStm} node from {@link AIfStm#apply(IAnalysis)}.
	* @param node the calling {@link AIfStm} node
	*/
	public void outAIfStm(AIfStm node, Q question) throws AnalysisException
	{
		defaultOutPStm(node, question);
	}


	/**
	* Called by the {@link AWhileStm} node from {@link AWhileStm#apply(IAnalysis)}.
	* @param node the calling {@link AWhileStm} node
	*/
	public void caseAWhileStm(AWhileStm node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAWhileStm(node, question);

		if(node.getTest() != null && !_visitedNodes.contains(node.getTest())) 
		{
			node.getTest().apply(this, question);
		}
		if(node.getBody() != null && !_visitedNodes.contains(node.getBody())) 
		{
			node.getBody().apply(this, question);
		}

		outAWhileStm(node, question);

	}


	/**
	* Called by the {@link AWhileStm} node from {@link AWhileStm#apply(IAnalysis)}.
	* @param node the calling {@link AWhileStm} node
	*/
	public void inAWhileStm(AWhileStm node, Q question) throws AnalysisException
	{
		defaultInPStm(node, question);
	}


	/**
	* Called by the {@link AWhileStm} node from {@link AWhileStm#apply(IAnalysis)}.
	* @param node the calling {@link AWhileStm} node
	*/
	public void outAWhileStm(AWhileStm node, Q question) throws AnalysisException
	{
		defaultOutPStm(node, question);
	}


	/**
	* Called by the {@link AExpressionStm} node from {@link AExpressionStm#apply(IAnalysis)}.
	* @param node the calling {@link AExpressionStm} node
	*/
	public void caseAExpressionStm(AExpressionStm node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAExpressionStm(node, question);

		if(node.getExp() != null && !_visitedNodes.contains(node.getExp())) 
		{
			node.getExp().apply(this, question);
		}

		outAExpressionStm(node, question);

	}


	/**
	* Called by the {@link AExpressionStm} node from {@link AExpressionStm#apply(IAnalysis)}.
	* @param node the calling {@link AExpressionStm} node
	*/
	public void inAExpressionStm(AExpressionStm node, Q question) throws AnalysisException
	{
		defaultInPStm(node, question);
	}


	/**
	* Called by the {@link AExpressionStm} node from {@link AExpressionStm#apply(IAnalysis)}.
	* @param node the calling {@link AExpressionStm} node
	*/
	public void outAExpressionStm(AExpressionStm node, Q question) throws AnalysisException
	{
		defaultOutPStm(node, question);
	}


	/**
	* Called by the {@link AObservableStm} node from {@link AObservableStm#apply(IAnalysis)}.
	* @param node the calling {@link AObservableStm} node
	*/
	public void caseAObservableStm(AObservableStm node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAObservableStm(node, question);

		if(node.getIdentifier() != null && !_visitedNodes.contains(node.getIdentifier())) 
		{
			node.getIdentifier().apply(this, question);
		}

		outAObservableStm(node, question);

	}


	/**
	* Called by the {@link AObservableStm} node from {@link AObservableStm#apply(IAnalysis)}.
	* @param node the calling {@link AObservableStm} node
	*/
	public void inAObservableStm(AObservableStm node, Q question) throws AnalysisException
	{
		defaultInPStm(node, question);
	}


	/**
	* Called by the {@link AObservableStm} node from {@link AObservableStm#apply(IAnalysis)}.
	* @param node the calling {@link AObservableStm} node
	*/
	public void outAObservableStm(AObservableStm node, Q question) throws AnalysisException
	{
		defaultOutPStm(node, question);
	}


	/**
	* Called by the {@link ABreakStm} node from {@link ABreakStm#apply(IAnalysis)}.
	* @param node the calling {@link ABreakStm} node
	*/
	public void caseABreakStm(ABreakStm node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inABreakStm(node, question);

		if(node.getToken() != null ) 
		{
			node.getToken().apply(this, question);
		}

		outABreakStm(node, question);

	}


	/**
	* Called by the {@link ABreakStm} node from {@link ABreakStm#apply(IAnalysis)}.
	* @param node the calling {@link ABreakStm} node
	*/
	public void inABreakStm(ABreakStm node, Q question) throws AnalysisException
	{
		defaultInPStm(node, question);
	}


	/**
	* Called by the {@link ABreakStm} node from {@link ABreakStm#apply(IAnalysis)}.
	* @param node the calling {@link ABreakStm} node
	*/
	public void outABreakStm(ABreakStm node, Q question) throws AnalysisException
	{
		defaultOutPStm(node, question);
	}


	/**
	* Called by the {@link AInstanceMappingStm} node from {@link AInstanceMappingStm#apply(IAnalysis)}.
	* @param node the calling {@link AInstanceMappingStm} node
	*/
	public void caseAInstanceMappingStm(AInstanceMappingStm node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAInstanceMappingStm(node, question);


		outAInstanceMappingStm(node, question);

	}


	/**
	* Called by the {@link AInstanceMappingStm} node from {@link AInstanceMappingStm#apply(IAnalysis)}.
	* @param node the calling {@link AInstanceMappingStm} node
	*/
	public void inAInstanceMappingStm(AInstanceMappingStm node, Q question) throws AnalysisException
	{
		defaultInPStm(node, question);
	}


	/**
	* Called by the {@link AInstanceMappingStm} node from {@link AInstanceMappingStm#apply(IAnalysis)}.
	* @param node the calling {@link AInstanceMappingStm} node
	*/
	public void outAInstanceMappingStm(AInstanceMappingStm node, Q question) throws AnalysisException
	{
		defaultOutPStm(node, question);
	}


	/**
	* Called by the {@link AFmuMappingStm} node from {@link AFmuMappingStm#apply(IAnalysis)}.
	* @param node the calling {@link AFmuMappingStm} node
	*/
	public void caseAFmuMappingStm(AFmuMappingStm node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAFmuMappingStm(node, question);


		outAFmuMappingStm(node, question);

	}


	/**
	* Called by the {@link AFmuMappingStm} node from {@link AFmuMappingStm#apply(IAnalysis)}.
	* @param node the calling {@link AFmuMappingStm} node
	*/
	public void inAFmuMappingStm(AFmuMappingStm node, Q question) throws AnalysisException
	{
		defaultInPStm(node, question);
	}


	/**
	* Called by the {@link AFmuMappingStm} node from {@link AFmuMappingStm#apply(IAnalysis)}.
	* @param node the calling {@link AFmuMappingStm} node
	*/
	public void outAFmuMappingStm(AFmuMappingStm node, Q question) throws AnalysisException
	{
		defaultOutPStm(node, question);
	}


	/**
	* Called by the {@link ATransferStm} node from {@link ATransferStm#apply(IAnalysis)}.
	* @param node the calling {@link ATransferStm} node
	*/
	public void caseATransferStm(ATransferStm node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inATransferStm(node, question);

		{
			List<AStringLiteralExp> copy = new ArrayList<AStringLiteralExp>(node.getNames());
			for( AStringLiteralExp e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					e.apply(this, question);
				}
			}
		}

		outATransferStm(node, question);

	}


	/**
	* Called by the {@link ATransferStm} node from {@link ATransferStm#apply(IAnalysis)}.
	* @param node the calling {@link ATransferStm} node
	*/
	public void inATransferStm(ATransferStm node, Q question) throws AnalysisException
	{
		defaultInPStm(node, question);
	}


	/**
	* Called by the {@link ATransferStm} node from {@link ATransferStm#apply(IAnalysis)}.
	* @param node the calling {@link ATransferStm} node
	*/
	public void outATransferStm(ATransferStm node, Q question) throws AnalysisException
	{
		defaultOutPStm(node, question);
	}


	/**
	* Called by the {@link ATransferAsStm} node from {@link ATransferAsStm#apply(IAnalysis)}.
	* @param node the calling {@link ATransferAsStm} node
	*/
	public void caseATransferAsStm(ATransferAsStm node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inATransferAsStm(node, question);

		{
			List<AStringLiteralExp> copy = new ArrayList<AStringLiteralExp>(node.getNames());
			for( AStringLiteralExp e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					e.apply(this, question);
				}
			}
		}

		outATransferAsStm(node, question);

	}


	/**
	* Called by the {@link ATransferAsStm} node from {@link ATransferAsStm#apply(IAnalysis)}.
	* @param node the calling {@link ATransferAsStm} node
	*/
	public void inATransferAsStm(ATransferAsStm node, Q question) throws AnalysisException
	{
		defaultInPStm(node, question);
	}


	/**
	* Called by the {@link ATransferAsStm} node from {@link ATransferAsStm#apply(IAnalysis)}.
	* @param node the calling {@link ATransferAsStm} node
	*/
	public void outATransferAsStm(ATransferAsStm node, Q question) throws AnalysisException
	{
		defaultOutPStm(node, question);
	}


	/**
	* Called by the {@link AConfigStm} node from {@link AConfigStm#apply(IAnalysis)}.
	* @param node the calling {@link AConfigStm} node
	*/
	public void caseAConfigStm(AConfigStm node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAConfigStm(node, question);


		outAConfigStm(node, question);

	}


	/**
	* Called by the {@link AConfigStm} node from {@link AConfigStm#apply(IAnalysis)}.
	* @param node the calling {@link AConfigStm} node
	*/
	public void inAConfigStm(AConfigStm node, Q question) throws AnalysisException
	{
		defaultInPStm(node, question);
	}


	/**
	* Called by the {@link AConfigStm} node from {@link AConfigStm#apply(IAnalysis)}.
	* @param node the calling {@link AConfigStm} node
	*/
	public void outAConfigStm(AConfigStm node, Q question) throws AnalysisException
	{
		defaultOutPStm(node, question);
	}


	/**
	* Called by the {@link AErrorStm} node from {@link AErrorStm#apply(IAnalysis)}.
	* @param node the calling {@link AErrorStm} node
	*/
	public void caseAErrorStm(AErrorStm node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAErrorStm(node, question);

		if(node.getExp() != null && !_visitedNodes.contains(node.getExp())) 
		{
			node.getExp().apply(this, question);
		}

		outAErrorStm(node, question);

	}


	/**
	* Called by the {@link AErrorStm} node from {@link AErrorStm#apply(IAnalysis)}.
	* @param node the calling {@link AErrorStm} node
	*/
	public void inAErrorStm(AErrorStm node, Q question) throws AnalysisException
	{
		defaultInPStm(node, question);
	}


	/**
	* Called by the {@link AErrorStm} node from {@link AErrorStm#apply(IAnalysis)}.
	* @param node the calling {@link AErrorStm} node
	*/
	public void outAErrorStm(AErrorStm node, Q question) throws AnalysisException
	{
		defaultOutPStm(node, question);
	}


	/**
	* Called by the {@link ATryStm} node from {@link ATryStm#apply(IAnalysis)}.
	* @param node the calling {@link ATryStm} node
	*/
	public void caseATryStm(ATryStm node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inATryStm(node, question);

		if(node.getBody() != null && !_visitedNodes.contains(node.getBody())) 
		{
			node.getBody().apply(this, question);
		}
		if(node.getFinally() != null && !_visitedNodes.contains(node.getFinally())) 
		{
			node.getFinally().apply(this, question);
		}

		outATryStm(node, question);

	}


	/**
	* Called by the {@link ATryStm} node from {@link ATryStm#apply(IAnalysis)}.
	* @param node the calling {@link ATryStm} node
	*/
	public void inATryStm(ATryStm node, Q question) throws AnalysisException
	{
		defaultInPStm(node, question);
	}


	/**
	* Called by the {@link ATryStm} node from {@link ATryStm#apply(IAnalysis)}.
	* @param node the calling {@link ATryStm} node
	*/
	public void outATryStm(ATryStm node, Q question) throws AnalysisException
	{
		defaultOutPStm(node, question);
	}


	/**
	* Called by the {@link ABasicBlockStm} node from {@link ABasicBlockStm#apply(IAnalysis)}.
	* @param node the calling {@link ABasicBlockStm} node
	*/
	public void caseABasicBlockStm(ABasicBlockStm node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inABasicBlockStm(node, question);

		{
			List<PStm> copy = new ArrayList<PStm>(node.getBody());
			for( PStm e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					e.apply(this, question);
				}
			}
		}

		outABasicBlockStm(node, question);

	}


	/**
	* Called by the {@link ABasicBlockStm} node from {@link ABasicBlockStm#apply(IAnalysis)}.
	* @param node the calling {@link ABasicBlockStm} node
	*/
	public void inABasicBlockStm(ABasicBlockStm node, Q question) throws AnalysisException
	{
		defaultInSBlockStm(node, question);
	}


	/**
	* Called by the {@link ABasicBlockStm} node from {@link ABasicBlockStm#apply(IAnalysis)}.
	* @param node the calling {@link ABasicBlockStm} node
	*/
	public void outABasicBlockStm(ABasicBlockStm node, Q question) throws AnalysisException
	{
		defaultOutSBlockStm(node, question);
	}


	/**
	* Called by the {@link AParallelBlockStm} node from {@link AParallelBlockStm#apply(IAnalysis)}.
	* @param node the calling {@link AParallelBlockStm} node
	*/
	public void caseAParallelBlockStm(AParallelBlockStm node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAParallelBlockStm(node, question);

		{
			List<PStm> copy = new ArrayList<PStm>(node.getBody());
			for( PStm e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					e.apply(this, question);
				}
			}
		}

		outAParallelBlockStm(node, question);

	}


	/**
	* Called by the {@link AParallelBlockStm} node from {@link AParallelBlockStm#apply(IAnalysis)}.
	* @param node the calling {@link AParallelBlockStm} node
	*/
	public void inAParallelBlockStm(AParallelBlockStm node, Q question) throws AnalysisException
	{
		defaultInSBlockStm(node, question);
	}


	/**
	* Called by the {@link AParallelBlockStm} node from {@link AParallelBlockStm#apply(IAnalysis)}.
	* @param node the calling {@link AParallelBlockStm} node
	*/
	public void outAParallelBlockStm(AParallelBlockStm node, Q question) throws AnalysisException
	{
		defaultOutSBlockStm(node, question);
	}


	/**
	* Called by the {@link PType} node from {@link PType#apply(IAnalysis)}.
	* @param node the calling {@link PType} node
	*/
	public void defaultInPType(PType node, Q question) throws AnalysisException
	{
		defaultInINode(node, question);
	}


	/**
	* Called by the {@link PType} node from {@link PType#apply(IAnalysis)}.
	* @param node the calling {@link PType} node
	*/
	public void defaultOutPType(PType node, Q question) throws AnalysisException
	{
		defaultOutINode(node, question);
	}


	/**
	* Called by the {@link PType} node from {@link PType#apply(IAnalysis)}.
	* @param node the calling {@link PType} node
	*/
	public void defaultPType(PType node, Q question) throws AnalysisException
	{
		defaultINode(node, question);
	}


	/**
	* Called by the {@link PType} node from {@link PType#apply(IAnalysis)}.
	* @param node the calling {@link PType} node
	*/
	public void inPType(PType node, Q question) throws AnalysisException
	{
		defaultInINode(node, question);
	}


	/**
	* Called by the {@link PType} node from {@link PType#apply(IAnalysis)}.
	* @param node the calling {@link PType} node
	*/
	public void outPType(PType node, Q question) throws AnalysisException
	{
		defaultOutINode(node, question);
	}


	/**
	* Called by the {@link SPrimitiveType} node from {@link SPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link SPrimitiveType} node
	*/
	public void defaultInSPrimitiveType(SPrimitiveType node, Q question) throws AnalysisException
	{
		defaultInPType(node, question);
	}


	/**
	* Called by the {@link SPrimitiveType} node from {@link SPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link SPrimitiveType} node
	*/
	public void defaultOutSPrimitiveType(SPrimitiveType node, Q question) throws AnalysisException
	{
		defaultOutPType(node, question);
	}


	/**
	* Called by the {@link SPrimitiveType} node from {@link SPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link SPrimitiveType} node
	*/
	public void defaultSPrimitiveType(SPrimitiveType node, Q question) throws AnalysisException
	{
		defaultPType(node, question);
	}


	/**
	* Called by the {@link SPrimitiveType} node from {@link SPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link SPrimitiveType} node
	*/
	public void inSPrimitiveType(SPrimitiveType node, Q question) throws AnalysisException
	{
		defaultInPType(node, question);
	}


	/**
	* Called by the {@link SPrimitiveType} node from {@link SPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link SPrimitiveType} node
	*/
	public void outSPrimitiveType(SPrimitiveType node, Q question) throws AnalysisException
	{
		defaultOutPType(node, question);
	}


	/**
	* Called by the {@link ANameType} node from {@link ANameType#apply(IAnalysis)}.
	* @param node the calling {@link ANameType} node
	*/
	public void caseANameType(ANameType node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inANameType(node, question);


		outANameType(node, question);

	}


	/**
	* Called by the {@link ANameType} node from {@link ANameType#apply(IAnalysis)}.
	* @param node the calling {@link ANameType} node
	*/
	public void inANameType(ANameType node, Q question) throws AnalysisException
	{
		defaultInPType(node, question);
	}


	/**
	* Called by the {@link ANameType} node from {@link ANameType#apply(IAnalysis)}.
	* @param node the calling {@link ANameType} node
	*/
	public void outANameType(ANameType node, Q question) throws AnalysisException
	{
		defaultOutPType(node, question);
	}


	/**
	* Called by the {@link AFunctionType} node from {@link AFunctionType#apply(IAnalysis)}.
	* @param node the calling {@link AFunctionType} node
	*/
	public void caseAFunctionType(AFunctionType node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAFunctionType(node, question);

		if(node.getResult() != null && !_visitedNodes.contains(node.getResult())) 
		{
			node.getResult().apply(this, question);
		}
		{
			List<PType> copy = new ArrayList<PType>(node.getParameters());
			for( PType e : copy) 
			{
				if(!_visitedNodes.contains(e))
				{
					e.apply(this, question);
				}
			}
		}

		outAFunctionType(node, question);

	}


	/**
	* Called by the {@link AFunctionType} node from {@link AFunctionType#apply(IAnalysis)}.
	* @param node the calling {@link AFunctionType} node
	*/
	public void inAFunctionType(AFunctionType node, Q question) throws AnalysisException
	{
		defaultInPType(node, question);
	}


	/**
	* Called by the {@link AFunctionType} node from {@link AFunctionType#apply(IAnalysis)}.
	* @param node the calling {@link AFunctionType} node
	*/
	public void outAFunctionType(AFunctionType node, Q question) throws AnalysisException
	{
		defaultOutPType(node, question);
	}


	/**
	* Called by the {@link AArrayType} node from {@link AArrayType#apply(IAnalysis)}.
	* @param node the calling {@link AArrayType} node
	*/
	public void caseAArrayType(AArrayType node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAArrayType(node, question);

		if(node.getType() != null && !_visitedNodes.contains(node.getType())) 
		{
			node.getType().apply(this, question);
		}

		outAArrayType(node, question);

	}


	/**
	* Called by the {@link AArrayType} node from {@link AArrayType#apply(IAnalysis)}.
	* @param node the calling {@link AArrayType} node
	*/
	public void inAArrayType(AArrayType node, Q question) throws AnalysisException
	{
		defaultInPType(node, question);
	}


	/**
	* Called by the {@link AArrayType} node from {@link AArrayType#apply(IAnalysis)}.
	* @param node the calling {@link AArrayType} node
	*/
	public void outAArrayType(AArrayType node, Q question) throws AnalysisException
	{
		defaultOutPType(node, question);
	}


	/**
	* Called by the {@link AUnknownType} node from {@link AUnknownType#apply(IAnalysis)}.
	* @param node the calling {@link AUnknownType} node
	*/
	public void caseAUnknownType(AUnknownType node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAUnknownType(node, question);


		outAUnknownType(node, question);

	}


	/**
	* Called by the {@link AUnknownType} node from {@link AUnknownType#apply(IAnalysis)}.
	* @param node the calling {@link AUnknownType} node
	*/
	public void inAUnknownType(AUnknownType node, Q question) throws AnalysisException
	{
		defaultInPType(node, question);
	}


	/**
	* Called by the {@link AUnknownType} node from {@link AUnknownType#apply(IAnalysis)}.
	* @param node the calling {@link AUnknownType} node
	*/
	public void outAUnknownType(AUnknownType node, Q question) throws AnalysisException
	{
		defaultOutPType(node, question);
	}


	/**
	* Called by the {@link AVoidType} node from {@link AVoidType#apply(IAnalysis)}.
	* @param node the calling {@link AVoidType} node
	*/
	public void caseAVoidType(AVoidType node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAVoidType(node, question);


		outAVoidType(node, question);

	}


	/**
	* Called by the {@link AVoidType} node from {@link AVoidType#apply(IAnalysis)}.
	* @param node the calling {@link AVoidType} node
	*/
	public void inAVoidType(AVoidType node, Q question) throws AnalysisException
	{
		defaultInPType(node, question);
	}


	/**
	* Called by the {@link AVoidType} node from {@link AVoidType#apply(IAnalysis)}.
	* @param node the calling {@link AVoidType} node
	*/
	public void outAVoidType(AVoidType node, Q question) throws AnalysisException
	{
		defaultOutPType(node, question);
	}


	/**
	* Called by the {@link AModuleType} node from {@link AModuleType#apply(IAnalysis)}.
	* @param node the calling {@link AModuleType} node
	*/
	public void caseAModuleType(AModuleType node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAModuleType(node, question);


		outAModuleType(node, question);

	}


	/**
	* Called by the {@link AModuleType} node from {@link AModuleType#apply(IAnalysis)}.
	* @param node the calling {@link AModuleType} node
	*/
	public void inAModuleType(AModuleType node, Q question) throws AnalysisException
	{
		defaultInPType(node, question);
	}


	/**
	* Called by the {@link AModuleType} node from {@link AModuleType#apply(IAnalysis)}.
	* @param node the calling {@link AModuleType} node
	*/
	public void outAModuleType(AModuleType node, Q question) throws AnalysisException
	{
		defaultOutPType(node, question);
	}


	/**
	* Called by the {@link AReferenceType} node from {@link AReferenceType#apply(IAnalysis)}.
	* @param node the calling {@link AReferenceType} node
	*/
	public void caseAReferenceType(AReferenceType node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAReferenceType(node, question);

		if(node.getType() != null && !_visitedNodes.contains(node.getType())) 
		{
			node.getType().apply(this, question);
		}

		outAReferenceType(node, question);

	}


	/**
	* Called by the {@link AReferenceType} node from {@link AReferenceType#apply(IAnalysis)}.
	* @param node the calling {@link AReferenceType} node
	*/
	public void inAReferenceType(AReferenceType node, Q question) throws AnalysisException
	{
		defaultInPType(node, question);
	}


	/**
	* Called by the {@link AReferenceType} node from {@link AReferenceType#apply(IAnalysis)}.
	* @param node the calling {@link AReferenceType} node
	*/
	public void outAReferenceType(AReferenceType node, Q question) throws AnalysisException
	{
		defaultOutPType(node, question);
	}


	/**
	* Called by the {@link ANullType} node from {@link ANullType#apply(IAnalysis)}.
	* @param node the calling {@link ANullType} node
	*/
	public void caseANullType(ANullType node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inANullType(node, question);


		outANullType(node, question);

	}


	/**
	* Called by the {@link ANullType} node from {@link ANullType#apply(IAnalysis)}.
	* @param node the calling {@link ANullType} node
	*/
	public void inANullType(ANullType node, Q question) throws AnalysisException
	{
		defaultInPType(node, question);
	}


	/**
	* Called by the {@link ANullType} node from {@link ANullType#apply(IAnalysis)}.
	* @param node the calling {@link ANullType} node
	*/
	public void outANullType(ANullType node, Q question) throws AnalysisException
	{
		defaultOutPType(node, question);
	}


	/**
	* Called by the {@link ABooleanPrimitiveType} node from {@link ABooleanPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link ABooleanPrimitiveType} node
	*/
	public void caseABooleanPrimitiveType(ABooleanPrimitiveType node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inABooleanPrimitiveType(node, question);


		outABooleanPrimitiveType(node, question);

	}


	/**
	* Called by the {@link ABooleanPrimitiveType} node from {@link ABooleanPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link ABooleanPrimitiveType} node
	*/
	public void inABooleanPrimitiveType(ABooleanPrimitiveType node, Q question) throws AnalysisException
	{
		defaultInSPrimitiveType(node, question);
	}


	/**
	* Called by the {@link ABooleanPrimitiveType} node from {@link ABooleanPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link ABooleanPrimitiveType} node
	*/
	public void outABooleanPrimitiveType(ABooleanPrimitiveType node, Q question) throws AnalysisException
	{
		defaultOutSPrimitiveType(node, question);
	}


	/**
	* Called by the {@link AStringPrimitiveType} node from {@link AStringPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link AStringPrimitiveType} node
	*/
	public void caseAStringPrimitiveType(AStringPrimitiveType node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAStringPrimitiveType(node, question);


		outAStringPrimitiveType(node, question);

	}


	/**
	* Called by the {@link AStringPrimitiveType} node from {@link AStringPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link AStringPrimitiveType} node
	*/
	public void inAStringPrimitiveType(AStringPrimitiveType node, Q question) throws AnalysisException
	{
		defaultInSPrimitiveType(node, question);
	}


	/**
	* Called by the {@link AStringPrimitiveType} node from {@link AStringPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link AStringPrimitiveType} node
	*/
	public void outAStringPrimitiveType(AStringPrimitiveType node, Q question) throws AnalysisException
	{
		defaultOutSPrimitiveType(node, question);
	}


	/**
	* Called by the {@link SNumericPrimitiveType} node from {@link SNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link SNumericPrimitiveType} node
	*/
	public void defaultInSNumericPrimitiveType(SNumericPrimitiveType node, Q question) throws AnalysisException
	{
		defaultInSPrimitiveType(node, question);
	}


	/**
	* Called by the {@link SNumericPrimitiveType} node from {@link SNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link SNumericPrimitiveType} node
	*/
	public void defaultOutSNumericPrimitiveType(SNumericPrimitiveType node, Q question) throws AnalysisException
	{
		defaultOutSPrimitiveType(node, question);
	}


	/**
	* Called by the {@link SNumericPrimitiveType} node from {@link SNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link SNumericPrimitiveType} node
	*/
	public void defaultSNumericPrimitiveType(SNumericPrimitiveType node, Q question) throws AnalysisException
	{
		defaultSPrimitiveType(node, question);
	}


	/**
	* Called by the {@link SNumericPrimitiveType} node from {@link SNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link SNumericPrimitiveType} node
	*/
	public void inSNumericPrimitiveType(SNumericPrimitiveType node, Q question) throws AnalysisException
	{
		defaultInSPrimitiveType(node, question);
	}


	/**
	* Called by the {@link SNumericPrimitiveType} node from {@link SNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link SNumericPrimitiveType} node
	*/
	public void outSNumericPrimitiveType(SNumericPrimitiveType node, Q question) throws AnalysisException
	{
		defaultOutSPrimitiveType(node, question);
	}


	/**
	* Called by the {@link ARealNumericPrimitiveType} node from {@link ARealNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link ARealNumericPrimitiveType} node
	*/
	public void caseARealNumericPrimitiveType(ARealNumericPrimitiveType node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inARealNumericPrimitiveType(node, question);


		outARealNumericPrimitiveType(node, question);

	}


	/**
	* Called by the {@link ARealNumericPrimitiveType} node from {@link ARealNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link ARealNumericPrimitiveType} node
	*/
	public void inARealNumericPrimitiveType(ARealNumericPrimitiveType node, Q question) throws AnalysisException
	{
		defaultInSNumericPrimitiveType(node, question);
	}


	/**
	* Called by the {@link ARealNumericPrimitiveType} node from {@link ARealNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link ARealNumericPrimitiveType} node
	*/
	public void outARealNumericPrimitiveType(ARealNumericPrimitiveType node, Q question) throws AnalysisException
	{
		defaultOutSNumericPrimitiveType(node, question);
	}


	/**
	* Called by the {@link AIntNumericPrimitiveType} node from {@link AIntNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link AIntNumericPrimitiveType} node
	*/
	public void caseAIntNumericPrimitiveType(AIntNumericPrimitiveType node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAIntNumericPrimitiveType(node, question);


		outAIntNumericPrimitiveType(node, question);

	}


	/**
	* Called by the {@link AIntNumericPrimitiveType} node from {@link AIntNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link AIntNumericPrimitiveType} node
	*/
	public void inAIntNumericPrimitiveType(AIntNumericPrimitiveType node, Q question) throws AnalysisException
	{
		defaultInSNumericPrimitiveType(node, question);
	}


	/**
	* Called by the {@link AIntNumericPrimitiveType} node from {@link AIntNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link AIntNumericPrimitiveType} node
	*/
	public void outAIntNumericPrimitiveType(AIntNumericPrimitiveType node, Q question) throws AnalysisException
	{
		defaultOutSNumericPrimitiveType(node, question);
	}


	/**
	* Called by the {@link AUIntNumericPrimitiveType} node from {@link AUIntNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link AUIntNumericPrimitiveType} node
	*/
	public void caseAUIntNumericPrimitiveType(AUIntNumericPrimitiveType node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAUIntNumericPrimitiveType(node, question);


		outAUIntNumericPrimitiveType(node, question);

	}


	/**
	* Called by the {@link AUIntNumericPrimitiveType} node from {@link AUIntNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link AUIntNumericPrimitiveType} node
	*/
	public void inAUIntNumericPrimitiveType(AUIntNumericPrimitiveType node, Q question) throws AnalysisException
	{
		defaultInSNumericPrimitiveType(node, question);
	}


	/**
	* Called by the {@link AUIntNumericPrimitiveType} node from {@link AUIntNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link AUIntNumericPrimitiveType} node
	*/
	public void outAUIntNumericPrimitiveType(AUIntNumericPrimitiveType node, Q question) throws AnalysisException
	{
		defaultOutSNumericPrimitiveType(node, question);
	}


	/**
	* Called by the {@link AFloatNumericPrimitiveType} node from {@link AFloatNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link AFloatNumericPrimitiveType} node
	*/
	public void caseAFloatNumericPrimitiveType(AFloatNumericPrimitiveType node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAFloatNumericPrimitiveType(node, question);


		outAFloatNumericPrimitiveType(node, question);

	}


	/**
	* Called by the {@link AFloatNumericPrimitiveType} node from {@link AFloatNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link AFloatNumericPrimitiveType} node
	*/
	public void inAFloatNumericPrimitiveType(AFloatNumericPrimitiveType node, Q question) throws AnalysisException
	{
		defaultInSNumericPrimitiveType(node, question);
	}


	/**
	* Called by the {@link AFloatNumericPrimitiveType} node from {@link AFloatNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link AFloatNumericPrimitiveType} node
	*/
	public void outAFloatNumericPrimitiveType(AFloatNumericPrimitiveType node, Q question) throws AnalysisException
	{
		defaultOutSNumericPrimitiveType(node, question);
	}


	/**
	* Called by the {@link AShortNumericPrimitiveType} node from {@link AShortNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link AShortNumericPrimitiveType} node
	*/
	public void caseAShortNumericPrimitiveType(AShortNumericPrimitiveType node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAShortNumericPrimitiveType(node, question);


		outAShortNumericPrimitiveType(node, question);

	}


	/**
	* Called by the {@link AShortNumericPrimitiveType} node from {@link AShortNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link AShortNumericPrimitiveType} node
	*/
	public void inAShortNumericPrimitiveType(AShortNumericPrimitiveType node, Q question) throws AnalysisException
	{
		defaultInSNumericPrimitiveType(node, question);
	}


	/**
	* Called by the {@link AShortNumericPrimitiveType} node from {@link AShortNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link AShortNumericPrimitiveType} node
	*/
	public void outAShortNumericPrimitiveType(AShortNumericPrimitiveType node, Q question) throws AnalysisException
	{
		defaultOutSNumericPrimitiveType(node, question);
	}


	/**
	* Called by the {@link AByteNumericPrimitiveType} node from {@link AByteNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link AByteNumericPrimitiveType} node
	*/
	public void caseAByteNumericPrimitiveType(AByteNumericPrimitiveType node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inAByteNumericPrimitiveType(node, question);


		outAByteNumericPrimitiveType(node, question);

	}


	/**
	* Called by the {@link AByteNumericPrimitiveType} node from {@link AByteNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link AByteNumericPrimitiveType} node
	*/
	public void inAByteNumericPrimitiveType(AByteNumericPrimitiveType node, Q question) throws AnalysisException
	{
		defaultInSNumericPrimitiveType(node, question);
	}


	/**
	* Called by the {@link AByteNumericPrimitiveType} node from {@link AByteNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link AByteNumericPrimitiveType} node
	*/
	public void outAByteNumericPrimitiveType(AByteNumericPrimitiveType node, Q question) throws AnalysisException
	{
		defaultOutSNumericPrimitiveType(node, question);
	}


	/**
	* Called by the {@link ALongNumericPrimitiveType} node from {@link ALongNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link ALongNumericPrimitiveType} node
	*/
	public void caseALongNumericPrimitiveType(ALongNumericPrimitiveType node, Q question) throws AnalysisException
	{
		_visitedNodes.add(node);
		inALongNumericPrimitiveType(node, question);


		outALongNumericPrimitiveType(node, question);

	}


	/**
	* Called by the {@link ALongNumericPrimitiveType} node from {@link ALongNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link ALongNumericPrimitiveType} node
	*/
	public void inALongNumericPrimitiveType(ALongNumericPrimitiveType node, Q question) throws AnalysisException
	{
		defaultInSNumericPrimitiveType(node, question);
	}


	/**
	* Called by the {@link ALongNumericPrimitiveType} node from {@link ALongNumericPrimitiveType#apply(IAnalysis)}.
	* @param node the calling {@link ALongNumericPrimitiveType} node
	*/
	public void outALongNumericPrimitiveType(ALongNumericPrimitiveType node, Q question) throws AnalysisException
	{
		defaultOutSNumericPrimitiveType(node, question);
	}


	/**
	* Called by the {@link INode} node from {@link INode#apply(IAnalysis)}.
	* @param node the calling {@link INode} node
	*/
	public void defaultOutINode(INode node, Q question) throws AnalysisException
	{
		//nothing to do
	}


	/**
	* Called by the {@link INode} node from {@link INode#apply(IAnalysis)}.
	* @param node the calling {@link INode} node
	*/
	public void defaultInINode(INode node, Q question) throws AnalysisException
	{
		//nothing to do
	}


	/**
	* Called by the {@link INode} node from {@link INode#apply(IAnalysis)}.
	* @param node the calling {@link INode} node
	*/
	public void defaultINode(INode node, Q question) throws AnalysisException
	{
		//nothing to do
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void defaultOutIToken(IToken node, Q question) throws AnalysisException
	{
		//nothing to do
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void defaultInIToken(IToken node, Q question) throws AnalysisException
	{
		//nothing to do
	}


	/**
	* Called by the {@link IToken} node from {@link IToken#apply(IAnalysis)}.
	* @param node the calling {@link IToken} node
	*/
	public void defaultIToken(IToken node, Q question) throws AnalysisException
	{
		//nothing to do
	}



}
