/*******************************************************************************
* Copyright (c) 2009, 2011 Overture Team and others.
*
* Overture is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Overture is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Overture.  If not, see <http://www.gnu.org/licenses/>.
*
* The Overture Tool web-site: http://overturetool.org/
*******************************************************************************/

/* This file was generated by ASTcreator (http://www.lausdahl.com/). */

package org.intocps.maestro.ast.node;


import org.intocps.maestro.ast.node.PExpBase;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.analysis.intf.IAnalysis;
import org.intocps.maestro.ast.analysis.AnalysisException;
import java.util.HashMap;
import org.intocps.maestro.ast.analysis.intf.IAnswer;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.AFieldExp;
import org.intocps.maestro.ast.analysis.intf.IQuestionAnswer;
import java.util.Map;
import java.lang.Boolean;
import org.intocps.maestro.ast.analysis.intf.IQuestion;
import java.lang.String;
import org.intocps.maestro.ast.node.INode;


/**
* Generated file by AST Creator
* @author Kenneth Lausdahl
*
*/
@SuppressWarnings({"all"})
public class AFieldExp extends PExpBase
{
	private static final long serialVersionUID = 1L;

	private PExp _root;
	private LexIdentifier _field;

	/**
	* Creates a new complete constructor {@code AFieldExp} node with the given nodes as children.
	* @deprecated This method should not be used, use AstFactory instead.
	* The basic child nodes are removed from their previous parents.
	* @param root_ the {@link PExp} node for the {@code root} child of this {@link AFieldExp} node
	* @param field_ the {@link LexIdentifier} node for the {@code field} child of this {@link AFieldExp} node
	*/
	public AFieldExp(PExp root_, LexIdentifier field_)
	{
		super();
		this.setRoot(root_);
		this.setField(field_);

	}



	/**
	 * Creates a new default constructor {@link AFieldExp} node with no children.
	 */
	public AFieldExp()
	{

	}


	/**
	 * Creates a deep clone of this {@link AFieldExp} node while putting all
	 * old node-new node relations in the map {@code oldToNewMap}.
	 * @param oldToNewMap the map filled with the old node-new node relation
	 * @return a deep clone of this {@link AFieldExp} node
	 */
	public AFieldExp clone(Map<INode,INode> oldToNewMap)
	{
		AFieldExp node = new AFieldExp(
			cloneNode(_root, oldToNewMap),
			_field
		);
		oldToNewMap.put(this, node);
		return node;
	}



	public String toString()
	{
		return "" + _root+"."+_field;
	}


	/**
	 * Returns a deep clone of this {@link AFieldExp} node.
	 * @return a deep clone of this {@link AFieldExp} node
	 */
	public AFieldExp clone()
	{
		return new AFieldExp(
			cloneNode(_root),
			_field
		);
	}


	/**
	* Forwarding hashCode call to {@link Object#hashCode()}.
	**/
	@Override
	public int hashCode()
	{
		return super.hashCode();
	}


	/**
	 * Removes the {@link INode} {@code child} as a child of this {@link AFieldExp} node.
	 * Do not call this method with any graph fields of this node. This will cause any child's
	 * with the same reference to be removed unintentionally or {@link RuntimeException}will be thrown.
	 * @param child the child node to be removed from this {@link AFieldExp} node
	 * @throws RuntimeException if {@code child} is not a child of this {@link AFieldExp} node
	 */
	public void removeChild(INode child)
	{
		if (this._root == child) {
			this._root = null;
			return;
		}

		throw new RuntimeException("Not a child.");
	}


	/**
	 * Creates a map of all field names and their value
	 * @param includeInheritedFields if true all inherited fields are included
	 * @return a a map of names to values of all fields
	 */
	@Override
	public Map<String,Object> getChildren(Boolean includeInheritedFields)
	{
		Map<String,Object> fields = new HashMap<String,Object>();
		if(includeInheritedFields)
		{
			fields.putAll(super.getChildren(includeInheritedFields));
		}
		fields.put("_root",this._root);
		fields.put("_field",this._field);
		return fields;
	}


	/**
	* Essentially this.toString().equals(o.toString()).
	**/
	@Override
	public boolean equals(Object o)
	{
		if (o != null && o instanceof AFieldExp)		{
			 return toString().equals(o.toString());
		}
		return false;
	}


	/**
	 * Sets the {@code _root} child of this {@link AFieldExp} node.
	 * @param value the new {@code _root} child of this {@link AFieldExp} node
	*/
	public void setRoot(PExp value)
	{
		if (this._root != null) {
			this._root.parent(null);
		}
		if (value != null) {
			if (value.parent() != null) {
				value.parent().removeChild(value);
		}
			value.parent(this);
		}
		this._root = value;

	}


	/**
	 * @return the {@link PExp} node which is the {@code _root} child of this {@link AFieldExp} node
	*/
	public PExp getRoot()
	{
		return this._root;
	}


	/**
	 * Sets the {@code _field} child of this {@link AFieldExp} node.
	 * @param value the new {@code _field} child of this {@link AFieldExp} node
	*/
	public void setField(LexIdentifier value)
	{
		this._field = value;
	}


	/**
	 * @return the {@link LexIdentifier} node which is the {@code _field} child of this {@link AFieldExp} node
	*/
	public LexIdentifier getField()
	{
		return this._field;
	}


	/**
	* Calls the {@link IAnalysis#caseAFieldExp(AFieldExp)} of the {@link IAnalysis} {@code caller}.
	* @param caller the {@link IAnalysis} to which this {@link AFieldExp} node is applied
	*/
	@Override
	public void apply(IAnalysis caller) throws AnalysisException
	{
		caller.caseAFieldExp(this);
	}


	/**
	* Calls the {@link IAnswer#caseAFieldExp(AFieldExp)} of the {@link IAnswer} {@code caller}.
	* @param caller the {@link IAnswer} to which this {@link AFieldExp} node is applied
	*/
	@Override
	public <A> A apply(IAnswer<A> caller) throws AnalysisException
	{
		return caller.caseAFieldExp(this);
	}


	/**
	* Calls the {@link IQuestion#caseAFieldExp(AFieldExp, Object)} of the {@link IQuestion} {@code caller}.
	* @param caller the {@link IQuestion} to which this {@link AFieldExp} node is applied
	* @param question the question provided to {@code caller}
	*/
	@Override
	public <Q> void apply(IQuestion<Q> caller, Q question) throws AnalysisException
	{
		caller.caseAFieldExp(this,question);
	}


	/**
	* Calls the {@link IQuestionAnswer#caseAFieldExp(AFieldExp, Object)} of the {@link IQuestionAnswer} {@code caller}.
	* @param caller the {@link IQuestionAnswer} to which this {@link AFieldExp} node is applied
	* @param question the question provided to {@code caller}
	*/
	@Override
	public <Q, A> A apply(IQuestionAnswer<Q, A> caller, Q question) throws AnalysisException
	{
		return caller.caseAFieldExp(this,question);
	}



}
