/*******************************************************************************
* Copyright (c) 2009, 2011 Overture Team and others.
*
* Overture is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Overture is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Overture.  If not, see <http://www.gnu.org/licenses/>.
*
* The Overture Tool web-site: http://overturetool.org/
*******************************************************************************/

/* This file was generated by ASTcreator (http://www.lausdahl.com/). */

package org.intocps.maestro.ast.node;


import org.intocps.maestro.ast.node.PExpBase;
import org.intocps.maestro.ast.analysis.intf.IAnalysis;
import org.intocps.maestro.ast.analysis.AnalysisException;
import java.util.HashMap;
import org.intocps.maestro.ast.node.ARefExp;
import org.intocps.maestro.ast.analysis.intf.IAnswer;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.analysis.intf.IQuestionAnswer;
import java.util.Map;
import java.lang.Boolean;
import org.intocps.maestro.ast.analysis.intf.IQuestion;
import java.lang.String;
import org.intocps.maestro.ast.node.INode;


/**
* Generated file by AST Creator
* @author Kenneth Lausdahl
*
*/
@SuppressWarnings({"all"})
public class ARefExp extends PExpBase
{
	private static final long serialVersionUID = 1L;

	private PExp _exp;

	/**
	* Creates a new complete constructor {@code ARefExp} node with the given nodes as children.
	* @deprecated This method should not be used, use AstFactory instead.
	* The basic child nodes are removed from their previous parents.
	* @param exp_ the {@link PExp} node for the {@code exp} child of this {@link ARefExp} node
	*/
	public ARefExp(PExp exp_)
	{
		super();
		this.setExp(exp_);

	}



	/**
	 * Creates a new default constructor {@link ARefExp} node with no children.
	 */
	public ARefExp()
	{

	}


	/**
	* Forwarding hashCode call to {@link Object#hashCode()}.
	**/
	@Override
	public int hashCode()
	{
		return super.hashCode();
	}


	/**
	 * Creates a map of all field names and their value
	 * @param includeInheritedFields if true all inherited fields are included
	 * @return a a map of names to values of all fields
	 */
	@Override
	public Map<String,Object> getChildren(Boolean includeInheritedFields)
	{
		Map<String,Object> fields = new HashMap<String,Object>();
		if(includeInheritedFields)
		{
			fields.putAll(super.getChildren(includeInheritedFields));
		}
		fields.put("_exp",this._exp);
		return fields;
	}


	/**
	 * Removes the {@link INode} {@code child} as a child of this {@link ARefExp} node.
	 * Do not call this method with any graph fields of this node. This will cause any child's
	 * with the same reference to be removed unintentionally or {@link RuntimeException}will be thrown.
	 * @param child the child node to be removed from this {@link ARefExp} node
	 * @throws RuntimeException if {@code child} is not a child of this {@link ARefExp} node
	 */
	public void removeChild(INode child)
	{
		if (this._exp == child) {
			this._exp = null;
			return;
		}

		throw new RuntimeException("Not a child.");
	}


	/**
	* Essentially this.toString().equals(o.toString()).
	**/
	@Override
	public boolean equals(Object o)
	{
		if (o != null && o instanceof ARefExp)		{
			 return toString().equals(o.toString());
		}
		return false;
	}



	public String toString()
	{
		return "" + "ref "+_exp;
	}


	/**
	 * Returns a deep clone of this {@link ARefExp} node.
	 * @return a deep clone of this {@link ARefExp} node
	 */
	public ARefExp clone()
	{
		return new ARefExp(
			cloneNode(_exp)
		);
	}


	/**
	 * Creates a deep clone of this {@link ARefExp} node while putting all
	 * old node-new node relations in the map {@code oldToNewMap}.
	 * @param oldToNewMap the map filled with the old node-new node relation
	 * @return a deep clone of this {@link ARefExp} node
	 */
	public ARefExp clone(Map<INode,INode> oldToNewMap)
	{
		ARefExp node = new ARefExp(
			cloneNode(_exp, oldToNewMap)
		);
		oldToNewMap.put(this, node);
		return node;
	}


	/**
	 * Sets the {@code _exp} child of this {@link ARefExp} node.
	 * @param value the new {@code _exp} child of this {@link ARefExp} node
	*/
	public void setExp(PExp value)
	{
		if (this._exp != null) {
			this._exp.parent(null);
		}
		if (value != null) {
			if (value.parent() != null) {
				value.parent().removeChild(value);
		}
			value.parent(this);
		}
		this._exp = value;

	}


	/**
	 * @return the {@link PExp} node which is the {@code _exp} child of this {@link ARefExp} node
	*/
	public PExp getExp()
	{
		return this._exp;
	}


	/**
	* Calls the {@link IAnalysis#caseARefExp(ARefExp)} of the {@link IAnalysis} {@code caller}.
	* @param caller the {@link IAnalysis} to which this {@link ARefExp} node is applied
	*/
	@Override
	public void apply(IAnalysis caller) throws AnalysisException
	{
		caller.caseARefExp(this);
	}


	/**
	* Calls the {@link IAnswer#caseARefExp(ARefExp)} of the {@link IAnswer} {@code caller}.
	* @param caller the {@link IAnswer} to which this {@link ARefExp} node is applied
	*/
	@Override
	public <A> A apply(IAnswer<A> caller) throws AnalysisException
	{
		return caller.caseARefExp(this);
	}


	/**
	* Calls the {@link IQuestion#caseARefExp(ARefExp, Object)} of the {@link IQuestion} {@code caller}.
	* @param caller the {@link IQuestion} to which this {@link ARefExp} node is applied
	* @param question the question provided to {@code caller}
	*/
	@Override
	public <Q> void apply(IQuestion<Q> caller, Q question) throws AnalysisException
	{
		caller.caseARefExp(this,question);
	}


	/**
	* Calls the {@link IQuestionAnswer#caseARefExp(ARefExp, Object)} of the {@link IQuestionAnswer} {@code caller}.
	* @param caller the {@link IQuestionAnswer} to which this {@link ARefExp} node is applied
	* @param question the question provided to {@code caller}
	*/
	@Override
	public <Q, A> A apply(IQuestionAnswer<Q, A> caller, Q question) throws AnalysisException
	{
		return caller.caseARefExp(this,question);
	}



}
