/*******************************************************************************
* Copyright (c) 2009, 2011 Overture Team and others.
*
* Overture is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Overture is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Overture.  If not, see <http://www.gnu.org/licenses/>.
*
* The Overture Tool web-site: http://overturetool.org/
*******************************************************************************/

/* This file was generated by ASTcreator (http://www.lausdahl.com/). */

package org.intocps.maestro.ast.node;


import org.intocps.maestro.ast.node.ASimulationSpecificationCompilationUnit;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.analysis.intf.IAnalysis;
import org.intocps.maestro.ast.analysis.AnalysisException;
import org.intocps.maestro.ast.node.PCompilationUnitBase;
import java.util.HashMap;
import org.intocps.maestro.ast.analysis.intf.IAnswer;
import java.util.stream.Collectors;
import java.util.List;
import java.util.Vector;
import org.intocps.maestro.ast.analysis.intf.IQuestionAnswer;
import org.intocps.maestro.ast.node.NodeList;
import java.util.Map;
import org.intocps.maestro.ast.node.PStm;
import java.lang.Boolean;
import org.intocps.maestro.ast.analysis.intf.IQuestion;
import java.lang.String;
import org.intocps.maestro.ast.node.AConfigFramework;
import java.util.LinkedList;
import org.intocps.maestro.ast.node.INode;


/**
* Generated file by AST Creator
* @author Kenneth Lausdahl
*
*/
@SuppressWarnings({"all"})
public class ASimulationSpecificationCompilationUnit extends PCompilationUnitBase
{
	private static final long serialVersionUID = 1L;

	private PStm _body;
	private List<? extends LexIdentifier> _imports = new Vector<LexIdentifier>();
	private List<? extends LexIdentifier> _framework = new Vector<LexIdentifier>();
	private NodeList<AConfigFramework> _frameworkConfigs = new NodeList<AConfigFramework>(this);


	/**
	* Creates a new complete constructor {@code ASimulationSpecificationCompilationUnit} node with the given nodes as children.
	* @deprecated This method should not be used, use AstFactory instead.
	* The basic child nodes are removed from their previous parents.
	* @param body_ the {@link PStm} node for the {@code body} child of this {@link ASimulationSpecificationCompilationUnit} node
	* @param imports_ the {@link List} node for the {@code imports} child of this {@link ASimulationSpecificationCompilationUnit} node
	* @param framework_ the {@link List} node for the {@code framework} child of this {@link ASimulationSpecificationCompilationUnit} node
	* @param frameworkConfigs_ the {@link NodeList} node for the {@code frameworkConfigs} child of this {@link ASimulationSpecificationCompilationUnit} node
	*/
	public ASimulationSpecificationCompilationUnit(PStm body_, List<? extends LexIdentifier> imports_, List<? extends LexIdentifier> framework_, List<? extends AConfigFramework> frameworkConfigs_)
	{
		super();
		this.setBody(body_);
		this.setImports(imports_);
		this.setFramework(framework_);
		this.setFrameworkConfigs(frameworkConfigs_);

	}


	/**
	 * Creates a new default constructor {@link ASimulationSpecificationCompilationUnit} node with no children.
	 */
	public ASimulationSpecificationCompilationUnit()
	{

	}


	/**
	 * Removes the {@link INode} {@code child} as a child of this {@link ASimulationSpecificationCompilationUnit} node.
	 * Do not call this method with any graph fields of this node. This will cause any child's
	 * with the same reference to be removed unintentionally or {@link RuntimeException}will be thrown.
	 * @param child the child node to be removed from this {@link ASimulationSpecificationCompilationUnit} node
	 * @throws RuntimeException if {@code child} is not a child of this {@link ASimulationSpecificationCompilationUnit} node
	 */
	public void removeChild(INode child)
	{
		if (this._body == child) {
			this._body = null;
			return;
		}

		if (this._frameworkConfigs.remove(child)) {
				return;
		}
		throw new RuntimeException("Not a child.");
	}


	/**
	 * Creates a map of all field names and their value
	 * @param includeInheritedFields if true all inherited fields are included
	 * @return a a map of names to values of all fields
	 */
	@Override
	public Map<String,Object> getChildren(Boolean includeInheritedFields)
	{
		Map<String,Object> fields = new HashMap<String,Object>();
		if(includeInheritedFields)
		{
			fields.putAll(super.getChildren(includeInheritedFields));
		}
		fields.put("_body",this._body);
		fields.put("_imports",this._imports);
		fields.put("_framework",this._framework);
		fields.put("_frameworkConfigs",this._frameworkConfigs);
		return fields;
	}



	public String toString()
	{
		return "" + "simulation "+ _imports.stream().map( s-> "import " + "" + s.toString()).collect(Collectors.joining(";\n","\n",";\n"))+ (_framework.isEmpty()?"":_framework.stream().map( s->"\""+  s.getText()+"\"").collect(Collectors.joining(",","\n@Framework(",");\n"))) + (_frameworkConfigs.isEmpty()?"":_frameworkConfigs.stream().map( s->  s.toString()).collect(Collectors.joining(";","\n;","\n")))+_body;
	}


	/**
	* Essentially this.toString().equals(o.toString()).
	**/
	@Override
	public boolean equals(Object o)
	{
		if (o != null && o instanceof ASimulationSpecificationCompilationUnit)		{
			 return toString().equals(o.toString());
		}
		return false;
	}


	/**
	 * Returns a deep clone of this {@link ASimulationSpecificationCompilationUnit} node.
	 * @return a deep clone of this {@link ASimulationSpecificationCompilationUnit} node
	 */
	public ASimulationSpecificationCompilationUnit clone()
	{
		return new ASimulationSpecificationCompilationUnit(
			cloneNode(_body),
			cloneListExternal(_imports),
			cloneListExternal(_framework),
			cloneList(_frameworkConfigs)
		);
	}


	/**
	* Forwarding hashCode call to {@link Object#hashCode()}.
	**/
	@Override
	public int hashCode()
	{
		return super.hashCode();
	}


	/**
	 * Creates a deep clone of this {@link ASimulationSpecificationCompilationUnit} node while putting all
	 * old node-new node relations in the map {@code oldToNewMap}.
	 * @param oldToNewMap the map filled with the old node-new node relation
	 * @return a deep clone of this {@link ASimulationSpecificationCompilationUnit} node
	 */
	public ASimulationSpecificationCompilationUnit clone(Map<INode,INode> oldToNewMap)
	{
		ASimulationSpecificationCompilationUnit node = new ASimulationSpecificationCompilationUnit(
			cloneNode(_body, oldToNewMap),
			cloneListExternal(_imports, oldToNewMap),
			cloneListExternal(_framework, oldToNewMap),
			cloneList(_frameworkConfigs, oldToNewMap)
		);
		oldToNewMap.put(this, node);
		return node;
	}


	/**
	 * Sets the {@code _body} child of this {@link ASimulationSpecificationCompilationUnit} node.
	 * @param value the new {@code _body} child of this {@link ASimulationSpecificationCompilationUnit} node
	*/
	public void setBody(PStm value)
	{
		if (this._body != null) {
			this._body.parent(null);
		}
		if (value != null) {
			if (value.parent() != null) {
				value.parent().removeChild(value);
		}
			value.parent(this);
		}
		this._body = value;

	}


	/**
	 * @return the {@link PStm} node which is the {@code _body} child of this {@link ASimulationSpecificationCompilationUnit} node
	*/
	public PStm getBody()
	{
		return this._body;
	}


	/**
	 * Sets the {@code _imports} child of this {@link ASimulationSpecificationCompilationUnit} node.
	 * @param value the new {@code _imports} child of this {@link ASimulationSpecificationCompilationUnit} node
	*/
	public void setImports(List<? extends LexIdentifier> value)
	{
		this._imports = value;
	}


	/**
	 * @return the {@link List} node which is the {@code _imports} child of this {@link ASimulationSpecificationCompilationUnit} node
	*/
	public List<? extends LexIdentifier> getImports()
	{
		return this._imports;
	}


	/**
	 * Sets the {@code _framework} child of this {@link ASimulationSpecificationCompilationUnit} node.
	 * @param value the new {@code _framework} child of this {@link ASimulationSpecificationCompilationUnit} node
	*/
	public void setFramework(List<? extends LexIdentifier> value)
	{
		this._framework = value;
	}


	/**
	 * @return the {@link List} node which is the {@code _framework} child of this {@link ASimulationSpecificationCompilationUnit} node
	*/
	public List<? extends LexIdentifier> getFramework()
	{
		return this._framework;
	}


	/**
	 * Sets the {@code _frameworkConfigs} child of this {@link ASimulationSpecificationCompilationUnit} node.
	 * @param value the new {@code _frameworkConfigs} child of this {@link ASimulationSpecificationCompilationUnit} node
	*/
	public void setFrameworkConfigs(List<? extends AConfigFramework> value)
	{
		if (this._frameworkConfigs.equals(value)) {
			return;
		}
		this._frameworkConfigs.clear();
		if (value != null) {
			this._frameworkConfigs.addAll(value);
		}

	}


	/**
	 * @return the {@link LinkedList} node which is the {@code _frameworkConfigs} child of this {@link ASimulationSpecificationCompilationUnit} node
	*/
	public LinkedList<AConfigFramework> getFrameworkConfigs()
	{
		return this._frameworkConfigs;
	}


	/**
	* Calls the {@link IAnalysis#caseASimulationSpecificationCompilationUnit(ASimulationSpecificationCompilationUnit)} of the {@link IAnalysis} {@code caller}.
	* @param caller the {@link IAnalysis} to which this {@link ASimulationSpecificationCompilationUnit} node is applied
	*/
	@Override
	public void apply(IAnalysis caller) throws AnalysisException
	{
		caller.caseASimulationSpecificationCompilationUnit(this);
	}


	/**
	* Calls the {@link IAnswer#caseASimulationSpecificationCompilationUnit(ASimulationSpecificationCompilationUnit)} of the {@link IAnswer} {@code caller}.
	* @param caller the {@link IAnswer} to which this {@link ASimulationSpecificationCompilationUnit} node is applied
	*/
	@Override
	public <A> A apply(IAnswer<A> caller) throws AnalysisException
	{
		return caller.caseASimulationSpecificationCompilationUnit(this);
	}


	/**
	* Calls the {@link IQuestion#caseASimulationSpecificationCompilationUnit(ASimulationSpecificationCompilationUnit, Object)} of the {@link IQuestion} {@code caller}.
	* @param caller the {@link IQuestion} to which this {@link ASimulationSpecificationCompilationUnit} node is applied
	* @param question the question provided to {@code caller}
	*/
	@Override
	public <Q> void apply(IQuestion<Q> caller, Q question) throws AnalysisException
	{
		caller.caseASimulationSpecificationCompilationUnit(this,question);
	}


	/**
	* Calls the {@link IQuestionAnswer#caseASimulationSpecificationCompilationUnit(ASimulationSpecificationCompilationUnit, Object)} of the {@link IQuestionAnswer} {@code caller}.
	* @param caller the {@link IQuestionAnswer} to which this {@link ASimulationSpecificationCompilationUnit} node is applied
	* @param question the question provided to {@code caller}
	*/
	@Override
	public <Q, A> A apply(IQuestionAnswer<Q, A> caller, Q question) throws AnalysisException
	{
		return caller.caseASimulationSpecificationCompilationUnit(this,question);
	}



}
