/*******************************************************************************
* Copyright (c) 2009, 2011 Overture Team and others.
*
* Overture is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Overture is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Overture.  If not, see <http://www.gnu.org/licenses/>.
*
* The Overture Tool web-site: http://overturetool.org/
*******************************************************************************/

/* This file was generated by ASTcreator (http://www.lausdahl.com/). */

package org.intocps.maestro.ast.node;


import org.intocps.maestro.ast.node.PExpBase;
import org.intocps.maestro.ast.node.SUnaryExp;
import java.util.Map;
import java.lang.Boolean;
import java.util.HashMap;
import java.lang.String;
import org.intocps.maestro.ast.node.INode;
import org.intocps.maestro.ast.node.PExp;


/**
* Generated file by AST Creator
* @author Kenneth Lausdahl
*
*/
@SuppressWarnings({"all"})
public abstract class SUnaryExpBase extends PExpBase implements SUnaryExp
{
	private static final long serialVersionUID = 1L;

	protected PExp _exp;


	/**
	* Creates a new complete constructor {@code SUnaryExpBase} node with the given nodes as children.
	* @deprecated This method should not be used, use AstFactory instead.
	* The basic child nodes are removed from their previous parents.
	* @param exp_ the {@link PExp} node for the {@code exp} child of this {@link SUnaryExpBase} node
	*/
	public SUnaryExpBase(PExp exp_)
	{
		super();
		this.setExp(exp_);

	}


	/**
	 * Creates a new default constructor {@link SUnaryExpBase} node with no children.
	 */
	public SUnaryExpBase()
	{

	}


	/**
	 * Returns a deep clone of this {@link SUnaryExpBase} node.
	 * @return a deep clone of this {@link SUnaryExpBase} node
	 */
	@Override
	public abstract SUnaryExp clone();

	/**
	 * Creates a deep clone of this {@link SUnaryExpBase} node while putting all
	 * old node-new node relations in the map {@code oldToNewMap}.
	 * @param oldToNewMap the map filled with the old node-new node relation
	 * @return a deep clone of this {@link SUnaryExpBase} node
	 */
	@Override
	public abstract SUnaryExp clone(Map<INode,INode> oldToNewMap);

	/**
	 * Creates a map of all field names and their value
	 * @param includeInheritedFields if true all inherited fields are included
	 * @return a a map of names to values of all fields
	 */
	@Override
	public Map<String,Object> getChildren(Boolean includeInheritedFields)
	{
		Map<String,Object> fields = new HashMap<String,Object>();
		if(includeInheritedFields)
		{
			fields.putAll(super.getChildren(includeInheritedFields));
		}
		fields.put("_exp",this._exp);
		return fields;
	}


	/**
	* Essentially this.toString().equals(o.toString()).
	**/
	@Override
	public boolean equals(Object o)
	{
		if (o != null && o instanceof SUnaryExpBase)		{
			 return toString().equals(o.toString());
		}
		return false;
	}


	/**
	* Forwarding hashCode call to {@link Object#hashCode()}.
	**/
	@Override
	public int hashCode()
	{
		return super.hashCode();
	}



	public String toString()
	{
		return super.toString();

	}


	/**
	 * Removes the {@link INode} {@code child} as a child of this {@link SUnaryExpBase} node.
	 * Do not call this method with any graph fields of this node. This will cause any child's
	 * with the same reference to be removed unintentionally or {@link RuntimeException}will be thrown.
	 * @param child the child node to be removed from this {@link SUnaryExpBase} node
	 * @throws RuntimeException if {@code child} is not a child of this {@link SUnaryExpBase} node
	 */
	public void removeChild(INode child)
	{
		if (this._exp == child) {
			this._exp = null;
			return;
		}

		throw new RuntimeException("Not a child.");
	}


	/**
	 * Sets the {@code _exp} child of this {@link SUnaryExpBase} node.
	 * @param value the new {@code _exp} child of this {@link SUnaryExpBase} node
	*/
	public void setExp(PExp value)
	{
		if (this._exp != null) {
			this._exp.parent(null);
		}
		if (value != null) {
			if (value.parent() != null) {
				value.parent().removeChild(value);
		}
			value.parent(this);
		}
		this._exp = value;

	}


	/**
	 * @return the {@link PExp} node which is the {@code _exp} child of this {@link SUnaryExpBase} node
	*/
	public PExp getExp()
	{
		return this._exp;
	}



}
