/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.ast.node;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.LexToken;
import org.intocps.maestro.ast.analysis.AnalysisException;
import org.intocps.maestro.ast.analysis.intf.IAnalysis;
import org.intocps.maestro.ast.analysis.intf.IAnswer;
import org.intocps.maestro.ast.analysis.intf.IQuestion;
import org.intocps.maestro.ast.analysis.intf.IQuestionAnswer;
import org.intocps.maestro.ast.node.INode;
import org.intocps.maestro.ast.node.NodeList;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PExpBase;

public class ACallExp
extends PExpBase {
    private static final long serialVersionUID = 1L;
    private PExp _object;
    private LexToken _expand;
    private LexIdentifier _methodName;
    private NodeList<PExp> _args = new NodeList(this);

    public ACallExp() {
    }

    public ACallExp(PExp object_, LexToken expand_, LexIdentifier methodName_, List<? extends PExp> args_) {
        this.setObject(object_);
        this.setExpand(expand_);
        this.setMethodName(methodName_);
        this.setArgs(args_);
    }

    @Override
    public boolean equals(Object o) {
        if (o != null && o instanceof ACallExp) {
            return this.toString().equals(o.toString());
        }
        return false;
    }

    @Override
    public String toString() {
        return (String)(this._object == null ? "" : this._object + ".") + (String)(this._expand == null ? "" : this._expand.getText() + " ") + this._methodName + "(" + this._args.stream().map(Object::toString).collect(Collectors.joining(", ")) + ")";
    }

    @Override
    public ACallExp clone(Map<INode, INode> oldToNewMap) {
        ACallExp node = new ACallExp(this.cloneNode(this._object, oldToNewMap), this.cloneNode(this._expand, oldToNewMap), this._methodName, this.cloneList(this._args, oldToNewMap));
        oldToNewMap.put(this, node);
        return node;
    }

    @Override
    public void removeChild(INode child) {
        if (this._object == child) {
            this._object = null;
            return;
        }
        if (this._expand == child) {
            this._expand = null;
            return;
        }
        if (this._args.remove(child)) {
            return;
        }
        throw new RuntimeException("Not a child.");
    }

    @Override
    public Map<String, Object> getChildren(Boolean includeInheritedFields) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        if (includeInheritedFields.booleanValue()) {
            fields.putAll(super.getChildren(includeInheritedFields));
        }
        fields.put("_object", this._object);
        fields.put("_expand", this._expand);
        fields.put("_methodName", this._methodName);
        fields.put("_args", this._args);
        return fields;
    }

    @Override
    public ACallExp clone() {
        return new ACallExp(this.cloneNode(this._object), this.cloneNode(this._expand), this._methodName, this.cloneList(this._args));
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public void setObject(PExp value) {
        if (this._object != null) {
            this._object.parent(null);
        }
        if (value != null) {
            if (value.parent() != null) {
                value.parent().removeChild(value);
            }
            value.parent(this);
        }
        this._object = value;
    }

    public PExp getObject() {
        return this._object;
    }

    public void setExpand(LexToken value) {
        if (this._expand != null) {
            this._expand.parent(null);
        }
        if (value != null) {
            if (value.parent() != null) {
                value.parent().removeChild(value);
            }
            value.parent(this);
        }
        this._expand = value;
    }

    public LexToken getExpand() {
        return this._expand;
    }

    public void setMethodName(LexIdentifier value) {
        this._methodName = value;
    }

    public LexIdentifier getMethodName() {
        return this._methodName;
    }

    public void setArgs(List<? extends PExp> value) {
        if (this._args.equals(value)) {
            return;
        }
        this._args.clear();
        if (value != null) {
            this._args.addAll(value);
        }
    }

    public LinkedList<PExp> getArgs() {
        return this._args;
    }

    @Override
    public void apply(IAnalysis caller) throws AnalysisException {
        caller.caseACallExp(this);
    }

    @Override
    public <A> A apply(IAnswer<A> caller) throws AnalysisException {
        return caller.caseACallExp(this);
    }

    @Override
    public <Q> void apply(IQuestion<Q> caller, Q question) throws AnalysisException {
        caller.caseACallExp(this, question);
    }

    @Override
    public <Q, A> A apply(IQuestionAnswer<Q, A> caller, Q question) throws AnalysisException {
        return caller.caseACallExp(this, question);
    }
}

