/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.ast.node;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.intocps.maestro.ast.analysis.AnalysisException;
import org.intocps.maestro.ast.analysis.intf.IAnalysis;
import org.intocps.maestro.ast.analysis.intf.IAnswer;
import org.intocps.maestro.ast.analysis.intf.IQuestion;
import org.intocps.maestro.ast.analysis.intf.IQuestionAnswer;
import org.intocps.maestro.ast.node.ExternalNode;
import org.intocps.maestro.ast.node.INode;

public abstract class Node
implements INode,
Cloneable,
Serializable,
Comparable<INode> {
    private static final long serialVersionUID = 1L;
    private INode parent;
    protected Set _visitedNodes = new HashSet();

    @Override
    public abstract Object clone();

    @Override
    public abstract INode clone(Map<INode, INode> var1);

    @Override
    public INode parent() {
        return this.parent;
    }

    @Override
    public void parent(INode parent) {
        this.parent = parent;
    }

    @Override
    public abstract void removeChild(INode var1);

    @Override
    public void replaceChild(INode oldChild, INode newChild) {
        Class<?> me = this.getClass();
        for (Field f : Node.getAllFields(new LinkedList<Field>(), me)) {
            f.setAccessible(true);
            try {
                Object valueInF = f.get(this);
                INode oldParent = oldChild.parent();
                if (valueInF == oldChild) {
                    f.set(this, newChild);
                    if (this == oldParent) {
                        newChild.parent(this);
                    }
                    return;
                }
                if (!(valueInF instanceof List)) continue;
                List list = (List)valueInF;
                for (int i = 0; i < list.size(); ++i) {
                    if (list.get(i) != oldChild) continue;
                    list.set(i, newChild);
                    if (this == oldParent) {
                        newChild.parent(this);
                    }
                    return;
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public static List<Field> getAllFields(List<Field> fields, Class<?> type) {
        for (Field field : type.getDeclaredFields()) {
            fields.add(field);
        }
        if (type.getSuperclass() != null) {
            fields = Node.getAllFields(fields, type.getSuperclass());
        }
        return fields;
    }

    protected <T extends INode> T cloneNode(T node) {
        if (node != null) {
            return (T)((INode)node.clone());
        }
        return null;
    }

    protected <T extends ExternalNode> T cloneNode(T node) {
        if (node != null) {
            return (T)((ExternalNode)node.clone());
        }
        return null;
    }

    protected <T extends INode> T cloneNode(T node, Map<INode, INode> oldToNewMap) {
        if (node != null) {
            INode clone = node.clone(oldToNewMap);
            oldToNewMap.put(node, clone);
            return (T)clone;
        }
        return null;
    }

    protected <T extends ExternalNode> T cloneNode(T node, Map<INode, INode> oldToNewMap) {
        if (node != null) {
            ExternalNode clone = (ExternalNode)node.clone();
            return (T)clone;
        }
        return null;
    }

    protected <T extends INode> List<T> cloneList(List<T> list) {
        LinkedList<INode> clone = new LinkedList<INode>();
        for (INode n : list) {
            clone.add((INode)n.clone());
        }
        return clone;
    }

    protected <T extends ExternalNode> List<T> cloneListExternal(List<T> list) {
        LinkedList<ExternalNode> clone = new LinkedList<ExternalNode>();
        for (ExternalNode n : list) {
            clone.add((ExternalNode)n.clone());
        }
        return clone;
    }

    protected <T extends INode> Collection<? extends List<T>> cloneListList(List<? extends List<T>> list) {
        LinkedList<List<T>> clone = new LinkedList<List<T>>();
        for (List<T> n : list) {
            clone.add(this.cloneList(n));
        }
        return clone;
    }

    protected <T extends INode> List<T> cloneList(List<T> list, Map<INode, INode> oldToNewMap) {
        LinkedList<INode> clone = new LinkedList<INode>();
        for (INode n : list) {
            INode cloneNode = n.clone(oldToNewMap);
            oldToNewMap.put(n, cloneNode);
            clone.add(cloneNode);
        }
        return clone;
    }

    protected <T extends ExternalNode> List<T> cloneListExternal(List<T> list, Map<INode, INode> oldToNewMap) {
        LinkedList<ExternalNode> clone = new LinkedList<ExternalNode>();
        for (ExternalNode n : list) {
            ExternalNode cloneNode = (ExternalNode)n.clone();
            clone.add(cloneNode);
        }
        return clone;
    }

    protected <T extends INode> Collection<? extends List<T>> cloneListList(List<? extends List<T>> list, Map<INode, INode> oldToNewMap) {
        LinkedList<List<T>> clone = new LinkedList<List<T>>();
        for (List<T> n : list) {
            clone.add(this.cloneList(n, oldToNewMap));
        }
        return clone;
    }

    @Override
    public <T extends INode> T getAncestor(Class<T> classType) {
        INode n = this;
        while (!classType.isInstance(n)) {
            this._visitedNodes.add(n);
            if ((n = n.parent()) != null && !this._visitedNodes.contains(n)) continue;
            this._visitedNodes.clear();
            return null;
        }
        this._visitedNodes.clear();
        return (T)((INode)classType.cast(n));
    }

    @Override
    public int compareTo(INode o) {
        return this.toString().compareTo(o.toString());
    }

    @Override
    public abstract void apply(IAnalysis var1) throws AnalysisException;

    @Override
    public abstract <A> A apply(IAnswer<A> var1) throws AnalysisException;

    @Override
    public abstract <Q> void apply(IQuestion<Q> var1, Q var2) throws AnalysisException;

    @Override
    public abstract <Q, A> A apply(IQuestionAnswer<Q, A> var1, Q var2) throws AnalysisException;

    @Override
    public Map<String, Object> getChildren(Boolean includeInheritedFields) {
        return new HashMap<String, Object>();
    }
}

