/*******************************************************************************
* Copyright (c) 2009, 2011 Overture Team and others.
*
* Overture is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Overture is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Overture.  If not, see <http://www.gnu.org/licenses/>.
*
* The Overture Tool web-site: http://overturetool.org/
*******************************************************************************/

/* This file was generated by ASTcreator (http://www.lausdahl.com/). */

package org.intocps.maestro.ast.node;


import org.intocps.maestro.ast.node.AStringLiteralExp;
import org.intocps.maestro.ast.analysis.intf.IAnalysis;
import org.intocps.maestro.ast.analysis.AnalysisException;
import java.util.HashMap;
import org.intocps.maestro.ast.analysis.intf.IAnswer;
import java.util.stream.Collectors;
import java.util.List;
import org.intocps.maestro.ast.node.PStmBase;
import org.intocps.maestro.ast.analysis.intf.IQuestionAnswer;
import org.intocps.maestro.ast.node.NodeList;
import java.util.Map;
import java.lang.Boolean;
import org.intocps.maestro.ast.analysis.intf.IQuestion;
import org.intocps.maestro.ast.node.ATransferAsStm;
import java.lang.String;
import java.util.LinkedList;
import org.intocps.maestro.ast.node.INode;


/**
* Generated file by AST Creator
* @author Kenneth Lausdahl
*
*/
@SuppressWarnings({"all"})
public class ATransferAsStm extends PStmBase
{
	private static final long serialVersionUID = 1L;

	private NodeList<AStringLiteralExp> _names = new NodeList<AStringLiteralExp>(this);

	/**
	* Creates a new complete constructor {@code ATransferAsStm} node with the given nodes as children.
	* @deprecated This method should not be used, use AstFactory instead.
	* The basic child nodes are removed from their previous parents.
	* @param names_ the {@link NodeList} node for the {@code names} child of this {@link ATransferAsStm} node
	*/
	public ATransferAsStm(List<? extends AStringLiteralExp> names_)
	{
		super();
		this.setNames(names_);

	}


	/**
	 * Creates a new default constructor {@link ATransferAsStm} node with no children.
	 */
	public ATransferAsStm()
	{

	}



	/**
	 * Returns a deep clone of this {@link ATransferAsStm} node.
	 * @return a deep clone of this {@link ATransferAsStm} node
	 */
	public ATransferAsStm clone()
	{
		return new ATransferAsStm(
			cloneList(_names)
		);
	}


	/**
	 * Creates a deep clone of this {@link ATransferAsStm} node while putting all
	 * old node-new node relations in the map {@code oldToNewMap}.
	 * @param oldToNewMap the map filled with the old node-new node relation
	 * @return a deep clone of this {@link ATransferAsStm} node
	 */
	public ATransferAsStm clone(Map<INode,INode> oldToNewMap)
	{
		ATransferAsStm node = new ATransferAsStm(
			cloneList(_names, oldToNewMap)
		);
		oldToNewMap.put(this, node);
		return node;
	}



	public String toString()
	{
		return "" + "@TransferAs("+_names.stream().map(Object::toString).collect(Collectors.joining(","))+")";
	}


	/**
	* Essentially this.toString().equals(o.toString()).
	**/
	@Override
	public boolean equals(Object o)
	{
		if (o != null && o instanceof ATransferAsStm)		{
			 return toString().equals(o.toString());
		}
		return false;
	}


	/**
	 * Removes the {@link INode} {@code child} as a child of this {@link ATransferAsStm} node.
	 * Do not call this method with any graph fields of this node. This will cause any child's
	 * with the same reference to be removed unintentionally or {@link RuntimeException}will be thrown.
	 * @param child the child node to be removed from this {@link ATransferAsStm} node
	 * @throws RuntimeException if {@code child} is not a child of this {@link ATransferAsStm} node
	 */
	public void removeChild(INode child)
	{
		if (this._names.remove(child)) {
				return;
		}
		throw new RuntimeException("Not a child.");
	}


	/**
	* Forwarding hashCode call to {@link Object#hashCode()}.
	**/
	@Override
	public int hashCode()
	{
		return super.hashCode();
	}


	/**
	 * Creates a map of all field names and their value
	 * @param includeInheritedFields if true all inherited fields are included
	 * @return a a map of names to values of all fields
	 */
	@Override
	public Map<String,Object> getChildren(Boolean includeInheritedFields)
	{
		Map<String,Object> fields = new HashMap<String,Object>();
		if(includeInheritedFields)
		{
			fields.putAll(super.getChildren(includeInheritedFields));
		}
		fields.put("_names",this._names);
		return fields;
	}


	/**
	 * Sets the {@code _names} child of this {@link ATransferAsStm} node.
	 * @param value the new {@code _names} child of this {@link ATransferAsStm} node
	*/
	public void setNames(List<? extends AStringLiteralExp> value)
	{
		if (this._names.equals(value)) {
			return;
		}
		this._names.clear();
		if (value != null) {
			this._names.addAll(value);
		}

	}


	/**
	 * @return the {@link LinkedList} node which is the {@code _names} child of this {@link ATransferAsStm} node
	*/
	public LinkedList<AStringLiteralExp> getNames()
	{
		return this._names;
	}


	/**
	* Calls the {@link IAnalysis#caseATransferAsStm(ATransferAsStm)} of the {@link IAnalysis} {@code caller}.
	* @param caller the {@link IAnalysis} to which this {@link ATransferAsStm} node is applied
	*/
	@Override
	public void apply(IAnalysis caller) throws AnalysisException
	{
		caller.caseATransferAsStm(this);
	}


	/**
	* Calls the {@link IAnswer#caseATransferAsStm(ATransferAsStm)} of the {@link IAnswer} {@code caller}.
	* @param caller the {@link IAnswer} to which this {@link ATransferAsStm} node is applied
	*/
	@Override
	public <A> A apply(IAnswer<A> caller) throws AnalysisException
	{
		return caller.caseATransferAsStm(this);
	}


	/**
	* Calls the {@link IQuestion#caseATransferAsStm(ATransferAsStm, Object)} of the {@link IQuestion} {@code caller}.
	* @param caller the {@link IQuestion} to which this {@link ATransferAsStm} node is applied
	* @param question the question provided to {@code caller}
	*/
	@Override
	public <Q> void apply(IQuestion<Q> caller, Q question) throws AnalysisException
	{
		caller.caseATransferAsStm(this,question);
	}


	/**
	* Calls the {@link IQuestionAnswer#caseATransferAsStm(ATransferAsStm, Object)} of the {@link IQuestionAnswer} {@code caller}.
	* @param caller the {@link IQuestionAnswer} to which this {@link ATransferAsStm} node is applied
	* @param question the question provided to {@code caller}
	*/
	@Override
	public <Q, A> A apply(IQuestionAnswer<Q, A> caller, Q question) throws AnalysisException
	{
		return caller.caseATransferAsStm(this,question);
	}



}
