/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.ast.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.intocps.maestro.ast.node.INode;
import org.intocps.maestro.ast.node.NodeList;

public class NodeListList<E extends INode>
extends LinkedList<List<E>> {
    INode parent;

    private boolean CanNullParentOfInnerList(List<? extends E> list, INode parent) {
        for (INode e : list) {
            if (e.parent() == parent) continue;
            return false;
        }
        return true;
    }

    protected void setParentOfInnterList(List<? extends E> list, INode parent) {
        for (INode e : list) {
            e.parent(parent);
        }
    }

    protected void setParent(List<? extends E> list) {
        for (INode n : list) {
            INode p = n.parent();
            if (p != null) {
                p.removeChild(n);
            }
            n.parent(this.parent);
        }
    }

    private NodeListList() {
        this.parent = null;
    }

    public NodeListList(INode parent) {
        this.parent = parent;
    }

    public NodeListList(INode parent, Collection<List<E>> c) {
        this(parent);
        this.addAll(c);
    }

    @Override
    public boolean add(List<E> o) {
        this.setParent(o);
        return super.add(o);
    }

    @Override
    public void addFirst(List<E> o) {
        this.setParent(o);
        super.addFirst(o);
    }

    @Override
    public void addLast(List<E> o) {
        this.setParent(o);
        super.addLast(o);
    }

    @Override
    public boolean remove(Object o) {
        if (super.remove(o) && ((INode)o).parent() == this.parent) {
            ((INode)o).parent(null);
            return true;
        }
        return false;
    }

    @Override
    public List<E> removeFirst() {
        List o = (List)super.removeFirst();
        if (this.CanNullParentOfInnerList(o, this.parent)) {
            this.setParentOfInnterList(o, null);
        }
        return o;
    }

    @Override
    public List<E> removeLast() {
        List o = (List)super.removeLast();
        if (this.CanNullParentOfInnerList(o, this.parent)) {
            this.setParentOfInnterList(o, null);
        }
        return o;
    }

    @Override
    public void clear() {
        for (List o : this) {
            if (!this.CanNullParentOfInnerList(o, this.parent)) continue;
            this.setParentOfInnterList(o, null);
        }
        super.clear();
    }

    @Override
    public Object clone() {
        LinkedList clone = new LinkedList();
        for (List list : this) {
            NodeList<INode> ll = new NodeList<INode>(null);
            for (INode e : list) {
                ll.add((INode)e.clone());
            }
            clone.add(ll);
        }
        return clone;
    }

    @Override
    public List<E> remove(int index) {
        List old = (List)super.remove(index);
        if (this.CanNullParentOfInnerList(old, this.parent)) {
            this.setParentOfInnterList(old, null);
        }
        return old;
    }

    @Override
    public boolean addAll(int index, Collection<? extends List<E>> c) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
        }
        if (c == this) {
            return false;
        }
        int i = 0;
        for (List elem : this) {
            if (i >= index) break;
            if (c.contains(elem)) {
                --index;
            }
            ++i;
        }
        ArrayList<List<E>> copy = new ArrayList<List<E>>(c);
        for (List<E> o : copy) {
            this.setParent(o);
        }
        return super.addAll(index, copy);
    }

    @Override
    public void add(int index, List<E> o) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
        }
        int i = 0;
        for (List elem : this) {
            if (i >= index) break;
            if (elem == o) {
                --index;
            }
            ++i;
        }
        this.setParent(o);
        super.add(index, o);
    }

    @Override
    public List<E> set(int index, List<E> o) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
        }
        int i = 0;
        for (List elem : this) {
            if (i == index && elem == o) {
                return o;
            }
            if (i >= index) break;
            if (elem == o) {
                --index;
            }
            ++i;
        }
        this.setParent(o);
        List<E> old = super.set(index, o);
        if (this.CanNullParentOfInnerList(old, this.parent)) {
            this.setParentOfInnterList(old, null);
        }
        return old;
    }

    @Override
    public ListIterator<List<E>> listIterator(int index) {
        return new NodeListIterator(super.listIterator(index));
    }

    private class NodeListIterator
    implements ListIterator<List<E>> {
        ListIterator<List<E>> iterator;
        List<E> last_returned;

        NodeListIterator(ListIterator<List<E>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public List<E> next() {
            this.last_returned = this.iterator.next();
            return this.last_returned;
        }

        @Override
        public boolean hasPrevious() {
            return this.iterator.hasPrevious();
        }

        @Override
        public List<E> previous() {
            this.last_returned = this.iterator.previous();
            return this.last_returned;
        }

        @Override
        public int nextIndex() {
            return this.iterator.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.iterator.previousIndex();
        }

        @Override
        public void remove() {
            this.iterator.remove();
            if (NodeListList.this.CanNullParentOfInnerList(this.last_returned, NodeListList.this.parent)) {
                NodeListList.this.setParentOfInnterList(this.last_returned, null);
            }
        }

        @Override
        public void set(List<E> o) {
            this.iterator.set(o);
            if (o != this.last_returned) {
                NodeListList.this.setParent(o);
                if (NodeListList.this.CanNullParentOfInnerList(this.last_returned, NodeListList.this.parent)) {
                    NodeListList.this.setParentOfInnterList(this.last_returned, null);
                }
                this.last_returned = o;
            }
        }

        @Override
        public void add(List<E> o) {
            this.iterator.add(o);
            NodeListList.this.setParent(o);
        }
    }
}

