/*******************************************************************************
* Copyright (c) 2009, 2011 Overture Team and others.
*
* Overture is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Overture is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Overture.  If not, see <http://www.gnu.org/licenses/>.
*
* The Overture Tool web-site: http://overturetool.org/
*******************************************************************************/

/* This file was generated by ASTcreator (http://www.lausdahl.com/). */

package org.intocps.maestro.ast.node;


import org.intocps.maestro.ast.node.ACallExp;
import org.intocps.maestro.ast.node.PExpBase;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.analysis.intf.IAnalysis;
import org.intocps.maestro.ast.analysis.AnalysisException;
import java.util.HashMap;
import org.intocps.maestro.ast.analysis.intf.IAnswer;
import java.util.stream.Collectors;
import org.intocps.maestro.ast.node.PExp;
import java.util.List;
import org.intocps.maestro.ast.analysis.intf.IQuestionAnswer;
import org.intocps.maestro.ast.node.NodeList;
import org.intocps.maestro.ast.LexToken;
import java.util.Map;
import java.lang.Boolean;
import org.intocps.maestro.ast.analysis.intf.IQuestion;
import java.lang.String;
import java.util.LinkedList;
import org.intocps.maestro.ast.node.INode;


/**
* Generated file by AST Creator
* @author Kenneth Lausdahl
*
*/
@SuppressWarnings({"all"})
public class ACallExp extends PExpBase
{
	private static final long serialVersionUID = 1L;

	private PExp _object;
	private LexToken _expand;
	private LexIdentifier _methodName;
	private NodeList<PExp> _args = new NodeList<PExp>(this);


	/**
	 * Creates a new default constructor {@link ACallExp} node with no children.
	 */
	public ACallExp()
	{

	}


	/**
	* Creates a new complete constructor {@code ACallExp} node with the given nodes as children.
	* @deprecated This method should not be used, use AstFactory instead.
	* The basic child nodes are removed from their previous parents.
	* @param object_ the {@link PExp} node for the {@code object} child of this {@link ACallExp} node
	* @param expand_ the {@link LexToken} node for the {@code expand} child of this {@link ACallExp} node
	* @param methodName_ the {@link LexIdentifier} node for the {@code methodName} child of this {@link ACallExp} node
	* @param args_ the {@link NodeList} node for the {@code args} child of this {@link ACallExp} node
	*/
	public ACallExp(PExp object_, LexToken expand_, LexIdentifier methodName_, List<? extends PExp> args_)
	{
		super();
		this.setObject(object_);
		this.setExpand(expand_);
		this.setMethodName(methodName_);
		this.setArgs(args_);

	}


	/**
	* Forwarding hashCode call to {@link Object#hashCode()}.
	**/
	@Override
	public int hashCode()
	{
		return super.hashCode();
	}



	public String toString()
	{
		return "" + ""+ (_object==null?"":_object+".")+(_expand==null?"":_expand.getText()+ " ")+ _methodName +"(" +_args.stream().map(Object::toString).collect(Collectors.joining(", "))+")";
	}


	/**
	* Essentially this.toString().equals(o.toString()).
	**/
	@Override
	public boolean equals(Object o)
	{
		if (o != null && o instanceof ACallExp)		{
			 return toString().equals(o.toString());
		}
		return false;
	}


	/**
	 * Removes the {@link INode} {@code child} as a child of this {@link ACallExp} node.
	 * Do not call this method with any graph fields of this node. This will cause any child's
	 * with the same reference to be removed unintentionally or {@link RuntimeException}will be thrown.
	 * @param child the child node to be removed from this {@link ACallExp} node
	 * @throws RuntimeException if {@code child} is not a child of this {@link ACallExp} node
	 */
	public void removeChild(INode child)
	{
		if (this._object == child) {
			this._object = null;
			return;
		}

		if (this._expand == child) {
			this._expand = null;
			return;
		}

		if (this._args.remove(child)) {
				return;
		}
		throw new RuntimeException("Not a child.");
	}


	/**
	 * Returns a deep clone of this {@link ACallExp} node.
	 * @return a deep clone of this {@link ACallExp} node
	 */
	public ACallExp clone()
	{
		return new ACallExp(
			cloneNode(_object),
			cloneNode(_expand),
			_methodName,
			cloneList(_args)
		);
	}


	/**
	 * Creates a map of all field names and their value
	 * @param includeInheritedFields if true all inherited fields are included
	 * @return a a map of names to values of all fields
	 */
	@Override
	public Map<String,Object> getChildren(Boolean includeInheritedFields)
	{
		Map<String,Object> fields = new HashMap<String,Object>();
		if(includeInheritedFields)
		{
			fields.putAll(super.getChildren(includeInheritedFields));
		}
		fields.put("_object",this._object);
		fields.put("_expand",this._expand);
		fields.put("_methodName",this._methodName);
		fields.put("_args",this._args);
		return fields;
	}


	/**
	 * Creates a deep clone of this {@link ACallExp} node while putting all
	 * old node-new node relations in the map {@code oldToNewMap}.
	 * @param oldToNewMap the map filled with the old node-new node relation
	 * @return a deep clone of this {@link ACallExp} node
	 */
	public ACallExp clone(Map<INode,INode> oldToNewMap)
	{
		ACallExp node = new ACallExp(
			cloneNode(_object, oldToNewMap),
			cloneNode(_expand, oldToNewMap),
			_methodName,
			cloneList(_args, oldToNewMap)
		);
		oldToNewMap.put(this, node);
		return node;
	}


	/**
	 * Sets the {@code _object} child of this {@link ACallExp} node.
	 * @param value the new {@code _object} child of this {@link ACallExp} node
	*/
	public void setObject(PExp value)
	{
		if (this._object != null) {
			this._object.parent(null);
		}
		if (value != null) {
			if (value.parent() != null) {
				value.parent().removeChild(value);
		}
			value.parent(this);
		}
		this._object = value;

	}


	/**
	 * @return the {@link PExp} node which is the {@code _object} child of this {@link ACallExp} node
	*/
	public PExp getObject()
	{
		return this._object;
	}


	/**
	 * Sets the {@code _expand} child of this {@link ACallExp} node.
	 * @param value the new {@code _expand} child of this {@link ACallExp} node
	*/
	public void setExpand(LexToken value)
	{
		if (this._expand != null) {
			this._expand.parent(null);
		}
		if (value != null) {
			if (value.parent() != null) {
				value.parent().removeChild(value);
		}
			value.parent(this);
		}
		this._expand = value;

	}


	/**
	 * @return the {@link LexToken} node which is the {@code _expand} child of this {@link ACallExp} node
	*/
	public LexToken getExpand()
	{
		return this._expand;
	}


	/**
	 * Sets the {@code _methodName} child of this {@link ACallExp} node.
	 * @param value the new {@code _methodName} child of this {@link ACallExp} node
	*/
	public void setMethodName(LexIdentifier value)
	{
		this._methodName = value;
	}


	/**
	 * @return the {@link LexIdentifier} node which is the {@code _methodName} child of this {@link ACallExp} node
	*/
	public LexIdentifier getMethodName()
	{
		return this._methodName;
	}


	/**
	 * Sets the {@code _args} child of this {@link ACallExp} node.
	 * @param value the new {@code _args} child of this {@link ACallExp} node
	*/
	public void setArgs(List<? extends PExp> value)
	{
		if (this._args.equals(value)) {
			return;
		}
		this._args.clear();
		if (value != null) {
			this._args.addAll(value);
		}

	}


	/**
	 * @return the {@link LinkedList} node which is the {@code _args} child of this {@link ACallExp} node
	*/
	public LinkedList<PExp> getArgs()
	{
		return this._args;
	}


	/**
	* Calls the {@link IAnalysis#caseACallExp(ACallExp)} of the {@link IAnalysis} {@code caller}.
	* @param caller the {@link IAnalysis} to which this {@link ACallExp} node is applied
	*/
	@Override
	public void apply(IAnalysis caller) throws AnalysisException
	{
		caller.caseACallExp(this);
	}


	/**
	* Calls the {@link IAnswer#caseACallExp(ACallExp)} of the {@link IAnswer} {@code caller}.
	* @param caller the {@link IAnswer} to which this {@link ACallExp} node is applied
	*/
	@Override
	public <A> A apply(IAnswer<A> caller) throws AnalysisException
	{
		return caller.caseACallExp(this);
	}


	/**
	* Calls the {@link IQuestion#caseACallExp(ACallExp, Object)} of the {@link IQuestion} {@code caller}.
	* @param caller the {@link IQuestion} to which this {@link ACallExp} node is applied
	* @param question the question provided to {@code caller}
	*/
	@Override
	public <Q> void apply(IQuestion<Q> caller, Q question) throws AnalysisException
	{
		caller.caseACallExp(this,question);
	}


	/**
	* Calls the {@link IQuestionAnswer#caseACallExp(ACallExp, Object)} of the {@link IQuestionAnswer} {@code caller}.
	* @param caller the {@link IQuestionAnswer} to which this {@link ACallExp} node is applied
	* @param question the question provided to {@code caller}
	*/
	@Override
	public <Q, A> A apply(IQuestionAnswer<Q, A> caller, Q question) throws AnalysisException
	{
		return caller.caseACallExp(this,question);
	}



}
