/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.ast.node;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.intocps.maestro.ast.analysis.AnalysisException;
import org.intocps.maestro.ast.analysis.intf.IAnalysis;
import org.intocps.maestro.ast.analysis.intf.IAnswer;
import org.intocps.maestro.ast.analysis.intf.IQuestion;
import org.intocps.maestro.ast.analysis.intf.IQuestionAnswer;
import org.intocps.maestro.ast.node.INode;
import org.intocps.maestro.ast.node.NodeList;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PExpBase;

public class AArrayIndexExp
extends PExpBase {
    private static final long serialVersionUID = 1L;
    private PExp _array;
    private NodeList<PExp> _indices = new NodeList(this);

    public AArrayIndexExp(PExp array_, List<? extends PExp> indices_) {
        this.setArray(array_);
        this.setIndices(indices_);
    }

    public AArrayIndexExp() {
    }

    @Override
    public String toString() {
        return String.valueOf(this._array) + "[" + this._indices.stream().map(Object::toString).collect(Collectors.joining("][")) + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (o != null && o instanceof AArrayIndexExp) {
            return this.toString().equals(o.toString());
        }
        return false;
    }

    @Override
    public AArrayIndexExp clone(Map<INode, INode> oldToNewMap) {
        AArrayIndexExp node = new AArrayIndexExp(this.cloneNode(this._array, oldToNewMap), this.cloneList(this._indices, oldToNewMap));
        oldToNewMap.put(this, node);
        return node;
    }

    @Override
    public AArrayIndexExp clone() {
        return new AArrayIndexExp(this.cloneNode(this._array), this.cloneList(this._indices));
    }

    @Override
    public void removeChild(INode child) {
        if (this._array == child) {
            this._array = null;
            return;
        }
        if (this._indices.remove(child)) {
            return;
        }
        throw new RuntimeException("Not a child.");
    }

    @Override
    public Map<String, Object> getChildren(Boolean includeInheritedFields) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        if (includeInheritedFields.booleanValue()) {
            fields.putAll(super.getChildren(includeInheritedFields));
        }
        fields.put("_array", this._array);
        fields.put("_indices", this._indices);
        return fields;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public void setArray(PExp value) {
        if (this._array != null) {
            this._array.parent(null);
        }
        if (value != null) {
            if (value.parent() != null) {
                value.parent().removeChild(value);
            }
            value.parent(this);
        }
        this._array = value;
    }

    public PExp getArray() {
        return this._array;
    }

    public void setIndices(List<? extends PExp> value) {
        if (this._indices.equals(value)) {
            return;
        }
        this._indices.clear();
        if (value != null) {
            this._indices.addAll(value);
        }
    }

    public LinkedList<PExp> getIndices() {
        return this._indices;
    }

    @Override
    public void apply(IAnalysis caller) throws AnalysisException {
        caller.caseAArrayIndexExp(this);
    }

    @Override
    public <A> A apply(IAnswer<A> caller) throws AnalysisException {
        return caller.caseAArrayIndexExp(this);
    }

    @Override
    public <Q> void apply(IQuestion<Q> caller, Q question) throws AnalysisException {
        caller.caseAArrayIndexExp(this, question);
    }

    @Override
    public <Q, A> A apply(IQuestionAnswer<Q, A> caller, Q question) throws AnalysisException {
        return caller.caseAArrayIndexExp(this, question);
    }
}

