/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.ast.display;

import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.intocps.maestro.ast.ABasicBlockStm;
import org.intocps.maestro.ast.AParallelBlockStm;
import org.intocps.maestro.ast.AVariableDeclaration;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.analysis.AnalysisException;
import org.intocps.maestro.ast.analysis.QuestionAdaptor;
import org.intocps.maestro.ast.node.AArrayType;
import org.intocps.maestro.ast.node.AConfigStm;
import org.intocps.maestro.ast.node.AIfStm;
import org.intocps.maestro.ast.node.ALocalVariableStm;
import org.intocps.maestro.ast.node.ARootDocument;
import org.intocps.maestro.ast.node.ASimulationSpecificationCompilationUnit;
import org.intocps.maestro.ast.node.ATryStm;
import org.intocps.maestro.ast.node.AWhileStm;
import org.intocps.maestro.ast.node.INode;
import org.intocps.maestro.ast.node.PCompilationUnit;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PInitializer;
import org.intocps.maestro.ast.node.PStm;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.ast.node.SBlockStm;

public class PrettyPrinter
extends QuestionAdaptor<Integer> {
    StringBuilder sb = new StringBuilder();

    public static String print(INode node) throws AnalysisException {
        PrettyPrinter printer = new PrettyPrinter();
        node.apply(printer, Integer.valueOf(0));
        return printer.sb.toString();
    }

    public static String printLineNumbers(INode node) throws AnalysisException {
        PrettyPrinter printer = new PrettyPrinter();
        node.apply(printer, Integer.valueOf(0));
        int lineNumber = 1;
        StringBuilder sb = new StringBuilder();
        int decimals = 3;
        for (String line : printer.sb.toString().split("\n")) {
            sb.append(String.format("%1$" + decimals + "s", lineNumber++ + "  ")).append(line).append("\n");
        }
        return sb.toString();
    }

    static String indent(int indentionCount) {
        return IntStream.range(0, indentionCount).mapToObj(i -> "\t").collect(Collectors.joining());
    }

    @Override
    public void caseARootDocument(ARootDocument node, Integer question) throws AnalysisException {
        for (PCompilationUnit unit : node.getContent()) {
            unit.apply(this, question);
        }
    }

    @Override
    public void caseASimulationSpecificationCompilationUnit(ASimulationSpecificationCompilationUnit node, Integer question) throws AnalysisException {
        this.sb.append(PrettyPrinter.indent(question) + "simulation ");
        node.getImports().forEach(x -> this.sb.append(PrettyPrinter.indent(question) + "\nimport " + x.getText() + ";"));
        if (node.getFramework() != null && !node.getFramework().isEmpty()) {
            this.sb.append(PrettyPrinter.indent(question) + "\n@Framework( " + node.getFramework().stream().map(LexIdentifier::getText).map(s -> "\"" + s + "\"").collect(Collectors.joining(",")) + ");");
        }
        if (node.getFrameworkConfigs() != null && !node.getFrameworkConfigs().isEmpty()) {
            node.getFrameworkConfigs().forEach(x -> this.sb.append(PrettyPrinter.indent(question) + "\n@FrameworkConfig( \"" + x.getName().getText() + "\", \"" + x.getConfig() + "\");"));
        }
        this.sb.append("\n");
        node.getBody().apply(this, question);
    }

    @Override
    public void caseAIfStm(AIfStm node, Integer question) throws AnalysisException {
        this.sb.append(PrettyPrinter.indent(question) + "if( ");
        node.getTest().apply(this, question);
        this.sb.append(" )\n");
        this.sb.append(PrettyPrinter.indent(question) + "{\n");
        this.applyBodyIntendedScoping(node.getThen(), question + 2);
        this.sb.append("\n" + PrettyPrinter.indent(question) + "}");
        if (node.getElse() != null) {
            this.sb.append("\n" + PrettyPrinter.indent(question) + "else\n" + PrettyPrinter.indent(question) + "{\n");
            this.applyBodyIntendedScoping(node.getElse(), question + 2);
            this.sb.append("\n" + PrettyPrinter.indent(question) + "}");
        }
    }

    void applyBodyIntendedScoping(INode node, int indentation) throws AnalysisException {
        if (node == null) {
            return;
        }
        if (node instanceof SBlockStm) {
            this.printABlockStm(((SBlockStm)node).getBody(), indentation - 1, true, node instanceof AParallelBlockStm);
        } else {
            node.apply(this, Integer.valueOf(indentation));
        }
    }

    @Override
    public void caseAConfigStm(AConfigStm node, Integer question) throws AnalysisException {
        this.sb.append(PrettyPrinter.indent(question) + "@Config(\"" + node.getConfig() + "\");");
    }

    @Override
    public void caseAWhileStm(AWhileStm node, Integer question) throws AnalysisException {
        this.sb.append(PrettyPrinter.indent(question) + "while( ");
        node.getTest().apply(this, question);
        this.sb.append(" )\n");
        this.sb.append(PrettyPrinter.indent(question) + "{\n");
        this.applyBodyIntendedScoping(node.getBody(), question + 1);
        this.sb.append("\n" + PrettyPrinter.indent(question) + "}");
    }

    @Override
    public void caseALocalVariableStm(ALocalVariableStm node, Integer question) throws AnalysisException {
        node.getDeclaration().apply(this, question);
    }

    @Override
    public void caseAVariableDeclaration(AVariableDeclaration node, Integer question) throws AnalysisException {
        this.sb.append(PrettyPrinter.indent(question));
        if (node.getExternal() != null && node.getExternal().booleanValue()) {
            this.sb.append("external ");
        }
        node.getType().apply(this, question);
        this.sb.append(" ");
        this.sb.append(node.getName().getText());
        for (PExp s : node.getSize()) {
            this.sb.append("[");
            s.apply(this, question);
            this.sb.append("]");
        }
        if (node.getInitializer() != null) {
            this.sb.append(" = ");
            node.getInitializer().apply(this, question);
        }
        this.sb.append(";");
    }

    @Override
    public void defaultPStm(PStm node, Integer question) throws AnalysisException {
        this.sb.append(PrettyPrinter.indent(question) + (String)(node.toString().endsWith(";") ? node.toString() : node.toString() + ";"));
    }

    @Override
    public void defaultPExp(PExp node, Integer question) throws AnalysisException {
        this.sb.append(node.toString());
    }

    @Override
    public void defaultPType(PType node, Integer question) throws AnalysisException {
        if (node instanceof AArrayType) {
            ((AArrayType)node).getType().apply(this, question);
        } else {
            this.sb.append(node.toString());
        }
    }

    @Override
    public void defaultPInitializer(PInitializer node, Integer question) throws AnalysisException {
        this.sb.append(node.toString());
    }

    @Override
    public void caseABasicBlockStm(ABasicBlockStm node, Integer question) throws AnalysisException {
        this.printABlockStm(node.getBody(), question, false, false);
    }

    @Override
    public void caseAParallelBlockStm(AParallelBlockStm node, Integer question) throws AnalysisException {
        this.printABlockStm(node.getBody(), question, false, true);
    }

    @Override
    public void caseATryStm(ATryStm node, Integer question) throws AnalysisException {
        this.sb.append(PrettyPrinter.indent(question) + "try \n");
        this.sb.append(PrettyPrinter.indent(question) + "{\n");
        this.applyBodyIntendedScoping(node.getBody(), question + 1);
        this.sb.append("\n" + PrettyPrinter.indent(question) + "}");
        this.sb.append(PrettyPrinter.indent(question) + "finally \n");
        this.sb.append(PrettyPrinter.indent(question) + "{\n");
        this.applyBodyIntendedScoping(node.getFinally(), question + 1);
        this.sb.append("\n" + PrettyPrinter.indent(question) + "}");
    }

    public void printABlockStm(List<? extends PStm> body, Integer question, boolean skipBracket, boolean parallel) throws AnalysisException {
        if (body.isEmpty()) {
            return;
        }
        if (!skipBracket) {
            this.sb.append(PrettyPrinter.indent(question) + (parallel ? "||" : "") + "{\n ");
        }
        Iterator<? extends PStm> itr = body.iterator();
        while (itr.hasNext()) {
            itr.next().apply(this, Integer.valueOf(question + 1));
            if (!itr.hasNext()) continue;
            this.sb.append("\n");
        }
        if (!skipBracket) {
            this.sb.append("\n" + PrettyPrinter.indent(question) + "}");
        }
    }
}

