/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.codegen.mabl2cpp;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Vector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.intocps.maestro.ast.AAndBinaryExp;
import org.intocps.maestro.ast.AEqualBinaryExp;
import org.intocps.maestro.ast.AGreaterBinaryExp;
import org.intocps.maestro.ast.AGreaterEqualBinaryExp;
import org.intocps.maestro.ast.ALessBinaryExp;
import org.intocps.maestro.ast.ALessEqualBinaryExp;
import org.intocps.maestro.ast.AMinusBinaryExp;
import org.intocps.maestro.ast.ANotEqualBinaryExp;
import org.intocps.maestro.ast.ANotUnaryExp;
import org.intocps.maestro.ast.AOrBinaryExp;
import org.intocps.maestro.ast.APlusBinaryExp;
import org.intocps.maestro.ast.AVariableDeclaration;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.NodeCollector;
import org.intocps.maestro.ast.analysis.AnalysisException;
import org.intocps.maestro.ast.analysis.DepthFirstAnalysisAdaptorQuestion;
import org.intocps.maestro.ast.analysis.intf.IQuestion;
import org.intocps.maestro.ast.node.AArrayIndexExp;
import org.intocps.maestro.ast.node.AArrayInitializer;
import org.intocps.maestro.ast.node.AArrayStateDesignator;
import org.intocps.maestro.ast.node.AArrayType;
import org.intocps.maestro.ast.node.AAssigmentStm;
import org.intocps.maestro.ast.node.ABlockStm;
import org.intocps.maestro.ast.node.ABoolLiteralExp;
import org.intocps.maestro.ast.node.ABooleanPrimitiveType;
import org.intocps.maestro.ast.node.ABreakStm;
import org.intocps.maestro.ast.node.ACallExp;
import org.intocps.maestro.ast.node.AExpInitializer;
import org.intocps.maestro.ast.node.AExpressionStm;
import org.intocps.maestro.ast.node.AIdentifierExp;
import org.intocps.maestro.ast.node.AIdentifierStateDesignator;
import org.intocps.maestro.ast.node.AIfStm;
import org.intocps.maestro.ast.node.AIntLiteralExp;
import org.intocps.maestro.ast.node.AIntNumericPrimitiveType;
import org.intocps.maestro.ast.node.ALoadExp;
import org.intocps.maestro.ast.node.AModuleType;
import org.intocps.maestro.ast.node.ANameType;
import org.intocps.maestro.ast.node.ARealLiteralExp;
import org.intocps.maestro.ast.node.ARealNumericPrimitiveType;
import org.intocps.maestro.ast.node.ARefExp;
import org.intocps.maestro.ast.node.AReferenceType;
import org.intocps.maestro.ast.node.ARootDocument;
import org.intocps.maestro.ast.node.ASimulationSpecificationCompilationUnit;
import org.intocps.maestro.ast.node.AStringLiteralExp;
import org.intocps.maestro.ast.node.AStringPrimitiveType;
import org.intocps.maestro.ast.node.AUIntLiteralExp;
import org.intocps.maestro.ast.node.AUIntNumericPrimitiveType;
import org.intocps.maestro.ast.node.AUnloadExp;
import org.intocps.maestro.ast.node.AWhileStm;
import org.intocps.maestro.ast.node.INode;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PStm;
import org.intocps.maestro.ast.node.PType;

class CppPrinter
extends DepthFirstAnalysisAdaptorQuestion<Integer> {
    private final Map<INode, PType> types;
    StringBuilder sb = new StringBuilder();

    public CppPrinter(Map<INode, PType> types) {
        this.types = types;
    }

    static String indent(int indentionCount) {
        return IntStream.range(0, indentionCount).mapToObj(i -> "\t").collect(Collectors.joining());
    }

    public static Map<String, String> print(INode node, Map<INode, PType> types) throws AnalysisException {
        CppPrinter printer = new CppPrinter(types);
        printer.sb.append("#include \"co-sim.hxx\"\n");
        node.apply((IQuestion)printer, (Object)0);
        HashMap<String, String> sources = new HashMap<String, String>();
        sources.put("co-sim.cxx", printer.sb.toString());
        sources.put("co-sim.hxx", "#ifndef COSIM\n#define COSIM\nvoid simulate();\n#endif");
        return sources;
    }

    public void caseALoadExp(ALoadExp node, Integer question) throws AnalysisException {
        AStringLiteralExp name = (AStringLiteralExp)node.getArgs().get(0);
        this.sb.append("load_" + name.getValue() + "(");
        for (int i = 1; i < node.getArgs().size(); ++i) {
            if (i > 1) {
                this.sb.append(", ");
            }
            ((PExp)node.getArgs().get(i)).apply((IQuestion)this, (Object)question);
        }
        this.sb.append(")");
    }

    public void caseAUnloadExp(AUnloadExp node, Integer question) throws AnalysisException {
    }

    public void caseACallExp(ACallExp node, Integer question) throws AnalysisException {
        boolean isFmuComp = false;
        boolean isDataWriter = false;
        if (node.getObject() != null) {
            node.getObject().apply((IQuestion)this, (Object)question);
            PType objType = this.types.get(node.getObject());
            isFmuComp = objType instanceof AModuleType && ((AModuleType)objType).getName().getText().equals("FMI2Component");
            boolean bl = isDataWriter = objType instanceof AModuleType && ((AModuleType)objType).getName().getText().equals("DataWriter");
            if (isFmuComp) {
                this.sb.append("->");
                this.sb.append("fmu");
            }
            this.sb.append("->");
        }
        this.sb.append(node.getMethodName().getText() + "(");
        if (isFmuComp) {
            node.getObject().apply((IQuestion)this, (Object)question);
            this.sb.append("->");
            this.sb.append("comp");
            if (!node.getArgs().isEmpty()) {
                this.sb.append(", ");
            }
        }
        if (isDataWriter) {
            if (node.getMethodName().getText().equals("writeDataPoint")) {
                this.sb.append("\"");
                for (PExp arg : node.getArgs().stream().skip(2L).collect(Collectors.toList())) {
                    PType at = this.types.get(arg);
                    if (at instanceof ABooleanPrimitiveType) {
                        this.sb.append("i");
                        continue;
                    }
                    if (at instanceof AIntNumericPrimitiveType) {
                        this.sb.append("i");
                        continue;
                    }
                    if (at instanceof AUIntNumericPrimitiveType) {
                        this.sb.append("u");
                        continue;
                    }
                    if (at instanceof ARealNumericPrimitiveType) {
                        this.sb.append("r");
                        continue;
                    }
                    if (at instanceof AStringPrimitiveType) {
                        this.sb.append("+");
                        continue;
                    }
                    this.sb.append("?");
                }
                this.sb.append("\", ");
            } else if (node.getMethodName().getText().equals("writeHeader")) {
                PExp exp = (PExp)node.getArgs().get(0);
                AIdentifierExp id = (AIdentifierExp)exp;
                LexIdentifier headerName = id.getName();
                ARootDocument doc = (ARootDocument)exp.getAncestor(ARootDocument.class);
                Optional<AVariableDeclaration> var = ((List)NodeCollector.collect((INode)doc, AVariableDeclaration.class).orElse(new Vector())).stream().filter(v -> v.getName().equals((Object)headerName)).findFirst();
                if (var.isPresent()) {
                    ((PExp)var.get().getSize().get(0)).apply((IQuestion)this, (Object)question);
                    this.sb.append(", ");
                }
            }
        }
        for (int i = 0; i < node.getArgs().size(); ++i) {
            if (i > 0) {
                this.sb.append(", ");
            }
            ((PExp)node.getArgs().get(i)).apply((IQuestion)this, (Object)question);
        }
        this.sb.append(")");
    }

    public void caseASimulationSpecificationCompilationUnit(ASimulationSpecificationCompilationUnit node, Integer question) throws AnalysisException {
        this.sb.append("#import <stdint.h>\n");
        this.sb.append("#import <string>\n");
        node.getImports().stream().forEach(im -> this.sb.append("#import \"" + im.getText().replace("FMI2", "SimFmi2").replace("Math", "SimMath") + ".h\"\n"));
        this.sb.append("void simulate()\n");
        node.getBody().apply((IQuestion)this, (Object)question);
    }

    public void caseABlockStm(ABlockStm node, Integer question) throws AnalysisException {
        this.sb.append(CppPrinter.indent(question));
        this.sb.append("{\n");
        for (PStm stm : node.getBody()) {
            stm.apply((IQuestion)this, (Object)(question + 1));
            this.sb.append("\n");
        }
        this.sb.append(CppPrinter.indent(question));
        this.sb.append("}\n");
    }

    public void caseAVariableDeclaration(AVariableDeclaration node, Integer question) throws AnalysisException {
        this.sb.append(CppPrinter.indent(question));
        node.getType().apply((IQuestion)this, (Object)question);
        this.sb.append(" ");
        this.sb.append(node.getName().getText());
        node.getSize().forEach(s -> this.sb.append("[").append(s).append("]"));
        if (node.getInitializer() != null) {
            this.sb.append(" = ");
            node.getInitializer().apply((IQuestion)this, (Object)question);
        }
        this.sb.append(";");
    }

    public void caseAArrayInitializer(AArrayInitializer node, Integer question) throws AnalysisException {
        this.sb.append("{");
        for (PExp exp : node.getExp()) {
            exp.apply((IQuestion)this, (Object)question);
            if (node.getExp().indexOf(exp) == node.getExp().size() - 1) continue;
            this.sb.append(", ");
        }
        this.sb.append("}");
    }

    public void caseAAssigmentStm(AAssigmentStm node, Integer question) throws AnalysisException {
        this.sb.append(CppPrinter.indent(question));
        node.getTarget().apply((IQuestion)this, (Object)question);
        this.sb.append(" = ");
        node.getExp().apply((IQuestion)this, (Object)question);
        this.sb.append(";");
    }

    public void caseAWhileStm(AWhileStm node, Integer question) throws AnalysisException {
        this.sb.append(CppPrinter.indent(question));
        this.sb.append("while(");
        node.getTest().apply((IQuestion)this, (Object)question);
        this.sb.append(")\n");
        node.getBody().apply((IQuestion)this, (Object)question);
    }

    public void caseAIfStm(AIfStm node, Integer question) throws AnalysisException {
        this.sb.append(CppPrinter.indent(question));
        this.sb.append("if(");
        node.getTest().apply((IQuestion)this, (Object)question);
        this.sb.append(")\n");
        node.getThen().apply((IQuestion)this, (Object)question);
        if (node.getElse() != null) {
            this.sb.append(CppPrinter.indent(question));
            this.sb.append("else\n");
            node.getElse().apply((IQuestion)this, (Object)question);
        }
    }

    public void caseAExpressionStm(AExpressionStm node, Integer question) throws AnalysisException {
        this.sb.append(CppPrinter.indent(question));
        node.getExp().apply((IQuestion)this, (Object)question);
        this.sb.append(";");
    }

    public void caseABreakStm(ABreakStm node, Integer question) throws AnalysisException {
        this.sb.append(CppPrinter.indent(question));
        this.sb.append("break");
        this.sb.append(";");
    }

    public void caseAIdentifierExp(AIdentifierExp node, Integer question) throws AnalysisException {
        this.sb.append(node.getName().getText());
    }

    public void caseAExpInitializer(AExpInitializer node, Integer question) throws AnalysisException {
        super.caseAExpInitializer(node, (Object)question);
    }

    public void caseARealNumericPrimitiveType(ARealNumericPrimitiveType node, Integer question) throws AnalysisException {
        this.sb.append("double");
    }

    public void caseABooleanPrimitiveType(ABooleanPrimitiveType node, Integer question) throws AnalysisException {
        this.sb.append("int");
    }

    public void caseAIntNumericPrimitiveType(AIntNumericPrimitiveType node, Integer question) throws AnalysisException {
        this.sb.append("int");
    }

    public void caseAStringPrimitiveType(AStringPrimitiveType node, Integer question) throws AnalysisException {
        this.sb.append("std::string");
    }

    public void caseAUIntNumericPrimitiveType(AUIntNumericPrimitiveType node, Integer question) throws AnalysisException {
        this.sb.append("unsigned int");
    }

    public void caseANameType(ANameType node, Integer question) throws AnalysisException {
        this.sb.append(node.getName().getText());
    }

    public void caseAReferenceType(AReferenceType node, Integer question) throws AnalysisException {
        node.getType().apply((IQuestion)this, (Object)question);
        this.sb.append("&");
    }

    public void caseAArrayType(AArrayType node, Integer question) throws AnalysisException {
        node.getType().apply((IQuestion)this, (Object)question);
        this.sb.append("*");
    }

    public void caseARefExp(ARefExp node, Integer question) throws AnalysisException {
        this.sb.append("&");
        node.getExp().apply((IQuestion)this, (Object)question);
    }

    public void caseABoolLiteralExp(ABoolLiteralExp node, Integer question) throws AnalysisException {
        this.sb.append("" + node.getValue());
    }

    public void caseAIntLiteralExp(AIntLiteralExp node, Integer question) throws AnalysisException {
        this.sb.append(node.getValue());
    }

    public void caseARealLiteralExp(ARealLiteralExp node, Integer question) throws AnalysisException {
        this.sb.append(node.getValue());
    }

    public void caseAUIntLiteralExp(AUIntLiteralExp node, Integer question) throws AnalysisException {
        this.sb.append(node.getValue());
    }

    public void caseAStringLiteralExp(AStringLiteralExp node, Integer question) throws AnalysisException {
        this.sb.append("\"" + node.getValue() + "\"");
    }

    public void caseAIdentifierStateDesignator(AIdentifierStateDesignator node, Integer question) throws AnalysisException {
        this.sb.append(node.getName().getText());
    }

    public void caseAArrayStateDesignator(AArrayStateDesignator node, Integer question) throws AnalysisException {
        node.getTarget().apply((IQuestion)this, (Object)question);
        this.sb.append("[");
        node.getExp().apply((IQuestion)this, (Object)question);
        this.sb.append("]");
    }

    public void caseAEqualBinaryExp(AEqualBinaryExp node, Integer question) throws AnalysisException {
        node.getLeft().apply((IQuestion)this, (Object)question);
        this.sb.append(" == ");
        node.getRight().apply((IQuestion)this, (Object)question);
    }

    public void caseANotEqualBinaryExp(ANotEqualBinaryExp node, Integer question) throws AnalysisException {
        node.getLeft().apply((IQuestion)this, (Object)question);
        this.sb.append(" != ");
        node.getRight().apply((IQuestion)this, (Object)question);
    }

    public void caseAOrBinaryExp(AOrBinaryExp node, Integer question) throws AnalysisException {
        node.getLeft().apply((IQuestion)this, (Object)question);
        this.sb.append(" || ");
        node.getRight().apply((IQuestion)this, (Object)question);
    }

    public void caseAAndBinaryExp(AAndBinaryExp node, Integer question) throws AnalysisException {
        node.getLeft().apply((IQuestion)this, (Object)question);
        this.sb.append(" && ");
        node.getRight().apply((IQuestion)this, (Object)question);
    }

    public void caseAPlusBinaryExp(APlusBinaryExp node, Integer question) throws AnalysisException {
        node.getLeft().apply((IQuestion)this, (Object)question);
        this.sb.append(" + ");
        node.getRight().apply((IQuestion)this, (Object)question);
    }

    public void caseAMinusBinaryExp(AMinusBinaryExp node, Integer question) throws AnalysisException {
        node.getLeft().apply((IQuestion)this, (Object)question);
        this.sb.append(" - ");
        node.getRight().apply((IQuestion)this, (Object)question);
    }

    public void caseALessBinaryExp(ALessBinaryExp node, Integer question) throws AnalysisException {
        node.getLeft().apply((IQuestion)this, (Object)question);
        this.sb.append(" < ");
        node.getRight().apply((IQuestion)this, (Object)question);
    }

    public void caseALessEqualBinaryExp(ALessEqualBinaryExp node, Integer question) throws AnalysisException {
        node.getLeft().apply((IQuestion)this, (Object)question);
        this.sb.append(" <= ");
        node.getRight().apply((IQuestion)this, (Object)question);
    }

    public void caseAGreaterEqualBinaryExp(AGreaterEqualBinaryExp node, Integer question) throws AnalysisException {
        node.getLeft().apply((IQuestion)this, (Object)question);
        this.sb.append(" > ");
        node.getRight().apply((IQuestion)this, (Object)question);
    }

    public void caseAGreaterBinaryExp(AGreaterBinaryExp node, Integer question) throws AnalysisException {
        node.getLeft().apply((IQuestion)this, (Object)question);
        this.sb.append(" >= ");
        node.getRight().apply((IQuestion)this, (Object)question);
    }

    public void caseAArrayIndexExp(AArrayIndexExp node, Integer question) throws AnalysisException {
        node.getArray().apply((IQuestion)this, (Object)question);
        for (int i = 0; i < node.getIndices().size(); ++i) {
            this.sb.append("[");
            ((PExp)node.getIndices().get(i)).apply((IQuestion)this, (Object)question);
            this.sb.append("]");
        }
    }

    public void caseANotUnaryExp(ANotUnaryExp node, Integer question) throws AnalysisException {
        this.sb.append("!");
        node.getExp().apply((IQuestion)this, (Object)question);
    }
}

