/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.codegen.mabl2cpp;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.intocps.maestro.ast.analysis.AnalysisException;
import org.intocps.maestro.ast.node.INode;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.codegen.mabl2cpp.CppPrinter;

public class MablCppCodeGenerator {
    final File outputDirectory;

    public MablCppCodeGenerator(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void generate(INode spec, Map<INode, PType> types) throws IOException, AnalysisException {
        this.outputDirectory.mkdirs();
        Map<String, String> sources = CppPrinter.print(spec, types);
        for (Map.Entry<String, String> source : sources.entrySet()) {
            IOUtils.write((String)source.getValue(), (OutputStream)new FileOutputStream(new File(this.outputDirectory, source.getKey())), (Charset)StandardCharsets.UTF_8);
        }
        this.copyLibraries(this.outputDirectory);
        this.createCMakeProject(this.outputDirectory);
    }

    private void createCMakeProject(File outputDirectory) throws IOException {
        InputStream is = this.getClass().getResourceAsStream("CMakeLists.txt");
        String cmakeLists = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
        IOUtils.write((String)cmakeLists, (OutputStream)new FileOutputStream(new File(outputDirectory, "CMakeLists.txt")), (Charset)StandardCharsets.UTF_8);
        IOUtils.copy((InputStream)this.getClass().getResourceAsStream("main.cpp"), (OutputStream)new FileOutputStream(new File(outputDirectory, "main.cpp")));
    }

    private void copyLibraries(File outputDirectory) throws IOException {
        String[] libraries;
        for (String libraryName : libraries = new String[]{"DataWriter", "Logger", "SimFmi2", "SimMath", "MEnv", "BooleanLogic", "DataWriterConfig", "unzip", "FmiComponentState"}) {
            for (String ext : new String[]{"cpp", "h"}) {
                String name = libraryName + "." + ext;
                InputStream is = this.getClass().getResourceAsStream("libs/" + name);
                File libs = new File(outputDirectory, "libs");
                libs.mkdirs();
                if (is == null) continue;
                IOUtils.copy((InputStream)is, (OutputStream)new FileOutputStream(new File(libs, name)));
            }
        }
    }
}

