/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.core.messages;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Vector;
import org.intocps.maestro.ast.LexToken;
import org.intocps.maestro.core.InternalException;
import org.intocps.maestro.core.messages.IErrorReporter;
import org.intocps.maestro.core.messages.MableError;
import org.intocps.maestro.core.messages.MableMessage;
import org.intocps.maestro.core.messages.MableWarning;

public class ErrorReporter
implements IErrorReporter {
    private final int MAX = 200;
    private final List<MableError> errors = new Vector<MableError>();
    private final List<MableWarning> warnings = new Vector<MableWarning>();
    private boolean suppress = false;
    private MableMessage lastMessage = null;

    public void suppressErrors(boolean sup) {
        this.suppress = sup;
    }

    @Override
    public void report(int number, String problem, LexToken location) {
        if (this.suppress) {
            return;
        }
        MableError error = new MableError(number, problem, location);
        this.errors.add(error);
        this.lastMessage = error;
        if (this.errors.size() >= 199) {
            this.errors.add(new MableError(10, "Too many errors", location));
            throw new InternalException(10, "Too many errors");
        }
    }

    @Override
    public void warning(int number, String problem, LexToken location) {
        if (this.suppress) {
            return;
        }
        MableWarning warning = new MableWarning(number, problem, location);
        this.warnings.add(warning);
        this.lastMessage = warning;
    }

    @Override
    public void detail(String tag, Object obj) {
        if (this.suppress) {
            return;
        }
        if (this.lastMessage != null) {
            this.lastMessage.add(tag + ": " + obj);
        }
    }

    @Override
    public void detail2(String tag1, Object obj1, String tag2, Object obj2) {
        this.detail(tag1, obj1);
        this.detail(tag2, obj2);
    }

    public void clearErrors() {
        this.errors.clear();
        this.warnings.clear();
    }

    @Override
    public int getErrorCount() {
        return this.errors.size();
    }

    @Override
    public int getWarningCount() {
        return this.warnings.size();
    }

    @Override
    public List<MableError> getErrors() {
        return this.errors;
    }

    @Override
    public List<MableWarning> getWarnings() {
        return this.warnings;
    }

    @Override
    public void printErrors(PrintWriter out) {
        for (MableError e : this.errors) {
            out.println(e.toString());
        }
    }

    @Override
    public void printWarnings(PrintWriter out) {
        for (MableWarning w : this.warnings) {
            out.println(w.toString());
        }
    }

    public String toString() {
        StringWriter out = new StringWriter();
        PrintWriter writer = new PrintWriter(out);
        this.printErrors(writer);
        this.printWarnings(writer);
        return out.toString();
    }
}

