/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.core;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringAnnotationProcessor {
    static final Logger logger = LoggerFactory.getLogger(StringAnnotationProcessor.class);

    public static String processStringAnnotations(File specificationFolder, String data) throws IOException {
        String FILE_TAG = "@file:";
        if (data != null && data.trim().startsWith("@file:")) {
            String fileName = data.substring(data.indexOf("@file:") + "@file:".length()).trim();
            File file = new File(fileName);
            if (!file.isAbsolute()) {
                file = new File(specificationFolder, fileName);
            }
            if (file.exists() && file.isFile()) {
                data = StringEscapeUtils.escapeJava((String)FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8));
            } else {
                logger.warn("Tag '@file:' not replaced in '" + data + "' file does not exist: '" + file.getAbsolutePath() + "'");
            }
        }
        return data;
    }
}

