/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.core.messages;

import java.io.PrintWriter;
import java.util.List;
import org.intocps.maestro.ast.LexToken;
import org.intocps.maestro.core.messages.MableError;
import org.intocps.maestro.core.messages.MableWarning;

public interface IErrorReporter {
    public void report(int var1, String var2, LexToken var3);

    public void warning(int var1, String var2, LexToken var3);

    public void detail(String var1, Object var2);

    public void detail2(String var1, Object var2, String var3, Object var4);

    public int getErrorCount();

    public int getWarningCount();

    public List<MableError> getErrors();

    public List<MableWarning> getWarnings();

    public void printErrors(PrintWriter var1);

    public void printWarnings(PrintWriter var1);

    public static class SilentReporter
    implements IErrorReporter {
        int errorCount = 0;
        int warningCount = 0;

        @Override
        public void report(int number, String problem, LexToken location) {
            ++this.errorCount;
        }

        @Override
        public void warning(int number, String problem, LexToken location) {
            ++this.warningCount;
        }

        @Override
        public void detail(String tag, Object obj) {
        }

        @Override
        public void detail2(String tag1, Object obj1, String tag2, Object obj2) {
        }

        @Override
        public int getErrorCount() {
            return this.errorCount;
        }

        @Override
        public int getWarningCount() {
            return this.warningCount;
        }

        @Override
        public List<MableError> getErrors() {
            return null;
        }

        @Override
        public List<MableWarning> getWarnings() {
            return null;
        }

        @Override
        public void printErrors(PrintWriter out) {
        }

        @Override
        public void printWarnings(PrintWriter out) {
        }
    }
}

