/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.core.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.util.List;
import java.util.Map;
import org.intocps.maestro.core.dto.IAlgorithmConfig;

public class MultiModel {
    @JsonProperty(value="fmus")
    @JsonPropertyDescription(value="A map of from fmu names on the form \"{FMU}\" to the path of the .fmu file")
    private final Map<String, String> fmus;
    @JsonProperty(value="connections")
    @JsonPropertyDescription(value="A map of connections where the key and value strings are on the form form \"{FMU}.instanceName.signal\". The mapping is from output to inputs. As a single output can be connected to multiple inputs")
    private final Map<String, List<String>> connections;
    @JsonProperty(value="parameters")
    @JsonPropertyDescription(value="A map from signal to its value. The key must be on the form \"{FMU}.instanceName.signal\" and value can be any value matching the signal.")
    private final Map<String, Object> parameters;
    @JsonProperty(value="environmentParameters")
    @JsonPropertyDescription(value="A list of parameters which should be obtained from the environment. The strings are on the form form \"{FMU}.instanceName.signal\".")
    private final List<String> environmentParameters;
    @JsonProperty(value="logVariables")
    @JsonPropertyDescription(value="A map from fmu instance \"{FMU}.instanceName\" to a list of signal names.")
    private final Map<String, List<String>> logVariables;
    @JsonProperty(value="parallelSimulation")
    @JsonPropertyDescription(value="If true the dostep part of the algorithm is run in parallel.")
    private final boolean parallelSimulation;
    @JsonProperty(value="stabalizationEnabled")
    @JsonPropertyDescription(value="Enable stabilization generation during initialization.")
    private final boolean stabalizationEnabled;
    @JsonProperty(value="global_absolute_tolerance")
    @JsonPropertyDescription(value="The global absolute tolerance.")
    private final double global_absolute_tolerance;
    @JsonProperty(value="global_relative_tolerance")
    @JsonPropertyDescription(value="The global relative tolerance.")
    private final double global_relative_tolerance;
    @JsonProperty(value="loggingOn")
    @JsonPropertyDescription(value="Enable logging.")
    private final boolean loggingOn;
    @JsonProperty(value="visible")
    @JsonPropertyDescription(value="The enable visible in FMI.")
    private final boolean visible;
    @JsonProperty(value="simulationProgramDelay")
    @JsonPropertyDescription(value="Delay simulation steps. i.e. steps are slowed down to near real time.")
    private final boolean simulationProgramDelay;
    @JsonProperty(value="overrideLogLevel")
    @JsonPropertyDescription(value="Override global log level of the simulator")
    private final InitializeLogLevel overrideLogLevel;
    @JsonProperty(value="algorithm")
    @JsonPropertyDescription(value="The step algorithm to be used, fixed or variable")
    private final IAlgorithmConfig algorithm;
    @JsonProperty(value="logLevels")
    @JsonPropertyDescription(value="A map of enabled log levels for each FMU. The key is \"{FMU}.instanceName\" and the log levels are the categories specified for each FMU")
    private final Map<String, List<String>> logLevels;
    @JsonProperty(value="faultInjectConfigurationPath")
    public String faultInjectConfigurationPath;
    @JsonProperty(value="faultInjectInstances")
    public Map<String, String> faultInjectInstances;
    @JsonProperty(value="convergenceAttempts")
    private final int convergenceAttempts;
    @JsonProperty(value="modelTransfers")
    @JsonPropertyDescription(value="A mapping from current instance name to the new instance name of that instance being transferred. i.e. A->A if A is transferred as is.")
    public Map<String, String> modelTransfers;
    @JsonProperty(value="modelSwaps")
    @JsonPropertyDescription(value="A map of from an instance name to its swap configuration. Thus the key is the instance name in this simulation.")
    public Map<String, ModelSwap> modelSwaps;

    @JsonCreator
    public MultiModel(@JsonProperty(value="fmus") Map<String, String> fmus, @JsonProperty(value="connections") Map<String, List<String>> connections, @JsonProperty(value="parameters") Map<String, Object> parameters, @JsonProperty(value="logVariables") Map<String, List<String>> logVariables, @JsonProperty(value="parallelSimulation") boolean parallelSimulation, @JsonProperty(value="stabalizationEnabled") boolean stabalizationEnabled, @JsonProperty(value="global_absolute_tolerance") double global_absolute_tolerance, @JsonProperty(value="global_relative_tolerance") double global_relative_tolerance, @JsonProperty(value="loggingOn") boolean loggingOn, @JsonProperty(value="visible") boolean visible, @JsonProperty(value="simulationProgramDelay") boolean simulationProgramDelay, @JsonProperty(value="algorithm") IAlgorithmConfig algorithm, @JsonProperty(value="overrideLogLevel") InitializeLogLevel overrideLogLevel, @JsonProperty(value="environmentParameters") List<String> environmentParameters, @JsonProperty(value="logLevels") Map<String, List<String>> logLevels, @JsonProperty(value="faultInjectConfigurationPath") String faultInjectConfigurationPath, @JsonProperty(value="faultInjectInstances") Map<String, String> faultInjectInstances, @JsonProperty(value="convergenceAttempts") int convergenceAttempts, @JsonProperty(value="modelTransfers") Map<String, String> modelTransfers, @JsonProperty(value="modelSwaps") Map<String, ModelSwap> modelSwaps) {
        this.fmus = fmus;
        this.connections = connections;
        this.parameters = parameters;
        this.logVariables = logVariables;
        this.loggingOn = loggingOn;
        this.visible = visible;
        this.simulationProgramDelay = simulationProgramDelay;
        this.parallelSimulation = parallelSimulation;
        this.stabalizationEnabled = stabalizationEnabled;
        this.global_absolute_tolerance = global_absolute_tolerance;
        this.global_relative_tolerance = global_relative_tolerance;
        this.algorithm = algorithm;
        this.overrideLogLevel = overrideLogLevel;
        this.environmentParameters = environmentParameters;
        this.logLevels = logLevels;
        this.faultInjectConfigurationPath = faultInjectConfigurationPath;
        this.faultInjectInstances = faultInjectInstances;
        this.convergenceAttempts = convergenceAttempts;
        this.modelTransfers = modelTransfers;
        this.modelSwaps = modelSwaps;
    }

    public int getConvergenceAttempts() {
        return this.convergenceAttempts;
    }

    public List<String> getEnvironmentParameters() {
        return this.environmentParameters;
    }

    public InitializeLogLevel getOverrideLogLevel() {
        return this.overrideLogLevel;
    }

    public Map<String, String> getFmus() {
        return this.fmus;
    }

    public Map<String, List<String>> getConnections() {
        return this.connections;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public Map<String, List<String>> getLogVariables() {
        return this.logVariables;
    }

    public boolean isParallelSimulation() {
        return this.parallelSimulation;
    }

    public boolean isStabalizationEnabled() {
        return this.stabalizationEnabled;
    }

    public double getGlobal_absolute_tolerance() {
        return this.global_absolute_tolerance;
    }

    public double getGlobal_relative_tolerance() {
        return this.global_relative_tolerance;
    }

    public boolean isLoggingOn() {
        return this.loggingOn;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isSimulationProgramDelay() {
        return this.simulationProgramDelay;
    }

    public Map<String, List<String>> getLogLevels() {
        return this.logLevels;
    }

    public IAlgorithmConfig getAlgorithm() {
        return this.algorithm;
    }

    public static enum InitializeLogLevel {
        OFF,
        FATAL,
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE,
        ALL;

    }

    public static class ModelSwap {
        @JsonProperty(value="swapInstance")
        @JsonPropertyDescription(value="The name of the instance swapped in")
        public String swapInstance;
        @JsonProperty(value="stepCondition")
        @JsonPropertyDescription(value="The condition that should be true for the step to be allowed. It could be (true)")
        public String stepCondition;
        @JsonProperty(value="swapCondition")
        @JsonPropertyDescription(value="The condition that should be true for the model to be swapped in i.e. replacing the previous. The condition could look like (controller.valve ==true) if the instance controller exist and have value as a boolean signal")
        public String swapCondition;
        @JsonProperty(value="swapConnections")
        @JsonPropertyDescription(value="A map of new connections like the connections but only with the delta for this new instance. Keys and values are on the form  \"{FMU}.instanceName.signal\". The key is the output and values the inputs")
        public Map<String, List<String>> swapConnections;
    }
}

