/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.core.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.annotations.ApiModel;
import java.util.List;

@ApiModel(subTypes={BoundedDifferenceConstraint.class, ZeroCrossingConstraint.class, SamplingConstraint.class, FmuMaxStepSizeConstraint.class}, discriminator="type", description="Simulation variable step algorithm constraint.", value="VarStepConstraint")
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=BoundedDifferenceConstraint.class, name="boundeddifference"), @JsonSubTypes.Type(value=ZeroCrossingConstraint.class, name="zerocrossing"), @JsonSubTypes.Type(value=SamplingConstraint.class, name="samplingrate"), @JsonSubTypes.Type(value=FmuMaxStepSizeConstraint.class, name="fmumaxstepsize")})
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public abstract class VarStepConstraint {
    @JsonProperty
    public String type;

    public abstract void validate() throws Exception;

    @ApiModel(parent=VarStepConstraint.class)
    public static class ZeroCrossingConstraint
    extends VarStepConstraint {
        List<String> ports;
        Integer order;
        Double abstol;
        Double safety;

        public ZeroCrossingConstraint() {
        }

        public ZeroCrossingConstraint(List<String> ports, Integer order, Double abstol, Double safety) {
            this.ports = ports;
            this.order = order;
            this.abstol = abstol;
            this.safety = safety;
        }

        public List<String> getPorts() {
            return this.ports;
        }

        public Integer getOrder() {
            return this.order;
        }

        public Double getAbstol() {
            return this.abstol;
        }

        public Double getSafety() {
            return this.safety;
        }

        @Override
        public void validate() throws Exception {
        }
    }

    @ApiModel(parent=VarStepConstraint.class)
    public static class BoundedDifferenceConstraint
    extends VarStepConstraint {
        List<String> ports;
        Double reltol;
        Double abstol;
        Double safety;
        Boolean skipDiscrete;

        public BoundedDifferenceConstraint() {
        }

        public BoundedDifferenceConstraint(List<String> ports, Double reltol, Double abstol, Double safety, Boolean skipDiscrete) {
            this.ports = ports;
            this.reltol = reltol;
            this.abstol = abstol;
            this.safety = safety;
            this.skipDiscrete = skipDiscrete;
        }

        public List<String> getPorts() {
            return this.ports;
        }

        public Double getReltol() {
            return this.reltol;
        }

        public Double getAbstol() {
            return this.abstol;
        }

        public Double getSafety() {
            return this.safety;
        }

        public Boolean getSkipDiscrete() {
            return this.skipDiscrete;
        }

        @Override
        public void validate() throws Exception {
        }
    }

    @ApiModel(parent=VarStepConstraint.class)
    public static class FmuMaxStepSizeConstraint
    extends VarStepConstraint {
        @Override
        public void validate() throws Exception {
        }
    }

    @ApiModel(parent=VarStepConstraint.class)
    public static class SamplingConstraint
    extends VarStepConstraint {
        Integer base;
        Integer rate;
        Integer startTime;

        public SamplingConstraint() {
        }

        public SamplingConstraint(Integer base, Integer rate, Integer startTime) {
            this.base = base;
            this.rate = rate;
            this.startTime = startTime;
        }

        public Integer getBase() {
            return this.base;
        }

        public Integer getRate() {
            return this.rate;
        }

        public Integer getStartTime() {
            return this.startTime;
        }

        @Override
        public void validate() throws Exception {
        }
    }
}

