/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.fmi;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.intocps.maestro.fmi.xml.NamedNodeMapIterator;
import org.intocps.maestro.fmi.xml.NodeIterator;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public class ModelDescription {
    private static final boolean DEBUG = false;
    final Document doc;
    final XPath xpath;
    List<ScalarVariable> scalarVariables = null;
    List<ScalarVariable> outputs = null;
    List<ScalarVariable> derivatives = null;
    Map<ScalarVariable, ScalarVariable> derivativesMap = new HashMap<ScalarVariable, ScalarVariable>();
    List<ScalarVariable> initialUnknowns = null;

    public ModelDescription(File file) throws ParserConfigurationException, SAXException, IOException {
        this(ModelDescription.getStream(file), new StreamSource(ModelDescription.class.getClassLoader().getResourceAsStream("fmi2ModelDescription.xsd")));
    }

    public ModelDescription(InputStream file) throws ParserConfigurationException, SAXException, IOException {
        this(file, new StreamSource(ModelDescription.class.getClassLoader().getResourceAsStream("fmi2ModelDescription.xsd")));
    }

    ModelDescription(InputStream xmlInputStream, Source schemaSource) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        ModelDescription.validateAgainstXSD(new StreamSource(xmlInputStream), schemaSource);
        xmlInputStream.reset();
        this.doc = docBuilderFactory.newDocumentBuilder().parse(xmlInputStream);
        XPathFactory xPathfactory = XPathFactory.newInstance();
        this.xpath = xPathfactory.newXPath();
    }

    static InputStream getStream(File file) throws IOException {
        byte[] bytes = IOUtils.toByteArray(new FileInputStream(file));
        return new ByteArrayInputStream(bytes);
    }

    static void validateAgainstXSD(Source document, Source schemaSource) throws SAXException, IOException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        factory.setResourceResolver(new ResourceResolver());
        Schema schema = factory.newSchema(schemaSource);
        Validator validator = schema.newValidator();
        validator.validate(document);
    }

    public static Node lookupSingle(Object doc, XPath xpath, String expression) throws XPathExpressionException {
        NodeList list = ModelDescription.lookup(doc, xpath, expression);
        if (list != null) {
            return list.item(0);
        }
        return null;
    }

    public static NodeList lookup(Object doc, XPath xpath, String expression) throws XPathExpressionException {
        XPathExpression expr = xpath.compile(expression);
        NodeList list = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
        boolean first = true;
        for (Node n : new NodeIterator(list)) {
            first = false;
        }
        if (first) {
            // empty if block
        }
        return list;
    }

    public static String formateNodeWithAtt(Object o) {
        if (o instanceof Document) {
            return "Root document";
        }
        if (o instanceof Node) {
            Node node = (Node)o;
            Object tmp = "";
            tmp = node.getLocalName();
            if (node.hasAttributes()) {
                for (Node att : new NamedNodeMapIterator(node.getAttributes())) {
                    tmp = (String)tmp + " " + att + ", ";
                }
            }
            return tmp;
        }
        return o.toString();
    }

    public String getModelId() throws XPathExpressionException {
        Node name = ModelDescription.lookupSingle(this.doc, this.xpath, "fmiModelDescription/@modelName");
        return name.getNodeValue();
    }

    public String getGuid() throws XPathExpressionException {
        Node name = ModelDescription.lookupSingle(this.doc, this.xpath, "fmiModelDescription/@guid");
        return name.getNodeValue();
    }

    public String getFmiVersion() throws XPathExpressionException {
        Node name = ModelDescription.lookupSingle(this.doc, this.xpath, "fmiModelDescription/@fmiVersion");
        return name.getNodeValue();
    }

    public String getModelDescription() throws XPathExpressionException {
        Node name = ModelDescription.lookupSingle(this.doc, this.xpath, "fmiModelDescription/@description");
        if (name == null) {
            return "";
        }
        return name.getNodeValue();
    }

    public String getAuthor() throws XPathExpressionException {
        Node name = ModelDescription.lookupSingle(this.doc, this.xpath, "fmiModelDescription/@author");
        if (name == null) {
            return "";
        }
        return name.getNodeValue();
    }

    public String getModelVersion() throws XPathExpressionException {
        Node name = ModelDescription.lookupSingle(this.doc, this.xpath, "fmiModelDescription/@version");
        if (name == null) {
            return "";
        }
        return name.getNodeValue();
    }

    public String getCopyright() throws XPathExpressionException {
        Node name = ModelDescription.lookupSingle(this.doc, this.xpath, "fmiModelDescription/@copyright");
        if (name == null) {
            return "";
        }
        return name.getNodeValue();
    }

    public String getLicense() throws XPathExpressionException {
        Node name = ModelDescription.lookupSingle(this.doc, this.xpath, "fmiModelDescription/@license");
        if (name == null) {
            return "";
        }
        return name.getNodeValue();
    }

    public String getGenerationTool() throws XPathExpressionException {
        Node name = ModelDescription.lookupSingle(this.doc, this.xpath, "fmiModelDescription/@generationTool");
        if (name == null) {
            return "";
        }
        return name.getNodeValue();
    }

    public String getGenerationDateAndTime() throws XPathExpressionException {
        Node name = ModelDescription.lookupSingle(this.doc, this.xpath, "fmiModelDescription/@generationDateAndTime");
        if (name == null) {
            return "";
        }
        return name.getNodeValue();
    }

    public String getVariableNamingConvention() throws XPathExpressionException {
        Node name = ModelDescription.lookupSingle(this.doc, this.xpath, "fmiModelDescription/@variableNamingConvention");
        if (name == null) {
            return "";
        }
        return name.getNodeValue();
    }

    public String getVendorToolName() throws XPathExpressionException {
        Node name = ModelDescription.lookupSingle(this.doc, this.xpath, "fmiModelDescription/VendorAnnotations/Tool/@name");
        if (name == null) {
            return "";
        }
        return name.getNodeValue();
    }

    public boolean getNeedsExecutionTool() throws XPathExpressionException {
        Node name = ModelDescription.lookupSingle(this.doc, this.xpath, "fmiModelDescription/CoSimulation/@needsExecutionTool");
        return name != null && Boolean.parseBoolean(name.getNodeValue());
    }

    public boolean getCanGetAndSetFmustate() throws XPathExpressionException {
        Node name = ModelDescription.lookupSingle(this.doc, this.xpath, "fmiModelDescription/CoSimulation/@canGetAndSetFMUstate");
        if (name == null) {
            return false;
        }
        return Boolean.valueOf(name.getNodeValue());
    }

    public boolean getCanBeInstantiatedOnlyOncePerProcess() throws XPathExpressionException {
        Node name = ModelDescription.lookupSingle(this.doc, this.xpath, "fmiModelDescription/CoSimulation/@canBeInstantiatedOnlyOncePerProcess");
        if (name == null) {
            return false;
        }
        return Boolean.valueOf(name.getNodeValue());
    }

    public boolean getCanInterpolateInputs() throws XPathExpressionException {
        Node name = ModelDescription.lookupSingle(this.doc, this.xpath, "fmiModelDescription/CoSimulation/@canInterpolateInputs");
        if (name == null) {
            return false;
        }
        return Boolean.valueOf(name.getNodeValue());
    }

    public boolean getCanHandleVariableCommunicationStepSize() throws XPathExpressionException {
        Node name = ModelDescription.lookupSingle(this.doc, this.xpath, "fmiModelDescription/CoSimulation/@canHandleVariableCommunicationStepSize");
        if (name == null) {
            return false;
        }
        return Boolean.valueOf(name.getNodeValue());
    }

    public List<LogCategory> getLogCategories() throws XPathExpressionException {
        Vector<LogCategory> categories = new Vector<LogCategory>();
        for (Node n : new NodeIterator(ModelDescription.lookup(this.doc, this.xpath, "fmiModelDescription/LogCategories/Category"))) {
            NamedNodeMap attributes = n.getAttributes();
            Node descritpionNode = attributes.getNamedItem("description");
            categories.add(new LogCategory(attributes.getNamedItem("name").getNodeValue(), descritpionNode != null ? descritpionNode.getNodeValue() : null));
        }
        return categories;
    }

    public List<ScalarVariable> getScalarVariables() throws XPathExpressionException, InvocationTargetException, IllegalAccessException {
        if (this.scalarVariables == null) {
            this.parse();
        }
        return this.scalarVariables;
    }

    public List<ScalarVariable> getOutputs() throws XPathExpressionException, InvocationTargetException, IllegalAccessException {
        if (this.outputs == null) {
            this.parse();
        }
        return this.outputs;
    }

    public Map<ScalarVariable, ScalarVariable> getDerivativesMap() throws XPathExpressionException, InvocationTargetException, IllegalAccessException {
        if (this.derivativesMap == null) {
            this.parse();
        }
        return this.derivativesMap;
    }

    public List<ScalarVariable> getDerivatives() throws XPathExpressionException, InvocationTargetException, IllegalAccessException {
        if (this.derivatives == null) {
            this.parse();
        }
        return this.derivatives;
    }

    public List<ScalarVariable> getInitialUnknowns() throws XPathExpressionException, InvocationTargetException, IllegalAccessException {
        if (this.initialUnknowns == null) {
            this.parse();
        }
        return this.initialUnknowns;
    }

    public synchronized void parse() throws XPathExpressionException, InvocationTargetException, IllegalAccessException {
        Map<String, SimbpleTypeDefinition> typeDefinitions = this.parseTypeDefinitions();
        Vector<ScalarVariable> vars = new Vector<ScalarVariable>();
        HashMap<Integer, ScalarVariable> indexMap = new HashMap<Integer, ScalarVariable>();
        int index = 0;
        Vector<ScalarVariable> ders = new Vector<ScalarVariable>();
        for (Node n : new NodeIterator(ModelDescription.lookup(this.doc, this.xpath, "fmiModelDescription/ModelVariables/ScalarVariable"))) {
            ScalarVariable sc = new ScalarVariable();
            indexMap.put(++index, sc);
            NamedNodeMap attributes = n.getAttributes();
            sc.name = attributes.getNamedItem("name").getNodeValue();
            sc.valueReference = Long.parseLong(attributes.getNamedItem("valueReference").getNodeValue());
            sc.causality = this.getAttribute(Causality.class, attributes, "causality");
            if (sc.causality == null) {
                sc.causality = Causality.Local;
            }
            sc.variability = this.getAttribute(Variability.class, attributes, "variability");
            sc.initial = this.getAttribute(Initial.class, attributes, "initial");
            sc.description = this.getNodeValue(attributes, "description", "");
            Node child = ModelDescription.lookupSingle(n, this.xpath, "Real[1] | Boolean[1] | String[1] | Integer[1] | Enumeration[1]");
            sc.type = this.parseType(child, typeDefinitions);
            if (sc.type.type == Types.Real && ((RealType)sc.type).derivative != null) {
                ders.add(sc);
            }
            vars.add(sc);
        }
        ders.forEach(der -> {
            ScalarVariable derSource = (ScalarVariable)indexMap.get(Integer.parseInt((String)((RealType)der.type).derivative));
            if (derSource.causality == Causality.Output) {
                this.derivativesMap.put(derSource, (ScalarVariable)der);
            }
        });
        for (Node n : new NodeIterator(ModelDescription.lookup(this.doc, this.xpath, "fmiModelDescription/ModelStructure/Outputs/Unknown"))) {
            this.decodeUnknownElement(indexMap, n, new IOptainUnknownDestination(){

                @Override
                public Map<ScalarVariable, ScalarVariable.DependencyKind> get(ScalarVariable sc) {
                    return sc.outputDependencies;
                }

                @Override
                public List<ScalarVariable> getList() {
                    if (ModelDescription.this.outputs == null) {
                        ModelDescription.this.outputs = new Vector<ScalarVariable>();
                    }
                    return ModelDescription.this.outputs;
                }
            }, ModelStructureElementType.Outputs);
        }
        for (Node n : new NodeIterator(ModelDescription.lookup(this.doc, this.xpath, "fmiModelDescription/ModelStructure/Derivatives/Unknown"))) {
            this.decodeUnknownElement(indexMap, n, new IOptainUnknownDestination(){

                @Override
                public Map<ScalarVariable, ScalarVariable.DependencyKind> get(ScalarVariable sc) {
                    return sc.derivativesDependencies;
                }

                @Override
                public List<ScalarVariable> getList() {
                    if (ModelDescription.this.derivatives == null) {
                        ModelDescription.this.derivatives = new Vector<ScalarVariable>();
                    }
                    return ModelDescription.this.derivatives;
                }
            }, ModelStructureElementType.Derivatives);
        }
        for (Node n : new NodeIterator(ModelDescription.lookup(this.doc, this.xpath, "fmiModelDescription/ModelStructure/InitialUnknowns/Unknown"))) {
            this.decodeUnknownElement(indexMap, n, new IOptainUnknownDestination(){

                @Override
                public Map<ScalarVariable, ScalarVariable.DependencyKind> get(ScalarVariable sc) {
                    return sc.initialUnknownsDependencies;
                }

                @Override
                public List<ScalarVariable> getList() {
                    if (ModelDescription.this.initialUnknowns == null) {
                        ModelDescription.this.initialUnknowns = new Vector<ScalarVariable>();
                    }
                    return ModelDescription.this.initialUnknowns;
                }
            }, ModelStructureElementType.InitialUnknown);
        }
        this.scalarVariables = vars;
        if (this.outputs == null) {
            this.outputs = new Vector<ScalarVariable>();
        }
        if (this.derivatives == null) {
            this.derivatives = new Vector<ScalarVariable>();
        }
        if (this.initialUnknowns == null) {
            this.initialUnknowns = new Vector<ScalarVariable>();
        }
    }

    private Map<String, SimbpleTypeDefinition> parseTypeDefinitions() throws XPathExpressionException, InvocationTargetException, IllegalAccessException {
        HashMap<String, SimbpleTypeDefinition> typeDefinitions = new HashMap<String, SimbpleTypeDefinition>();
        for (Node n : new NodeIterator(ModelDescription.lookup(this.doc, this.xpath, "fmiModelDescription/TypeDefinitions/SimpleType"))) {
            SimbpleTypeDefinition def = new SimbpleTypeDefinition();
            Node attribute = n.getAttributes().getNamedItem("name");
            if (attribute != null) {
                def.name = attribute.getNodeValue();
            }
            if ((attribute = n.getAttributes().getNamedItem("description")) != null) {
                def.description = attribute.getNodeValue();
            }
            Node child = ModelDescription.lookupSingle(n, this.xpath, "Real[1] | Boolean[1] | String[1] | Integer[1] | Enumeration[1]");
            def.type = this.parseType(child, typeDefinitions);
            typeDefinitions.put(def.name, def);
        }
        return typeDefinitions;
    }

    private void copyDefaults(Type type, Node node, Map<String, SimbpleTypeDefinition> typeDefinitions) throws InvocationTargetException, IllegalAccessException {
        String declaredType;
        Node attribute = node.getAttributes().getNamedItem("declaredType");
        if (attribute != null && typeDefinitions.containsKey(declaredType = attribute.getNodeValue())) {
            typeDefinitions.get(declaredType).setDefaults(type);
        }
    }

    private String parseTypeStart(Node node) {
        Node startAtt = node.getAttributes().getNamedItem("start");
        if (startAtt != null) {
            return startAtt.getNodeValue();
        }
        return null;
    }

    private void parseBooleanType(BooleanType type, Node node) {
        String startValue = this.parseTypeStart(node);
        if (startValue != null) {
            type.start = Boolean.valueOf(startValue);
        }
    }

    private void parseStringType(StringType type, Node node) {
        String startValue = this.parseTypeStart(node);
        if (startValue != null) {
            type.start = startValue;
        }
    }

    private void parseIntegerType(IntegerType type, Node node, boolean realMode) {
        Node attribute;
        String startValue = this.parseTypeStart(node);
        if (startValue != null) {
            type.start = !realMode ? (Number)Integer.valueOf(startValue) : (Number)Double.valueOf(startValue);
        }
        if ((attribute = node.getAttributes().getNamedItem("min")) != null) {
            if (!realMode) {
                type.min = Integer.parseInt(attribute.getNodeValue());
            } else {
                ((RealType)type).min = Double.parseDouble(attribute.getNodeValue());
            }
        }
        if ((attribute = node.getAttributes().getNamedItem("max")) != null) {
            if (!realMode) {
                type.max = Integer.parseInt(attribute.getNodeValue());
            } else {
                ((RealType)type).max = Double.parseDouble(attribute.getNodeValue());
            }
        }
        if ((attribute = node.getAttributes().getNamedItem("quantity")) != null) {
            type.quantity = attribute.getNodeValue();
        }
    }

    private void parseRealType(RealType type, Node node) {
        Node attribute;
        this.parseIntegerType(type, node, true);
        String startValue = this.parseTypeStart(node);
        if (startValue != null) {
            type.start = Double.valueOf(startValue);
        }
        if ((attribute = node.getAttributes().getNamedItem("unit")) != null) {
            type.unit = attribute.getNodeValue();
        }
        if ((attribute = node.getAttributes().getNamedItem("displayUnit")) != null) {
            type.displayUnit = attribute.getNodeValue();
        }
        if ((attribute = node.getAttributes().getNamedItem("relativeQuantity")) != null) {
            type.relativeQuantity = Boolean.parseBoolean(attribute.getNodeValue());
        }
        if ((attribute = node.getAttributes().getNamedItem("nominal")) != null) {
            type.nominal = Double.parseDouble(attribute.getNodeValue());
        }
        if ((attribute = node.getAttributes().getNamedItem("unbound")) != null) {
            type.unbound = Boolean.parseBoolean(attribute.getNodeValue());
        }
        if ((attribute = node.getAttributes().getNamedItem("reinit")) != null) {
            type.reinit = Boolean.parseBoolean(attribute.getNodeValue());
        }
    }

    private Type parseType(Node child, Map<String, SimbpleTypeDefinition> typeDefinitions) throws InvocationTargetException, IllegalAccessException {
        Types typeId = Types.valueOfIgnorecase(child.getNodeName());
        Type type = null;
        switch (typeId) {
            case Boolean: {
                type = new BooleanType();
                this.copyDefaults(type, child, typeDefinitions);
                this.parseBooleanType((BooleanType)type, child);
                break;
            }
            case Enumeration: {
                type = new EnumerationType();
            }
            case Integer: {
                if (type == null) {
                    type = new IntegerType();
                }
                this.copyDefaults(type, child, typeDefinitions);
                this.parseIntegerType((IntegerType)type, child, false);
                break;
            }
            case Real: {
                type = new RealType();
                this.copyDefaults(type, child, typeDefinitions);
                this.parseRealType((RealType)type, child);
                Node derivative = child.getAttributes().getNamedItem("derivative");
                if (derivative == null) break;
                ((RealType)type).derivative = derivative.getNodeValue();
                break;
            }
            case String: {
                type = new StringType();
                this.copyDefaults(type, child, typeDefinitions);
                this.parseStringType((StringType)type, child);
                break;
            }
        }
        return type;
    }

    private void decodeUnknownElement(Map<Integer, ScalarVariable> indexMap, Node n, IOptainUnknownDestination handler, ModelStructureElementType type) throws ModelDescriptionParseException {
        Node dependenciesNode;
        NamedNodeMap attributes = n.getAttributes();
        int index = Integer.valueOf(attributes.getNamedItem("index").getNodeValue());
        ScalarVariable sc = indexMap.get(index);
        if (sc == null) {
            throw new ModelDescriptionParseException("Invalid index attribut value in Unknown: //Unknown[@index='" + index + "']");
        }
        if (handler.getList() != null) {
            handler.getList().add(sc);
        }
        if ((dependenciesNode = attributes.getNamedItem("dependencies")) != null) {
            String dependencies = dependenciesNode.getNodeValue();
            if (dependencies != null && !dependencies.isEmpty()) {
                String[] dependencyArr = dependencies.split(" ");
                List<Object> dependencyKinds = new Vector();
                Node dependencyKindsNode = attributes.getNamedItem("dependenciesKind");
                if (dependencyKindsNode != null) {
                    dependencyKinds = this.getAttribute(ScalarVariable.DependencyKind.class, dependencyKindsNode.getNodeValue().split(" "));
                }
                if (dependencyKinds.size() > dependencyArr.length) {
                    throw new ModelDescriptionParseException("dependencies and dependenciesKind does not match missing dependency for kind //Unknown[@index='" + index + "']");
                }
                for (int i = 0; i < dependencyArr.length; ++i) {
                    ScalarVariable key;
                    ScalarVariable.DependencyKind kind = ScalarVariable.DependencyKind.Dependent;
                    if (dependencyKinds.size() > i) {
                        kind = (ScalarVariable.DependencyKind)((Object)dependencyKinds.get(i));
                    }
                    if ((key = indexMap.get(Integer.valueOf(dependencyArr[i]))) == null) {
                        throw new ModelDescriptionParseException("Invalid index attribut value in Unknown: //Unknown[@index='" + index + "']");
                    }
                    handler.get(sc).put(key, kind);
                }
            }
        } else {
            switch (type) {
                case Derivatives: 
                case Outputs: {
                    for (ScalarVariable other : indexMap.values()) {
                        switch (other.causality) {
                            case CalculatedParameter: {
                                break;
                            }
                            case Independent: 
                            case Input: {
                                handler.get(sc).put(other, ScalarVariable.DependencyKind.Dependent);
                                break;
                            }
                            case Local: {
                                break;
                            }
                            case Output: {
                                break;
                            }
                        }
                    }
                    break;
                }
                case InitialUnknown: {
                    for (ScalarVariable other : indexMap.values()) {
                        switch (other.causality) {
                            case CalculatedParameter: {
                                break;
                            }
                            case Independent: 
                            case Input: {
                                handler.get(sc).put(other, ScalarVariable.DependencyKind.Dependent);
                                break;
                            }
                            case Local: {
                                break;
                            }
                            case Output: {
                                break;
                            }
                        }
                        if (other.initial == null) continue;
                        switch (other.initial) {
                            case Approx: {
                                break;
                            }
                            case Calculated: {
                                break;
                            }
                            case Exact: {
                                handler.get(sc).put(other, ScalarVariable.DependencyKind.Dependent);
                                break;
                            }
                        }
                    }
                    break;
                }
            }
        }
    }

    public int getMaxOutputDerivativeOrder() throws XPathExpressionException {
        Node name = ModelDescription.lookupSingle(this.doc, this.xpath, "fmiModelDescription/CoSimulation/@maxOutputDerivativeOrder");
        if (name == null) {
            return 0;
        }
        return Integer.parseInt(name.getNodeValue());
    }

    private <T> T getNodeValue(NamedNodeMap attributes, String name, T defaultValue) {
        Node att = attributes.getNamedItem(name);
        if (att != null) {
            return (T)att.getNodeValue();
        }
        return defaultValue;
    }

    private <T extends Enum<T>> T getAttribute(Class<T> en, NamedNodeMap attributes, String name) {
        Node att = attributes.getNamedItem(name);
        if (att != null) {
            return Enum.valueOf(en, StringUtils.capitalize(att.getNodeValue()));
        }
        return null;
    }

    private <T extends Enum<T>> List<T> getAttribute(Class<T> en, String[] name) {
        Vector<T> list = new Vector<T>();
        for (String n : name) {
            list.add(Enum.valueOf(en, StringUtils.capitalize(n)));
        }
        return list;
    }

    public static class Input
    implements LSInput {
        private String publicId;
        private String systemId;
        private BufferedInputStream inputStream;

        public Input(String publicId, String sysId, InputStream input) {
            this.publicId = publicId;
            this.systemId = sysId;
            this.inputStream = new BufferedInputStream(input);
        }

        @Override
        public String getPublicId() {
            return this.publicId;
        }

        @Override
        public void setPublicId(String publicId) {
            this.publicId = publicId;
        }

        @Override
        public String getBaseURI() {
            return null;
        }

        @Override
        public void setBaseURI(String baseURI) {
        }

        @Override
        public InputStream getByteStream() {
            return null;
        }

        @Override
        public void setByteStream(InputStream byteStream) {
        }

        @Override
        public boolean getCertifiedText() {
            return false;
        }

        @Override
        public void setCertifiedText(boolean certifiedText) {
        }

        @Override
        public Reader getCharacterStream() {
            return null;
        }

        @Override
        public void setCharacterStream(Reader characterStream) {
        }

        @Override
        public String getEncoding() {
            return null;
        }

        @Override
        public void setEncoding(String encoding) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getStringData() {
            BufferedInputStream bufferedInputStream = this.inputStream;
            synchronized (bufferedInputStream) {
                try {
                    byte[] input = new byte[this.inputStream.available()];
                    this.inputStream.read(input);
                    String contents = new String(input);
                    return contents;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.out.println("Exception " + e);
                    return null;
                }
            }
        }

        @Override
        public void setStringData(String stringData) {
        }

        @Override
        public String getSystemId() {
            return this.systemId;
        }

        @Override
        public void setSystemId(String systemId) {
            this.systemId = systemId;
        }

        public BufferedInputStream getInputStream() {
            return this.inputStream;
        }

        public void setInputStream(BufferedInputStream inputStream) {
            this.inputStream = inputStream;
        }
    }

    public static class ResourceResolver
    implements LSResourceResolver {
        @Override
        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream(systemId);
            return new Input(publicId, systemId, resourceAsStream);
        }
    }

    public static class LogCategory {
        public final String name;
        public final String description;

        public LogCategory(String name, String description) {
            this.name = name;
            this.description = description;
        }

        protected LogCategory() {
            this.name = null;
            this.description = null;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class ScalarVariable {
        public final Map<ScalarVariable, DependencyKind> outputDependencies = new HashMap<ScalarVariable, DependencyKind>();
        public final Map<ScalarVariable, DependencyKind> derivativesDependencies = new HashMap<ScalarVariable, DependencyKind>();
        public final Map<ScalarVariable, DependencyKind> initialUnknownsDependencies = new HashMap<ScalarVariable, DependencyKind>();
        public String name;
        public long valueReference;
        public String description;
        public Causality causality;
        public Variability variability;
        public Initial initial;
        public Type type;

        public Type getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public Long getValueReference() {
            return new Long(this.valueReference);
        }

        public String toString() {
            return this.getName();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ScalarVariable) {
                return this.name.equals(((ScalarVariable)obj).getName());
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public static enum DependencyKind {
            Dependent,
            Constant,
            Fixed,
            Tunable,
            Discrete;

        }
    }

    public static class SimbpleTypeDefinition {
        public Type type;
        public String name;
        public String description;

        public void setDefaults(Type destination) throws InvocationTargetException, IllegalAccessException {
            BeanUtils.copyProperties(this.type, destination);
        }
    }

    public static class RealType
    extends IntegerType {
        public Object derivative;
        public String unit;
        public String displayUnit;
        public boolean relativeQuantity = false;
        public double nominal;
        public boolean unbound = false;
        public boolean reinit = false;
        public Double min;
        public Double max;

        public RealType() {
            this.type = Types.Real;
        }
    }

    public static class EnumerationType
    extends IntegerType {
        public EnumerationType() {
            this.type = Types.Enumeration;
        }
    }

    public static class IntegerType
    extends Type {
        public String quantity;
        public Integer min;
        public Integer max;

        public IntegerType() {
            this.type = Types.Integer;
        }
    }

    public static class StringType
    extends Type {
        public StringType() {
            this.type = Types.String;
        }
    }

    public static class BooleanType
    extends Type {
        public BooleanType() {
            this.type = Types.Boolean;
        }
    }

    public static class Type {
        public Types type;
        public Object start;

        public String toString() {
            return this.type + (String)(this.start != null ? " " + this.start : "");
        }
    }

    public static class ModelDescriptionParseException
    extends XPathExpressionException {
        private static final long serialVersionUID = 1L;

        public ModelDescriptionParseException(String message) {
            super(message);
        }
    }

    private static interface IOptainUnknownDestination {
        public Map<ScalarVariable, ScalarVariable.DependencyKind> get(ScalarVariable var1);

        public List<ScalarVariable> getList();
    }

    static enum ModelStructureElementType {
        InitialUnknown,
        Outputs,
        Derivatives;

    }

    public static enum Initial {
        Exact,
        Approx,
        Calculated;


        public static Initial valueOfIgnorecase(String value) {
            for (Initial i : Initial.values()) {
                if (!i.name().equalsIgnoreCase(value)) continue;
                return i;
            }
            return null;
        }
    }

    public static enum Variability {
        Constant,
        Fixed,
        Tunable,
        Discrete,
        Continuous;


        public static Variability valueOfIgnorecase(String value) {
            for (Variability v : Variability.values()) {
                if (!v.name().equalsIgnoreCase(value)) continue;
                return v;
            }
            return null;
        }
    }

    public static enum Causality {
        Parameter,
        CalculatedParameter,
        Input,
        Output,
        Local,
        Independent;


        public static Causality valueOfIgnorecase(String value) {
            for (Causality c : Causality.values()) {
                if (!c.name().equalsIgnoreCase(value)) continue;
                return c;
            }
            return null;
        }
    }

    public static enum Types {
        Boolean,
        Real,
        Integer,
        String,
        Enumeration;


        public static Types valueOfIgnorecase(String value) {
            for (Types t : Types.values()) {
                if (!t.name().equalsIgnoreCase(value)) continue;
                return t;
            }
            return null;
        }
    }
}

