/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.keyvalue;

import java.io.Serializable;
import java.util.Arrays;

public class MultiKey
implements Serializable {
    private static final long serialVersionUID = 4465448607415788805L;
    private final Object[] keys;
    private final int hashCode;

    public MultiKey(Object key1, Object key2) {
        this(new Object[]{key1, key2}, false);
    }

    public MultiKey(Object key1, Object key2, Object key3) {
        this(new Object[]{key1, key2, key3}, false);
    }

    public MultiKey(Object key1, Object key2, Object key3, Object key4) {
        this(new Object[]{key1, key2, key3, key4}, false);
    }

    public MultiKey(Object key1, Object key2, Object key3, Object key4, Object key5) {
        this(new Object[]{key1, key2, key3, key4, key5}, false);
    }

    public MultiKey(Object[] keys2) {
        this(keys2, true);
    }

    public MultiKey(Object[] keys2, boolean makeClone) {
        if (keys2 == null) {
            throw new IllegalArgumentException("The array of keys must not be null");
        }
        this.keys = makeClone ? (Object[])keys2.clone() : keys2;
        int total = 0;
        for (int i = 0; i < keys2.length; ++i) {
            if (keys2[i] == null) continue;
            total ^= keys2[i].hashCode();
        }
        this.hashCode = total;
    }

    public Object[] getKeys() {
        return (Object[])this.keys.clone();
    }

    public Object getKey(int index) {
        return this.keys[index];
    }

    public int size() {
        return this.keys.length;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof MultiKey) {
            MultiKey otherMulti = (MultiKey)other;
            return Arrays.equals(this.keys, otherMulti.keys);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "MultiKey" + Arrays.asList(this.keys).toString();
    }
}

