/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.fmi;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import org.intocps.maestro.fmi.xml.NamedNodeMapIterator;
import org.intocps.maestro.fmi.xml.NodeIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0010\n\u0002\b\u000b\b&\u0018\u0000 52\u00020\u0001:\b456789:;B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0001H\u0002J\u0006\u0010\u0010\u001a\u00020\u000eJ\u0006\u0010\u0011\u001a\u00020\bJ\u0006\u0010\u0012\u001a\u00020\bJ\u0006\u0010\u0013\u001a\u00020\bJ\u0006\u0010\u0014\u001a\u00020\u000eJ\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u0006\u0010\u0017\u001a\u00020\u000eJ\u0006\u0010\u0018\u001a\u00020\u000eJ\u0006\u0010\u0019\u001a\u00020\u000eJ\u0006\u0010\u001a\u001a\u00020\u000eJ\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u000eJ\u0006\u0010!\u001a\u00020\u000eJ\u0006\u0010\"\u001a\u00020\bJ\u0006\u0010#\u001a\u00020\u000eJ\u0006\u0010$\u001a\u00020\u000eJ \u0010%\u001a\u00020&2\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010'\u001a\u00020\u000eH\u0004J\"\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010'\u001a\u00020\u000eH\u0004J\"\u0010*\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010'\u001a\u00020\u000eH\u0004J\b\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020.2\u0006\u0010\u000f\u001a\u00020)H\u0004J(\u0010/\u001a\u0002H0\"\u0010\b\u0000\u00100\u0018\u0001*\b\u0012\u0004\u0012\u0002H0012\u0006\u00102\u001a\u00020\u000eH\u0086\b\u00a2\u0006\u0002\u00103R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\n8\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\f8\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lorg/intocps/maestro/fmi/ModelDescription;", "", "xmlInputStream", "Ljava/io/InputStream;", "schemaSource", "Ljavax/xml/transform/Source;", "(Ljava/io/InputStream;Ljavax/xml/transform/Source;)V", "DEBUG", "", "doc", "Lorg/w3c/dom/Document;", "xpath", "Ljavax/xml/xpath/XPath;", "formatNodeWithAtt", "", "node", "getAuthor", "getCanBeInstantiatedOnlyOncePerProcess", "getCanGetAndSetFmustate", "getCanHandleVariableCommunicationStepSize", "getCopyright", "getDefaultExperiment", "Lorg/intocps/maestro/fmi/ModelDescription$DefaultExperiment;", "getFmiVersion", "getGenerationDateAndTime", "getGenerationTool", "getLicense", "getLogCategories", "", "Lorg/intocps/maestro/fmi/ModelDescription$LogCategory;", "getMaxOutputDerivativeOrder", "", "getModelDescription", "getModelName", "getNeedsExecutionTool", "getVariableNamingConvention", "getVersion", "lookup", "Lorg/w3c/dom/NodeList;", "expression", "lookupSingle", "Lorg/w3c/dom/Node;", "lookupSingleNodeValue", "parse", "", "parseBaseUnit", "Lorg/intocps/maestro/fmi/ModelDescription$BaseUnit;", "valueOf", "T", "", "type", "(Ljava/lang/String;)Ljava/lang/Enum;", "BaseUnit", "Companion", "DefaultExperiment", "Initial", "Input", "LogCategory", "ResourceResolver", "Variability", "fmi"})
public abstract class ModelDescription {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean DEBUG;
    @JvmField
    @NotNull
    protected final Document doc;
    @JvmField
    @NotNull
    protected final XPath xpath;

    public ModelDescription(@NotNull InputStream xmlInputStream, @NotNull Source schemaSource) throws SAXException, IOException, ParserConfigurationException {
        Intrinsics.checkNotNullParameter(xmlInputStream, "xmlInputStream");
        Intrinsics.checkNotNullParameter(schemaSource, "schemaSource");
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        Companion.validateAgainstXSD(new StreamSource(xmlInputStream), schemaSource);
        xmlInputStream.reset();
        Document document = docBuilderFactory.newDocumentBuilder().parse(xmlInputStream);
        Intrinsics.checkNotNullExpressionValue(document, "docBuilderFactory.newDocumentBuilder().parse(xmlInputStream)");
        this.doc = document;
        XPathFactory xPathfactory = XPathFactory.newInstance();
        XPath xPath = xPathfactory.newXPath();
        Intrinsics.checkNotNullExpressionValue(xPath, "xPathfactory.newXPath()");
        this.xpath = xPath;
    }

    @NotNull
    public final String getFmiVersion() throws XPathExpressionException {
        String string = this.lookupSingleNodeValue(this.doc, this.xpath, "fmiModelDescription/@fmiVersion");
        return string == null ? "" : string;
    }

    @NotNull
    public final String getModelName() throws XPathExpressionException {
        String string = this.lookupSingleNodeValue(this.doc, this.xpath, "fmiModelDescription/@modelName");
        return string == null ? "" : string;
    }

    @NotNull
    public final String getModelDescription() throws XPathExpressionException {
        String string = this.lookupSingleNodeValue(this.doc, this.xpath, "fmiModelDescription/@description");
        return string == null ? "" : string;
    }

    @NotNull
    public final String getAuthor() throws XPathExpressionException {
        String string = this.lookupSingleNodeValue(this.doc, this.xpath, "fmiModelDescription/@author");
        return string == null ? "" : string;
    }

    @NotNull
    public final String getVersion() throws XPathExpressionException {
        String string = this.lookupSingleNodeValue(this.doc, this.xpath, "fmiModelDescription/@version");
        return string == null ? "" : string;
    }

    @NotNull
    public final String getCopyright() throws XPathExpressionException {
        String string = this.lookupSingleNodeValue(this.doc, this.xpath, "fmiModelDescription/@copyright");
        return string == null ? "" : string;
    }

    @NotNull
    public final String getLicense() throws XPathExpressionException {
        String string = this.lookupSingleNodeValue(this.doc, this.xpath, "fmiModelDescription/@license");
        return string == null ? "" : string;
    }

    @NotNull
    public final String getGenerationTool() throws XPathExpressionException {
        String string = this.lookupSingleNodeValue(this.doc, this.xpath, "fmiModelDescription/@generationTool");
        return string == null ? "" : string;
    }

    @NotNull
    public final String getGenerationDateAndTime() throws XPathExpressionException {
        String string = this.lookupSingleNodeValue(this.doc, this.xpath, "fmiModelDescription/@generationDateAndTime");
        return string == null ? "" : string;
    }

    @NotNull
    public final String getVariableNamingConvention() throws XPathExpressionException {
        String string = this.lookupSingleNodeValue(this.doc, this.xpath, "fmiModelDescription/@variableNamingConvention");
        return string == null ? "" : string;
    }

    public final boolean getNeedsExecutionTool() throws XPathExpressionException {
        boolean bl;
        String string;
        Node name = this.lookupSingle(this.doc, this.xpath, "fmiModelDescription/CoSimulation/@needsExecutionTool");
        Node node = name;
        String string2 = string = node == null ? null : node.getNodeValue();
        if (string == null) {
            bl = false;
        } else {
            boolean bl2;
            String string3 = string;
            boolean bl3 = false;
            bl = bl2 = Boolean.parseBoolean(string3);
        }
        return bl;
    }

    public final boolean getCanBeInstantiatedOnlyOncePerProcess() throws XPathExpressionException {
        boolean bl;
        String string;
        Node name = this.lookupSingle(this.doc, this.xpath, "fmiModelDescription/CoSimulation/@canBeInstantiatedOnlyOncePerProcess");
        Node node = name;
        String string2 = string = node == null ? null : node.getNodeValue();
        if (string == null) {
            bl = false;
        } else {
            boolean bl2;
            String string3 = string;
            boolean bl3 = false;
            bl = bl2 = Boolean.parseBoolean(string3);
        }
        return bl;
    }

    public final boolean getCanGetAndSetFmustate() throws XPathExpressionException {
        boolean bl;
        String string;
        Node name = this.lookupSingle(this.doc, this.xpath, "fmiModelDescription/CoSimulation/@canGetAndSetFMUstate");
        Node node = name;
        String string2 = string = node == null ? null : node.getNodeValue();
        if (string == null) {
            bl = false;
        } else {
            boolean bl2;
            String string3 = string;
            boolean bl3 = false;
            bl = bl2 = Boolean.parseBoolean(string3);
        }
        return bl;
    }

    public final int getMaxOutputDerivativeOrder() throws XPathExpressionException {
        int n;
        String string;
        Node name = this.lookupSingle(this.doc, this.xpath, "fmiModelDescription/CoSimulation/@maxOutputDerivativeOrder");
        Node node = name;
        String string2 = string = node == null ? null : node.getNodeValue();
        if (string == null) {
            n = 0;
        } else {
            int n2;
            String string3 = string;
            boolean bl = false;
            n = n2 = Integer.parseInt(string3);
        }
        return n;
    }

    public final boolean getCanHandleVariableCommunicationStepSize() throws XPathExpressionException {
        boolean bl;
        String string;
        Node name = this.lookupSingle(this.doc, this.xpath, "fmiModelDescription/CoSimulation/@canHandleVariableCommunicationStepSize");
        Node node = name;
        String string2 = string = node == null ? null : node.getNodeValue();
        if (string == null) {
            bl = false;
        } else {
            boolean bl2;
            String string3 = string;
            boolean bl3 = false;
            bl = bl2 = Boolean.parseBoolean(string3);
        }
        return bl;
    }

    @NotNull
    public final List<LogCategory> getLogCategories() throws XPathExpressionException {
        List categories = new Vector();
        Iterable $this$forEach$iv = new NodeIterator(this.lookup(this.doc, this.xpath, "fmiModelDescription/LogCategories/Category"));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node node = (Node)element$iv;
            boolean bl = false;
            String string = node.getAttributes().getNamedItem("name").getNodeValue();
            Intrinsics.checkNotNullExpressionValue(string, "node.attributes.getNamedItem(\"name\").nodeValue");
            String string2 = string;
            string = node.getAttributes().getNamedItem("description").getNodeValue();
            Intrinsics.checkNotNullExpressionValue(string, "node.attributes.getNamedItem(\"description\").nodeValue");
            categories.add(new LogCategory(string2, string));
        }
        return categories;
    }

    @Nullable
    public final DefaultExperiment getDefaultExperiment() {
        try {
            DefaultExperiment defaultExperiment;
            Node node = this.lookupSingle(this.doc, this.xpath, "fmiModelDescription/DefaultExperiment");
            boolean bl = false;
            boolean bl2 = false;
            Node defaultExperimentNode = node;
            boolean bl3 = false;
            if (defaultExperimentNode == null) {
                defaultExperiment = null;
            } else {
                Double d;
                Double d2;
                Double d3;
                boolean bl4;
                String string;
                String string2;
                Double d4;
                Node node2 = defaultExperimentNode.getAttributes().getNamedItem("startTime");
                if (node2 == null) {
                    d4 = null;
                } else {
                    string2 = node2.getNodeValue();
                    if (string2 == null) {
                        d4 = null;
                    } else {
                        string = string2;
                        bl4 = false;
                        d4 = Double.parseDouble(string);
                    }
                }
                node2 = defaultExperimentNode.getAttributes().getNamedItem("stopTime");
                if (node2 == null) {
                    d3 = null;
                } else {
                    string2 = node2.getNodeValue();
                    if (string2 == null) {
                        d3 = null;
                    } else {
                        string = string2;
                        bl4 = false;
                        d3 = Double.parseDouble(string);
                    }
                }
                node2 = defaultExperimentNode.getAttributes().getNamedItem("tolerance");
                if (node2 == null) {
                    d2 = null;
                } else {
                    string2 = node2.getNodeValue();
                    if (string2 == null) {
                        d2 = null;
                    } else {
                        string = string2;
                        bl4 = false;
                        d2 = Double.parseDouble(string);
                    }
                }
                node2 = defaultExperimentNode.getAttributes().getNamedItem("stepSize");
                if (node2 == null) {
                    d = null;
                } else {
                    string2 = node2.getNodeValue();
                    if (string2 == null) {
                        d = null;
                    } else {
                        string = string2;
                        bl4 = false;
                        d = Double.parseDouble(string);
                    }
                }
                defaultExperiment = new DefaultExperiment(d4, d3, d2, d);
            }
            return defaultExperiment;
        }
        catch (Exception e) {
            throw new Exception(Intrinsics.stringPlus("Default experiment cannot be parsed during model description parsing: ", e));
        }
    }

    public synchronized void parse() throws Exception {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    protected final BaseUnit parseBaseUnit(@NotNull Node node) {
        Intrinsics.checkNotNullParameter(node, "node");
        BaseUnit.Builder baseUnitBuilder = new BaseUnit.Builder(0, 0, 0, 0, 0, 0, 0, 0, 0.0, 0.0, 1023, null);
        int attributesMapLength = node.getAttributes().getLength();
        int n = 0;
        if (n >= attributesMapLength) return baseUnitBuilder.build();
        do {
            int i = n++;
            String nodeName = node.getAttributes().item(i).getNodeName();
            String nodeValue = node.getAttributes().item(i).getNodeValue();
            String string = nodeName;
            if (string == null) throw new Exception(Intrinsics.stringPlus("Unknown base unit being parsed: ", nodeName));
            int n2 = -1;
            switch (string.hashCode()) {
                case 65: {
                    if (string.equals("A")) {
                        n2 = 1;
                    }
                    break;
                }
                case 3169: {
                    if (string.equals("cd")) {
                        n2 = 2;
                    }
                    break;
                }
                case 115: {
                    if (string.equals("s")) {
                        n2 = 3;
                    }
                    break;
                }
                case 112661: {
                    if (string.equals("rad")) {
                        n2 = 4;
                    }
                    break;
                }
                case -1019779949: {
                    if (string.equals("offset")) {
                        n2 = 5;
                    }
                    break;
                }
                case 75: {
                    if (string.equals("K")) {
                        n2 = 6;
                    }
                    break;
                }
                case 108298: {
                    if (string.equals("mol")) {
                        n2 = 7;
                    }
                    break;
                }
                case 3420: {
                    if (string.equals("kg")) {
                        n2 = 8;
                    }
                    break;
                }
                case -1282148017: {
                    if (string.equals("factor")) {
                        n2 = 9;
                    }
                    break;
                }
                case 109: {
                    if (string.equals("m")) {
                        n2 = 10;
                    }
                    break;
                }
            }
            switch (n2) {
                case 8: {
                    Intrinsics.checkNotNullExpressionValue(nodeValue, "nodeValue");
                    String string2 = nodeValue;
                    boolean bl = false;
                    baseUnitBuilder.setKg(Integer.parseInt(string2));
                    break;
                }
                case 10: {
                    Intrinsics.checkNotNullExpressionValue(nodeValue, "nodeValue");
                    String string2 = nodeValue;
                    boolean bl = false;
                    baseUnitBuilder.setM(Integer.parseInt(string2));
                    break;
                }
                case 3: {
                    Intrinsics.checkNotNullExpressionValue(nodeValue, "nodeValue");
                    String string2 = nodeValue;
                    boolean bl = false;
                    baseUnitBuilder.setS(Integer.parseInt(string2));
                    break;
                }
                case 1: {
                    Intrinsics.checkNotNullExpressionValue(nodeValue, "nodeValue");
                    String string2 = nodeValue;
                    boolean bl = false;
                    baseUnitBuilder.setA(Integer.parseInt(string2));
                    break;
                }
                case 6: {
                    Intrinsics.checkNotNullExpressionValue(nodeValue, "nodeValue");
                    String string2 = nodeValue;
                    boolean bl = false;
                    baseUnitBuilder.setK(Integer.parseInt(string2));
                    break;
                }
                case 7: {
                    Intrinsics.checkNotNullExpressionValue(nodeValue, "nodeValue");
                    String string2 = nodeValue;
                    boolean bl = false;
                    baseUnitBuilder.setMol(Integer.parseInt(string2));
                    break;
                }
                case 2: {
                    Intrinsics.checkNotNullExpressionValue(nodeValue, "nodeValue");
                    String string2 = nodeValue;
                    boolean bl = false;
                    baseUnitBuilder.setCd(Integer.parseInt(string2));
                    break;
                }
                case 4: {
                    Intrinsics.checkNotNullExpressionValue(nodeValue, "nodeValue");
                    String string2 = nodeValue;
                    boolean bl = false;
                    baseUnitBuilder.setRad(Integer.parseInt(string2));
                    break;
                }
                case 9: {
                    Intrinsics.checkNotNullExpressionValue(nodeValue, "nodeValue");
                    String string2 = nodeValue;
                    boolean bl = false;
                    baseUnitBuilder.setFactor(Double.parseDouble(string2));
                    break;
                }
                case 5: {
                    Intrinsics.checkNotNullExpressionValue(nodeValue, "nodeValue");
                    String string2 = nodeValue;
                    boolean bl = false;
                    baseUnitBuilder.setOffset(Double.parseDouble(string2));
                    break;
                }
                default: {
                    throw new Exception(Intrinsics.stringPlus("Unknown base unit being parsed: ", nodeName));
                }
            }
        } while (n < attributesMapLength);
        return baseUnitBuilder.build();
    }

    @Nullable
    protected final Node lookupSingle(@NotNull Object doc, @NotNull XPath xpath, @NotNull String expression) throws XPathExpressionException {
        Intrinsics.checkNotNullParameter(doc, "doc");
        Intrinsics.checkNotNullParameter(xpath, "xpath");
        Intrinsics.checkNotNullParameter(expression, "expression");
        return this.lookup(doc, xpath, expression).item(0);
    }

    @Nullable
    protected final String lookupSingleNodeValue(@NotNull Object doc, @NotNull XPath xpath, @NotNull String expression) throws XPathExpressionException {
        Intrinsics.checkNotNullParameter(doc, "doc");
        Intrinsics.checkNotNullParameter(xpath, "xpath");
        Intrinsics.checkNotNullParameter(expression, "expression");
        Node node = this.lookupSingle(doc, xpath, expression);
        return node == null ? null : node.getNodeValue();
    }

    @NotNull
    protected final NodeList lookup(@NotNull Object doc, @NotNull XPath xpath, @NotNull String expression) throws XPathExpressionException {
        Object object;
        Intrinsics.checkNotNullParameter(doc, "doc");
        Intrinsics.checkNotNullParameter(xpath, "xpath");
        Intrinsics.checkNotNullParameter(expression, "expression");
        XPathExpression expr = xpath.compile(expression);
        if (this.DEBUG) {
            String string = Intrinsics.stringPlus("Starting from: ", this.formatNodeWithAtt(doc));
            boolean bl = false;
            System.out.println((Object)string);
        }
        if ((object = expr.evaluate(doc, XPathConstants.NODESET)) == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.w3c.dom.NodeList");
        }
        NodeList list = (NodeList)object;
        if (this.DEBUG) {
            object = "\tFound: ";
            boolean bl = false;
            System.out.print(object);
        }
        boolean first = true;
        for (Node n : new NodeIterator(list)) {
            if (this.DEBUG) {
                String string = !first ? "\t       " : "";
                Intrinsics.checkNotNullExpressionValue(n, "n");
                String string2 = Intrinsics.stringPlus(string, this.formatNodeWithAtt(n));
                boolean bl = false;
                System.out.println((Object)string2);
            }
            first = false;
        }
        if (first && this.DEBUG) {
            String string = "none";
            boolean bl = false;
            System.out.println((Object)string);
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ Enum valueOf(String type) {
        String string;
        Intrinsics.checkNotNullParameter(type, "type");
        boolean $i$f$valueOf = false;
        Intrinsics.reifiedOperationMarker(4, "T");
        Class<Enum> clazz = Enum.class;
        String string2 = type;
        boolean bl = false;
        CharSequence charSequence = string2;
        int n = 0;
        if (charSequence.length() > 0) {
            String string3;
            void it;
            char c = string2.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            Class<Enum> clazz2 = clazz;
            boolean bl2 = false;
            void var10_11 = it;
            boolean bl3 = false;
            if (Character.isLowerCase((char)var10_11)) {
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue(locale, "getDefault()");
                string3 = CharsKt.titlecase((char)it, locale);
            } else {
                string3 = String.valueOf((char)it);
            }
            String string4 = string3;
            clazz = clazz2;
            StringBuilder stringBuilder2 = stringBuilder.append(string4.toString());
            charSequence = string2;
            n = 1;
            c = '\u0000';
            String string5 = ((String)charSequence).substring(n);
            Intrinsics.checkNotNullExpressionValue(string5, "(this as java.lang.String).substring(startIndex)");
            string = stringBuilder2.append(string5).toString();
        } else {
            string = string2;
        }
        Enum enum_ = Enum.valueOf(clazz, string);
        Intrinsics.checkNotNullExpressionValue(enum_, "valueOf(T::class.java,\n            type.replaceFirstChar { if (it.isLowerCase()) it.titlecase(Locale.getDefault()) else it.toString() })");
        return enum_;
    }

    private final String formatNodeWithAtt(Object node) {
        if (node instanceof Document) {
            return "Root document";
        }
        if (node instanceof Node) {
            StringBuilder tmp = new StringBuilder(((Node)node).getLocalName());
            if (((Node)node).hasAttributes()) {
                for (Node att : new NamedNodeMapIterator(((Node)node).getAttributes())) {
                    tmp.append(" ").append(att).append(", ");
                }
            }
            String string = tmp.toString();
            Intrinsics.checkNotNullExpressionValue(string, "tmp.toString()");
            return string;
        }
        return node.toString();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lorg/intocps/maestro/fmi/ModelDescription$Companion;", "", "()V", "validateAgainstXSD", "", "document", "Ljavax/xml/transform/Source;", "schemaSource", "fmi"})
    public static final class Companion {
        private Companion() {
        }

        public final void validateAgainstXSD(@NotNull Source document, @NotNull Source schemaSource) throws SAXException, IOException {
            Intrinsics.checkNotNullParameter(document, "document");
            Intrinsics.checkNotNullParameter(schemaSource, "schemaSource");
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            boolean bl = false;
            boolean bl2 = false;
            SchemaFactory $this$validateAgainstXSD_u24lambda_u2d0 = schemaFactory;
            boolean bl3 = false;
            $this$validateAgainstXSD_u24lambda_u2d0.setResourceResolver(new ResourceResolver());
            $this$validateAgainstXSD_u24lambda_u2d0.newSchema(schemaSource).newValidator().validate(document);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/intocps/maestro/fmi/ModelDescription$Initial;", "", "(Ljava/lang/String;I)V", "Exact", "Approx", "Calculated", "fmi"})
    public static final class Initial
    extends Enum<Initial> {
        public static final /* enum */ Initial Exact = new Initial();
        public static final /* enum */ Initial Approx = new Initial();
        public static final /* enum */ Initial Calculated = new Initial();
        private static final /* synthetic */ Initial[] $VALUES;

        public static Initial[] values() {
            Initial[] initialArray = $VALUES;
            return Arrays.copyOf(initialArray, initialArray.length);
        }

        public static Initial valueOf(String value) {
            Intrinsics.checkNotNullParameter(value, "value");
            return Enum.valueOf(Initial.class, value);
        }

        static {
            $VALUES = initialArray = new Initial[]{Initial.Exact, Initial.Approx, Initial.Calculated};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/intocps/maestro/fmi/ModelDescription$Variability;", "", "(Ljava/lang/String;I)V", "Constant", "Fixed", "Tunable", "Discrete", "Continuous", "fmi"})
    public static final class Variability
    extends Enum<Variability> {
        public static final /* enum */ Variability Constant = new Variability();
        public static final /* enum */ Variability Fixed = new Variability();
        public static final /* enum */ Variability Tunable = new Variability();
        public static final /* enum */ Variability Discrete = new Variability();
        public static final /* enum */ Variability Continuous = new Variability();
        private static final /* synthetic */ Variability[] $VALUES;

        public static Variability[] values() {
            Variability[] variabilityArray = $VALUES;
            return Arrays.copyOf(variabilityArray, variabilityArray.length);
        }

        public static Variability valueOf(String value) {
            Intrinsics.checkNotNullParameter(value, "value");
            return Enum.valueOf(Variability.class, value);
        }

        static {
            $VALUES = variabilityArray = new Variability[]{Variability.Constant, Variability.Fixed, Variability.Tunable, Variability.Discrete, Variability.Continuous};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ>\u0010\u0012\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0013J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\u000b\u0010\tR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\f\u0010\tR\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\r\u0010\t\u00a8\u0006\u001b"}, d2={"Lorg/intocps/maestro/fmi/ModelDescription$DefaultExperiment;", "", "startTime", "", "stopTime", "tolerance", "stepSize", "(Ljava/lang/Double;Ljava/lang/Double;Ljava/lang/Double;Ljava/lang/Double;)V", "getStartTime", "()Ljava/lang/Double;", "Ljava/lang/Double;", "getStepSize", "getStopTime", "getTolerance", "component1", "component2", "component3", "component4", "copy", "(Ljava/lang/Double;Ljava/lang/Double;Ljava/lang/Double;Ljava/lang/Double;)Lorg/intocps/maestro/fmi/ModelDescription$DefaultExperiment;", "equals", "", "other", "hashCode", "", "toString", "", "fmi"})
    public static final class DefaultExperiment {
        @Nullable
        private final Double startTime;
        @Nullable
        private final Double stopTime;
        @Nullable
        private final Double tolerance;
        @Nullable
        private final Double stepSize;

        public DefaultExperiment(@Nullable Double startTime, @Nullable Double stopTime, @Nullable Double tolerance, @Nullable Double stepSize) {
            this.startTime = startTime;
            this.stopTime = stopTime;
            this.tolerance = tolerance;
            this.stepSize = stepSize;
        }

        @Nullable
        public final Double getStartTime() {
            return this.startTime;
        }

        @Nullable
        public final Double getStopTime() {
            return this.stopTime;
        }

        @Nullable
        public final Double getTolerance() {
            return this.tolerance;
        }

        @Nullable
        public final Double getStepSize() {
            return this.stepSize;
        }

        @Nullable
        public final Double component1() {
            return this.startTime;
        }

        @Nullable
        public final Double component2() {
            return this.stopTime;
        }

        @Nullable
        public final Double component3() {
            return this.tolerance;
        }

        @Nullable
        public final Double component4() {
            return this.stepSize;
        }

        @NotNull
        public final DefaultExperiment copy(@Nullable Double startTime, @Nullable Double stopTime, @Nullable Double tolerance, @Nullable Double stepSize) {
            return new DefaultExperiment(startTime, stopTime, tolerance, stepSize);
        }

        public static /* synthetic */ DefaultExperiment copy$default(DefaultExperiment defaultExperiment, Double d, Double d2, Double d3, Double d4, int n, Object object) {
            if ((n & 1) != 0) {
                d = defaultExperiment.startTime;
            }
            if ((n & 2) != 0) {
                d2 = defaultExperiment.stopTime;
            }
            if ((n & 4) != 0) {
                d3 = defaultExperiment.tolerance;
            }
            if ((n & 8) != 0) {
                d4 = defaultExperiment.stepSize;
            }
            return defaultExperiment.copy(d, d2, d3, d4);
        }

        @NotNull
        public String toString() {
            return "DefaultExperiment(startTime=" + this.startTime + ", stopTime=" + this.stopTime + ", tolerance=" + this.tolerance + ", stepSize=" + this.stepSize + ')';
        }

        public int hashCode() {
            int result = this.startTime == null ? 0 : ((Object)this.startTime).hashCode();
            result = result * 31 + (this.stopTime == null ? 0 : ((Object)this.stopTime).hashCode());
            result = result * 31 + (this.tolerance == null ? 0 : ((Object)this.tolerance).hashCode());
            result = result * 31 + (this.stepSize == null ? 0 : ((Object)this.stepSize).hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DefaultExperiment)) {
                return false;
            }
            DefaultExperiment defaultExperiment = (DefaultExperiment)other;
            if (!Intrinsics.areEqual((Object)this.startTime, (Object)defaultExperiment.startTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.stopTime, (Object)defaultExperiment.stopTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.tolerance, (Object)defaultExperiment.tolerance)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.stepSize, (Object)defaultExperiment.stepSize);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\u0010\u0018\u00002\u00020\u0001:\u0001\u001bBk\b\u0002\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u0012\b\b\u0002\u0010\n\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0010R\u0011\u0010\r\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0014R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lorg/intocps/maestro/fmi/ModelDescription$BaseUnit;", "", "kg", "", "m", "s", "A", "K", "mol", "cd", "rad", "factor", "", "offset", "(IIIIIIIIDD)V", "getA", "()I", "getK", "getCd", "getFactor", "()D", "getKg", "getM", "getMol", "getOffset", "getRad", "getS", "Builder", "fmi"})
    public static final class BaseUnit {
        private final int kg;
        private final int m;
        private final int s;
        private final int A;
        private final int K;
        private final int mol;
        private final int cd;
        private final int rad;
        private final double factor;
        private final double offset;

        private BaseUnit(int kg, int m, int s, int A, int K, int mol, int cd, int rad, double factor, double offset) {
            this.kg = kg;
            this.m = m;
            this.s = s;
            this.A = A;
            this.K = K;
            this.mol = mol;
            this.cd = cd;
            this.rad = rad;
            this.factor = factor;
            this.offset = offset;
        }

        /* synthetic */ BaseUnit(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, double d, double d2, int n9, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n9 & 1) != 0) {
                n = 0;
            }
            if ((n9 & 2) != 0) {
                n2 = 0;
            }
            if ((n9 & 4) != 0) {
                n3 = 0;
            }
            if ((n9 & 8) != 0) {
                n4 = 0;
            }
            if ((n9 & 0x10) != 0) {
                n5 = 0;
            }
            if ((n9 & 0x20) != 0) {
                n6 = 0;
            }
            if ((n9 & 0x40) != 0) {
                n7 = 0;
            }
            if ((n9 & 0x80) != 0) {
                n8 = 0;
            }
            if ((n9 & 0x100) != 0) {
                d = 1.0;
            }
            if ((n9 & 0x200) != 0) {
                d2 = 0.0;
            }
            this(n, n2, n3, n4, n5, n6, n7, n8, d, d2);
        }

        public final int getKg() {
            return this.kg;
        }

        public final int getM() {
            return this.m;
        }

        public final int getS() {
            return this.s;
        }

        public final int getA() {
            return this.A;
        }

        public final int getK() {
            return this.K;
        }

        public final int getMol() {
            return this.mol;
        }

        public final int getCd() {
            return this.cd;
        }

        public final int getRad() {
            return this.rad;
        }

        public final double getFactor() {
            return this.factor;
        }

        public final double getOffset() {
            return this.offset;
        }

        public /* synthetic */ BaseUnit(int kg, int m, int s, int A, int K, int mol, int cd, int rad, double factor, double offset, DefaultConstructorMarker $constructor_marker) {
            this(kg, m, s, A, K, mol, cd, rad, factor, offset);
        }

        /*
         * Duplicate member names - consider using --renamedupmembers true
         */
        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001Bi\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u0012\b\b\u0002\u0010\n\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010'\u001a\u00020(J\t\u0010)\u001a\u00020\u0003H\u00c6\u0003J\t\u0010*\u001a\u00020\fH\u00c6\u0003J\t\u0010+\u001a\u00020\u0003H\u00c6\u0003J\t\u0010,\u001a\u00020\u0003H\u00c6\u0003J\t\u0010-\u001a\u00020\u0003H\u00c6\u0003J\t\u0010.\u001a\u00020\u0003H\u00c6\u0003J\t\u0010/\u001a\u00020\u0003H\u00c6\u0003J\t\u00100\u001a\u00020\u0003H\u00c6\u0003J\t\u00101\u001a\u00020\u0003H\u00c6\u0003J\t\u00102\u001a\u00020\fH\u00c6\u0003Jm\u00103\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\fH\u00c6\u0001J\u0013\u00104\u001a\u0002052\b\u00106\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00107\u001a\u00020\u0003H\u00d6\u0001J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0003J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0003J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0003J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0003J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0003J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\fJ\u000e\u0010$\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0003J\u000e\u0010&\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0003J\t\u00108\u001a\u000209H\u00d6\u0001R\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0007\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0010\"\u0004\b\u0014\u0010\u0012R\u001a\u0010\t\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0010\"\u0004\b\u0016\u0010\u0012R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0010\"\u0004\b\u001c\u0010\u0012R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0010\"\u0004\b\u001e\u0010\u0012R\u001a\u0010\b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0010\"\u0004\b \u0010\u0012R\u001a\u0010\r\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0018\"\u0004\b\"\u0010\u001aR\u001a\u0010\n\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0010\"\u0004\b$\u0010\u0012R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0010\"\u0004\b&\u0010\u0012\u00a8\u0006:"}, d2={"Lorg/intocps/maestro/fmi/ModelDescription$BaseUnit$Builder;", "", "kg", "", "m", "s", "A", "K", "mol", "cd", "rad", "factor", "", "offset", "(IIIIIIIIDD)V", "getA", "()I", "setA", "(I)V", "getK", "setK", "getCd", "setCd", "getFactor", "()D", "setFactor", "(D)V", "getKg", "setKg", "getM", "setM", "getMol", "setMol", "getOffset", "setOffset", "getRad", "setRad", "getS", "setS", "build", "Lorg/intocps/maestro/fmi/ModelDescription$BaseUnit;", "component1", "component10", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "hashCode", "toString", "", "fmi"})
        public static final class Builder {
            private int kg;
            private int m;
            private int s;
            private int A;
            private int K;
            private int mol;
            private int cd;
            private int rad;
            private double factor;
            private double offset;

            public Builder(int kg, int m, int s, int A, int K, int mol, int cd, int rad, double factor, double offset) {
                this.kg = kg;
                this.m = m;
                this.s = s;
                this.A = A;
                this.K = K;
                this.mol = mol;
                this.cd = cd;
                this.rad = rad;
                this.factor = factor;
                this.offset = offset;
            }

            public /* synthetic */ Builder(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, double d, double d2, int n9, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n9 & 1) != 0) {
                    n = 0;
                }
                if ((n9 & 2) != 0) {
                    n2 = 0;
                }
                if ((n9 & 4) != 0) {
                    n3 = 0;
                }
                if ((n9 & 8) != 0) {
                    n4 = 0;
                }
                if ((n9 & 0x10) != 0) {
                    n5 = 0;
                }
                if ((n9 & 0x20) != 0) {
                    n6 = 0;
                }
                if ((n9 & 0x40) != 0) {
                    n7 = 0;
                }
                if ((n9 & 0x80) != 0) {
                    n8 = 0;
                }
                if ((n9 & 0x100) != 0) {
                    d = 1.0;
                }
                if ((n9 & 0x200) != 0) {
                    d2 = 0.0;
                }
                this(n, n2, n3, n4, n5, n6, n7, n8, d, d2);
            }

            public final int getKg() {
                return this.kg;
            }

            public final void setKg(int n) {
                this.kg = n;
            }

            public final int getM() {
                return this.m;
            }

            public final void setM(int n) {
                this.m = n;
            }

            public final int getS() {
                return this.s;
            }

            public final void setS(int n) {
                this.s = n;
            }

            public final int getA() {
                return this.A;
            }

            public final void setA(int n) {
                this.A = n;
            }

            public final int getK() {
                return this.K;
            }

            public final void setK(int n) {
                this.K = n;
            }

            public final int getMol() {
                return this.mol;
            }

            public final void setMol(int n) {
                this.mol = n;
            }

            public final int getCd() {
                return this.cd;
            }

            public final void setCd(int n) {
                this.cd = n;
            }

            public final int getRad() {
                return this.rad;
            }

            public final void setRad(int n) {
                this.rad = n;
            }

            public final double getFactor() {
                return this.factor;
            }

            public final void setFactor(double d) {
                this.factor = d;
            }

            public final double getOffset() {
                return this.offset;
            }

            public final void setOffset(double d) {
                this.offset = d;
            }

            @NotNull
            public final Builder setKg(int kg) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$setKg_u24lambda_u2d0 = builder;
                boolean bl3 = false;
                $this$setKg_u24lambda_u2d0.setKg(kg);
                return builder;
            }

            @NotNull
            public final Builder setM(int m) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$setM_u24lambda_u2d1 = builder;
                boolean bl3 = false;
                $this$setM_u24lambda_u2d1.setM(m);
                return builder;
            }

            @NotNull
            public final Builder setS(int s) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$setS_u24lambda_u2d2 = builder;
                boolean bl3 = false;
                $this$setS_u24lambda_u2d2.setS(s);
                return builder;
            }

            @NotNull
            public final Builder setA(int A) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$setA_u24lambda_u2d3 = builder;
                boolean bl3 = false;
                $this$setA_u24lambda_u2d3.setA(A);
                return builder;
            }

            @NotNull
            public final Builder setK(int K) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$setK_u24lambda_u2d4 = builder;
                boolean bl3 = false;
                $this$setK_u24lambda_u2d4.setK(K);
                return builder;
            }

            @NotNull
            public final Builder setMol(int mol) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$setMol_u24lambda_u2d5 = builder;
                boolean bl3 = false;
                $this$setMol_u24lambda_u2d5.setMol(mol);
                return builder;
            }

            @NotNull
            public final Builder setCd(int cd) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$setCd_u24lambda_u2d6 = builder;
                boolean bl3 = false;
                $this$setCd_u24lambda_u2d6.setCd(cd);
                return builder;
            }

            @NotNull
            public final Builder setRad(int rad) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$setRad_u24lambda_u2d7 = builder;
                boolean bl3 = false;
                $this$setRad_u24lambda_u2d7.setRad(rad);
                return builder;
            }

            @NotNull
            public final Builder setFactor(double factor) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$setFactor_u24lambda_u2d8 = builder;
                boolean bl3 = false;
                $this$setFactor_u24lambda_u2d8.setFactor(factor);
                return builder;
            }

            @NotNull
            public final Builder setOffset(double offset) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$setOffset_u24lambda_u2d9 = builder;
                boolean bl3 = false;
                $this$setOffset_u24lambda_u2d9.setOffset(offset);
                return builder;
            }

            @NotNull
            public final BaseUnit build() {
                return new BaseUnit(this.kg, this.m, this.s, this.A, this.K, this.mol, this.cd, this.rad, this.factor, this.offset, null);
            }

            public final int component1() {
                return this.kg;
            }

            public final int component2() {
                return this.m;
            }

            public final int component3() {
                return this.s;
            }

            public final int component4() {
                return this.A;
            }

            public final int component5() {
                return this.K;
            }

            public final int component6() {
                return this.mol;
            }

            public final int component7() {
                return this.cd;
            }

            public final int component8() {
                return this.rad;
            }

            public final double component9() {
                return this.factor;
            }

            public final double component10() {
                return this.offset;
            }

            @NotNull
            public final Builder copy(int kg, int m, int s, int A, int K, int mol, int cd, int rad, double factor, double offset) {
                return new Builder(kg, m, s, A, K, mol, cd, rad, factor, offset);
            }

            public static /* synthetic */ Builder copy$default(Builder builder, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, double d, double d2, int n9, Object object) {
                if ((n9 & 1) != 0) {
                    n = builder.kg;
                }
                if ((n9 & 2) != 0) {
                    n2 = builder.m;
                }
                if ((n9 & 4) != 0) {
                    n3 = builder.s;
                }
                if ((n9 & 8) != 0) {
                    n4 = builder.A;
                }
                if ((n9 & 0x10) != 0) {
                    n5 = builder.K;
                }
                if ((n9 & 0x20) != 0) {
                    n6 = builder.mol;
                }
                if ((n9 & 0x40) != 0) {
                    n7 = builder.cd;
                }
                if ((n9 & 0x80) != 0) {
                    n8 = builder.rad;
                }
                if ((n9 & 0x100) != 0) {
                    d = builder.factor;
                }
                if ((n9 & 0x200) != 0) {
                    d2 = builder.offset;
                }
                return builder.copy(n, n2, n3, n4, n5, n6, n7, n8, d, d2);
            }

            @NotNull
            public String toString() {
                return "Builder(kg=" + this.kg + ", m=" + this.m + ", s=" + this.s + ", A=" + this.A + ", K=" + this.K + ", mol=" + this.mol + ", cd=" + this.cd + ", rad=" + this.rad + ", factor=" + this.factor + ", offset=" + this.offset + ')';
            }

            public int hashCode() {
                int result = Integer.hashCode(this.kg);
                result = result * 31 + Integer.hashCode(this.m);
                result = result * 31 + Integer.hashCode(this.s);
                result = result * 31 + Integer.hashCode(this.A);
                result = result * 31 + Integer.hashCode(this.K);
                result = result * 31 + Integer.hashCode(this.mol);
                result = result * 31 + Integer.hashCode(this.cd);
                result = result * 31 + Integer.hashCode(this.rad);
                result = result * 31 + Double.hashCode(this.factor);
                result = result * 31 + Double.hashCode(this.offset);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Builder)) {
                    return false;
                }
                Builder builder = (Builder)other;
                if (this.kg != builder.kg) {
                    return false;
                }
                if (this.m != builder.m) {
                    return false;
                }
                if (this.s != builder.s) {
                    return false;
                }
                if (this.A != builder.A) {
                    return false;
                }
                if (this.K != builder.K) {
                    return false;
                }
                if (this.mol != builder.mol) {
                    return false;
                }
                if (this.cd != builder.cd) {
                    return false;
                }
                if (this.rad != builder.rad) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.factor, (Object)builder.factor)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.offset, (Object)builder.offset);
            }

            public Builder() {
                this(0, 0, 0, 0, 0, 0, 0, 0, 0.0, 0.0, 1023, null);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\t\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/intocps/maestro/fmi/ModelDescription$LogCategory;", "", "name", "", "description", "(Ljava/lang/String;Ljava/lang/String;)V", "getDescription", "()Ljava/lang/String;", "getName", "toString", "fmi"})
    public static final class LogCategory {
        @NotNull
        private final String name;
        @NotNull
        private final String description;

        public LogCategory(@NotNull String name, @NotNull String description) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(description, "description");
            this.name = name;
            this.description = description;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        @NotNull
        public String toString() {
            return this.name;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u00062\b\u0010\t\u001a\u0004\u0018\u00010\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/intocps/maestro/fmi/ModelDescription$ResourceResolver;", "Lorg/w3c/dom/ls/LSResourceResolver;", "()V", "resolveResource", "Lorg/w3c/dom/ls/LSInput;", "type", "", "namespaceURI", "publicId", "systemId", "baseURI", "fmi"})
    public static final class ResourceResolver
    implements LSResourceResolver {
        @Override
        @NotNull
        public LSInput resolveResource(@Nullable String type, @Nullable String namespaceURI, @Nullable String publicId, @Nullable String systemId, @Nullable String baseURI) {
            InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream(systemId);
            String string = publicId;
            String string2 = string == null ? "" : string;
            string = systemId;
            return new Input(string2, string == null ? "" : string, resourceAsStream);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\n\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010\u0015\u001a\u00020\u0003H\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010\u0017\u001a\u00020\u0003H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0006H\u0016J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u0011H\u0016J\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u0013H\u0016J\u0010\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u0003H\u0016J\u0010\u0010#\u001a\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020\u0003H\u0016J\u0010\u0010&\u001a\u00020\u00192\u0006\u0010\u0004\u001a\u00020\u0003H\u0016R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/intocps/maestro/fmi/ModelDescription$Input;", "Lorg/w3c/dom/ls/LSInput;", "publicId", "", "systemId", "input", "Ljava/io/InputStream;", "(Ljava/lang/String;Ljava/lang/String;Ljava/io/InputStream;)V", "inputStream", "Ljava/io/BufferedInputStream;", "getInputStream", "()Ljava/io/BufferedInputStream;", "setInputStream", "(Ljava/io/BufferedInputStream;)V", "getBaseURI", "getByteStream", "getCertifiedText", "", "getCharacterStream", "Ljava/io/Reader;", "getEncoding", "getPublicId", "getStringData", "getSystemId", "setBaseURI", "", "baseURI", "setByteStream", "byteStream", "setCertifiedText", "certifiedText", "setCharacterStream", "characterStream", "setEncoding", "encoding", "setPublicId", "setStringData", "stringData", "setSystemId", "fmi"})
    public static final class Input
    implements LSInput {
        @NotNull
        private String publicId;
        @NotNull
        private String systemId;
        @Nullable
        private BufferedInputStream inputStream;

        public Input(@NotNull String publicId, @NotNull String systemId, @Nullable InputStream input) {
            Intrinsics.checkNotNullParameter(publicId, "publicId");
            Intrinsics.checkNotNullParameter(systemId, "systemId");
            this.publicId = publicId;
            this.systemId = systemId;
            this.inputStream = input == null ? null : new BufferedInputStream(input);
        }

        @Nullable
        public final BufferedInputStream getInputStream() {
            return this.inputStream;
        }

        public final void setInputStream(@Nullable BufferedInputStream bufferedInputStream) {
            this.inputStream = bufferedInputStream;
        }

        @Override
        @NotNull
        public String getPublicId() {
            return this.publicId;
        }

        @Override
        public void setPublicId(@NotNull String publicId) {
            Intrinsics.checkNotNullParameter(publicId, "publicId");
            this.publicId = publicId;
        }

        @Override
        @Nullable
        public String getBaseURI() {
            return null;
        }

        @Override
        public void setBaseURI(@NotNull String baseURI) {
            Intrinsics.checkNotNullParameter(baseURI, "baseURI");
        }

        @Override
        @Nullable
        public InputStream getByteStream() {
            return null;
        }

        @Override
        public void setByteStream(@NotNull InputStream byteStream) {
            Intrinsics.checkNotNullParameter(byteStream, "byteStream");
        }

        @Override
        public boolean getCertifiedText() {
            return false;
        }

        @Override
        public void setCertifiedText(boolean certifiedText) {
        }

        @Override
        @Nullable
        public Reader getCharacterStream() {
            return null;
        }

        @Override
        public void setCharacterStream(@NotNull Reader characterStream) {
            Intrinsics.checkNotNullParameter(characterStream, "characterStream");
        }

        @Override
        @Nullable
        public String getEncoding() {
            return null;
        }

        @Override
        public void setEncoding(@NotNull String encoding) {
            Intrinsics.checkNotNullParameter(encoding, "encoding");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public String getStringData() {
            BufferedInputStream bufferedInputStream = this.inputStream;
            Intrinsics.checkNotNull(bufferedInputStream);
            boolean bl = false;
            boolean bl2 = false;
            synchronized (bufferedInputStream) {
                String string;
                boolean bl3 = false;
                try {
                    BufferedInputStream bufferedInputStream2 = this.getInputStream();
                    Intrinsics.checkNotNull(bufferedInputStream2);
                    byte[] input = new byte[bufferedInputStream2.available()];
                    bufferedInputStream2 = this.getInputStream();
                    Intrinsics.checkNotNull(bufferedInputStream2);
                    bufferedInputStream2.read(input);
                    boolean bl4 = false;
                    string = new String(input, Charsets.UTF_8);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    String string2 = Intrinsics.stringPlus("Exception ", e);
                    boolean bl5 = false;
                    System.out.println((Object)string2);
                    string = null;
                }
                String string3 = string;
                return string3;
            }
        }

        @Override
        public void setStringData(@NotNull String stringData) {
            Intrinsics.checkNotNullParameter(stringData, "stringData");
        }

        @Override
        @NotNull
        public String getSystemId() {
            return this.systemId;
        }

        @Override
        public void setSystemId(@NotNull String systemId) {
            Intrinsics.checkNotNullParameter(systemId, "systemId");
            this.systemId = systemId;
        }
    }
}

