/*
 * Decompiled with CFR 0.152.
 */
package com.spencerwi.either;

import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class Either<L, R> {
    public static <L, R> Either<L, R> either(Supplier<L> leftSupplier, Supplier<R> rightSupplier) {
        R rightValue = rightSupplier.get();
        if (rightValue != null) {
            return Either.right(rightValue);
        }
        return Either.left(leftSupplier.get());
    }

    public static <L, R> Either<L, R> left(L left) {
        return new Left(left);
    }

    public static <L, R> Either<L, R> right(R right) {
        return new Right(right);
    }

    public abstract L getLeft();

    public abstract R getRight();

    public abstract boolean isLeft();

    public abstract boolean isRight();

    public abstract <T> T fold(Function<L, T> var1, Function<R, T> var2);

    public abstract <T, U> Either<T, U> map(Function<L, T> var1, Function<R, U> var2);

    public abstract void run(Consumer<L> var1, Consumer<R> var2);

    public static class Right<L, R>
    extends Either<L, R> {
        protected R rightValue;

        private Right(R right) {
            this.rightValue = right;
        }

        @Override
        public L getLeft() {
            throw new NoSuchElementException("Tried to getLeft from a Right");
        }

        @Override
        public R getRight() {
            return this.rightValue;
        }

        @Override
        public boolean isLeft() {
            return false;
        }

        @Override
        public boolean isRight() {
            return true;
        }

        @Override
        public <T> T fold(Function<L, T> transformLeft, Function<R, T> transformRight) {
            return transformRight.apply(this.rightValue);
        }

        @Override
        public <T, U> Either<T, U> map(Function<L, T> transformLeft, Function<R, U> transformRight) {
            return Either.right(transformRight.apply(this.rightValue));
        }

        @Override
        public void run(Consumer<L> runLeft, Consumer<R> runRight) {
            runRight.accept(this.rightValue);
        }

        public int hashCode() {
            return this.rightValue.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof Right) {
                Right otherAsRight = (Right)other;
                return this.rightValue.equals(otherAsRight.rightValue);
            }
            return false;
        }
    }

    public static class Left<L, R>
    extends Either<L, R> {
        protected L leftValue;

        private Left(L left) {
            this.leftValue = left;
        }

        @Override
        public L getLeft() {
            return this.leftValue;
        }

        @Override
        public R getRight() {
            throw new NoSuchElementException("Tried to getRight from a Left");
        }

        @Override
        public boolean isLeft() {
            return true;
        }

        @Override
        public boolean isRight() {
            return false;
        }

        @Override
        public <T> T fold(Function<L, T> transformLeft, Function<R, T> transformRight) {
            return transformLeft.apply(this.leftValue);
        }

        @Override
        public <T, U> Either<T, U> map(Function<L, T> transformLeft, Function<R, U> transformRight) {
            return Either.left(transformLeft.apply(this.leftValue));
        }

        @Override
        public void run(Consumer<L> runLeft, Consumer<R> runRight) {
            runLeft.accept(this.leftValue);
        }

        public int hashCode() {
            return this.leftValue.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof Left) {
                Left otherAsLeft = (Left)other;
                return this.leftValue.equals(otherAsLeft.leftValue);
            }
            return false;
        }
    }
}

