/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.fmi.jnifmuapi;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.io.IOUtils;
import org.intocps.fmi.Fmi2Status;
import org.intocps.fmi.FmiInvalidNativeStateException;
import org.intocps.fmi.FmuInvocationException;
import org.intocps.fmi.FmuMissingLibraryException;
import org.intocps.fmi.IFmiComponent;
import org.intocps.fmi.IFmu;
import org.intocps.fmi.IFmuCallback;
import org.intocps.fmi.jnifmuapi.FmiUtil;
import org.intocps.fmi.jnifmuapi.FmuComponent;
import org.intocps.fmi.jnifmuapi.NativeFmu;
import org.intocps.fmi.jnifmuapi.NativeFmuLibraryLoader;
import org.intocps.fmi.jnifmuapi.shared.NativeLoadManager;

class DirectoryFmu
extends NativeFmu
implements IFmu {
    protected static final String MODEL_DESCRIPTION = "modelDescription.xml";
    public final String name;
    public final File dir;
    protected final NativeLoadManager lifeCycle;

    public long getFmuPtr() {
        return this.lifeCycle.getFmuPtr();
    }

    public DirectoryFmu(File path, String name) {
        this.dir = path;
        this.name = name;
        this.lifeCycle = new NativeLoadManager(this.dir, this.name, new LiveCycleProtectedFunctions(this));
    }

    @Override
    public void load() throws FmuInvocationException, FmuMissingLibraryException {
        if (this.lifeCycle.isLoaded()) {
            return;
        }
        String modelIdentifier = null;
        String errorMsg = "Fmu do not conform to the standard. Unable to obtain modelIdentifier '%s' for co-simulation, defaulting to archieve name '%s'";
        String recovery_log_message = "Attempting to recover loading of the library by setting modelIdentifier to {}";
        try {
            modelIdentifier = FmiUtil.getModelIdentifier(this.getModelDescription());
        }
        catch (IOException e) {
            logger.error(String.format("Fmu do not conform to the standard. Unable to obtain modelIdentifier '%s' for co-simulation, defaulting to archieve name '%s'", "", this.name), e);
            logger.warn("Attempting to recover loading of the library by setting modelIdentifier to {}", (Object)this.name);
        }
        this.lifeCycle.load(modelIdentifier, FmiUtil.FMIVersion.FMI2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IFmiComponent instantiate(String guid, String name, boolean visible, boolean loggingOn, final IFmuCallback callback) throws XPathExpressionException, FmiInvalidNativeStateException {
        long c;
        if (!this.lifeCycle.isLoaded()) {
            return null;
        }
        File resourceDir = new File(this.dir, "resources");
        resourceDir.mkdirs();
        URI resourceUri = resourceDir.toURI();
        if (System.getProperty("fmi.instantiate.with.empty.authority") != null && resourceUri.getAuthority() == null) {
            try {
                logger.debug("Inserting empty authority into URI: {}", (Object)resourceUri);
                resourceUri = new URI(resourceUri.getScheme(), "", resourceUri.getPath(), null);
                logger.trace("URI changed to '{}'", (Object)resourceUri);
            }
            catch (URISyntaxException e) {
                logger.error("Failed to create resourceUri with empty authority");
            }
        }
        String resourceLocation = resourceUri.toString();
        logger.trace("resourceLocationURI is: '{}'", (Object)resourceUri);
        NativeFmu.ICallback cb = null;
        if (callback != null) {
            cb = new NativeFmu.ICallback(){

                @Override
                public void log(String name, byte status, String category, String message) {
                    callback.log(name, Fmi2Status.valueOf(status), category, message);
                }

                @Override
                public void stepFinished(byte fmuStatus) {
                    callback.stepFinished(Fmi2Status.valueOf(fmuStatus));
                }
            };
        }
        this.lifeCycle.checkState();
        Object object = NativeLoadManager.lock;
        synchronized (object) {
            c = this.ninstantiate(this.lifeCycle.getFmuPtr(), name, guid, resourceLocation, visible, loggingOn, cb);
        }
        if (c == 0L) {
            return null;
        }
        return new FmuComponent(this, c, guid, name);
    }

    @Override
    public void unLoad() throws FmiInvalidNativeStateException {
        this.lifeCycle.unLoad();
    }

    @Override
    public String getVersion() throws FmiInvalidNativeStateException {
        this.lifeCycle.checkState();
        return this.nGetVersion(this.lifeCycle.getFmuPtr());
    }

    @Override
    public String getTypesPlatform() throws FmiInvalidNativeStateException {
        this.lifeCycle.checkState();
        return this.nGetTypesPlatform(this.lifeCycle.getFmuPtr());
    }

    @Override
    public InputStream getModelDescription() throws IOException {
        File path = new File(this.dir, MODEL_DESCRIPTION);
        if (!path.exists() || !path.canRead()) {
            return null;
        }
        byte[] bytes = IOUtils.toByteArray(new FileInputStream(path));
        return new ByteArrayInputStream(bytes);
    }

    @Override
    public boolean isValid() {
        return this.lifeCycle.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void synchronizedFree(FmuComponent comp) throws FmiInvalidNativeStateException {
        Object object = NativeLoadManager.lock;
        synchronized (object) {
            comp.internalFreeInstance();
        }
    }

    public static String getJniApiVersion() {
        NativeFmuLibraryLoader.loadNativeApi();
        return NativeFmu.nGetJniApiVersion();
    }

    static class LiveCycleProtectedFunctions
    implements NativeLoadManager.NativeLifecycleFunction {
        final NativeFmu nativeFmu;

        public LiveCycleProtectedFunctions(NativeFmu nativeFmu) {
            this.nativeFmu = nativeFmu;
        }

        @Override
        public long lifeCycleLoadLibrary(String libraryPath) {
            return this.nativeFmu.nLoadLibrary(libraryPath);
        }

        @Override
        public void lifeCycleUnLoad(long ptr) {
            this.nativeFmu.nUnLoad(ptr);
        }
    }
}

