/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.fmi.jnifmuapi;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.intocps.fmi.Fmi2Status;
import org.intocps.fmi.Fmi2StatusKind;
import org.intocps.fmi.FmiInvalidNativeStateException;
import org.intocps.fmi.FmuInvocationException;
import org.intocps.fmi.FmuResult;
import org.intocps.fmi.IFmiComponent;
import org.intocps.fmi.IFmiComponentState;
import org.intocps.fmi.IFmu;
import org.intocps.fmi.InvalidParameterException;
import org.intocps.fmi.jnifmuapi.DirectoryFmu;
import org.intocps.fmi.jnifmuapi.FmuComponentState;
import org.intocps.fmi.jnifmuapi.NativeFmuComponent;

public class FmuComponent
extends NativeFmuComponent
implements IFmiComponent {
    private final long componentPtr;
    private final long fmuPtr;
    private final IFmu fmu;
    private final String guid;
    private final String name;

    public FmuComponent(DirectoryFmu fmu, long componentPtr, String guid, String name) {
        this.fmu = fmu;
        this.fmuPtr = fmu.getFmuPtr();
        this.componentPtr = componentPtr;
        this.guid = guid;
        this.name = name;
    }

    @Override
    public IFmu getFmu() {
        return this.fmu;
    }

    @Override
    public Fmi2Status setDebugLogging(boolean loggingOn, String[] categories) throws FmiInvalidNativeStateException {
        this.checkState();
        return Fmi2Status.valueOf(this.nSetDebugLogging(this.fmuPtr, this.componentPtr, loggingOn, categories));
    }

    @Override
    public Fmi2Status setupExperiment(boolean toleranceDefined, double tolerance, double startTime, boolean stopTimeDefined, double stopTime) throws FmiInvalidNativeStateException {
        this.checkState();
        return Fmi2Status.valueOf(this.nSetupExperiment(this.fmuPtr, this.componentPtr, toleranceDefined, tolerance, startTime, stopTimeDefined, stopTime));
    }

    @Override
    public Fmi2Status enterInitializationMode() throws FmiInvalidNativeStateException {
        this.checkState();
        return Fmi2Status.valueOf(this.nEnterInitializationMode(this.fmuPtr, this.componentPtr));
    }

    @Override
    public Fmi2Status exitInitializationMode() throws FmiInvalidNativeStateException {
        this.checkState();
        return Fmi2Status.valueOf(this.nExitInitializationMode(this.fmuPtr, this.componentPtr));
    }

    @Override
    public Fmi2Status reset() throws FmiInvalidNativeStateException {
        this.checkState();
        return Fmi2Status.valueOf(this.nReset(this.fmuPtr, this.componentPtr));
    }

    @Override
    public Fmi2Status setRealInputDerivatives(long[] scalarValueIndices, int[] order, double[] derivatives) throws FmuInvocationException {
        if (scalarValueIndices.length != derivatives.length) {
            throw new FmuInvocationException("Value count and derivative value count must match");
        }
        this.checkOrder(order);
        this.checkState();
        Fmi2Status status = Fmi2Status.valueOf(this.nSetRealInputDerivatives(this.fmuPtr, this.componentPtr, scalarValueIndices, scalarValueIndices.length, order, derivatives));
        return status;
    }

    private void checkOrder(int[] order) throws FmuInvocationException {
        if (order == null || order.length == 0) {
            throw new FmuInvocationException("Orders must not be null or empty");
        }
        for (int i : order) {
            if (i >= 1) continue;
            throw new FmuInvocationException("Order must be 1 or greater: " + i);
        }
    }

    @Override
    public FmuResult<double[]> getRealOutputDerivatives(long[] scalarValueIndices, int[] order) throws FmuInvocationException {
        this.checkOrder(order);
        double[] res = new double[scalarValueIndices.length];
        this.checkState();
        Fmi2Status status = Fmi2Status.valueOf(this.nGetRealOutputDerivatives(this.fmuPtr, this.componentPtr, scalarValueIndices, scalarValueIndices.length, order, res));
        return new FmuResult<double[]>(status, res);
    }

    @Override
    public FmuResult<double[]> getDirectionalDerivative(long[] vUnknownRef, long[] vKnownRef, double[] dvKnown) throws FmiInvalidNativeStateException {
        long nUnknownSize = vUnknownRef.length;
        long nKnownSize = vKnownRef.length;
        double[] dvUnknown = new double[(int)nKnownSize];
        this.checkState();
        Fmi2Status status = Fmi2Status.valueOf(this.nGetDirectionalDerivative(this.fmuPtr, this.componentPtr, vUnknownRef, nUnknownSize, vKnownRef, nKnownSize, dvKnown, dvUnknown));
        return new FmuResult<double[]>(status, dvUnknown);
    }

    @Override
    public Fmi2Status doStep(double currentCommunicationPoint, double communicationStepSize, boolean noSetFMUStatePriorToCurrentPoint) throws FmiInvalidNativeStateException {
        this.checkState();
        return Fmi2Status.valueOf(this.nDoStep(this.fmuPtr, this.componentPtr, currentCommunicationPoint, communicationStepSize, noSetFMUStatePriorToCurrentPoint));
    }

    @Override
    public FmuResult<double[]> getReal(long[] scalarValueIndices) throws FmiInvalidNativeStateException {
        this.checkState();
        double[] res = new double[scalarValueIndices.length];
        Fmi2Status status = Fmi2Status.valueOf(this.nGetReal(this.fmuPtr, this.componentPtr, scalarValueIndices, scalarValueIndices.length, res));
        return new FmuResult<double[]>(status, res);
    }

    @Override
    public FmuResult<int[]> getInteger(long[] scalarValueIndices) throws FmiInvalidNativeStateException {
        this.checkState();
        int[] res = new int[scalarValueIndices.length];
        Fmi2Status status = Fmi2Status.valueOf(this.nGetInteger(this.fmuPtr, this.componentPtr, scalarValueIndices, scalarValueIndices.length, res));
        return new FmuResult<int[]>(status, res);
    }

    @Override
    public FmuResult<boolean[]> getBooleans(long[] scalarValueIndices) throws FmiInvalidNativeStateException {
        this.checkState();
        boolean[] res = new boolean[scalarValueIndices.length];
        Fmi2Status status = Fmi2Status.valueOf(this.nGetBoolean(this.fmuPtr, this.componentPtr, scalarValueIndices, scalarValueIndices.length, res));
        return new FmuResult<boolean[]>(status, res);
    }

    @Override
    public FmuResult<String[]> getStrings(long[] scalarValueIndices) throws FmuInvocationException {
        this.checkState();
        String[] res = new String[scalarValueIndices.length];
        Fmi2Status status = Fmi2Status.valueOf(this.nGetString(this.fmuPtr, this.componentPtr, scalarValueIndices, scalarValueIndices.length, res));
        return new FmuResult<String[]>(status, res);
    }

    @Override
    public Fmi2Status setBooleans(long[] scalarValueIndices, boolean[] values2) throws InvalidParameterException, FmiInvalidNativeStateException {
        if (scalarValueIndices.length != values2.length) {
            throw new InvalidParameterException("Length of index and value array does not match");
        }
        this.checkState();
        return Fmi2Status.valueOf(this.nSetBoolean(this.fmuPtr, this.componentPtr, scalarValueIndices, scalarValueIndices.length, values2));
    }

    @Override
    public Fmi2Status setReals(long[] scalarValueIndices, double[] values2) throws InvalidParameterException, FmiInvalidNativeStateException {
        if (scalarValueIndices.length != values2.length) {
            throw new InvalidParameterException("Length of index and value array does not match");
        }
        this.checkState();
        return Fmi2Status.valueOf(this.nSetReal(this.fmuPtr, this.componentPtr, scalarValueIndices, scalarValueIndices.length, values2));
    }

    @Override
    public Fmi2Status setIntegers(long[] scalarValueIndices, int[] values2) throws InvalidParameterException, FmiInvalidNativeStateException {
        if (scalarValueIndices.length != values2.length) {
            throw new InvalidParameterException("Length of index and value array does not match");
        }
        this.checkState();
        return Fmi2Status.valueOf(this.nSetInteger(this.fmuPtr, this.componentPtr, scalarValueIndices, scalarValueIndices.length, values2));
    }

    @Override
    public Fmi2Status setStrings(long[] scalarValueIndices, String[] values2) throws InvalidParameterException, FmiInvalidNativeStateException {
        if (scalarValueIndices.length != values2.length) {
            throw new InvalidParameterException("Length of index and value array does not match");
        }
        this.checkState();
        return Fmi2Status.valueOf(this.nSetString(this.fmuPtr, this.componentPtr, scalarValueIndices, scalarValueIndices.length, values2));
    }

    public static String convertToString(Object arr) {
        List<Object> l = new Vector();
        if (arr.getClass().isArray()) {
            int length = Array.getLength(arr);
            for (int i = 0; i < length; ++i) {
                Object arrayElement = Array.get(arr, i);
                l.add(arrayElement);
            }
        }
        if (arr instanceof List) {
            l = (List)arr;
        }
        String s = "[ ";
        Iterator itr = l.iterator();
        while (itr.hasNext()) {
            Object o = itr.next();
            s = s + o.toString();
            if (!itr.hasNext()) continue;
            s = s + ", ";
        }
        return s + " ]";
    }

    @Override
    public FmuResult<Fmi2Status> getStatus(Fmi2StatusKind kind) throws FmiInvalidNativeStateException {
        this.checkState();
        byte[] b = new byte[1];
        Fmi2Status status = Fmi2Status.valueOf(this.nGetStatus(this.fmuPtr, this.componentPtr, kind.value, b));
        return new FmuResult<Fmi2Status>(status, Fmi2Status.valueOf(b[0]));
    }

    @Override
    public FmuResult<Boolean> getBooleanStatus(Fmi2StatusKind kind) throws FmiInvalidNativeStateException {
        this.checkState();
        boolean[] b = new boolean[1];
        Fmi2Status status = Fmi2Status.valueOf(this.nGetBooleanStatus(this.fmuPtr, this.componentPtr, kind.value, b));
        return new FmuResult<Boolean>(status, b[0]);
    }

    @Override
    public FmuResult<Integer> getIntegerStatus(Fmi2StatusKind kind) throws FmiInvalidNativeStateException {
        this.checkState();
        int[] b = new int[1];
        Fmi2Status status = Fmi2Status.valueOf(this.nGetIntegerStatus(this.fmuPtr, this.componentPtr, kind.value, b));
        return new FmuResult<Integer>(status, b[0]);
    }

    @Override
    public FmuResult<Double> getRealStatus(Fmi2StatusKind kind) throws FmiInvalidNativeStateException {
        this.checkState();
        double[] b = new double[1];
        Fmi2Status status = Fmi2Status.valueOf(this.nGetRealStatus(this.fmuPtr, this.componentPtr, kind.value, b));
        return new FmuResult<Double>(status, b[0]);
    }

    @Override
    public FmuResult<String> getStringStatus(Fmi2StatusKind kind) throws FmiInvalidNativeStateException {
        this.checkState();
        String[] b = new String[1];
        Fmi2Status status = Fmi2Status.valueOf(this.nGetStringStatus(this.fmuPtr, this.componentPtr, kind.value, b));
        return new FmuResult<String>(status, b[0]);
    }

    @Override
    public Fmi2Status terminate() throws FmiInvalidNativeStateException {
        this.checkState();
        return Fmi2Status.valueOf(this.nTerminate(this.fmuPtr, this.componentPtr));
    }

    @Override
    public void freeInstance() throws FmiInvalidNativeStateException {
        this.checkState();
        if (this.fmu instanceof DirectoryFmu) {
            ((DirectoryFmu)this.fmu).synchronizedFree(this);
        } else {
            this.internalFreeInstance();
        }
    }

    void internalFreeInstance() throws FmiInvalidNativeStateException {
        this.nFreeInstance(this.fmuPtr, this.componentPtr);
    }

    public String toString() {
        return this.guid + "." + this.name;
    }

    @Override
    public boolean isValid() {
        return this.fmuPtr != 0L && this.componentPtr != 0L;
    }

    private void checkState() throws FmiInvalidNativeStateException {
        if (!this.isValid()) {
            throw new FmiInvalidNativeStateException("The internal " + (this.fmuPtr != 0L ? "" : " FMU state is invalid. ") + (this.componentPtr != 0L ? "" : " Component state is invalid"));
        }
    }

    @Override
    public FmuResult<IFmiComponentState> getState() throws FmuInvocationException {
        long[] statePtr = new long[1];
        Fmi2Status res = Fmi2Status.valueOf(this.nGetFmuState(this.fmuPtr, this.componentPtr, statePtr));
        if (res == Fmi2Status.OK) {
            return new FmuResult<IFmiComponentState>(res, new FmuComponentState(this, statePtr[0]));
        }
        return new FmuResult<Object>(res, null);
    }

    @Override
    public Fmi2Status setState(IFmiComponentState state) throws FmuInvocationException {
        if (state != null && state instanceof FmuComponentState) {
            FmuComponentState st = (FmuComponentState)state;
            if (st.comp == this && st.allocated) {
                Fmi2Status res = Fmi2Status.valueOf(this.nSetFmuState(this.fmuPtr, this.componentPtr, st.ptr));
                return res;
            }
        }
        throw new FmuInvocationException("Invalid state");
    }

    @Override
    public Fmi2Status freeState(IFmiComponentState state) throws FmuInvocationException {
        if (state != null && state instanceof FmuComponentState) {
            FmuComponentState st = (FmuComponentState)state;
            if (st.comp == this && st.allocated) {
                Fmi2Status res = Fmi2Status.valueOf(this.nFreeFmuState(this.fmuPtr, this.componentPtr, st.ptr));
                if (res == Fmi2Status.OK) {
                    st.allocated = false;
                }
                return res;
            }
        }
        throw new FmuInvocationException("Invalid state");
    }

    @Override
    public FmuResult<Double> getMaxStepSize() throws FmiInvalidNativeStateException {
        this.checkState();
        double[] res = new double[1];
        Fmi2Status status = Fmi2Status.valueOf(this.nGetMaxStepsize(this.fmuPtr, this.componentPtr, res));
        return new FmuResult<Double>(status, status == Fmi2Status.Error ? Double.MAX_VALUE : res[0]);
    }
}

