/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.reload4j;

import java.util.Deque;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.MDC;
import org.slf4j.helpers.ThreadLocalMapOfStacks;
import org.slf4j.spi.MDCAdapter;

public class Reload4jMDCAdapter
implements MDCAdapter {
    private final ThreadLocalMapOfStacks threadLocalMapOfDeques = new ThreadLocalMapOfStacks();

    @Override
    public void clear() {
        Hashtable map = MDC.getContext();
        if (map != null) {
            map.clear();
        }
    }

    @Override
    public String get(String key) {
        return (String)MDC.get(key);
    }

    @Override
    public void put(String key, String val) {
        MDC.put(key, val);
    }

    @Override
    public void remove(String key) {
        MDC.remove(key);
    }

    public Map getCopyOfContextMap() {
        Hashtable old = MDC.getContext();
        if (old != null) {
            return new HashMap(old);
        }
        return null;
    }

    @Override
    public void setContextMap(Map<String, String> contextMap) {
        Hashtable old = MDC.getContext();
        if (contextMap == null) {
            if (old != null) {
                old.clear();
            }
            return;
        }
        if (old == null) {
            for (Map.Entry<String, String> mapEntry : contextMap.entrySet()) {
                MDC.put(mapEntry.getKey(), mapEntry);
            }
        } else {
            old.clear();
            old.putAll(contextMap);
        }
    }

    @Override
    public void pushByKey(String key, String value) {
        this.threadLocalMapOfDeques.pushByKey(key, value);
    }

    @Override
    public String popByKey(String key) {
        return this.threadLocalMapOfDeques.popByKey(key);
    }

    @Override
    public Deque<String> getCopyOfDequeByKey(String key) {
        return this.threadLocalMapOfDeques.getCopyOfDequeByKey(key);
    }

    @Override
    public void clearDequeByKey(String key) {
        this.threadLocalMapOfDeques.clearDequeByKey(key);
    }
}

