/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.fmi.jnifmuapi;

import java.io.File;
import org.intocps.fmi.jnifmuapi.shared.NativeFmuApi;
import org.intocps.fmi.jnifmuapi.shared.NativeLibraryLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeFmuLibraryLoader {
    static final Logger logger = LoggerFactory.getLogger(NativeFmuLibraryLoader.class);
    private static boolean isLoaded;

    public static void loadNativeApi() {
        if (isLoaded) {
            return;
        }
        String libPath = NativeFmuApi.getPlatformSpecificLibraryPath("fmuapi");
        logger.debug("Loading library: " + libPath);
        try {
            File lib = new NativeLibraryLoader().loadLibrary(libPath);
            logger.debug("Loaded Library file: " + lib);
            isLoaded = true;
        }
        catch (Exception e) {
            logger.error("Failed to load native Library file: " + libPath, e);
            isLoaded = false;
            throw new RuntimeException("Failed to load native Library file: " + libPath, e);
        }
    }

    public static boolean isNativeApiLoaded() {
        return isLoaded;
    }
}

