/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.fmi.jnifmuapi;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;

public class TempDirectory {
    final Path path;

    public TempDirectory(String prefix) {
        try {
            this.path = Files.createTempDirectory(prefix, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Path getPath() {
        return this.path;
    }

    public void deleteOnExit() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                TempDirectory.delete(TempDirectory.this.path);
            }
        });
    }

    private static void deleteOrScheduleOnExit(final Path path) {
        try {
            Files.deleteIfExists(path);
        }
        catch (IOException e) {
            try {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        try {
                            TempDirectory.delete(path);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public static void delete(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    TempDirectory.deleteOrScheduleOnExit(dir);
                    return super.postVisitDirectory(dir, exc);
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    TempDirectory.deleteOrScheduleOnExit(file);
                    return super.visitFile(file, attrs);
                }
            });
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

