/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.fmi.jnifmuapi.fmi3;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.intocps.fmi.FmiInvalidNativeStateException;
import org.intocps.fmi.FmuInvocationException;
import org.intocps.fmi.FmuMissingLibraryException;
import org.intocps.fmi.jnifmuapi.FmiUtil;
import org.intocps.fmi.jnifmuapi.NativeFmuLibraryLoader;
import org.intocps.fmi.jnifmuapi.fmi3.Fmi3Instance;
import org.intocps.fmi.jnifmuapi.fmi3.IClockUpdateCallback;
import org.intocps.fmi.jnifmuapi.fmi3.IFmi3Fmu;
import org.intocps.fmi.jnifmuapi.fmi3.IFmi3Instance;
import org.intocps.fmi.jnifmuapi.fmi3.IIntermediateUpdateCallback;
import org.intocps.fmi.jnifmuapi.fmi3.ILockPreemptionCallback;
import org.intocps.fmi.jnifmuapi.fmi3.ILogMessageCallback;
import org.intocps.fmi.jnifmuapi.fmi3.IUnlockPreemptionCallback;
import org.intocps.fmi.jnifmuapi.fmi3.NativeFmu3;
import org.intocps.fmi.jnifmuapi.shared.NativeLoadManager;

public class DirectoryFmi3Fmu
extends NativeFmu3
implements IFmi3Fmu {
    protected static final String MODEL_DESCRIPTION = "modelDescription.xml";
    public final String name;
    public final File dir;
    protected final NativeLoadManager lifeCycle;

    public long getFmuPtr() {
        return this.lifeCycle.getFmuPtr();
    }

    public DirectoryFmi3Fmu(File path, String name) {
        this.dir = path;
        this.name = name;
        this.lifeCycle = new NativeLoadManager(this.dir, this.name, new LiveCycleProtectedFunctions(this));
    }

    @Override
    public void load() throws FmuInvocationException, FmuMissingLibraryException {
        if (this.lifeCycle.isLoaded()) {
            return;
        }
        if (!this.lifeCycle.isDirValid()) {
            throw new FmuInvocationException("FMU Directory invalid: " + this.dir);
        }
        String modelIdentifier = null;
        String errorMsg = "Fmu do not conform to the standard. Unable to obtain modelIdentifier '%s' for co-simulation, defaulting to archieve name '%s'";
        String recovery_log_message = "Attempting to recover loading of the library by setting modelIdentifier to {}";
        try {
            modelIdentifier = FmiUtil.getModelIdentifier(this.getModelDescription());
        }
        catch (IOException e) {
            logger.error(String.format("Fmu do not conform to the standard. Unable to obtain modelIdentifier '%s' for co-simulation, defaulting to archieve name '%s'", "", this.name), e);
            logger.warn("Attempting to recover loading of the library by setting modelIdentifier to {}", (Object)this.name);
        }
        this.lifeCycle.load(modelIdentifier, FmiUtil.FMIVersion.FMI3);
    }

    @Override
    public void unLoad() throws FmiInvalidNativeStateException {
        this.lifeCycle.unLoad();
    }

    @Override
    public String getVersion() throws FmiInvalidNativeStateException {
        NativeFmuLibraryLoader.loadNativeApi();
        return this.nGetVersion(this.getFmuPtr());
    }

    @Override
    public InputStream getModelDescription() throws IOException {
        File path = new File(this.dir, MODEL_DESCRIPTION);
        if (!path.exists() || !path.canRead()) {
            return null;
        }
        byte[] bytes = IOUtils.toByteArray(new FileInputStream(path));
        return new ByteArrayInputStream(bytes);
    }

    @Override
    public boolean isValid() {
        return this.lifeCycle.isValid();
    }

    protected String getResourceLocation() {
        File resourceDir = new File(this.dir, "resources");
        resourceDir.mkdirs();
        resourceDir = resourceDir.getAbsoluteFile();
        logger.trace("resourceLocation is: '{}'", (Object)resourceDir);
        return resourceDir.toString();
    }

    @Override
    public IFmi3Instance instantiateModelExchange(String instanceName, String instantiationToken, boolean visible, boolean loggingOn, ILogMessageCallback logMessage) {
        if (!this.lifeCycle.isLoaded()) {
            return null;
        }
        long instancePtr = this.nInstantiateModelExchange(this.lifeCycle.getFmuPtr(), instanceName, instantiationToken, this.getResourceLocation(), visible, loggingOn, logMessage);
        if (instancePtr == 0L) {
            return null;
        }
        return new Fmi3Instance(instancePtr, this);
    }

    @Override
    public IFmi3Instance instantiateCoSimulation(String instanceName, String instantiationToken, boolean visible, boolean loggingOn, boolean eventModeUsed, boolean earlyReturnAllowed, long[] requiredIntermediateVariables, ILogMessageCallback logMessage, IIntermediateUpdateCallback intermediateUpdate) {
        long instancePtr;
        if (!this.lifeCycle.isLoaded()) {
            return null;
        }
        if (requiredIntermediateVariables == null) {
            requiredIntermediateVariables = new long[]{};
        }
        if ((instancePtr = this.nInstantiateCoSimulation(this.lifeCycle.getFmuPtr(), instanceName, instantiationToken, this.getResourceLocation(), visible, loggingOn, eventModeUsed, earlyReturnAllowed, requiredIntermediateVariables, requiredIntermediateVariables.length, logMessage, intermediateUpdate)) == 0L) {
            return null;
        }
        return new Fmi3Instance(instancePtr, this);
    }

    @Override
    public IFmi3Instance instantiateScheduledExecution(String instanceName, String instantiationToken, boolean visible, boolean loggingOn, ILogMessageCallback logMessage, IClockUpdateCallback clockUpdate, ILockPreemptionCallback lockPreemption, IUnlockPreemptionCallback unlockPreemption) {
        if (!this.lifeCycle.isLoaded()) {
            return null;
        }
        long instancePtr = this.nInstantiateScheduledExecution(this.lifeCycle.getFmuPtr(), instanceName, instantiationToken, this.getResourceLocation(), visible, loggingOn, logMessage, clockUpdate, lockPreemption, unlockPreemption);
        if (instancePtr == 0L) {
            return null;
        }
        return new Fmi3Instance(instancePtr, this);
    }

    public static String getJniApiFmiVersion() {
        NativeFmuLibraryLoader.loadNativeApi();
        return NativeFmu3.nGetJniApiFmiVersion();
    }

    static class LiveCycleProtectedFunctions
    implements NativeLoadManager.NativeLifecycleFunction {
        final NativeFmu3 nativeFmu;

        public LiveCycleProtectedFunctions(NativeFmu3 nativeFmu) {
            this.nativeFmu = nativeFmu;
        }

        @Override
        public long lifeCycleLoadLibrary(String libraryPath) {
            return this.nativeFmu.nLoadLibrary(libraryPath);
        }

        @Override
        public void lifeCycleUnLoad(long ptr) {
            this.nativeFmu.nUnLoad(ptr);
        }
    }
}

