/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.fmi.jnifmuapi.fmi3;

import org.intocps.fmi.FmiInvalidNativeStateException;
import org.intocps.fmi.jnifmuapi.fmi3.DirectoryFmi3Fmu;
import org.intocps.fmi.jnifmuapi.fmi3.Fmi3State;
import org.intocps.fmi.jnifmuapi.fmi3.Fmi3Status;
import org.intocps.fmi.jnifmuapi.fmi3.FmuResult;
import org.intocps.fmi.jnifmuapi.fmi3.IFmi3Instance;
import org.intocps.fmi.jnifmuapi.fmi3.NativeFmu3Instance;

public class Fmi3Instance
extends NativeFmu3Instance
implements IFmi3Instance {
    private final long instancePtr;
    private final DirectoryFmi3Fmu fmu;
    private final long fmuPtr;

    public Fmi3Instance(long instancePtr, DirectoryFmi3Fmu fmi3Fmu) {
        this.instancePtr = instancePtr;
        this.fmu = fmi3Fmu;
        this.fmuPtr = fmi3Fmu.getFmuPtr();
    }

    @Override
    public Fmi3Status terminate() throws FmiInvalidNativeStateException {
        this.checkState();
        return this.nTerminate(this.instancePtr);
    }

    @Override
    public Fmi3Status reset() throws FmiInvalidNativeStateException {
        this.checkState();
        return this.nReset(this.instancePtr);
    }

    @Override
    public void freeInstance() throws FmiInvalidNativeStateException {
        this.checkState();
        this.nFreeInstance(this.instancePtr);
    }

    @Override
    public Fmi3Status enterInitializationMode(Double tolerance, double startTime, Double stopTime) throws FmiInvalidNativeStateException {
        this.checkState();
        return this.nEnterInitializationMode(this.instancePtr, tolerance != null, tolerance == null ? 0.0 : tolerance, startTime, stopTime != null, stopTime == null ? 0.0 : stopTime);
    }

    @Override
    public Fmi3Status exitInitializationMode() throws FmiInvalidNativeStateException {
        this.checkState();
        return this.nExitInitializationMode(this.instancePtr);
    }

    @Override
    public Fmi3Status enterEventMode() throws FmiInvalidNativeStateException {
        this.checkState();
        return this.nEnterEventMode(this.instancePtr);
    }

    @Override
    public Fmi3Status enterConfigurationMode() throws FmiInvalidNativeStateException {
        this.checkState();
        return this.nEnterConfigurationMode(this.instancePtr);
    }

    @Override
    public Fmi3Status exitConfigurationMode() throws FmiInvalidNativeStateException {
        this.checkState();
        return this.nExitConfigurationMode(this.instancePtr);
    }

    @Override
    public FmuResult<IFmi3Instance.DoStepResult> doStep(double currentCommunicationPoint, double communicationStepSize, boolean noSetFMUStatePriorToCurrentPoint) throws FmiInvalidNativeStateException {
        boolean[] eventHandlingNeeded = new boolean[1];
        boolean[] terminateSimulation = new boolean[1];
        boolean[] earlyReturn = new boolean[1];
        double[] lastSuccessfulTime = new double[1];
        return new FmuResult<IFmi3Instance.DoStepResult>(this.doStep(currentCommunicationPoint, communicationStepSize, noSetFMUStatePriorToCurrentPoint, eventHandlingNeeded, terminateSimulation, earlyReturn, lastSuccessfulTime), new IFmi3Instance.DoStepResult(eventHandlingNeeded[0], terminateSimulation[0], earlyReturn[0], lastSuccessfulTime[0]));
    }

    @Override
    public Fmi3Status doStep(double currentCommunicationPoint, double communicationStepSize, boolean noSetFMUStatePriorToCurrentPoint, boolean[] eventHandlingNeeded, boolean[] terminateSimulation, boolean[] earlyReturn, double[] lastSuccessfulTime) throws FmiInvalidNativeStateException {
        this.checkState();
        if (eventHandlingNeeded == null || eventHandlingNeeded.length < 1) {
            eventHandlingNeeded = new boolean[1];
        }
        if (terminateSimulation == null || terminateSimulation.length < 1) {
            terminateSimulation = new boolean[1];
        }
        if (earlyReturn == null || earlyReturn.length < 1) {
            earlyReturn = new boolean[1];
        }
        if (lastSuccessfulTime == null || lastSuccessfulTime.length < 1) {
            lastSuccessfulTime = new double[1];
        }
        return this.nDoStep(this.instancePtr, currentCommunicationPoint, communicationStepSize, noSetFMUStatePriorToCurrentPoint, eventHandlingNeeded, terminateSimulation, earlyReturn, lastSuccessfulTime);
    }

    @Override
    public Fmi3Status setDebugLogging(boolean loggingOn, String ... categories) throws FmiInvalidNativeStateException {
        this.checkState();
        if (categories == null) {
            categories = new String[]{};
        }
        return this.nSetDebugLogging(this.instancePtr, loggingOn, categories);
    }

    @Override
    public FmuResult<Long> getNumberOfVariableDependencies(long valueReference) throws FmiInvalidNativeStateException {
        this.checkState();
        long[] ret = new long[1];
        Fmi3Status status = this.nGetNumberOfVariableDependencies(this.instancePtr, valueReference, ret);
        return new FmuResult<Long>(status, ret[0]);
    }

    @Override
    public Fmi3Status setClock(long[] valueReferences, boolean[] clockActive) throws FmiInvalidNativeStateException {
        this.checkState();
        if (valueReferences == null) {
            valueReferences = new long[]{};
        }
        if (clockActive == null) {
            clockActive = new boolean[]{};
        }
        return this.nSetClock(this.instancePtr, valueReferences, valueReferences.length, clockActive);
    }

    @Override
    public FmuResult<boolean[]> getClock(long[] valueReferences) throws FmiInvalidNativeStateException {
        this.checkState();
        if (valueReferences == null) {
            valueReferences = new long[]{};
        }
        boolean[] result = new boolean[valueReferences.length];
        return new FmuResult<boolean[]>(this.nGetClock(this.instancePtr, valueReferences, valueReferences.length, result), result);
    }

    @Override
    public FmuResult<IFmi3Instance.VariableDependency> getVariableDependencies(long dependent, long nDependencies) throws FmiInvalidNativeStateException {
        this.checkState();
        IFmi3Instance.VariableDependency dependency = new IFmi3Instance.VariableDependency((int)nDependencies);
        Fmi3Status status = this.nGetVariableDependencies(this.instancePtr, dependent, dependency.elementIndicesOfDependent, dependency.independents, dependency.elementIndicesOfIndependents, dependency.dependencyKinds, nDependencies);
        return new FmuResult<IFmi3Instance.VariableDependency>(status, dependency);
    }

    @Override
    public FmuResult<Fmi3State> getState() throws FmiInvalidNativeStateException {
        this.checkState();
        long[] s = new long[1];
        Fmi3Status status = this.nGetFMUState(this.instancePtr, s);
        return new FmuResult<Fmi3State>(status, new Fmu3StateImpl(s[0]){

            @Override
            public Fmi3Status free() throws FmiInvalidNativeStateException {
                return Fmi3Instance.this.freeState(this);
            }
        });
    }

    @Override
    public Fmi3Status setState(Fmi3State state) throws FmiInvalidNativeStateException {
        this.checkState();
        if (state instanceof Fmu3StateImpl) {
            return this.nSetFMUState(this.instancePtr, ((Fmu3StateImpl)state).ptr);
        }
        return Fmi3Status.Error;
    }

    @Override
    public Fmi3Status freeState(Fmi3State state) throws FmiInvalidNativeStateException {
        this.checkState();
        if (state instanceof Fmu3StateImpl) {
            return this.nFreeFMUState(this.instancePtr, ((Fmu3StateImpl)state).ptr);
        }
        return Fmi3Status.Error;
    }

    @Override
    public FmuResult<Long> getSerializedStateSize(Fmi3State state) throws FmiInvalidNativeStateException {
        this.checkState();
        if (state instanceof Fmu3StateImpl) {
            long[] size = new long[1];
            Fmi3Status status = this.nSerializedFMUStateSize(this.instancePtr, ((Fmu3StateImpl)state).ptr, size);
            return new FmuResult<Long>(status, size[0]);
        }
        return new FmuResult<Object>(Fmi3Status.Error, null);
    }

    @Override
    public FmuResult<byte[]> serializedState(Fmi3State state, long size) throws FmiInvalidNativeStateException {
        this.checkState();
        if (state instanceof Fmu3StateImpl) {
            byte[] data = new byte[(int)size];
            Fmi3Status status = this.nSerializeFMUState(this.instancePtr, ((Fmu3StateImpl)state).ptr, data, size);
            return new FmuResult<byte[]>(status, data);
        }
        return new FmuResult<Object>(Fmi3Status.Error, null);
    }

    @Override
    public FmuResult<Fmi3State> deSerializedState(byte[] serializedState) throws FmiInvalidNativeStateException {
        this.checkState();
        if (serializedState == null) {
            return new FmuResult<Object>(Fmi3Status.Error, null);
        }
        long[] ptr = new long[1];
        Fmi3Status status = this.nDeserializeFMUState(this.instancePtr, serializedState, serializedState.length, ptr);
        return new FmuResult<Fmi3State>(status, new Fmu3StateImpl(ptr[0]){

            @Override
            public Fmi3Status free() throws FmiInvalidNativeStateException {
                return Fmi3Instance.this.freeState(this);
            }
        });
    }

    @Override
    public FmuResult<double[]> getDirectionalDerivative(long[] unknowns, long[] knowns, double[] seed) throws FmiInvalidNativeStateException {
        this.checkState();
        if (unknowns == null) {
            unknowns = new long[]{};
        }
        if (knowns == null) {
            knowns = new long[]{};
        }
        if (seed == null) {
            seed = new double[]{};
        }
        double[] sensitivity = new double[knowns.length * unknowns.length];
        Fmi3Status status = this.nGetDirectionalDerivative(this.instancePtr, unknowns, unknowns.length, knowns, knowns.length, seed, seed.length, sensitivity, sensitivity.length);
        return new FmuResult<double[]>(status, sensitivity);
    }

    @Override
    public FmuResult<double[]> getGetAdjointDerivative(long[] unknowns, long[] knowns, double[] seed, int nSensitivity) throws FmiInvalidNativeStateException {
        this.checkState();
        if (unknowns == null) {
            unknowns = new long[]{};
        }
        if (knowns == null) {
            knowns = new long[]{};
        }
        if (seed == null) {
            seed = new double[]{};
        }
        double[] sensitivity = new double[nSensitivity];
        Fmi3Status status = this.nGetAdjointDerivative(this.instancePtr, unknowns, unknowns.length, knowns, knowns.length, seed, seed.length, sensitivity, sensitivity.length);
        return new FmuResult<double[]>(status, sensitivity);
    }

    @Override
    public FmuResult<IFmi3Instance.GetIntervalDecimalResponse> getIntervalDecimal(long[] valueReferences) throws FmiInvalidNativeStateException {
        this.checkState();
        if (valueReferences == null) {
            valueReferences = new long[]{};
        }
        IFmi3Instance.GetIntervalDecimalResponse response = new IFmi3Instance.GetIntervalDecimalResponse(valueReferences.length);
        Fmi3Status status = this.nGetIntervalDecimal(this.instancePtr, valueReferences, valueReferences.length, response.intervals, response.qualifiers);
        return new FmuResult<IFmi3Instance.GetIntervalDecimalResponse>(status, response);
    }

    @Override
    public FmuResult<IFmi3Instance.IntervalFractionResponse> getIntervalFraction(long[] valueReferences) throws FmiInvalidNativeStateException {
        this.checkState();
        if (valueReferences == null) {
            valueReferences = new long[]{};
        }
        IFmi3Instance.IntervalFractionResponse response = new IFmi3Instance.IntervalFractionResponse(valueReferences.length);
        Fmi3Status status = this.nGetIntervalFraction(this.instancePtr, valueReferences, valueReferences.length, response.intervalCounters, response.resolutions, response.qualifiers);
        return new FmuResult<IFmi3Instance.IntervalFractionResponse>(status, response);
    }

    @Override
    public FmuResult<double[]> getShiftDecimal(long[] valueReferences) throws FmiInvalidNativeStateException {
        this.checkState();
        if (valueReferences == null) {
            valueReferences = new long[]{};
        }
        double[] shifts = new double[valueReferences.length];
        Fmi3Status status = this.nGetShiftDecimal(this.instancePtr, valueReferences, valueReferences.length, shifts);
        return new FmuResult<double[]>(status, shifts);
    }

    @Override
    public FmuResult<IFmi3Instance.GetShiftFractionResponse> getShiftFraction(long[] valueReferences) throws FmiInvalidNativeStateException {
        this.checkState();
        if (valueReferences == null) {
            valueReferences = new long[]{};
        }
        IFmi3Instance.GetShiftFractionResponse response = new IFmi3Instance.GetShiftFractionResponse(valueReferences.length);
        Fmi3Status status = this.nGetShiftFraction(this.instancePtr, valueReferences, valueReferences.length, response.shiftCounters, response.resolutions);
        return new FmuResult<IFmi3Instance.GetShiftFractionResponse>(status, response);
    }

    @Override
    public Fmi3Status setIntervalDecimal(long[] valueReferences, double[] intervals) throws FmiInvalidNativeStateException {
        this.checkState();
        if (valueReferences == null) {
            valueReferences = new long[]{};
        }
        if (intervals == null) {
            intervals = new double[]{};
        }
        return this.nSetIntervalDecimal(this.instancePtr, valueReferences, valueReferences.length, intervals);
    }

    @Override
    public Fmi3Status setIntervalFraction(long[] valueReferences, long[] intervalCounters, long[] resolutions) throws FmiInvalidNativeStateException {
        this.checkState();
        if (valueReferences == null) {
            valueReferences = new long[]{};
        }
        if (intervalCounters == null) {
            intervalCounters = new long[]{};
        }
        if (resolutions == null) {
            resolutions = new long[]{};
        }
        return this.nSetIntervalFraction(this.instancePtr, valueReferences, valueReferences.length, intervalCounters, resolutions);
    }

    @Override
    public Fmi3Status setShiftDecimal(long[] valueReferences, double[] shifts) {
        if (valueReferences == null) {
            valueReferences = new long[]{};
        }
        if (shifts == null) {
            shifts = new double[]{};
        }
        return this.nSetShiftDecimal(this.instancePtr, valueReferences, valueReferences.length, shifts);
    }

    @Override
    public Fmi3Status setShiftFraction(long[] valueReferences, long[] counters, long[] resolutions) {
        if (valueReferences == null) {
            valueReferences = new long[]{};
        }
        if (counters == null) {
            counters = new long[]{};
        }
        if (resolutions == null) {
            resolutions = new long[]{};
        }
        return this.nSetShiftFraction(this.instancePtr, valueReferences, valueReferences.length, counters, resolutions);
    }

    @Override
    public Fmi3Status evaluateDiscreteStates() throws FmiInvalidNativeStateException {
        this.checkState();
        return this.nEvaluateDiscreteStates(this.instancePtr);
    }

    @Override
    public FmuResult<IFmi3Instance.UpdateDiscreteStates> updateDiscreteStates() throws FmiInvalidNativeStateException {
        this.checkState();
        double[] nextEventTime = new double[1];
        boolean[] discreteStatesNeedUpdate = new boolean[1];
        boolean[] terminateSimulation = new boolean[1];
        boolean[] nominalsOfContinuousStatesChanged = new boolean[1];
        boolean[] valuesOfContinuousStatesChanged = new boolean[1];
        boolean[] nextEventTimeDefined = new boolean[1];
        return new FmuResult<IFmi3Instance.UpdateDiscreteStates>(this.nUpdateDiscreteStates(this.instancePtr, discreteStatesNeedUpdate, terminateSimulation, nominalsOfContinuousStatesChanged, valuesOfContinuousStatesChanged, nextEventTimeDefined, nextEventTime), new IFmi3Instance.UpdateDiscreteStates(discreteStatesNeedUpdate[0], terminateSimulation[0], nominalsOfContinuousStatesChanged[0], valuesOfContinuousStatesChanged[0], nextEventTimeDefined[0], nextEventTime[0]));
    }

    @Override
    public Fmi3Status enterContinuousTimeMode() throws FmiInvalidNativeStateException {
        this.checkState();
        return this.nEnterContinuousTimeMode(this.instancePtr);
    }

    @Override
    public FmuResult<IFmi3Instance.CompletedIntegratorStepResponse> completedIntegratorStep(boolean noSetFMUStatePriorToCurrentPoint) throws FmiInvalidNativeStateException {
        this.checkState();
        boolean[] terminateSimulation = new boolean[1];
        boolean[] enterEventMode = new boolean[1];
        Fmi3Status status = this.nCompletedIntegratorStep(this.instancePtr, noSetFMUStatePriorToCurrentPoint, enterEventMode, terminateSimulation);
        return new FmuResult<IFmi3Instance.CompletedIntegratorStepResponse>(status, new IFmi3Instance.CompletedIntegratorStepResponse(enterEventMode[0], terminateSimulation[0]));
    }

    @Override
    public Fmi3Status setTime(double time) throws FmiInvalidNativeStateException {
        this.checkState();
        return this.nSetTime(this.instancePtr, time);
    }

    @Override
    public Fmi3Status setContinuousStates(double[] continuousStates) throws FmiInvalidNativeStateException {
        this.checkState();
        if (continuousStates == null) {
            continuousStates = new double[]{};
        }
        return this.nSetContinuousStates(this.instancePtr, continuousStates, continuousStates.length);
    }

    @Override
    public FmuResult<double[]> getContinuousStateDerivatives(int nContinuousStates) throws FmiInvalidNativeStateException {
        this.checkState();
        double[] derivatives = new double[nContinuousStates];
        Fmi3Status status = this.nGetContinuousStateDerivatives(this.instancePtr, derivatives, derivatives.length);
        return new FmuResult<double[]>(status, derivatives);
    }

    @Override
    public FmuResult<double[]> getGetEventIndicators(int nEventIndicators) throws FmiInvalidNativeStateException {
        this.checkState();
        double[] indicators = new double[nEventIndicators];
        Fmi3Status status = this.nGetEventIndicators(this.instancePtr, indicators, indicators.length);
        return new FmuResult<double[]>(status, indicators);
    }

    @Override
    public FmuResult<double[]> getGetContinuousStates(int nContinuousStates) throws FmiInvalidNativeStateException {
        this.checkState();
        double[] continuousStates = new double[nContinuousStates];
        return new FmuResult<double[]>(this.nGetContinuousStates(this.instancePtr, continuousStates, nContinuousStates), continuousStates);
    }

    @Override
    public FmuResult<double[]> getGetNominalsOfContinuousStates(int nContinuousStates) throws FmiInvalidNativeStateException {
        this.checkState();
        double[] nominals = new double[nContinuousStates];
        return new FmuResult<double[]>(this.nGetNominalsOfContinuousStates(this.instancePtr, nominals, nContinuousStates), nominals);
    }

    @Override
    public FmuResult<Long> getNumberOfEventIndicators() throws FmiInvalidNativeStateException {
        this.checkState();
        long[] count = new long[1];
        Fmi3Status status = this.nGetNumberOfEventIndicators(this.instancePtr, count);
        return new FmuResult<Long>(status, count[0]);
    }

    @Override
    public FmuResult<Long> getNumberOfContinuousStates() throws FmiInvalidNativeStateException {
        this.checkState();
        long[] count = new long[1];
        Fmi3Status status = this.nGetNumberOfContinuousStates(this.instancePtr, count);
        return new FmuResult<Long>(status, count[0]);
    }

    @Override
    public Fmi3Status enterStepMode() throws FmiInvalidNativeStateException {
        this.checkState();
        return this.nEnterStepMode(this.instancePtr);
    }

    @Override
    public FmuResult<double[]> getOutputDerivatives(long[] valueReferences, int[] orders) throws FmiInvalidNativeStateException {
        this.checkState();
        double[] values2 = new double[valueReferences.length];
        Fmi3Status status = this.nGetOutputDerivatives(this.instancePtr, valueReferences, valueReferences.length, orders, values2, valueReferences.length);
        return new FmuResult<double[]>(status, values2);
    }

    @Override
    public Fmi3Status activateModelPartition(long clockReference, double activationTime) throws FmiInvalidNativeStateException {
        this.checkState();
        return this.nActivateModelPartition(this.instancePtr, clockReference, activationTime);
    }

    @Override
    public FmuResult<float[]> getFloat32(long[] valueReferences, int nValueReferences, int nValues) throws FmiInvalidNativeStateException {
        this.checkState();
        float[] out = new float[nValues];
        return new FmuResult<float[]>(this.nGetFloat32(this.instancePtr, valueReferences, nValueReferences, out, nValues), out);
    }

    @Override
    public FmuResult<double[]> getFloat64(long[] valueReferences, int nValueReferences, int nValues) throws FmiInvalidNativeStateException {
        this.checkState();
        double[] out = new double[nValues];
        return new FmuResult<double[]>(this.nGetFloat64(this.instancePtr, valueReferences, nValueReferences, out, nValues), out);
    }

    @Override
    public FmuResult<byte[]> getInt8(long[] valueReferences, int nValueReferences, int nValues) throws FmiInvalidNativeStateException {
        this.checkState();
        byte[] out = new byte[nValues];
        return new FmuResult<byte[]>(this.nGetInt8(this.instancePtr, valueReferences, nValueReferences, out, nValues), out);
    }

    @Override
    public FmuResult<byte[]> getUInt8(long[] valueReferences, int nValueReferences, int nValues) throws FmiInvalidNativeStateException {
        this.checkState();
        byte[] out = new byte[nValues];
        return new FmuResult<byte[]>(this.nGetUInt8(this.instancePtr, valueReferences, nValueReferences, out, nValues), out);
    }

    @Override
    public FmuResult<short[]> getInt16(long[] valueReferences, int nValueReferences, int nValues) throws FmiInvalidNativeStateException {
        this.checkState();
        short[] out = new short[nValues];
        return new FmuResult<short[]>(this.nGetInt16(this.instancePtr, valueReferences, nValueReferences, out, nValues), out);
    }

    @Override
    public FmuResult<short[]> getUInt16(long[] valueReferences, int nValueReferences, int nValues) throws FmiInvalidNativeStateException {
        this.checkState();
        short[] out = new short[nValues];
        return new FmuResult<short[]>(this.nGetUInt16(this.instancePtr, valueReferences, nValueReferences, out, nValues), out);
    }

    @Override
    public FmuResult<int[]> getInt32(long[] valueReferences, int nValueReferences, int nValues) throws FmiInvalidNativeStateException {
        this.checkState();
        int[] out = new int[nValues];
        return new FmuResult<int[]>(this.nGetInt32(this.instancePtr, valueReferences, nValueReferences, out, nValues), out);
    }

    @Override
    public FmuResult<int[]> getUInt32(long[] valueReferences, int nValueReferences, int nValues) throws FmiInvalidNativeStateException {
        this.checkState();
        int[] out = new int[nValues];
        return new FmuResult<int[]>(this.nGetUInt32(this.instancePtr, valueReferences, nValueReferences, out, nValues), out);
    }

    @Override
    public FmuResult<long[]> getInt64(long[] valueReferences, int nValueReferences, int nValues) throws FmiInvalidNativeStateException {
        this.checkState();
        long[] out = new long[nValues];
        return new FmuResult<long[]>(this.nGetInt64(this.instancePtr, valueReferences, nValueReferences, out, nValues), out);
    }

    @Override
    public FmuResult<long[]> getUInt64(long[] valueReferences, int nValueReferences, int nValues) throws FmiInvalidNativeStateException {
        this.checkState();
        long[] out = new long[nValues];
        return new FmuResult<long[]>(this.nGetUInt64(this.instancePtr, valueReferences, nValueReferences, out, nValues), out);
    }

    @Override
    public FmuResult<boolean[]> getBoolean(long[] valueReferences, int nValueReferences, int nValues) throws FmiInvalidNativeStateException {
        this.checkState();
        boolean[] out = new boolean[nValues];
        return new FmuResult<boolean[]>(this.nGetBoolean(this.instancePtr, valueReferences, nValueReferences, out, nValues), out);
    }

    @Override
    public FmuResult<String[]> getString(long[] valueReferences, int nValueReferences, int nValues) throws FmiInvalidNativeStateException {
        this.checkState();
        String[] out = new String[nValues];
        return new FmuResult<String[]>(this.nGetString(this.instancePtr, valueReferences, nValueReferences, out, nValues), out);
    }

    @Override
    public FmuResult<byte[][]> getBinary(long[] valueReferences, int nValueReferences) throws FmiInvalidNativeStateException {
        this.checkState();
        byte[][] out = new byte[valueReferences.length][];
        return new FmuResult<byte[][]>(this.nGetBinary(this.instancePtr, valueReferences, valueReferences.length, out, out.length), out);
    }

    @Override
    public Fmi3Status setFloat32(long[] valueReferences, int nValueReferences, float[] values2, int nv) throws FmiInvalidNativeStateException {
        this.checkState();
        return this.nSetFloat32(this.instancePtr, valueReferences, nValueReferences, values2, nv);
    }

    @Override
    public Fmi3Status setFloat64(long[] valueReferences, int nValueReferences, double[] values2, int nv) throws FmiInvalidNativeStateException {
        this.checkState();
        return this.nSetFloat64(this.instancePtr, valueReferences, nValueReferences, values2, nv);
    }

    @Override
    public Fmi3Status setInt8(long[] valueReferences, int nValueReferences, byte[] values2, int nv) throws FmiInvalidNativeStateException {
        this.checkState();
        return this.nSetInt8(this.instancePtr, valueReferences, nValueReferences, values2, nv);
    }

    @Override
    public Fmi3Status setUInt8(long[] valueReferences, int nValueReferences, byte[] values2, int nv) throws FmiInvalidNativeStateException {
        this.checkState();
        return this.nSetUInt8(this.instancePtr, valueReferences, nValueReferences, values2, nv);
    }

    @Override
    public Fmi3Status setInt16(long[] valueReferences, int nValueReferences, short[] values2, int nv) throws FmiInvalidNativeStateException {
        this.checkState();
        return this.nSetInt16(this.instancePtr, valueReferences, nValueReferences, values2, nv);
    }

    @Override
    public Fmi3Status setUInt16(long[] valueReferences, int nValueReferences, short[] values2, int nv) throws FmiInvalidNativeStateException {
        this.checkState();
        return this.nSetUInt16(this.instancePtr, valueReferences, nValueReferences, values2, nv);
    }

    @Override
    public Fmi3Status setInt32(long[] valueReferences, int nValueReferences, int[] values2, int nv) throws FmiInvalidNativeStateException {
        this.checkState();
        return this.nSetInt32(this.instancePtr, valueReferences, nValueReferences, values2, nv);
    }

    @Override
    public Fmi3Status setUInt32(long[] valueReferences, int nValueReferences, int[] values2, int nv) throws FmiInvalidNativeStateException {
        this.checkState();
        return this.nSetUInt32(this.instancePtr, valueReferences, nValueReferences, values2, nv);
    }

    @Override
    public Fmi3Status setInt64(long[] valueReferences, int nValueReferences, long[] values2, int nv) throws FmiInvalidNativeStateException {
        this.checkState();
        return this.nSetInt64(this.instancePtr, valueReferences, nValueReferences, values2, nv);
    }

    @Override
    public Fmi3Status setUInt64(long[] valueReferences, int nValueReferences, long[] values2, int nv) throws FmiInvalidNativeStateException {
        this.checkState();
        return this.nSetUInt64(this.instancePtr, valueReferences, nValueReferences, values2, nv);
    }

    @Override
    public Fmi3Status setBoolean(long[] valueReferences, int nValueReferences, boolean[] values2, int nv) throws FmiInvalidNativeStateException {
        this.checkState();
        return this.nSetBoolean(this.instancePtr, valueReferences, nValueReferences, values2, nv);
    }

    @Override
    public Fmi3Status setString(long[] valueReferences, int nValueReferences, String[] values2, int nv) throws FmiInvalidNativeStateException {
        this.checkState();
        return this.nSetString(this.instancePtr, valueReferences, nValueReferences, values2, nv);
    }

    @Override
    public Fmi3Status setBinary(long[] valueReferences, byte[][] array_name) throws FmiInvalidNativeStateException {
        this.checkState();
        long[] sizes = new long[array_name.length];
        for (int i = 0; i < array_name.length; ++i) {
            sizes[i] = array_name[i] == null ? 0L : (long)array_name[i].length;
        }
        return this.nSetBinary(this.instancePtr, valueReferences, valueReferences.length, sizes, array_name, array_name.length);
    }

    @Override
    public boolean isValid() {
        return this.fmuPtr != 0L && this.instancePtr != 0L;
    }

    private void checkState() throws FmiInvalidNativeStateException {
        if (!this.isValid()) {
            throw new FmiInvalidNativeStateException("The internal " + (this.fmuPtr != 0L ? "" : " FMU state is invalid. ") + (this.instancePtr != 0L ? "" : " Component state is invalid"));
        }
    }

    abstract class Fmu3StateImpl
    implements Fmi3State {
        final long ptr;

        public Fmu3StateImpl(long ptr) {
            this.ptr = ptr;
        }
    }
}

