/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.fmi;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.intocps.fmi.jnifmuapi.fmi2.schemas.Fmi2Schema;
import org.intocps.maestro.fmi.ModelDescription;
import org.intocps.maestro.fmi.fmi2.Fmi2ModelDescriptionUnit;
import org.intocps.maestro.fmi.fmi2.Fmi2Unit;
import org.intocps.maestro.fmi.xml.NodeIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class Fmi2ModelDescription
extends Fmi2ModelDescriptionUnit {
    static final Logger logger = LoggerFactory.getLogger(Fmi2ModelDescription.class);
    private final Map<ScalarVariable, ScalarVariable> derivativesMap = new HashMap<ScalarVariable, ScalarVariable>();
    private List<ScalarVariable> scalarVariables = null;
    private List<ScalarVariable> outputs = null;
    private List<ScalarVariable> derivatives = null;
    private List<ScalarVariable> initialUnknowns = null;

    public Fmi2ModelDescription(File file) throws ParserConfigurationException, SAXException, IOException {
        super(Fmi2ModelDescription.getStream(file), new StreamSource(IOUtils.toBufferedInputStream((InputStream)new Fmi2Schema().getSchema())));
    }

    public Fmi2ModelDescription(InputStream file) throws ParserConfigurationException, SAXException, IOException {
        super(file, new StreamSource(IOUtils.toBufferedInputStream((InputStream)new Fmi2Schema().getSchema())));
    }

    private static InputStream getStream(File file) throws IOException {
        byte[] bytes = IOUtils.toByteArray((InputStream)new FileInputStream(file));
        return new ByteArrayInputStream(bytes);
    }

    public String getModelId() throws XPathExpressionException {
        Node name = this.lookupSingle(this.doc, this.xpath, "fmiModelDescription/@modelName");
        if (name == null) {
            return "";
        }
        return name.getNodeValue();
    }

    public String getGuid() throws XPathExpressionException {
        Node name = this.lookupSingle(this.doc, this.xpath, "fmiModelDescription/@guid");
        if (name == null) {
            return "";
        }
        return name.getNodeValue();
    }

    public String getModelVersion() throws XPathExpressionException {
        Node name = this.lookupSingle(this.doc, this.xpath, "fmiModelDescription/@version");
        if (name == null) {
            return "";
        }
        return name.getNodeValue();
    }

    public String getVendorToolName() throws XPathExpressionException {
        Node name = this.lookupSingle(this.doc, this.xpath, "fmiModelDescription/VendorAnnotations/Tool/@name");
        if (name == null) {
            return "";
        }
        return name.getNodeValue();
    }

    public boolean getCanInterpolateInputs() throws XPathExpressionException {
        Node name = this.lookupSingle(this.doc, this.xpath, "fmiModelDescription/CoSimulation/@canInterpolateInputs");
        if (name == null) {
            return false;
        }
        return Boolean.parseBoolean(name.getNodeValue());
    }

    public List<ScalarVariable> getScalarVariables() throws XPathExpressionException, InvocationTargetException, IllegalAccessException {
        if (this.scalarVariables == null) {
            this.parse();
        }
        return this.scalarVariables;
    }

    public List<ScalarVariable> getOutputs() throws XPathExpressionException, InvocationTargetException, IllegalAccessException {
        if (this.outputs == null) {
            this.parse();
        }
        return this.outputs;
    }

    public Map<ScalarVariable, ScalarVariable> getDerivativesMap() throws XPathExpressionException, InvocationTargetException, IllegalAccessException {
        if (this.derivativesMap == null) {
            this.parse();
        }
        return this.derivativesMap;
    }

    public List<ScalarVariable> getDerivatives() throws XPathExpressionException, InvocationTargetException, IllegalAccessException {
        if (this.derivatives == null) {
            this.parse();
        }
        return this.derivatives;
    }

    public List<ScalarVariable> getInitialUnknowns() throws XPathExpressionException, InvocationTargetException, IllegalAccessException {
        if (this.initialUnknowns == null) {
            this.parse();
        }
        return this.initialUnknowns;
    }

    @Override
    public synchronized void parse() throws XPathExpressionException, InvocationTargetException, IllegalAccessException {
        Collection<Fmi2Unit> units = this.getUnitDefinitions();
        Map<String, Fmi2Unit> unitMap = units.stream().collect(Collectors.toMap(Fmi2Unit::getName, u -> u));
        Map<String, SimpleTypeDefinition> typeDefinitions = this.parseTypeDefinitions(unitMap);
        Vector<ScalarVariable> vars = new Vector<ScalarVariable>();
        HashMap<Integer, ScalarVariable> indexMap = new HashMap<Integer, ScalarVariable>();
        int index = 0;
        Vector<ScalarVariable> ders = new Vector<ScalarVariable>();
        for (Node n : new NodeIterator(this.lookup(this.doc, this.xpath, "fmiModelDescription/ModelVariables/ScalarVariable"))) {
            ScalarVariable sc = new ScalarVariable();
            indexMap.put(++index, sc);
            NamedNodeMap attributes = n.getAttributes();
            sc.name = attributes.getNamedItem("name").getNodeValue();
            sc.valueReference = Long.parseLong(attributes.getNamedItem("valueReference").getNodeValue());
            sc.causality = this.getAttribute(Causality.class, attributes, "causality");
            if (sc.causality == null) {
                sc.causality = Causality.Local;
            }
            sc.variability = this.getAttribute(ModelDescription.Variability.class, attributes, "variability");
            sc.initial = this.getAttribute(ModelDescription.Initial.class, attributes, "initial");
            sc.description = this.getNodeValue(attributes, "description", "");
            Node child = this.lookupSingle(n, this.xpath, "Real[1] | Boolean[1] | String[1] | Integer[1] | Enumeration[1]");
            sc.type = this.parseType(Objects.requireNonNull(child, "Unable to lookup type when parsing variable"), typeDefinitions, unitMap);
            if (sc.type.type == Types.Real && ((RealType)sc.type).derivative != null) {
                ders.add(sc);
            }
            vars.add(sc);
        }
        ders.forEach(der -> {
            ScalarVariable derSource = (ScalarVariable)indexMap.get(Integer.parseInt((String)((RealType)der.type).derivative));
            if (derSource.causality == Causality.Output) {
                this.derivativesMap.put(derSource, (ScalarVariable)der);
            }
        });
        for (Node n : new NodeIterator(this.lookup(this.doc, this.xpath, "fmiModelDescription/ModelStructure/Outputs/Unknown"))) {
            this.decodeUnknownElement(indexMap, n, new IOptainUnknownDestination(){

                @Override
                public Map<ScalarVariable, ScalarVariable.DependencyKind> get(ScalarVariable sc) {
                    return sc.outputDependencies;
                }

                @Override
                public List<ScalarVariable> getList() {
                    if (Fmi2ModelDescription.this.outputs == null) {
                        Fmi2ModelDescription.this.outputs = new Vector<ScalarVariable>();
                    }
                    return Fmi2ModelDescription.this.outputs;
                }
            }, ModelStructureElementType.Outputs);
        }
        for (Node n : new NodeIterator(this.lookup(this.doc, this.xpath, "fmiModelDescription/ModelStructure/Derivatives/Unknown"))) {
            this.decodeUnknownElement(indexMap, n, new IOptainUnknownDestination(){

                @Override
                public Map<ScalarVariable, ScalarVariable.DependencyKind> get(ScalarVariable sc) {
                    return sc.derivativesDependencies;
                }

                @Override
                public List<ScalarVariable> getList() {
                    if (Fmi2ModelDescription.this.derivatives == null) {
                        Fmi2ModelDescription.this.derivatives = new Vector<ScalarVariable>();
                    }
                    return Fmi2ModelDescription.this.derivatives;
                }
            }, ModelStructureElementType.Derivatives);
        }
        for (Node n : new NodeIterator(this.lookup(this.doc, this.xpath, "fmiModelDescription/ModelStructure/InitialUnknowns/Unknown"))) {
            this.decodeUnknownElement(indexMap, n, new IOptainUnknownDestination(){

                @Override
                public Map<ScalarVariable, ScalarVariable.DependencyKind> get(ScalarVariable sc) {
                    return sc.initialUnknownsDependencies;
                }

                @Override
                public List<ScalarVariable> getList() {
                    if (Fmi2ModelDescription.this.initialUnknowns == null) {
                        Fmi2ModelDescription.this.initialUnknowns = new Vector<ScalarVariable>();
                    }
                    return Fmi2ModelDescription.this.initialUnknowns;
                }
            }, ModelStructureElementType.InitialUnknown);
        }
        this.scalarVariables = vars;
        if (this.outputs == null) {
            this.outputs = new Vector<ScalarVariable>();
        }
        if (this.derivatives == null) {
            this.derivatives = new Vector<ScalarVariable>();
        }
        if (this.initialUnknowns == null) {
            this.initialUnknowns = new Vector<ScalarVariable>();
        }
    }

    private Map<String, SimpleTypeDefinition> parseTypeDefinitions(Map<String, Fmi2Unit> unitMap) throws XPathExpressionException, InvocationTargetException, IllegalAccessException {
        HashMap<String, SimpleTypeDefinition> typeDefinitions = new HashMap<String, SimpleTypeDefinition>();
        for (Node n : new NodeIterator(this.lookup(this.doc, this.xpath, "fmiModelDescription/TypeDefinitions/SimpleType"))) {
            SimpleTypeDefinition def = new SimpleTypeDefinition();
            Node attribute = n.getAttributes().getNamedItem("name");
            if (attribute != null) {
                def.name = attribute.getNodeValue();
            }
            if ((attribute = n.getAttributes().getNamedItem("description")) != null) {
                def.description = attribute.getNodeValue();
            }
            Node child = this.lookupSingle(n, this.xpath, "Real[1] | Boolean[1] | String[1] | Integer[1] | Enumeration[1]");
            def.type = this.parseType(Objects.requireNonNull(child, "Unable to lookup type when parsing type definitions"), typeDefinitions, unitMap);
            typeDefinitions.put(def.name, def);
        }
        return typeDefinitions;
    }

    private void copyDefaults(Type type, Node node, Map<String, SimpleTypeDefinition> typeDefinitions) throws InvocationTargetException, IllegalAccessException {
        Node attribute = node.getAttributes().getNamedItem("declaredType");
        if (attribute != null) {
            String declaredType = attribute.getNodeValue();
            if (typeDefinitions.containsKey(declaredType)) {
                typeDefinitions.get(declaredType).setDefaults(type);
            } else if (!declaredType.isEmpty()) {
                logger.warn("Could not find declared type: '{}'", (Object)declaredType);
            }
        }
    }

    private String parseTypeStart(Node node) {
        Node startAtt = node.getAttributes().getNamedItem("start");
        if (startAtt != null) {
            return startAtt.getNodeValue();
        }
        return null;
    }

    private void parseBooleanType(BooleanType type, Node node) {
        String startValue = this.parseTypeStart(node);
        if (startValue != null) {
            String valTrueFalse = startValue.replaceAll("^1", "true").replaceAll("^0", "false");
            type.start = Boolean.valueOf(valTrueFalse);
        }
    }

    private void parseStringType(StringType type, Node node) {
        String startValue = this.parseTypeStart(node);
        if (startValue != null) {
            type.start = startValue;
        }
    }

    private void parseIntegerType(IntegerType type, Node node, boolean realMode) {
        Node attribute;
        String startValue = this.parseTypeStart(node);
        if (startValue != null) {
            type.start = !realMode ? (Number)Integer.valueOf(startValue) : (Number)Double.valueOf(startValue);
        }
        if ((attribute = node.getAttributes().getNamedItem("min")) != null) {
            if (!realMode) {
                type.min = Integer.parseInt(attribute.getNodeValue());
            } else {
                ((RealType)type).min = Double.parseDouble(attribute.getNodeValue());
            }
        }
        if ((attribute = node.getAttributes().getNamedItem("max")) != null) {
            if (!realMode) {
                type.max = Integer.parseInt(attribute.getNodeValue());
            } else {
                ((RealType)type).max = Double.parseDouble(attribute.getNodeValue());
            }
        }
        if ((attribute = node.getAttributes().getNamedItem("quantity")) != null) {
            type.quantity = attribute.getNodeValue();
        }
    }

    private void parseRealType(RealType type, Node node) {
        Node attribute;
        this.parseIntegerType(type, node, true);
        String startValue = this.parseTypeStart(node);
        if (startValue != null) {
            type.start = Double.valueOf(startValue);
        }
        if ((attribute = node.getAttributes().getNamedItem("unit")) != null) {
            type.unit = attribute.getNodeValue();
        }
        if ((attribute = node.getAttributes().getNamedItem("displayUnit")) != null) {
            type.displayUnit = attribute.getNodeValue();
        }
        if ((attribute = node.getAttributes().getNamedItem("relativeQuantity")) != null) {
            type.relativeQuantity = Boolean.parseBoolean(attribute.getNodeValue());
        }
        if ((attribute = node.getAttributes().getNamedItem("nominal")) != null) {
            type.nominal = Double.parseDouble(attribute.getNodeValue());
        }
        if ((attribute = node.getAttributes().getNamedItem("unbound")) != null) {
            type.unbound = Boolean.parseBoolean(attribute.getNodeValue());
        }
        if ((attribute = node.getAttributes().getNamedItem("reinit")) != null) {
            type.reinit = Boolean.parseBoolean(attribute.getNodeValue());
        }
    }

    private Type parseType(Node child, Map<String, SimpleTypeDefinition> typeDefinitions, Map<String, Fmi2Unit> unitMap) throws InvocationTargetException, IllegalAccessException {
        Types typeId = Types.valueOfIgnorecase(child.getNodeName());
        Type type = null;
        switch (Objects.requireNonNull(typeId, "Unable to parse typeid when parsing type").ordinal()) {
            case 0: {
                type = new BooleanType();
                this.copyDefaults(type, child, typeDefinitions);
                this.parseBooleanType((BooleanType)type, child);
                break;
            }
            case 4: {
                type = new EnumerationType();
            }
            case 2: {
                if (type == null) {
                    type = new IntegerType();
                }
                this.copyDefaults(type, child, typeDefinitions);
                this.parseIntegerType((IntegerType)type, child, false);
                break;
            }
            case 1: {
                type = new RealType();
                this.copyDefaults(type, child, typeDefinitions);
                this.parseRealType((RealType)type, child);
                Node derivative = child.getAttributes().getNamedItem("derivative");
                if (derivative == null) break;
                ((RealType)type).derivative = derivative.getNodeValue();
                break;
            }
            case 3: {
                type = new StringType();
                this.copyDefaults(type, child, typeDefinitions);
                this.parseStringType((StringType)type, child);
                break;
            }
        }
        if (type != null) {
            Node attributeDeclaredType;
            type.unit = this.getUnit(child, unitMap);
            if (type.unit == null && (attributeDeclaredType = child.getAttributes().getNamedItem("declaredType")) != null) {
                String declaredType = attributeDeclaredType.getNodeValue();
                if (typeDefinitions.containsKey(declaredType)) {
                    type.unit = typeDefinitions.get((Object)declaredType).type.unit;
                } else if (!declaredType.isEmpty()) {
                    logger.warn("Could not find declared type: '{}'", (Object)declaredType);
                }
            }
        }
        return type;
    }

    private Fmi2Unit getUnit(Node node, Map<String, Fmi2Unit> unitMap) {
        String declaredUnit;
        Node attribute = node.getAttributes().getNamedItem("unit");
        if (attribute != null && unitMap.containsKey(declaredUnit = attribute.getNodeValue())) {
            return unitMap.get(declaredUnit);
        }
        return null;
    }

    private void decodeUnknownElement(Map<Integer, ScalarVariable> indexMap, Node n, IOptainUnknownDestination handler, ModelStructureElementType type) throws ModelDescriptionParseException {
        Node dependenciesNode;
        NamedNodeMap attributes = n.getAttributes();
        int index = Integer.parseInt(attributes.getNamedItem("index").getNodeValue());
        ScalarVariable sc = indexMap.get(index);
        if (sc == null) {
            throw new ModelDescriptionParseException("Invalid index attribute value in Unknown: //Unknown[@index='" + index + "']");
        }
        if (handler.getList() != null) {
            handler.getList().add(sc);
        }
        if ((dependenciesNode = attributes.getNamedItem("dependencies")) != null) {
            String dependencies = dependenciesNode.getNodeValue();
            if (dependencies != null && !dependencies.isEmpty()) {
                String[] dependencyArr = dependencies.split(" ");
                List<Object> dependencyKinds = new Vector();
                Node dependencyKindsNode = attributes.getNamedItem("dependenciesKind");
                if (dependencyKindsNode != null) {
                    dependencyKinds = this.getAttribute(ScalarVariable.DependencyKind.class, dependencyKindsNode.getNodeValue().split(" "));
                }
                if (dependencyKinds.size() > dependencyArr.length) {
                    throw new ModelDescriptionParseException("dependencies and dependenciesKind does not match missing dependency for kind //Unknown[@index='" + index + "']");
                }
                for (int i = 0; i < dependencyArr.length; ++i) {
                    ScalarVariable key;
                    ScalarVariable.DependencyKind kind = ScalarVariable.DependencyKind.Dependent;
                    if (dependencyKinds.size() > i) {
                        kind = (ScalarVariable.DependencyKind)((Object)dependencyKinds.get(i));
                    }
                    if ((key = indexMap.get(Integer.valueOf(dependencyArr[i]))) == null) {
                        throw new ModelDescriptionParseException("Invalid index attribute value in Unknown: //Unknown[@index='" + index + "']");
                    }
                    handler.get(sc).put(key, kind);
                }
            }
        } else {
            switch (type.ordinal()) {
                case 1: 
                case 2: {
                    for (ScalarVariable other : indexMap.values()) {
                        switch (other.causality.ordinal()) {
                            case 1: {
                                break;
                            }
                            case 2: 
                            case 5: {
                                handler.get(sc).put(other, ScalarVariable.DependencyKind.Dependent);
                                break;
                            }
                            case 4: {
                                break;
                            }
                            case 3: {
                                break;
                            }
                        }
                    }
                    break;
                }
                case 0: {
                    for (ScalarVariable other : indexMap.values()) {
                        switch (other.causality.ordinal()) {
                            case 1: {
                                break;
                            }
                            case 2: 
                            case 5: {
                                handler.get(sc).put(other, ScalarVariable.DependencyKind.Dependent);
                                break;
                            }
                            case 4: {
                                break;
                            }
                            case 3: {
                                break;
                            }
                        }
                        if (other.initial == null) continue;
                        switch (other.initial) {
                            case Approx: {
                                break;
                            }
                            case Calculated: {
                                break;
                            }
                            case Exact: {
                                handler.get(sc).put(other, ScalarVariable.DependencyKind.Dependent);
                                break;
                            }
                        }
                    }
                    break;
                }
            }
        }
    }

    private <T> T getNodeValue(NamedNodeMap attributes, String name, T defaultValue) {
        Node att = attributes.getNamedItem(name);
        if (att != null) {
            return (T)att.getNodeValue();
        }
        return defaultValue;
    }

    private <T extends Enum<T>> T getAttribute(Class<T> en, NamedNodeMap attributes, String name) {
        Node att = attributes.getNamedItem(name);
        if (att != null) {
            return Enum.valueOf(en, StringUtils.capitalize((String)att.getNodeValue()));
        }
        return null;
    }

    private <T extends Enum<T>> List<T> getAttribute(Class<T> en, String[] name) {
        Vector<T> list = new Vector<T>();
        for (String n : name) {
            list.add(Enum.valueOf(en, StringUtils.capitalize((String)n)));
        }
        return list;
    }

    public static class ScalarVariable {
        public final Map<ScalarVariable, DependencyKind> outputDependencies = new HashMap<ScalarVariable, DependencyKind>();
        public final Map<ScalarVariable, DependencyKind> derivativesDependencies = new HashMap<ScalarVariable, DependencyKind>();
        public final Map<ScalarVariable, DependencyKind> initialUnknownsDependencies = new HashMap<ScalarVariable, DependencyKind>();
        public String name;
        public long valueReference;
        public String description;
        public Causality causality;
        public ModelDescription.Variability variability;
        public ModelDescription.Initial initial;
        public Type type;

        public Type getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public Long getValueReference() {
            return this.valueReference;
        }

        public String toString() {
            return this.getName();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ScalarVariable) {
                return this.name.equals(((ScalarVariable)obj).getName());
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public static enum DependencyKind {
            Dependent,
            Constant,
            Fixed,
            Tunable,
            Discrete;

        }
    }

    public static enum Causality {
        Parameter,
        CalculatedParameter,
        Input,
        Output,
        Local,
        Independent;


        public static Causality valueOfIgnorecase(String value) {
            for (Causality c : Causality.values()) {
                if (!c.name().equalsIgnoreCase(value)) continue;
                return c;
            }
            return null;
        }
    }

    public static class Type {
        public Types type;
        public Object start;
        public Fmi2Unit unit;

        public String toString() {
            return String.valueOf((Object)this.type) + (String)(this.start != null ? " " + String.valueOf(this.start) : "");
        }

        public boolean isAssignableFrom(Type other, boolean autoConvert) {
            if (this.unit == null || other.unit == null || this.unit.getBaseUnit() == null || other.unit.getBaseUnit() == null) {
                return true;
            }
            if (autoConvert) {
                return this.unit.getBaseUnit().equalsAutoConvert(other.unit.getBaseUnit());
            }
            return this.unit.getBaseUnit().equals(other.unit.getBaseUnit());
        }
    }

    public static enum Types {
        Boolean,
        Real,
        Integer,
        String,
        Enumeration;


        public static Types valueOfIgnorecase(String value) {
            for (Types t : Types.values()) {
                if (!t.name().equalsIgnoreCase(value)) continue;
                return t;
            }
            return null;
        }
    }

    public static class RealType
    extends IntegerType {
        public Object derivative;
        public String unit;
        public String displayUnit;
        public boolean relativeQuantity = false;
        public double nominal;
        public boolean unbound = false;
        public boolean reinit = false;
        public Double min;
        public Double max;

        public RealType() {
            this.type = Types.Real;
        }
    }

    private static enum ModelStructureElementType {
        InitialUnknown,
        Outputs,
        Derivatives;

    }

    private static interface IOptainUnknownDestination {
        public Map<ScalarVariable, ScalarVariable.DependencyKind> get(ScalarVariable var1);

        public List<ScalarVariable> getList();
    }

    public static class SimpleTypeDefinition {
        public Type type;
        public String name;
        public String description;

        public void setDefaults(Type destination) throws InvocationTargetException, IllegalAccessException {
            BeanUtils.copyProperties((Object)this.type, (Object)destination);
        }
    }

    public static class BooleanType
    extends Type {
        public BooleanType() {
            this.type = Types.Boolean;
        }
    }

    public static class StringType
    extends Type {
        public StringType() {
            this.type = Types.String;
        }
    }

    public static class IntegerType
    extends Type {
        public String quantity;
        public Integer min;
        public Integer max;

        public IntegerType() {
            this.type = Types.Integer;
        }
    }

    public static class EnumerationType
    extends IntegerType {
        public EnumerationType() {
            this.type = Types.Enumeration;
        }
    }

    public static class ModelDescriptionParseException
    extends XPathExpressionException {
        private static final long serialVersionUID = 1L;

        public ModelDescriptionParseException(String message) {
            super(message);
        }
    }

    public static class LogCategory {
        public final String name;
        public final String description;

        public LogCategory(String name, String description) {
            this.name = name;
            this.description = description;
        }

        protected LogCategory() {
            this.name = null;
            this.description = null;
        }

        public String toString() {
            return this.name;
        }
    }
}

