/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.fmi.jnifmuapi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.intocps.fmi.FmuInvocationException;
import org.intocps.fmi.jnifmuapi.TempDirectory;
import org.intocps.fmi.jnifmuapi.ZipUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FmiUtil {
    static final Logger logger = LoggerFactory.getLogger(FmiUtil.class);

    public static File generateLibraryFileFromPlatform(String osName, String osArch, String modelIdentifier, File fmuRoot, FMIVersion fmiVersion) {
        String arch = osArch;
        String libDir = "";
        String libExtension = "";
        if (osName.toLowerCase().contains("windows")) {
            libExtension = ".dll";
            switch (fmiVersion) {
                case FMI2: {
                    if (arch.contains("amd64")) {
                        libDir = "win64";
                        break;
                    }
                    libDir = "win32";
                    break;
                }
                case FMI3: {
                    libDir = arch.contains("amd64") ? "x86_64-windows" : "x86-windows";
                }
            }
        } else if (osName.contains("nix") || osName.contains("nux") || osName.indexOf("aix") > 0) {
            libExtension = ".so";
            switch (fmiVersion) {
                case FMI2: {
                    if (arch.contains("amd64")) {
                        libDir = "linux64";
                        break;
                    }
                    libDir = "linux32";
                    break;
                }
                case FMI3: {
                    libDir = arch.contains("amd64") ? "x86_64-linux" : "x86-linux";
                }
            }
        } else if (osName.toLowerCase().contains("mac")) {
            libExtension = ".dylib";
            switch (fmiVersion) {
                case FMI2: {
                    if (arch.contains("x86_64")) {
                        libDir = "darwin64";
                        break;
                    }
                    libDir = "darwin32";
                    break;
                }
                case FMI3: {
                    libDir = arch.contains("x86_64") ? "x86_64-darwin" : "x86_32-darwin";
                }
            }
        }
        File libraryPath = new File(new File(new File(fmuRoot, "binaries"), libDir), modelIdentifier + libExtension);
        return libraryPath;
    }

    public static String getModelIdentifier(InputStream modelDescription) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(modelDescription);
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            XPathExpression expr = xpath.compile("fmiModelDescription/CoSimulation/@modelIdentifier");
            NodeList list = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
            if (list != null) {
                Node n = list.item(0);
                return n.getNodeValue();
            }
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            logger.error("Unable to parse model description", e);
        }
        return null;
    }

    public static File generateLibraryFile(String modelIdentifier, File dir, FMIVersion fmiVersion) {
        String osName = System.getProperty("os.name");
        String arch = System.getProperty("os.arch");
        return FmiUtil.generateLibraryFileFromPlatform(osName, arch, modelIdentifier, dir, fmiVersion);
    }

    public static String logMessageLibraryPath(File libraryPath) {
        Path p = libraryPath.toPath();
        int pLength = p.getNameCount();
        String desiredPath = p.subpath(pLength - 3, pLength).toString();
        return desiredPath;
    }

    public static File createTempDir(String prefix) {
        TempDirectory dir = new TempDirectory(prefix);
        dir.deleteOnExit();
        return dir.getPath().toFile();
    }

    public static void unPack(File fromFile, File toDirectory) throws IOException {
        toDirectory.mkdirs();
        logger.debug("Extracting: " + fromFile.getAbsolutePath() + " to " + toDirectory.getAbsolutePath());
        ZipUtility.unzipApacheCompress(fromFile, toDirectory);
        logger.debug("Extracted '" + fromFile.getAbsolutePath() + "' to '" + toDirectory.getAbsolutePath() + "'");
    }

    public static String getFmuName(File path) throws FmuInvocationException {
        if (path.getName().indexOf(".fmu") == -1) {
            throw new FmuInvocationException("invalid fmu name: " + path.getName());
        }
        return path.getName().substring(0, path.getName().indexOf(46));
    }

    public static enum FMIVersion {
        FMI2,
        FMI3;

    }
}

