/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.fmi.jnifmuapi;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.intocps.fmi.Fmi2Status;
import org.intocps.fmi.Fmi2StatusKind;
import org.intocps.fmi.FmuInvocationException;
import org.intocps.fmi.FmuResult;
import org.intocps.fmi.IFmiComponent;
import org.intocps.fmi.IFmuCallback;
import org.intocps.fmi.InvalidParameterException;
import org.intocps.fmi.jnifmuapi.Fmu;
import org.intocps.fmi.jnifmuapi.FmuModelDescription;
import org.intocps.fmi.jnifmuapi.shared.NativeFmuApi;
import org.intocps.fmi.jnifmuapi.shared.NativeLibraryLoader;
import org.xml.sax.SAXException;

public class Main {
    public static void main(String[] args2) throws Exception {
        String libPath = NativeFmuApi.getPlatformSpecificLibraryPath("fmuapi");
        System.out.println("Loading library: " + libPath);
        File lib = new NativeLibraryLoader().loadLibrary(libPath);
        System.out.println("Loaded Library file: " + lib);
        long sbase = System.currentTimeMillis();
        Fmu f = new Fmu(new File("fmu2test1.fmu"), new File(new File("Default"), "fmus"));
        f.unPack();
        f.load();
        System.out.println("FMU version: " + f.getVersion());
        long s = System.currentTimeMillis();
        for (int i = 0; i < 10; ++i) {
            Main.testInstance(f);
        }
        long end = System.currentTimeMillis() - s;
        System.out.println("####\n\nit took " + end + " milis");
        long endTotal = System.currentTimeMillis() - sbase;
        System.out.println("Total " + endTotal + " milis");
    }

    public static FmuModelDescription getModelDescription(Fmu fmu) {
        try {
            return new FmuModelDescription(new File(fmu.dir, "modelDescription.xml"));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void testInstance(Fmu f) throws XPathExpressionException, FmuInvocationException {
        boolean visible = false;
        boolean loggingOn = false;
        FmuModelDescription description = Main.getModelDescription(f);
        IFmiComponent instnace = f.instantiate(description.getGuid(), f.name, visible, loggingOn, new IFmuCallback(){

            @Override
            public void log(String instanceName, Fmi2Status status, String category, String message) {
                System.out.println("log: " + instanceName + " " + (Object)((Object)status) + " " + category + " " + message);
            }

            @Override
            public void stepFinished(Fmi2Status status) {
            }
        });
        boolean toleranceDefined = false;
        double tolerance = 1.0;
        double tStart = 0.0;
        double tEnd = 20.0;
        Fmi2Status fmi2Flag = instnace.setupExperiment(toleranceDefined, tolerance, tStart, true, tEnd);
        if (fmi2Flag.value > Fmi2Status.Warning.value) {
            Main.error("could not initialize model; failed FMI setup experiment");
        }
        fmi2Flag = instnace.enterInitializationMode();
        if (fmi2Flag.value > Fmi2Status.Warning.value) {
            Main.error("could not initialize model; failed FMI enter initialization mode");
        }
        fmi2Flag = instnace.exitInitializationMode();
        if (fmi2Flag.value > Fmi2Status.Warning.value) {
            Main.error("could not initialize model; failed FMI exit initialization mode");
        }
        Fmi2Status status = null;
        double h = 0.01;
        int nSteps = 0;
        double time = tStart;
        while (time < tEnd) {
            System.out.println("do step: " + time);
            status = instnace.doStep(time, h, true);
            if (status == Fmi2Status.Discard) {
                FmuResult<Boolean> terminateRes = instnace.getBooleanStatus(Fmi2StatusKind.Terminated);
                if (Fmi2Status.OK != terminateRes.status) {
                    Main.error("could not complete simulation of the model. getBooleanStatus return other than fmi2OK");
                }
                if (((Boolean)terminateRes.result).booleanValue()) {
                    Main.error("the model requested to end the simulation");
                }
                Main.error("could not complete simulation of the model");
            }
            if (status != Fmi2Status.OK) {
                Main.error("could not complete simulation of the model");
            }
            time += h;
            long[] realIndices = new long[]{0L, 1L, 2L};
            FmuResult<double[]> reals = instnace.getReal(realIndices);
            if (reals == null) {
                System.err.println("failed to get reals");
            }
            try {
                instnace.setReals(realIndices, new double[]{1.1, 1.2, 1.3});
            }
            catch (InvalidParameterException e) {
                e.printStackTrace();
            }
            ++nSteps;
        }
        System.out.println("Simulated with " + nSteps + " steps");
        instnace.terminate();
    }

    private static void error(String msg) {
        System.err.println(msg);
    }

    public static void addLibraryPath(String pathToAdd) throws Exception {
        String[] paths;
        Field usrPathsField = ClassLoader.class.getDeclaredField("usr_paths");
        usrPathsField.setAccessible(true);
        for (String path : paths = (String[])usrPathsField.get(null)) {
            if (!path.equals(pathToAdd)) continue;
            return;
        }
        String[] newPaths = Arrays.copyOf(paths, paths.length + 1);
        newPaths[newPaths.length - 1] = pathToAdd;
        usrPathsField.set(null, newPaths);
    }
}

