/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.fmi.jnifmuapi.shared;

import java.io.File;
import java.nio.file.Path;
import org.intocps.fmi.FmiInvalidNativeStateException;
import org.intocps.fmi.FmuInvocationException;
import org.intocps.fmi.FmuMissingLibraryException;
import org.intocps.fmi.jnifmuapi.FmiUtil;
import org.intocps.fmi.jnifmuapi.NativeFmuLibraryLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeLoadManager {
    static final Logger logger = LoggerFactory.getLogger(NativeLoadManager.class);
    public static final Object lock = new Object();
    private final String name;
    private final NativeLifecycleFunction lifecycleFunc;
    boolean loaded;
    private long fmuPtr;
    public final File dir;

    public boolean isLoaded() {
        return this.loaded;
    }

    public NativeLoadManager(File dir, String name, NativeLifecycleFunction lifecycleFunc) {
        this.dir = dir;
        if (!this.isDirValid()) {
            logger.error("Native load manager instantiated with a nonexistent directory: {}. Subsequent calls will fail.", (Object)this.dir);
        }
        this.name = name;
        this.lifecycleFunc = lifecycleFunc;
    }

    public boolean isDirValid() {
        return this.dir != null && this.dir.exists();
    }

    public long getFmuPtr() {
        return this.fmuPtr;
    }

    public void load(String modelIdentifier, FmiUtil.FMIVersion fmiVersion) throws FmuInvocationException, FmuMissingLibraryException {
        File libraryPath;
        if (this.loaded) {
            return;
        }
        String errorMsg = "Fmu do not conform to the standard. Unable to obtain modelIndentifier '%s' for co-simulation, defaulting to archieve name '%s'";
        String recovery_log_message = "Attempting to recover loading of the library by setting modelIdentifier to '{}'";
        if (modelIdentifier == null) {
            modelIdentifier = this.name;
        }
        if (modelIdentifier == null) {
            logger.error(String.format("Fmu do not conform to the standard. Unable to obtain modelIndentifier '%s' for co-simulation, defaulting to archieve name '%s'", "", this.name));
            logger.warn("Attempting to recover loading of the library by setting modelIdentifier to '{}'", (Object)this.name);
        }
        if (!(libraryPath = this.generateLibraryFile(modelIdentifier, fmiVersion)).exists()) {
            logger.error(String.format("The library corresponding to the modelIdentifier '%s' could not be found at: '%s", modelIdentifier, NativeLoadManager.logMessageLibraryPath(libraryPath)));
            logger.warn(String.format("Attempting to recover loading of the library by setting modelIdentifier to '{}'", this.name));
            modelIdentifier = this.name;
            libraryPath = this.generateLibraryFile(modelIdentifier, fmiVersion);
        }
        this.internalLoad(libraryPath);
    }

    public File generateLibraryFile(String modelIdentifier, FmiUtil.FMIVersion fmiVersion) {
        String osName = System.getProperty("os.name");
        String arch = System.getProperty("os.arch");
        return FmiUtil.generateLibraryFileFromPlatform(osName, arch, modelIdentifier, this.dir, fmiVersion);
    }

    public static String logMessageLibraryPath(File libraryPath) {
        Path p = libraryPath.toPath();
        int pLength = p.getNameCount();
        return p.subpath(pLength - 3, pLength).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalLoad(File libraryPath) throws FmuInvocationException, FmuMissingLibraryException {
        if (this.loaded) {
            return;
        }
        if (libraryPath == null || !libraryPath.exists()) {
            String errorMsg = libraryPath == null ? "" : NativeLoadManager.logMessageLibraryPath(libraryPath);
            throw new FmuMissingLibraryException("The library for the architecture and OS does not exist within the FMU at: " + errorMsg);
        }
        logger.debug("Loading FMU library: {}", (Object)libraryPath);
        NativeFmuLibraryLoader.loadNativeApi();
        Object object = lock;
        synchronized (object) {
            this.fmuPtr = this.lifecycleFunc.lifeCycleLoadLibrary(libraryPath.getAbsolutePath());
        }
        if (this.fmuPtr == 0L) {
            throw new FmuInvocationException("Load failed");
        }
        logger.debug("Successfully loaded FMU library: {}", (Object)libraryPath);
        this.loaded = true;
        logger.debug("Loaded library into DLL pointer: " + this.fmuPtr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unLoad() throws FmiInvalidNativeStateException {
        if (!this.loaded) {
            return;
        }
        this.checkState();
        Object object = lock;
        synchronized (object) {
            this.lifecycleFunc.lifeCycleUnLoad(this.fmuPtr);
        }
        this.loaded = false;
    }

    public boolean isValid() {
        return this.fmuPtr != 0L;
    }

    public void checkState() throws FmiInvalidNativeStateException {
        if (!this.isValid()) {
            throw new FmiInvalidNativeStateException("The internal " + (this.fmuPtr != 0L ? "" : " FMU state is invalid. "));
        }
    }

    public static interface NativeLifecycleFunction {
        public long lifeCycleLoadLibrary(String var1);

        public void lifeCycleUnLoad(long var1);
    }
}

