/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.framework.fmi2.api;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PStm;
import org.intocps.maestro.ast.node.PType;

public interface Fmi2Builder<S, B, E, SETTINGS> {
    public B build() throws Exception;

    public SETTINGS getSettings();

    public IFunctionBuilder getFunctionBuilder();

    public boolean isDirty();

    public void resetDirty();

    public PStm buildRaw() throws Exception;

    public RuntimeModule<S> loadRuntimeModule(String var1, Object ... var2);

    public RuntimeModule<S> loadRuntimeModule(TryScope<S> var1, String var2, Object ... var3);

    public Scope<S> getRootScope();

    public DynamicActiveScope<S> getDynamicScope();

    public <V, T> Variable<T, V> getCurrentLinkedValue(Port var1);

    public DoubleVariable<S> getDoubleVariableFrom(E var1);

    public IntVariable<S> getIntVariableFrom(E var1);

    public StringVariable<S> getStringVariableFrom(E var1);

    public BoolVariable<S> getBooleanVariableFrom(E var1);

    public <V, T> Variable<T, V> getFmuVariableFrom(E var1);

    public static interface NumericExpressionValue
    extends ExpressionValue,
    NumericTypedReferenceExp {
    }

    public static interface StringExpressionValue
    extends ExpressionValue {
    }

    public static interface IntExpressionValue
    extends NumericExpressionValue {
    }

    public static interface DoubleExpressionValue
    extends NumericExpressionValue {
    }

    public static interface BooleanExpressionValue
    extends ExpressionValue {
    }

    public static interface ExpressionValue
    extends ProvidesTypedReferenceExp {
    }

    public static interface ArrayVariable<T, CV>
    extends Variable<T, NamedVariable<T>> {
        public int size();

        public List<? extends Variable<T, CV>> items();

        public void setValue(IntExpressionValue var1, ExpressionValue var2);
    }

    public static interface Variable<T, V> {
        public String getName();

        public void setValue(V var1);

        public void setValue(Variable<T, V> var1);

        public void setValue(Scope<T> var1, Variable<T, V> var2);

        public void setValue(Scope<T> var1, V var2);

        public Scope<T> getDeclaredScope();
    }

    public static interface Fmi2ComponentVariable<T>
    extends Variable<T, NamedVariable<T>> {
        public void setDebugLogging(List<String> var1, boolean var2);

        public void setupExperiment(DoubleVariable<T> var1, DoubleVariable<T> var2, Double var3);

        public void setupExperiment(double var1, Double var3, Double var4);

        public void enterInitializationMode();

        public void exitInitializationMode();

        public void setupExperiment(Scope<T> var1, DoubleVariable<T> var2, DoubleVariable<T> var3, Double var4);

        public void setupExperiment(Scope<T> var1, double var2, Double var4, Double var5);

        public void enterInitializationMode(Scope<T> var1);

        public void exitInitializationMode(Scope<T> var1);

        public void terminate(Scope<T> var1);

        public void terminate();

        public Map.Entry<BoolVariable<T>, DoubleVariable<T>> step(Scope<T> var1, DoubleVariable<T> var2, DoubleVariable<T> var3, BoolVariable<T> var4);

        public Map.Entry<BoolVariable<T>, DoubleVariable<T>> step(Scope<T> var1, DoubleVariable<T> var2, DoubleVariable<T> var3);

        public Map.Entry<BoolVariable<T>, DoubleVariable<T>> step(DoubleVariable<T> var1, DoubleVariable<T> var2, BoolVariable<T> var3);

        public Map.Entry<BoolVariable<T>, DoubleVariable<T>> step(DoubleVariable<T> var1, DoubleVariable<T> var2);

        public List<? extends Port> getPorts();

        public List<? extends Port> getPorts(String ... var1);

        public List<? extends Port> getPorts(int ... var1);

        public Port getPort(String var1);

        public Port getPort(int var1);

        public <V> Map<? extends Port, ? extends Variable<T, V>> get(Port ... var1);

        public <V> Map<? extends Port, ? extends Variable<T, V>> get(Scope<T> var1, Port ... var2);

        public <V> Map<? extends Port, ? extends Variable<T, V>> get();

        public <V> Map<? extends Port, ? extends Variable<T, V>> get(int ... var1);

        public <V> Map<? extends Port, ? extends Variable<T, V>> get(String ... var1);

        public <V> Map<? extends Port, ? extends Variable<T, V>> getAndShare(String ... var1);

        public <V> Map<? extends Port, ? extends Variable<T, V>> getAndShare(Port ... var1);

        public <V> Map<? extends Port, ? extends Variable<T, V>> getAndShare();

        public <V> Variable<T, V> getShared(String var1);

        public <V> Variable<T, V> getShared(Port var1);

        public <V> Variable<T, V> getSingle(String var1);

        public <V> Variable<T, V> getSingle(Port var1);

        public <V> void set(Scope<T> var1, PortValueMap<V> var2);

        public <V> void set(Scope<T> var1, PortVariableMap<T, V> var2);

        public <V> void set(PortValueMap<V> var1);

        public <V> void set(Port var1, Value<V> var2);

        public <V> void set(Port var1, Variable<T, V> var2);

        public <V> void set(Scope<T> var1, Port var2, Variable<T, V> var3);

        public <V> void set(PortVariableMap<T, V> var1);

        public void setLinked(Scope<T> var1, Port ... var2);

        public void setLinked();

        public void setLinked(Port ... var1);

        public void setLinked(String ... var1);

        public void setLinked(long ... var1);

        public void setInt(Map<? extends Integer, ? extends Value<Integer>> var1);

        public void setString(Map<? extends String, ? extends Value<String>> var1);

        public <V> void share(Map<? extends Port, ? extends Variable<T, V>> var1);

        public <V> void share(Port var1, Variable<T, V> var2);

        public StateVariable<T> getState() throws XPathExpressionException;

        public StateVariable<T> getState(Scope<T> var1) throws XPathExpressionException;

        public static interface PortExpressionValueMap
        extends Map<Port, ExpressionValue> {
        }

        public static interface PortValueMap<V>
        extends Map<Port, Value<V>> {
        }

        public static interface PortVariableMap<S, V>
        extends Map<Port, Variable<S, V>> {
        }
    }

    public static interface Fmu2Variable<S>
    extends Variable<S, NamedVariable<S>> {
        public Fmi2ComponentVariable<S> instantiate(String var1, String var2);

        public Fmi2ComponentVariable<S> instantiate(String var1);

        public Fmi2ComponentVariable<S> instantiate(String var1, TryScope<PStm> var2, Scope<PStm> var3, String var4);

        public Fmi2ComponentVariable<S> instantiate(String var1, TryScope<PStm> var2, Scope<PStm> var3, String var4, boolean var5);

        public Fmi2ComponentVariable<S> instantiate(String var1, TryScope<S> var2, Scope<S> var3);
    }

    public static interface StateVariable<T>
    extends Variable<T, Object> {
        public void set() throws IllegalStateException;

        public void set(Scope<T> var1) throws IllegalStateException;

        public void destroy() throws IllegalStateException;

        public void destroy(Scope<T> var1) throws IllegalStateException;
    }

    public static interface NamedVariable<T>
    extends Variable<T, NamedValue> {
    }

    public static interface StringVariable<T>
    extends Variable<T, StringExpressionValue>,
    ProvidesTypedReferenceExp {
    }

    public static interface BoolVariable<T>
    extends Variable<T, BooleanExpressionValue>,
    ProvidesTypedReferenceExp {
        public Predicate toPredicate();
    }

    public static interface DoubleVariable<T>
    extends Variable<T, DoubleExpressionValue>,
    ProvidesTypedReferenceExp,
    NumericTypedReferenceExp {
        public void set(Double var1);
    }

    public static interface NumericTypedReferenceExp
    extends ProvidesTypedReferenceExp {
    }

    public static interface ProvidesTypedReferenceExp {
        public PType getType();

        public PExp getExp();
    }

    public static interface IntVariable<T>
    extends Variable<T, IntExpressionValue>,
    ProvidesTypedReferenceExp,
    NumericTypedReferenceExp {
        public void decrement();

        public void increment();
    }

    public static interface NamedValue
    extends Value<Object> {
    }

    public static interface Value<V> {
        public V get();
    }

    public static interface Port {
        public String getName();

        public Long getPortReferenceValue();

        public void linkTo(Port ... var1) throws PortLinkException;

        public void breakLink() throws PortLinkException;

        public boolean isLinked();

        public boolean isLinkedAsOutputProvider();

        public boolean isLinkedAsInputConsumer();

        public static class PortLinkException
        extends Exception {
            Port port;

            public PortLinkException(String message, Port port) {
                super(message);
                this.port = port;
            }
        }
    }

    public static interface Numeric<A extends Number>
    extends Value<Number>,
    Type {
        public void set(A var1);

        @Override
        public A get();
    }

    public static interface Type {
    }

    public static interface Predicate {
        public Predicate and(Predicate var1);

        public Predicate or(Predicate var1);

        public Predicate not();
    }

    public static interface WhileScope<T>
    extends Scope<T>,
    ScopeElement<T> {
    }

    public static interface TryScope<T>
    extends ScopeElement<T> {
        public Scope<T> enter();

        public Scope<T> enterFinally();

        public Scope<T> leave();

        public Scope<T> getBody();

        public Scope<T> getFinallyBody();
    }

    public static interface IfScope<T>
    extends ScopeElement<T> {
        public Scope<T> enterThen();

        public Scope<T> enterElse();

        public Scope<T> leave();
    }

    public static interface DynamicActiveScope<T>
    extends Scope<T> {
    }

    public static interface Scope<T>
    extends Scoping<T> {
        @Override
        public Scope<T> activate();

        public DoubleVariable<T> store(double var1);

        public StringVariable<T> store(String var1);

        public BoolVariable<T> store(boolean var1);

        public IntVariable<T> store(int var1);

        public DoubleVariable<T> store(String var1, double var2);

        public StringVariable<T> store(String var1, String var2);

        public BoolVariable<T> store(String var1, boolean var2);

        public IntVariable<T> store(String var1, int var2);

        public <CV> ArrayVariable<T, CV> store(String var1, CV[] var2);

        @Deprecated
        public <V> Variable<T, V> store(Value<V> var1);

        public Fmu2Variable<T> createFMU(String var1, String var2, String ... var3) throws Exception;

        public void markTransferPoint(String ... var1);

        public void addTransferAs(String ... var1);
    }

    public static interface Scoping<T>
    extends ScopeElement<T> {
        public WhileScope<T> enterWhile(Predicate var1);

        public IfScope<T> enterIf(Predicate var1);

        public TryScope<T> enterTry();

        public Scoping<T> parallel();

        public Scoping<T> enterScope();

        public Scope<T> leave();

        public void add(T ... var1);

        public void addAll(Collection<T> var1);

        public void addBefore(T var1, T ... var2);

        public void addAfter(T var1, T ... var2);

        public Scoping<T> activate();
    }

    public static interface ScopeElement<T> {
        public ScopeElement<T> parent();

        public T getDeclaration();

        public <P extends ScopeElement<T>> P findParent(Class<P> var1);
    }

    public static interface RuntimeFunction {
        public String getName();

        public List<Map.Entry<String, FunctionType>> getArgs();

        public FunctionType getReturnType();

        public boolean usingVargs();

        public static class FunctionType {
            final Type nativeType;
            final String namedType;

            public FunctionType(Type type) {
                this.nativeType = type;
                this.namedType = null;
            }

            public FunctionType(String name) {
                this.nativeType = null;
                this.namedType = name;
            }

            public Type getNativeType() {
                return this.nativeType;
            }

            public String getNamedType() {
                return this.namedType;
            }

            public boolean isNative() {
                return this.nativeType != null;
            }

            public static enum Type {
                Void,
                Int,
                UInt,
                Double,
                String,
                Boolean,
                Any;

            }
        }
    }

    public static interface IFunctionBuilder {
        public IFunctionBuilder setName(String var1);

        public IFunctionBuilder setReturnType(String var1);

        public IFunctionBuilder setReturnType(RuntimeFunction.FunctionType.Type var1);

        public IFunctionBuilder addArgument(String var1, RuntimeFunction.FunctionType.Type var2);

        public IFunctionBuilder useVargs();

        public IFunctionBuilder addArgument(String var1, String var2);

        public RuntimeFunction build();
    }

    public static interface NumericValue {
    }

    public static interface RuntimeModule<S>
    extends Variable<S, NamedVariable<S>> {
        public void initialize(List<RuntimeFunction> var1);

        public void initialize(RuntimeFunction ... var1);

        public void callVoid(RuntimeFunction var1, Object ... var2);

        public void callVoid(Scope<S> var1, RuntimeFunction var2, Object ... var3);

        public <V> Variable<S, V> call(Scope<S> var1, RuntimeFunction var2, Object ... var3);

        public <V> Variable<S, V> call(RuntimeFunction var1, Object ... var2);
    }
}

