/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.framework.fmi2.api;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PStm;
import org.intocps.maestro.ast.node.PType;

public interface FmiBuilder<AST, B, E, SETTINGS> {
    public B build() throws Exception;

    public SETTINGS getSettings();

    public IFunctionBuilder getFunctionBuilder();

    public boolean isDirty();

    public void resetDirty();

    public PStm buildRaw() throws Exception;

    public RuntimeModule<AST> loadRuntimeModule(String var1, Object ... var2);

    public RuntimeModule<AST> loadRuntimeModule(TryScope<AST> var1, String var2, Object ... var3);

    public Scope<AST> getRootScope();

    public DynamicActiveScope<AST> getDynamicScope();

    public <V, T> Variable<T, V> getCurrentLinkedValue(Port var1);

    public DoubleVariable<AST> getDoubleVariableFrom(E var1);

    public IntVariable<AST> getIntVariableFrom(E var1);

    public StringVariable<AST> getStringVariableFrom(E var1);

    public BoolVariable<AST> getBooleanVariableFrom(E var1);

    public <V, T> Variable<T, V> getFmuVariableFrom(E var1);

    public static interface NumericExpressionValue
    extends ExpressionValue,
    NumericTypedReferenceExp {
    }

    public static interface StringExpressionValue
    extends ExpressionValue {
    }

    public static interface UIntExpressionValue
    extends IntExpressionValue {
    }

    public static interface LongExpressionValue
    extends NumericExpressionValue {
    }

    public static interface IntExpressionValue
    extends NumericExpressionValue {
    }

    public static interface FloatExpressionValue
    extends NumericExpressionValue {
    }

    public static interface DoubleExpressionValue
    extends NumericExpressionValue {
    }

    public static interface BooleanExpressionValue
    extends ExpressionValue {
    }

    public static interface ExpressionValue
    extends ProvidesTypedReferenceExp {
    }

    public static interface ArrayVariable<AST, CV>
    extends Variable<AST, NamedVariable<AST>> {
        public int size();

        public List<? extends Variable<AST, CV>> items();

        public void setValue(IntExpressionValue var1, ExpressionValue var2);
    }

    public static interface Variable<AST, V>
    extends ProvidesTypedReferenceExp {
        public String getName();

        public void setValue(V var1);

        public void setValue(Variable<AST, V> var1);

        public void setValue(Scope<AST> var1, Variable<AST, V> var2);

        public void setValue(Scope<AST> var1, V var2);

        public Scope<AST> getDeclaredScope();
    }

    public static interface Fmi2ComponentVariable<AST, PORT_SCALAR_TYPE>
    extends FmiSimulationInstance<AST, PORT_SCALAR_TYPE> {
        @Override
        public void setDebugLogging(List<String> var1, boolean var2);

        public void setupExperiment(DoubleVariable<AST> var1, DoubleVariable<AST> var2, BoolVariable<AST> var3, Double var4);

        public void setupExperiment(double var1, Double var3, Double var4);

        public void enterInitializationMode();

        public void exitInitializationMode();

        public void setupExperiment(Scope<AST> var1, DoubleVariable<AST> var2, DoubleVariable<AST> var3, BoolVariable<AST> var4, Double var5);

        public void setupExperiment(Scope<AST> var1, double var2, Double var4, Double var5);

        public void enterInitializationMode(Scope<AST> var1);

        public void exitInitializationMode(Scope<AST> var1);

        public void terminate(Scope<AST> var1);

        public void terminate();

        public Map.Entry<BoolVariable<AST>, DoubleVariable<AST>> step(Scope<AST> var1, DoubleVariable<AST> var2, DoubleVariable<AST> var3, BoolVariable<AST> var4);

        public Map.Entry<BoolVariable<AST>, DoubleVariable<AST>> step(Scope<AST> var1, DoubleVariable<AST> var2, DoubleVariable<AST> var3);

        public Map.Entry<BoolVariable<AST>, DoubleVariable<AST>> step(DoubleVariable<AST> var1, DoubleVariable<AST> var2, BoolVariable<AST> var3);

        public Map.Entry<BoolVariable<AST>, DoubleVariable<AST>> step(DoubleVariable<AST> var1, DoubleVariable<AST> var2);
    }

    public static interface Fmi3InstanceVariable<AST, PORT_SCALAR_TYPE>
    extends FmiSimulationInstance<AST, PORT_SCALAR_TYPE> {
        public void setupExperiment(DoubleVariable<AST> var1, DoubleVariable<AST> var2, BoolVariable<AST> var3, Double var4);

        public void setupExperiment(double var1, Double var3, Double var4);

        public void enterInitializationMode(boolean var1, double var2, double var4, boolean var6, double var7);

        public void enterInitializationMode(Scope<AST> var1, BoolVariable<PStm> var2, DoubleVariable<PStm> var3, DoubleVariable<PStm> var4, BoolVariable<PStm> var5, DoubleVariable<PStm> var6);

        public void enterInitializationMode(BoolVariable<PStm> var1, DoubleVariable<PStm> var2, DoubleVariable<PStm> var3, BoolVariable<PStm> var4, DoubleVariable<PStm> var5);

        public void exitInitializationMode();

        public void setupExperiment(Scope<AST> var1, DoubleVariable<AST> var2, DoubleVariable<AST> var3, BoolVariable<AST> var4, Double var5);

        public void setupExperiment(Scope<AST> var1, double var2, Double var4, Double var5);

        public void enterInitializationMode(Scope<AST> var1, boolean var2, double var3, double var5, boolean var7, double var8);

        public void exitInitializationMode(Scope<AST> var1);

        public void terminate(Scope<AST> var1);

        public void terminate();
    }

    public static interface FmiSimulationInstance<AST, PORT_SCALAR_TYPE>
    extends SimulationInstance<AST> {
        public void setDebugLogging(List<String> var1, boolean var2);

        public List<? extends Port<PORT_SCALAR_TYPE, AST>> getPorts();

        public List<? extends Port<PORT_SCALAR_TYPE, AST>> getPorts(String ... var1);

        public List<? extends Port<PORT_SCALAR_TYPE, AST>> getPorts(int ... var1);

        public Port<PORT_SCALAR_TYPE, AST> getPort(String var1);

        public Port<PORT_SCALAR_TYPE, AST> getPort(int var1);

        public <V> Map<? extends Port<PORT_SCALAR_TYPE, AST>, ? extends Variable<AST, V>> get(Port<PORT_SCALAR_TYPE, AST> ... var1);

        public <V> Map<? extends Port<PORT_SCALAR_TYPE, AST>, ? extends Variable<AST, V>> get(Scope<AST> var1, Port<PORT_SCALAR_TYPE, AST> ... var2);

        public <V> Map<? extends Port<PORT_SCALAR_TYPE, AST>, ? extends Variable<AST, V>> get();

        public <V> Map<? extends Port<PORT_SCALAR_TYPE, AST>, ? extends Variable<AST, V>> get(int ... var1);

        public <V> Map<? extends Port<PORT_SCALAR_TYPE, AST>, ? extends Variable<AST, V>> get(String ... var1);

        public <V> Map<? extends Port<PORT_SCALAR_TYPE, AST>, ? extends Variable<AST, V>> getAndShare(String ... var1);

        public <V> Map<? extends Port<PORT_SCALAR_TYPE, AST>, ? extends Variable<AST, V>> getAndShare(Port<PORT_SCALAR_TYPE, AST> ... var1);

        public <V> Map<? extends Port<PORT_SCALAR_TYPE, AST>, ? extends Variable<AST, V>> getAndShare();

        public <V> Variable<AST, V> getShared(String var1);

        public <V> Variable<AST, V> getShared(Port<PORT_SCALAR_TYPE, AST> var1);

        public <V> Variable<AST, V> getSingle(String var1);

        public <V> Variable<AST, V> getSingle(Port<PORT_SCALAR_TYPE, AST> var1);

        public <V> void set(Scope<AST> var1, PortValueMap<V, PORT_SCALAR_TYPE, AST> var2);

        public <V> void set(Scope<AST> var1, PortVariableMap<V, PORT_SCALAR_TYPE, AST> var2);

        public <V> void set(PortValueMap<V, PORT_SCALAR_TYPE, AST> var1);

        public <V> void set(Port<PORT_SCALAR_TYPE, AST> var1, Value<V> var2);

        public <V> void set(Port<PORT_SCALAR_TYPE, AST> var1, Variable<AST, V> var2);

        public <V> void set(Scope<AST> var1, Port<PORT_SCALAR_TYPE, AST> var2, Variable<AST, V> var3);

        public <V> void set(PortVariableMap<V, PORT_SCALAR_TYPE, AST> var1);

        public void setLinked(Scope<AST> var1, Port<PORT_SCALAR_TYPE, AST> ... var2);

        public void setLinked();

        public void setLinked(Port<PORT_SCALAR_TYPE, AST> ... var1);

        public void setLinked(String ... var1);

        public void setLinked(long ... var1);

        public void setInt(Map<? extends Integer, ? extends Value<Integer>> var1);

        public void setString(Map<? extends String, ? extends Value<String>> var1);

        public <V> void share(Map<? extends Port<PORT_SCALAR_TYPE, AST>, ? extends Variable<AST, V>> var1);

        public <V> void share(Port<PORT_SCALAR_TYPE, AST> var1, Variable<AST, V> var2);

        public StateVariable<AST> getState() throws XPathExpressionException;

        public StateVariable<AST> getState(Scope<AST> var1) throws XPathExpressionException;

        public static interface PortExpressionValueMap<PORT_SCALAR_TYPE, AST>
        extends Map<Port<PORT_SCALAR_TYPE, AST>, ExpressionValue> {
        }

        public static interface PortValueMap<V, PORT_SCALAR_TYPE, AST>
        extends Map<Port<PORT_SCALAR_TYPE, AST>, Value<V>> {
        }

        public static interface PortVariableMap<V, PORT_SCALAR_TYPE, AST>
        extends Map<Port<PORT_SCALAR_TYPE, AST>, Variable<AST, V>> {
        }
    }

    public static interface SimulationInstance<AST>
    extends Variable<AST, NamedVariable<AST>> {
    }

    public static interface Fmu3Variable<AST>
    extends Variable<AST, NamedVariable<AST>> {
    }

    public static interface Fmu2Variable<AST, PORT_SCALAR_TYPE>
    extends Variable<AST, NamedVariable<AST>> {
        public Fmi2ComponentVariable<AST, PORT_SCALAR_TYPE> instantiate(String var1, String var2);

        public Fmi2ComponentVariable<AST, PORT_SCALAR_TYPE> instantiate(String var1);

        public Fmi2ComponentVariable<AST, PORT_SCALAR_TYPE> instantiate(String var1, TryScope<PStm> var2, Scope<PStm> var3, String var4);

        public Fmi2ComponentVariable<AST, PORT_SCALAR_TYPE> instantiate(String var1, TryScope<PStm> var2, Scope<PStm> var3, String var4, boolean var5);

        public Fmi2ComponentVariable<AST, PORT_SCALAR_TYPE> instantiate(String var1, TryScope<AST> var2, Scope<AST> var3);
    }

    public static interface StateVariable<AST>
    extends Variable<AST, Object> {
        public void set() throws IllegalStateException;

        public void set(Scope<AST> var1) throws IllegalStateException;

        public void destroy() throws IllegalStateException;

        public void destroy(Scope<AST> var1) throws IllegalStateException;
    }

    public static interface NamedVariable<AST>
    extends Variable<AST, NamedValue> {
    }

    public static interface StringVariable<T>
    extends Variable<T, StringExpressionValue>,
    ProvidesTypedReferenceExp {
    }

    public static interface BoolVariable<AST>
    extends Variable<AST, BooleanExpressionValue>,
    ProvidesTypedReferenceExp {
        public Predicate toPredicate();
    }

    public static interface FloatVariable<AST>
    extends Variable<AST, FloatExpressionValue>,
    ProvidesTypedReferenceExp,
    NumericTypedReferenceExp {
        public void set(Float var1);
    }

    public static interface DoubleVariable<AST>
    extends Variable<AST, DoubleExpressionValue>,
    ProvidesTypedReferenceExp,
    NumericTypedReferenceExp {
        public void set(Double var1);
    }

    public static interface NumericTypedReferenceExp
    extends ProvidesTypedReferenceExp {
    }

    public static interface ProvidesTypedReferenceExp {
        public PType getType();

        public PExp getExp();
    }

    public static interface UIntVariable<AST>
    extends Variable<AST, UIntExpressionValue>,
    ProvidesTypedReferenceExp,
    NumericTypedReferenceExp {
        public void decrement();

        public void increment();
    }

    public static interface IntVariable<AST>
    extends Variable<AST, IntExpressionValue>,
    ProvidesTypedReferenceExp,
    NumericTypedReferenceExp {
        public void decrement();

        public void increment();
    }

    public static interface NamedValue
    extends Value<Object>,
    ProvidesTypedReferenceExp {
    }

    public static interface Value<V> {
        public V get();
    }

    public static interface Port<PORT_SCALAR_TYPE, AST> {
        public String getQualifiedName();

        public FmiSimulationInstance<AST, PORT_SCALAR_TYPE> getOwner();

        public PORT_SCALAR_TYPE getSourceObject();

        public String getName();

        public Long getPortReferenceValue();

        public void linkTo(Port<PORT_SCALAR_TYPE, AST> ... var1) throws PortLinkException;

        public void breakLink() throws PortLinkException;

        public boolean isLinked();

        public boolean isLinkedAsOutputProvider();

        public boolean isLinkedAsInputConsumer();

        public static class PortLinkException
        extends Exception {
            Port port;

            public PortLinkException(String message, Port port) {
                super(message);
                this.port = port;
            }
        }
    }

    public static interface Numeric<A extends Number>
    extends Value<Number>,
    Type {
        public void set(A var1);

        @Override
        public A get();
    }

    public static interface Type {
    }

    public static interface Predicate {
        public Predicate and(Predicate var1);

        public Predicate or(Predicate var1);

        public Predicate not();
    }

    public static interface WhileScope<AST>
    extends Scope<AST>,
    ScopeElement<AST> {
    }

    public static interface TryScope<AST>
    extends ScopeElement<AST> {
        public Scope<AST> enter();

        public Scope<AST> enterFinally();

        public Scope<AST> leave();

        public Scope<AST> getBody();

        public Scope<AST> getFinallyBody();
    }

    public static interface IfScope<AST>
    extends ScopeElement<AST> {
        public Scope<AST> enterThen();

        public Scope<AST> enterElse();

        public Scope<AST> leave();
    }

    public static interface DynamicActiveScope<AST>
    extends Scope<AST> {
    }

    public static interface Scope<AST>
    extends Scoping<AST> {
        @Override
        public Scope<AST> activate();

        public DoubleVariable<AST> store(double var1);

        public FloatVariable<AST> store(float var1);

        public StringVariable<AST> store(String var1);

        public BoolVariable<AST> store(boolean var1);

        public IntVariable<AST> store(int var1);

        public UIntVariable<AST> storeUInt(long var1);

        public DoubleVariable<AST> store(String var1, double var2);

        public FloatVariable<AST> store(String var1, float var2);

        public StringVariable<AST> store(String var1, String var2);

        public BoolVariable<AST> store(String var1, boolean var2);

        public IntVariable<AST> store(String var1, int var2);

        public UIntVariable<AST> storeUInt(String var1, long var2);

        public <CV> ArrayVariable<AST, CV> store(String var1, CV[] var2);

        public <V> ArrayVariable<AST, V> createArray(String var1, Class<? extends V> var2, IntVariable<AST> ... var3) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException;

        public <V> ArrayVariable<AST, V> createArray(String var1, Class<? extends V> var2, UIntVariable<AST> ... var3) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException;

        @Deprecated
        public <V> Variable<AST, V> store(Value<V> var1);

        public <PS> Fmu2Variable<AST, PS> createFMU(String var1, String var2, String ... var3) throws Exception;

        public <PS> Fmu3Variable<AST> createFMU3(String var1, String var2, String ... var3) throws Exception;

        public void markTransferPoint(String ... var1);

        public void addTransferAs(String ... var1);
    }

    public static interface Scoping<AST>
    extends ScopeElement<AST> {
        public WhileScope<AST> enterWhile(Predicate var1);

        public IfScope<AST> enterIf(Predicate var1);

        public TryScope<AST> enterTry();

        public Scoping<AST> parallel();

        public Scoping<AST> enterScope();

        public Scope<AST> leave();

        public void add(AST ... var1);

        public void addAll(Collection<AST> var1);

        public void addBefore(AST var1, AST ... var2);

        public void addAfter(AST var1, AST ... var2);

        public Scoping<AST> activate();
    }

    public static interface ScopeElement<AST> {
        public ScopeElement<AST> parent();

        public AST getDeclaration();

        public <P extends ScopeElement<AST>> P findParent(Class<P> var1);
    }

    public static interface RuntimeFunction {
        public String getName();

        public List<Map.Entry<String, FunctionType>> getArgs();

        public FunctionType getReturnType();

        public boolean usingVargs();

        public static class FunctionType {
            final Type nativeType;
            final String namedType;

            public FunctionType(Type type) {
                this.nativeType = type;
                this.namedType = null;
            }

            public FunctionType(String name) {
                this.nativeType = null;
                this.namedType = name;
            }

            public Type getNativeType() {
                return this.nativeType;
            }

            public String getNamedType() {
                return this.namedType;
            }

            public boolean isNative() {
                return this.nativeType != null;
            }

            public static enum Type {
                Void,
                Int,
                UInt,
                Double,
                String,
                Boolean,
                Any;

            }
        }
    }

    public static interface IFunctionBuilder {
        public IFunctionBuilder setName(String var1);

        public IFunctionBuilder setReturnType(String var1);

        public IFunctionBuilder setReturnType(RuntimeFunction.FunctionType.Type var1);

        public IFunctionBuilder addArgument(String var1, RuntimeFunction.FunctionType.Type var2);

        public IFunctionBuilder useVargs();

        public IFunctionBuilder addArgument(String var1, String var2);

        public RuntimeFunction build();
    }

    public static interface NumericValue {
    }

    public static interface RuntimeModule<AST>
    extends Variable<AST, NamedVariable<AST>> {
        public void initialize(List<RuntimeFunction> var1);

        public void initialize(RuntimeFunction ... var1);

        public void callVoid(RuntimeFunction var1, Object ... var2);

        public void callVoid(Scope<AST> var1, RuntimeFunction var2, Object ... var3);

        public <V> Variable<AST, V> call(Scope<AST> var1, RuntimeFunction var2, Object ... var3);

        public <V> Variable<AST, V> call(RuntimeFunction var1, Object ... var2);
    }
}

