/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.framework.fmi2;

import com.fujitsu.vdmj.ExitStatus;
import com.fujitsu.vdmj.Settings;
import com.fujitsu.vdmj.VDMJ;
import com.fujitsu.vdmj.VDMSL;
import com.fujitsu.vdmj.lex.Dialect;
import com.fujitsu.vdmj.runtime.Interpreter;
import fmi2vdm.FMI2SaxHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.intocps.fmi.IFmu;
import org.intocps.maestro.core.messages.IErrorReporter;
import org.intocps.maestro.framework.fmi2.IFmuValidator;
import org.intocps.maestro.framework.fmi2.vdm.annotations.ast.ASTOnFailAnnotation;
import org.intocps.maestro.framework.fmi2.vdm.annotations.in.INOnFailAnnotation;
import org.intocps.orchestration.coe.FmuFactory;
import org.intocps.orchestration.coe.modeldefinition.ModelDescription;
import org.xml.sax.helpers.DefaultHandler;

public class Fmi2FmuValidator
implements IFmuValidator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validate(String id, URI path, IErrorReporter reporter) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            FMI2SaxHandler handler = new FMI2SaxHandler(path.getPath(), "var");
            IFmu fmu = FmuFactory.create(null, (URI)path);
            ModelDescription md = new ModelDescription(fmu.getModelDescription());
            saxParser.parse(fmu.getModelDescription(), (DefaultHandler)handler);
            String vdm = handler.getFMIModelDescription().toVDM("\t");
            Object annotationsSearchClassPath = System.getProperty("vdmj.annotations", "com.fujitsu.vdmj.ast.annotations");
            if (!((String)annotationsSearchClassPath).contains(ASTOnFailAnnotation.class.getPackage().getName())) {
                annotationsSearchClassPath = (String)annotationsSearchClassPath + ";" + ASTOnFailAnnotation.class.getPackage().getName();
            }
            Class<VDMJ> clazz = VDMJ.class;
            synchronized (VDMJ.class) {
                Class<Settings> clazz2 = Settings.class;
                synchronized (Settings.class) {
                    System.setProperty("vdmj.annotations", (String)annotationsSearchClassPath);
                    System.setProperty("vdmj.mappingpath", "/maestro/fmi2/vdm");
                    VDMSL controller = new VDMSL();
                    controller.setQuiet(true);
                    Settings.dialect = Dialect.VDM_SL;
                    Settings.verbose = false;
                    Settings.annotations = true;
                    String[] fmi2StaticModelFiles = new String[]{"CoSimulation_4.3.1.vdmsl", "DefaultExperiment_2.2.5.vdmsl", "FMIModelDescription_2.2.1.vdmsl", "LogCategories_2.2.4.vdmsl", "Misc.vdmsl", "ModelExchange_3.3.1.vdmsl", "ModelStructure_2.2.8.vdmsl", "ModelVariables_2.2.7.vdmsl", "TypeDefinitions_2.2.3.vdmsl", "UnitDefinitions_2.2.2.vdmsl", "VariableNaming_2.2.9.vdmsl", "VendorAnnotations_2.2.6.vdmsl"};
                    List specFiles = Arrays.stream(fmi2StaticModelFiles).map(specPath -> {
                        try {
                            File tmp = File.createTempFile("fmi2Spec", "");
                            try (FileOutputStream dest = new FileOutputStream(tmp);
                                 InputStream in = this.getClass().getClassLoader().getResourceAsStream((String)specPath);){
                                if (in != null) {
                                    IOUtils.copy((InputStream)in, (OutputStream)dest);
                                }
                            }
                            return tmp;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            return null;
                        }
                    }).collect(Collectors.toList());
                    File modelSped = File.createTempFile("fmi2", "");
                    FileUtils.write((File)modelSped, (CharSequence)vdm, (Charset)StandardCharsets.UTF_8);
                    specFiles.add(modelSped);
                    Class<INOnFailAnnotation> clazz3 = INOnFailAnnotation.class;
                    synchronized (INOnFailAnnotation.class) {
                        controller.parse(specFiles);
                        if (controller.typeCheck() == ExitStatus.EXIT_OK) {
                            INOnFailAnnotation.failures.clear();
                            Interpreter interpreter = controller.getInterpreter();
                            interpreter.init();
                            interpreter.execute("isValidFMIModelDescription(var)");
                            boolean success = INOnFailAnnotation.failures.isEmpty();
                            INOnFailAnnotation.failures.forEach(msg -> reporter.warning(0, msg + " URI: " + path, null));
                            INOnFailAnnotation.failures.clear();
                            for (File specFile : specFiles) {
                                FileUtils.deleteQuietly((File)specFile);
                            }
                            // ** MonitorExit[var17_18] (shouldn't be in output)
                            // ** MonitorExit[var12_13] (shouldn't be in output)
                            // ** MonitorExit[var11_12] (shouldn't be in output)
                            return true;
                        }
                        reporter.warning(999, "Internal error could not check spec for: " + path, null);
                        // ** MonitorExit[var17_18] (shouldn't be in output)
                        // ** MonitorExit[var12_13] (shouldn't be in output)
                        // ** MonitorExit[var11_12] (shouldn't be in output)
                        return false;
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

