/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.framework.fmi2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Deprecated(since="1.0", forRemoval=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Fmi2EnvironmentConfiguration {
    @JsonProperty(value="end_time")
    public Double endTime = 10.0;
    @JsonProperty(value="step_size")
    public Double stepSize = 0.1;
    public Map<String, String> fmus;
    public Map<String, List<String>> connections;
    public Map<String, List<String>> logVariables;
    public Map<String, List<String>> livestream;
    public Double liveLogInterval;
    @JsonProperty(value="algorithm")
    public IAlgorithmConfig algorithm;
    @JsonProperty(value="logLevels")
    public Map<String, List<String>> logLevels = new HashMap<String, List<String>>();
    @JsonProperty(value="visible")
    public boolean visible = false;
    @JsonProperty(value="loggingOn")
    public boolean loggingOn = false;

    @JsonIgnore
    public static String extractInstanceFromKeyInstance(String tuple) {
        String startInstanceSplitSequence = "}.";
        int indexStart = tuple.indexOf(startInstanceSplitSequence);
        return tuple.substring(indexStart + startInstanceSplitSequence.length());
    }

    @JsonIgnore
    public Map<String, URI> getFmuFiles() throws Exception {
        HashMap<String, URI> files = new HashMap<String, URI>();
        if (this.fmus != null) {
            for (Map.Entry<String, String> entry : this.fmus.entrySet()) {
                try {
                    files.put(entry.getKey(), new URI(entry.getValue()));
                }
                catch (Exception e) {
                    throw new Exception(entry.getKey() + "-" + entry.getValue() + ": " + e.getMessage(), e);
                }
            }
        }
        return files;
    }

    @JsonIgnore
    public Double getLivelogInterval() {
        if (this.liveLogInterval != null) {
            return this.liveLogInterval;
        }
        return 0.1;
    }

    @JsonIgnore
    public Map<String, List<String>> getInstanceNameToLogLevels() {
        if (this.logLevels != null) {
            HashMap<String, List<String>> ll = new HashMap<String, List<String>>();
            this.logLevels.forEach((k, v) -> ll.put(Fmi2EnvironmentConfiguration.extractInstanceFromKeyInstance(k), (List<String>)v));
            return ll;
        }
        return null;
    }

    public static class FixedStepAlgorithmConfig
    implements IAlgorithmConfig {
        @JsonProperty(value="size")
        public final Double size;

        @JsonCreator
        public FixedStepAlgorithmConfig(@JsonProperty(value="size") Double size) {
            this.size = size;
        }

        public Double getSize() {
            return this.size;
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=FixedStepAlgorithmConfig.class, name="fixed-step")})
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public static interface IAlgorithmConfig {
    }
}

