/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.intocps.maestro.core.messages.IErrorReporter;
import org.intocps.maestro.fmi.ModelDescription;
import org.intocps.maestro.framework.core.EnvironmentException;
import org.intocps.maestro.framework.fmi2.Fmi2SimulationEnvironment;
import org.intocps.maestro.framework.fmi2.ModelDescriptionValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ModelDescriptionValidatorTest {
    private ModelDescriptionValidator modelDescriptionValidator;
    private ModelDescription md;
    private List<ModelDescription.ScalarVariable> variables;

    @BeforeEach
    public void beforeEachTestMethod() throws Exception {
        InputStream multimodelJson = this.getClass().getResourceAsStream("watertankmultimodel.json");
        Fmi2SimulationEnvironment env = Fmi2SimulationEnvironment.of((InputStream)multimodelJson, (IErrorReporter)new IErrorReporter.SilentReporter());
        this.modelDescriptionValidator = new ModelDescriptionValidator();
        Iterator iterator = env.getFmusWithModelDescriptions().iterator();
        iterator.next();
        this.md = (ModelDescription)((Map.Entry)iterator.next()).getValue();
        this.variables = this.md.getScalarVariables();
    }

    @Test
    public void verifyVariabilityCausalityIllegalConfiguration1Throws() throws Exception {
        this.variables.forEach(o -> {
            o.causality = ModelDescription.Causality.Parameter;
            o.variability = ModelDescription.Variability.Constant;
        });
        Assertions.assertThrows(EnvironmentException.class, () -> this.modelDescriptionValidator.verifyVariabilityCausality(this.variables));
    }

    @Test
    public void verifyVariabilityCausalityIllegalConfiguration2Throws() throws Exception {
        this.variables.forEach(o -> {
            o.causality = ModelDescription.Causality.Independent;
            o.variability = ModelDescription.Variability.Constant;
        });
        Assertions.assertThrows(EnvironmentException.class, () -> this.modelDescriptionValidator.verifyVariabilityCausality(this.variables));
    }

    @Test
    public void verifyVariabilityCausalityIllegalConfiguration3Throws() throws Exception {
        this.variables.forEach(o -> {
            o.causality = ModelDescription.Causality.Output;
            o.variability = ModelDescription.Variability.Fixed;
        });
        Assertions.assertThrows(EnvironmentException.class, () -> this.modelDescriptionValidator.verifyVariabilityCausality(this.variables));
    }

    @Test
    public void verifyVariabilityCausalityIllegalConfigurationInitial1Throws() throws Exception {
        this.variables.forEach(o -> {
            o.initial = ModelDescription.Initial.Exact;
            o.causality = ModelDescription.Causality.Input;
        });
        Assertions.assertThrows(EnvironmentException.class, () -> this.modelDescriptionValidator.verifyVariabilityCausality(this.variables));
    }

    @Test
    public void verifyVariabilityCausalityIllegalConfigurationInitial2Throws() throws Exception {
        this.variables.forEach(o -> {
            o.initial = ModelDescription.Initial.Exact;
            o.causality = ModelDescription.Causality.Independent;
        });
        Assertions.assertThrows(EnvironmentException.class, () -> this.modelDescriptionValidator.verifyVariabilityCausality(this.variables));
    }

    @Test
    public void verifyVariabilityCausalityLegalConfigurationPasses() throws Exception {
        this.modelDescriptionValidator.verifyVariabilityCausality(this.variables);
    }

    @Test
    public void addInitialModelDescription_AddInitialToAllFields() throws Exception {
        List decoratedvariables = this.modelDescriptionValidator.addInitialToModelDescription(this.variables);
        List variablesThatShouldHaveAnInitial = decoratedvariables.stream().filter(o -> o.causality != ModelDescription.Causality.Independent && o.causality != ModelDescription.Causality.Input).collect(Collectors.toList());
        List variablesThatShouldNotHaveAnInitial = decoratedvariables.stream().filter(o -> o.causality == ModelDescription.Causality.Independent || o.causality == ModelDescription.Causality.Input).collect(Collectors.toList());
        Assertions.assertTrue((boolean)variablesThatShouldHaveAnInitial.stream().allMatch(o -> o.initial != null));
        Assertions.assertTrue((boolean)variablesThatShouldNotHaveAnInitial.stream().allMatch(o -> o.initial == null));
    }

    @Test
    public void addInitialModelDescription_ValveOutFlow() throws Exception {
        List<ModelDescription.ScalarVariable> valuesBefore = this.variables.stream().filter(o -> o.getValueReference() == 5L || o.getValueReference() == 6L).collect(Collectors.toList());
        valuesBefore.forEach(o -> {
            o.initial = null;
        });
        Assertions.assertTrue((boolean)valuesBefore.stream().allMatch(o -> o.initial == null));
        List decoratedvariables = this.modelDescriptionValidator.addInitialToModelDescription(this.variables);
        List valuesAfter = decoratedvariables.stream().filter(o -> o.getValueReference() == 5L || o.getValueReference() == 6L).collect(Collectors.toList());
        Assertions.assertTrue((boolean)valuesAfter.stream().allMatch(o -> o.initial != null));
    }
}

