/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.framework.fmi2;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.intocps.fmi.IFmu;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.MableAstFactory;
import org.intocps.maestro.core.Framework;
import org.intocps.maestro.core.messages.IErrorReporter;
import org.intocps.maestro.fmi.ModelDescription;
import org.intocps.maestro.framework.core.EnvironmentException;
import org.intocps.maestro.framework.core.FrameworkUnitInfo;
import org.intocps.maestro.framework.core.FrameworkVariableInfo;
import org.intocps.maestro.framework.core.IRelation;
import org.intocps.maestro.framework.core.ISimulationEnvironment;
import org.intocps.maestro.framework.core.IVariable;
import org.intocps.maestro.framework.fmi2.ComponentInfo;
import org.intocps.maestro.framework.fmi2.ExplicitModelDescription;
import org.intocps.maestro.framework.fmi2.Fmi2SimulationEnvironmentConfiguration;
import org.intocps.maestro.framework.fmi2.FmuFactory;
import org.intocps.maestro.framework.fmi2.IFmuValidator;
import org.intocps.maestro.framework.fmi2.MaestroV1FmuValidation;
import org.intocps.maestro.framework.fmi2.ModelConnection;
import org.intocps.maestro.framework.fmi2.RelationVariable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fmi2SimulationEnvironment
implements ISimulationEnvironment {
    static final Logger logger = LoggerFactory.getLogger(Fmi2SimulationEnvironment.class);
    private final Map<String, String> instanceLexToInstanceName = new HashMap<String, String>();
    private final Map<String, List<String>> instanceNameToLogLevels = new HashMap<String, List<String>>();
    Map<LexIdentifier, Set<Relation>> variableToRelations = new HashMap<LexIdentifier, Set<Relation>>();
    Map<String, ComponentInfo> instanceNameToInstanceComponentInfo = new HashMap<String, ComponentInfo>();
    HashMap<String, ModelDescription> fmuKeyToModelDescription = new HashMap();
    Map<String, URI> fmuToUri = null;
    Map<String, Variable> variables = new HashMap<String, Variable>();
    Map<String, List<RelationVariable>> globalVariablesToLogForInstance = new HashMap<String, List<RelationVariable>>();
    private String faultInjectionConfigurationPath;

    protected Fmi2SimulationEnvironment(Fmi2SimulationEnvironmentConfiguration msg) throws Exception {
        this.initialize(msg);
    }

    public static Fmi2SimulationEnvironment of(File file, IErrorReporter reporter) throws Exception {
        try (FileInputStream is = new FileInputStream(file);){
            Fmi2SimulationEnvironment fmi2SimulationEnvironment = Fmi2SimulationEnvironment.of(is, reporter);
            return fmi2SimulationEnvironment;
        }
    }

    public static Fmi2SimulationEnvironment of(Fmi2SimulationEnvironmentConfiguration msg, IErrorReporter reporter) throws Exception {
        return new Fmi2SimulationEnvironment(msg);
    }

    public static Fmi2SimulationEnvironment of(InputStream inputStream, IErrorReporter reporter) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        Fmi2SimulationEnvironmentConfiguration msg = null;
        msg = (Fmi2SimulationEnvironmentConfiguration)mapper.readValue(inputStream, Fmi2SimulationEnvironmentConfiguration.class);
        return Fmi2SimulationEnvironment.of(msg, reporter);
    }

    public static List<ModelConnection> buildConnections(Map<String, List<String>> connections) throws Exception {
        Vector<ModelConnection> list = new Vector<ModelConnection>();
        for (Map.Entry<String, List<String>> entry : connections.entrySet()) {
            for (String input : entry.getValue()) {
                list.add(new ModelConnection(ModelConnection.Variable.parse(entry.getKey()), ModelConnection.Variable.parse(input)));
            }
        }
        return list;
    }

    private static Map<String, List<RelationVariable>> getEnvironmentVariablesToLog(Map<String, List<String>> variablesToLogMap, Map<String, List<RelationVariable>> globalVariablesToLogForInstance) {
        Function<String, String> extractInstance = x -> x.split("}.")[1];
        Map<String, List<RelationVariable>> t = variablesToLogMap.entrySet().stream().collect(Collectors.toMap(entry -> (String)extractInstance.apply((String)entry.getKey()), entry -> ((List)globalVariablesToLogForInstance.get(extractInstance.apply((String)entry.getKey()))).stream().filter(x -> ((List)entry.getValue()).contains(x.scalarVariable.name)).collect(Collectors.toList())));
        return t;
    }

    public List<RelationVariable> getConnectedOutputs() {
        return this.getInstances().stream().flatMap(instance -> {
            Stream<RelationVariable> relationOutputs = this.getRelations(new LexIdentifier((String)instance.getKey(), null)).stream().filter(relation -> relation.getOrigin() == IRelation.InternalOrExternal.External && relation.getDirection() == IRelation.Direction.OutputToInput).map(x -> x.getSource().scalarVariable);
            return relationOutputs;
        }).collect(Collectors.toList());
    }

    public void setLexNameToInstanceNameMapping(String lexName, String instanceName) {
        this.instanceLexToInstanceName.put(lexName, instanceName);
    }

    public ComponentInfo getInstanceByLexName(String lexName) {
        return this.instanceNameToInstanceComponentInfo.get(lexName);
    }

    public List<RelationVariable> getVariablesToLog(String instanceName) {
        List<RelationVariable> vars = this.globalVariablesToLogForInstance.get(instanceName);
        if (vars == null) {
            return new ArrayList<RelationVariable>();
        }
        return vars;
    }

    public Set<Map.Entry<String, ModelDescription>> getFmusWithModelDescriptions() {
        return this.fmuKeyToModelDescription.entrySet();
    }

    public Set<Map.Entry<String, ComponentInfo>> getInstances() {
        return this.instanceNameToInstanceComponentInfo.entrySet();
    }

    public Set<Map.Entry<String, URI>> getFmuToUri() {
        return this.fmuToUri.entrySet();
    }

    public URI getUriFromFMUName(String fmuName) {
        return this.fmuToUri.get(fmuName);
    }

    private void initialize(Fmi2SimulationEnvironmentConfiguration msg) throws Exception {
        Map<String, URI> fmuToURI = msg.getFmuFiles();
        this.fmuToUri = fmuToURI;
        List<ModelConnection> connections = Fmi2SimulationEnvironment.buildConnections(msg.connections);
        HashMap<String, ModelDescription> fmuKeyToModelDescription = this.buildFmuKeyToFmuMD(fmuToURI);
        this.fmuKeyToModelDescription = fmuKeyToModelDescription;
        if (msg.faultInjectConfigurationPath != null && msg.faultInjectConfigurationPath.length() > 0) {
            if (new File(msg.faultInjectConfigurationPath).exists()) {
                this.faultInjectionConfigurationPath = msg.faultInjectConfigurationPath;
            } else {
                throw new EnvironmentException("Failed to find the fault injection configuration file: " + msg.faultInjectConfigurationPath);
            }
        }
        HashSet<ModelConnection.ModelInstance> instancesFromConnections = new HashSet<ModelConnection.ModelInstance>();
        for (ModelConnection modelConnection : connections) {
            ComponentInfo instanceComponentInfo;
            instancesFromConnections.add(modelConnection.from.instance);
            instancesFromConnections.add(modelConnection.to.instance);
            if (!this.instanceNameToInstanceComponentInfo.containsKey(modelConnection.from.instance.instanceName)) {
                instanceComponentInfo = new ComponentInfo(fmuKeyToModelDescription.get(modelConnection.from.instance.key), modelConnection.from.instance.key);
                if (msg.faultInjectInstances != null && msg.faultInjectInstances.containsKey(modelConnection.from.instance.instanceName)) {
                    instanceComponentInfo.setFaultInject(msg.faultInjectInstances.get(modelConnection.from.instance.instanceName));
                }
                this.instanceNameToInstanceComponentInfo.put(modelConnection.from.instance.instanceName, instanceComponentInfo);
            }
            if (this.instanceNameToInstanceComponentInfo.containsKey(modelConnection.to.instance.instanceName)) continue;
            instanceComponentInfo = new ComponentInfo(fmuKeyToModelDescription.get(modelConnection.to.instance.key), modelConnection.to.instance.key);
            if (msg.faultInjectInstances != null && msg.faultInjectInstances.containsKey(modelConnection.to.instance.instanceName)) {
                instanceComponentInfo.setFaultInject(msg.faultInjectInstances.get(modelConnection.to.instance.instanceName));
            }
            this.instanceNameToInstanceComponentInfo.put(modelConnection.to.instance.instanceName, instanceComponentInfo);
        }
        for (ModelConnection.ModelInstance modelInstance : instancesFromConnections) {
            final LexIdentifier instanceLexIdentifier = new LexIdentifier(modelInstance.instanceName, null);
            Set<Relation> instanceRelations = this.getOrCreateRelationsForLexIdentifier(instanceLexIdentifier);
            List instanceOutputScalarVariablesPorts = this.instanceNameToInstanceComponentInfo.get((Object)modelInstance.instanceName).modelDescription.getScalarVariables().stream().filter(x -> x.causality == ModelDescription.Causality.Output).collect(Collectors.toList());
            ArrayList<RelationVariable> globalVariablesToLogForGivenInstance = new ArrayList<RelationVariable>();
            this.globalVariablesToLogForInstance.putIfAbsent(modelInstance.instanceName, globalVariablesToLogForGivenInstance);
            for (ModelDescription.ScalarVariable outputScalarVariable : instanceOutputScalarVariablesPorts) {
                List externalInputTargets;
                final Variable outputVariable = this.getOrCreateVariable(outputScalarVariable, instanceLexIdentifier);
                HashMap dependantInputs = new HashMap();
                for (ModelDescription.ScalarVariable inputScalarVariable : outputScalarVariable.outputDependencies.keySet()) {
                    if (inputScalarVariable.causality != ModelDescription.Causality.Input) continue;
                    Variable inputVariable = this.getOrCreateVariable(inputScalarVariable, instanceLexIdentifier);
                    dependantInputs.put(instanceLexIdentifier, inputVariable);
                }
                if (dependantInputs.size() != 0) {
                    Relation r = new Relation();
                    r.source = outputVariable;
                    r.targets = dependantInputs;
                    r.direction = IRelation.Direction.OutputToInput;
                    r.origin = IRelation.InternalOrExternal.Internal;
                    instanceRelations.add(r);
                }
                if ((externalInputTargets = connections.stream().filter(conn -> conn.from.instance.equals(modelInstance) && conn.from.variable.equals(outputScalarVariable.name)).map(conn -> conn.to).collect(Collectors.toList())).size() == 0) continue;
                globalVariablesToLogForGivenInstance.add(outputVariable.scalarVariable);
                HashMap<LexIdentifier, Variable> externalInputs = new HashMap<LexIdentifier, Variable>();
                for (ModelConnection.Variable modelConnToVar : externalInputTargets) {
                    ModelDescription md = this.instanceNameToInstanceComponentInfo.get((Object)modelConnToVar.instance.instanceName).modelDescription;
                    Optional<ModelDescription.ScalarVariable> toScalarVariable = md.getScalarVariables().stream().filter(sv -> sv.name.equals(modelConnToVar.variable)).findFirst();
                    if (toScalarVariable.isPresent()) {
                        LexIdentifier inputInstanceLexIdentifier = new LexIdentifier(modelConnToVar.instance.instanceName, null);
                        Variable inputVariable = this.getOrCreateVariable(toScalarVariable.get(), inputInstanceLexIdentifier);
                        externalInputs.put(inputInstanceLexIdentifier, inputVariable);
                        Set<Relation> inputInstanceRelations = this.getOrCreateRelationsForLexIdentifier(inputInstanceLexIdentifier);
                        Relation r = new Relation();
                        r.source = inputVariable;
                        r.targets = new HashMap<LexIdentifier, Variable>(){
                            {
                                this.put(instanceLexIdentifier, outputVariable);
                            }
                        };
                        r.origin = IRelation.InternalOrExternal.External;
                        r.direction = IRelation.Direction.InputToOutput;
                        inputInstanceRelations.add(r);
                        continue;
                    }
                    throw new EnvironmentException("Failed to find the scalar variable " + modelConnToVar.variable + " at " + modelConnToVar.instance + " when building the dependencies tree");
                }
                Relation r = new Relation();
                r.source = outputVariable;
                r.targets = externalInputs;
                r.direction = IRelation.Direction.OutputToInput;
                r.origin = IRelation.InternalOrExternal.External;
                instanceRelations.add(r);
            }
            HashMap<String, List<String>> globalLogVariablesMaps = new HashMap<String, List<String>>();
            if (msg.logVariables != null) {
                globalLogVariablesMaps.putAll(msg.logVariables);
            }
            if (msg.livestream != null) {
                msg.livestream.forEach((k, v) -> globalLogVariablesMaps.merge((String)k, (List<String>)v, (v1, v2) -> {
                    TreeSet set = new TreeSet(v1);
                    set.addAll(v2);
                    return new ArrayList(set);
                }));
            }
            ArrayList<RelationVariable> variablesToLogForInstance = new ArrayList<RelationVariable>();
            String logVariablesKey = modelInstance.key + "." + modelInstance.instanceName;
            if (!globalLogVariablesMaps.containsKey(logVariablesKey)) continue;
            for (String s : (List)globalLogVariablesMaps.get(logVariablesKey)) {
                variablesToLogForInstance.add(new RelationVariable(this.fmuKeyToModelDescription.get(modelInstance.key).getScalarVariables().stream().filter(x -> x.name.equals(s)).findFirst().get(), instanceLexIdentifier));
            }
            if (this.globalVariablesToLogForInstance.containsKey(modelInstance.instanceName)) {
                List<RelationVariable> existingRVs = this.globalVariablesToLogForInstance.get(modelInstance.instanceName);
                for (RelationVariable rv : variablesToLogForInstance) {
                    if (existingRVs.contains(rv)) continue;
                    existingRVs.add(rv);
                }
                continue;
            }
            this.globalVariablesToLogForInstance.put(modelInstance.instanceName, variablesToLogForInstance);
        }
    }

    public Map<String, List<String>> getLogLevels() {
        return Collections.unmodifiableMap(this.instanceNameToLogLevels);
    }

    private HashMap<String, ModelDescription> buildFmuKeyToFmuMD(Map<String, URI> fmus) throws Exception {
        HashMap<String, ModelDescription> fmuKeyToFmuWithMD = new HashMap<String, ModelDescription>();
        for (Map.Entry<String, URI> entry : fmus.entrySet()) {
            String key = entry.getKey();
            URI value = entry.getValue();
            IFmu fmu = FmuFactory.create(null, value);
            ExplicitModelDescription md = new ExplicitModelDescription(fmu.getModelDescription());
            fmuKeyToFmuWithMD.put(key, md);
        }
        return fmuKeyToFmuWithMD;
    }

    Variable getOrCreateVariable(ModelDescription.ScalarVariable inputScalarVariable, LexIdentifier instanceLexIdentifier) {
        if (this.variables.containsKey(inputScalarVariable.name + instanceLexIdentifier)) {
            return this.variables.get(inputScalarVariable.name + instanceLexIdentifier);
        }
        Variable variable = new Variable(new RelationVariable(inputScalarVariable, instanceLexIdentifier));
        this.variables.put(inputScalarVariable.name + instanceLexIdentifier, variable);
        return variable;
    }

    Set<Relation> getOrCreateRelationsForLexIdentifier(LexIdentifier instanceLexIdentifier) {
        if (this.variableToRelations.containsKey(instanceLexIdentifier)) {
            return this.variableToRelations.get(instanceLexIdentifier);
        }
        HashSet<Relation> relations = new HashSet<Relation>();
        this.variableToRelations.put(instanceLexIdentifier, relations);
        return relations;
    }

    public Set<Relation> getRelations(List<LexIdentifier> identifiers) {
        return identifiers.stream().filter(id -> this.variableToRelations.containsKey(id)).map(lexId -> this.variableToRelations.get(lexId)).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public Set<Relation> getRelations(LexIdentifier ... identifiers) {
        if (identifiers == null) {
            return Collections.emptySet();
        }
        return this.getRelations(Arrays.asList(identifiers));
    }

    public Set<Relation> getRelations(String ... identifiers) {
        if (identifiers == null) {
            return Collections.emptySet();
        }
        return this.getRelations(Arrays.stream(identifiers).map(x -> MableAstFactory.newLexIdentifier((String)x)).collect(Collectors.toList()));
    }

    public <T extends FrameworkUnitInfo> T getUnitInfo(LexIdentifier identifier, Framework framework) {
        return (T)this.instanceNameToInstanceComponentInfo.get(identifier.getText());
    }

    public void check(IErrorReporter reporter) throws Exception {
        List<IFmuValidator> validators = Arrays.asList(new MaestroV1FmuValidation());
        Map<String, Boolean> validated = this.getFmuToUri().stream().collect(Collectors.toMap(Map.Entry::getKey, map -> validators.stream().allMatch(v -> v.validate((String)map.getKey(), (URI)map.getValue(), reporter))));
        if (validated.values().stream().anyMatch(v -> v == false)) {
            throw new Exception("The following FMUs does not respected the standard: " + validated.entrySet().stream().filter(map -> (Boolean)map.getValue() == false).map(Map.Entry::getKey).collect(Collectors.joining(",", "[", "]")));
        }
    }

    public ModelDescription getModelDescription(String name) {
        return this.fmuKeyToModelDescription.get(name);
    }

    public String getFaultInjectionConfigurationPath() {
        return this.faultInjectionConfigurationPath;
    }

    public static class Variable
    implements IVariable {
        public final RelationVariable scalarVariable;

        public Variable(RelationVariable scalarVariable) {
            this.scalarVariable = scalarVariable;
        }

        public RelationVariable getScalarVariable() {
            return this.scalarVariable;
        }

        <T extends FrameworkVariableInfo> T getFrameworkInfo(Framework framework) {
            return (T)((FrameworkVariableInfo)this.scalarVariable);
        }

        public String toString() {
            return this.scalarVariable.toString();
        }
    }

    public static class Relation
    implements FrameworkVariableInfo,
    IRelation {
        Variable source;
        IRelation.InternalOrExternal origin;
        IRelation.Direction direction;
        Map<LexIdentifier, Variable> targets;

        public IRelation.InternalOrExternal getOrigin() {
            return this.origin;
        }

        public Variable getSource() {
            return this.source;
        }

        public IRelation.Direction getDirection() {
            return this.direction;
        }

        public Map<LexIdentifier, Variable> getTargets() {
            return this.targets;
        }

        public String toString() {
            return (this.origin == IRelation.InternalOrExternal.Internal ? "I" : "E") + " " + this.source + " " + (this.direction == IRelation.Direction.OutputToInput ? "->" : "<-") + " " + this.targets.entrySet().stream().map(map -> ((Variable)map.getValue()).toString()).collect(Collectors.joining(",", "[", "]"));
        }

        public static class RelationBuilder {
            private final Variable source;
            private final Map<LexIdentifier, Variable> targets;
            private IRelation.InternalOrExternal origin = IRelation.InternalOrExternal.External;
            private IRelation.Direction direction = IRelation.Direction.OutputToInput;

            public RelationBuilder(Variable source, Map<LexIdentifier, Variable> targets) {
                this.source = source;
                this.targets = targets;
            }

            public RelationBuilder setInternalOrExternal(IRelation.InternalOrExternal origin) {
                this.origin = origin;
                return this;
            }

            public RelationBuilder setDirection(IRelation.Direction direction) {
                this.direction = direction;
                return this;
            }

            public Relation build() {
                Relation rel = new Relation();
                rel.source = this.source;
                rel.targets = this.targets;
                rel.origin = this.origin;
                rel.direction = this.direction;
                return rel;
            }
        }
    }
}

