/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.framework.fmi2;

import java.io.File;
import java.net.URI;
import java.util.List;
import maestro.MaestroCheck;
import org.intocps.fmi.IFmu;
import org.intocps.maestro.ast.LexToken;
import org.intocps.maestro.core.messages.IErrorReporter;
import org.intocps.maestro.framework.fmi2.FmuFactory;
import org.intocps.maestro.framework.fmi2.IFmuValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fmi2FmuValidator
implements IFmuValidator {
    static final Logger logger = LoggerFactory.getLogger(Fmi2FmuValidator.class);

    @Override
    public boolean validate(String id, URI path, IErrorReporter reporter) {
        try {
            logger.trace("Validating: {} at {}", (Object)id, (Object)path);
            IFmu fmu = FmuFactory.create(null, path);
            MaestroCheck checker = new MaestroCheck();
            List onFailErrors = checker.check(fmu.getModelDescription());
            onFailErrors.forEach(onFailError -> {
                reporter.warning(onFailError.errno, onFailError.message, new LexToken(path + File.separator + "modelDescription.xml", 0, 0));
                logger.warn(onFailError.toString());
            });
            return true;
        }
        catch (Exception e) {
            logger.error("An exception occurred during Fmi2FmUValidator: ", (Throwable)e);
            return false;
        }
    }
}

