/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.framework.fmi2;

import org.intocps.maestro.framework.core.EnvironmentException;

public class KeyInstance {
    public String key;
    public String instance;
    public String variable;

    public KeyInstance(String key, String instance) {
        this.key = key;
        this.instance = instance;
    }

    public KeyInstance(String key, String instance, String variable) {
        this(key, instance);
        this.variable = variable;
    }

    public static KeyInstance ofKeyInstance(String keyInstance) throws EnvironmentException {
        int indexOfKeyEnd = keyInstance.indexOf("}");
        if (indexOfKeyEnd == -1) {
            throw new EnvironmentException("Failed to replace instance in variable: " + keyInstance + " due to missing index of '}'");
        }
        String key = keyInstance.substring(1, indexOfKeyEnd);
        String instance = keyInstance.substring(indexOfKeyEnd + 2);
        if (instance.length() == 0) {
            throw new EnvironmentException("Failed to replace instance in variable: " + keyInstance + " due to missing instance name'");
        }
        return new KeyInstance(key, instance);
    }

    public static KeyInstance ofVariable(String variableString) throws EnvironmentException {
        int indexOfKeyEnd = variableString.indexOf("}");
        if (indexOfKeyEnd == -1) {
            throw new EnvironmentException("Failed to replace instance in variable: " + variableString + " due to missing index of '}'");
        }
        String key = variableString.substring(1, indexOfKeyEnd);
        String variableStringWithoutKey = variableString.substring(indexOfKeyEnd + 2);
        int indexOfEndInstance = variableStringWithoutKey.indexOf(46);
        if (indexOfEndInstance == -1) {
            throw new EnvironmentException("Failed to replace instance in variable: " + variableString + " due to missing index of '.'");
        }
        String instance = variableStringWithoutKey.substring(0, indexOfEndInstance);
        String variable = variableStringWithoutKey.substring(indexOfEndInstance + 1);
        return new KeyInstance(key, instance, variable);
    }

    public String toKeyInstance() {
        return "{" + this.key + "}." + this.instance;
    }

    public String toVariable() {
        return this.toKeyInstance() + "." + this.variable;
    }

    public int hashCode() {
        return this.key.hashCode() ^ this.instance.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof KeyInstance && ((KeyInstance)obj).key.equals(this.key) && ((KeyInstance)obj).instance.equals(this.instance);
    }
}

